/*
 * Decompiled with CFR 0.152.
 */
package crushftp.server.daemon;

import com.crushftp.client.Common;
import com.crushftp.client.File_S;
import com.crushftp.client.Worker;
import crushftp.handlers.Log;
import crushftp.server.ServerStatus;
import crushftp.server.daemon.GenericServer;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ServerBeat
extends GenericServer {
    Exception error = null;
    public String vip = "";
    public String index1 = "1";
    public int port = 0;
    public String adapter = "";
    public String localIp = "";
    public String netmask = "255.255.255.0";
    boolean master = false;
    String master_lan_ip = "";
    long start_millis = System.currentTimeMillis();
    long state_change_time = System.currentTimeMillis();
    public final String uid = crushftp.handlers.Common.makeBoundary();
    public Properties beat_tracker = new Properties();
    public long last_logged = 0L;
    long offline_time = 0L;

    public ServerBeat(Properties server_item) {
        super(server_item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatus() {
        Object object = updateServerStatuses;
        synchronized (object) {
            this.updateStatusInit();
            if (this.socket_created) {
                this.server_item.put("display", "ServerBeat://" + this.vip + ":" + this.port + "/ is running. (" + this.server_item.getProperty("vip2") + ") Master=" + this.master + " MasterIP=" + this.master_lan_ip);
            } else {
                this.server_item.put("display", "ServerBeat://" + this.vip + ":" + this.port + "/ is stopped.  (" + this.server_item.getProperty("vip2") + ") Master=" + this.master + " MasterIP=" + this.master_lan_ip);
            }
        }
    }

    public static void main(String[] args) {
        boolean enabled = true;
        System.out.println("ServerBeat DeadMan's Switch: Validating session.obj timestamp to ensure its not more than 30 seconds old.");
        crushftp.handlers.Common.initSystemProperties(true);
        Common.log = new Vector();
        while (true) {
            try {
                while (true) {
                    if (System.currentTimeMillis() - new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "sessions.obj").lastModified() > (long)((args.length > 0 ? Integer.parseInt(args[0]) : 10) * 1000) && enabled) {
                        Properties server_prefs = (Properties)crushftp.handlers.Common.readXMLObject(String.valueOf(System.getProperty("crushftp.prefs")) + "prefs.XML");
                        Vector server_list = (Vector)server_prefs.get("server_list");
                        int x = 0;
                        while (x < server_list.size()) {
                            Properties server_item = (Properties)server_list.elementAt(x);
                            if (server_item.getProperty("serverType", "").equalsIgnoreCase("SERVERBEAT")) {
                                new ServerBeat(null).disableMaster(server_item.getProperty("vip"), server_item.getProperty("index1", "1"), server_item.getProperty("adapter"), server_item.getProperty("netmask", "255.255.255.0"), server_prefs.getProperty("serverbeat_command_disable", "ifconfig"), server_prefs.getProperty("serverbeat_ifdown_command", "ifdown"));
                            }
                            ++x;
                        }
                        enabled = false;
                    } else if (System.currentTimeMillis() - new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "sessions.obj").lastModified() < 5000L && !enabled) {
                        enabled = true;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void run() {
        this.init();
        try {
            if (ServerStatus.siIG("enterprise_level") <= 0) {
                this.busyMessage = "ServerBeat only valid for Enterprise licenses.";
                throw new Exception(this.busyMessage);
            }
            this.getSocket();
            this.startBeat();
            this.start_millis = System.currentTimeMillis();
            this.init(this.server_item.getProperty("vip"), this.server_item.getProperty("index1", "1"), Integer.parseInt(this.server_item.getProperty("port")), this.server_item.getProperty("netmask", "255.255.255.0"), this.server_item.getProperty("adapter"));
            Worker.startWorker(new Runnable(){

                @Override
                public void run() {
                    while (ServerBeat.this.die_now.length() == 0) {
                        new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "sessions.obj").setLastModified(System.currentTimeMillis());
                        try {
                            ServerBeat.this.server_sock.setSoTimeout(1000);
                            Socket message_replier = ServerBeat.this.server_sock.accept();
                            message_replier.setSoTimeout(2000);
                            ObjectOutputStream oos = new ObjectOutputStream(message_replier.getOutputStream());
                            try {
                                oos.writeUnshared(ServerBeat.this.buildMessage());
                                oos.flush();
                                oos.reset();
                                ObjectInputStream ois = new ObjectInputStream(message_replier.getInputStream());
                                final Properties reply = (Properties)ois.readUnshared();
                                if (reply.getProperty("command", "").equals("become_master")) {
                                    Worker.startWorker(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                if (reply.getProperty("uid", "").equals((this).ServerBeat.this.uid)) {
                                                    Log.log("SERVER_BEAT", 0, "We have been told we should be master:" + (this).ServerBeat.this.beat_tracker.get((this).ServerBeat.this.uid));
                                                    if ((this).ServerBeat.this.offline_time == 0L) {
                                                        (this).ServerBeat.this.offline_time = System.currentTimeMillis();
                                                    }
                                                    long delay = Long.parseLong((this).ServerBeat.this.server_item.getProperty("delay_master", "10")) * 1000L;
                                                    if (System.currentTimeMillis() - (this).ServerBeat.this.offline_time > delay) {
                                                        ServerBeat.this.becomeMaster((this).ServerBeat.this.listen_ip, (this).ServerBeat.this.index1);
                                                        (this).ServerBeat.this.beat_tracker.put((this).ServerBeat.this.uid, ServerBeat.this.buildMessage());
                                                    } else {
                                                        Log.log("SERVER_BEAT", 0, "WAITING:(" + (System.currentTimeMillis() - (this).ServerBeat.this.offline_time) + "ms of " + delay + "ms) We have been told we should be master:" + (this).ServerBeat.this.beat_tracker.get((this).ServerBeat.this.uid));
                                                        Thread.sleep(1000L);
                                                    }
                                                } else {
                                                    if ((this).ServerBeat.this.master) {
                                                        Log.log("SERVER_BEAT", 0, "We have been told we should no longer be master:" + (this).ServerBeat.this.beat_tracker.get((this).ServerBeat.this.uid) + "  This server is the new master:" + (this).ServerBeat.this.beat_tracker.get(reply.getProperty("uid", "")));
                                                    } else {
                                                        Log.log("SERVER_BEAT", 0, "We have been told to just be double sure and clear master status as the controller is changing things..." + (this).ServerBeat.this.beat_tracker.get((this).ServerBeat.this.uid));
                                                    }
                                                    ServerBeat.this.disableMaster((this).ServerBeat.this.vip, (this).ServerBeat.this.index1, (this).ServerBeat.this.adapter, (this).ServerBeat.this.netmask, ServerStatus.SG("serverbeat_command_disable"), ServerStatus.SG("serverbeat_ifdown_command"));
                                                    (this).ServerBeat.this.beat_tracker.put((this).ServerBeat.this.uid, ServerBeat.this.buildMessage());
                                                    Log.log("SERVER_BEAT", 0, "We are not master:" + (this).ServerBeat.this.beat_tracker.get((this).ServerBeat.this.uid));
                                                }
                                            }
                                            catch (Exception e) {
                                                Log.log("SERVER_BEAT", 1, e);
                                            }
                                        }
                                    });
                                }
                                if (reply.getProperty("command", "").equals("info")) {
                                    try {
                                        ServerBeat.this.master_lan_ip = ((Properties)ServerBeat.this.beat_tracker.get(reply.getProperty("uid", ""))).getProperty("ip");
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                ois.close();
                            }
                            finally {
                                oos.close();
                                message_replier.close();
                            }
                        }
                        catch (SocketTimeoutException message_replier) {
                        }
                        catch (Exception e) {
                            Log.log("SERVER_BEAT", 2, e);
                        }
                    }
                }
            }, "Serverbeat listener:" + this.server_sock.getLocalPort());
            Worker.startWorker(new Runnable(){

                @Override
                public void run() {
                    while (ServerBeat.this.die_now.length() == 0) {
                        int x = 0;
                        while (x < ServerBeat.this.server_item.getProperty("vip2").split(",").length) {
                            String member_ip = ServerBeat.this.server_item.getProperty("vip2").split(",")[x].trim();
                            if (!member_ip.trim().equalsIgnoreCase(System.getProperty("crushftp.hostname", "").trim())) {
                                try {
                                    Socket message_retriever = new Socket();
                                    message_retriever.setSoTimeout(1000);
                                    message_retriever.connect(new InetSocketAddress(member_ip, ServerBeat.this.port));
                                    ObjectInputStream ois = new ObjectInputStream(message_retriever.getInputStream());
                                    try {
                                        Properties msg = (Properties)ois.readUnshared();
                                        Properties reply = ServerBeat.this.runMasterLogic(msg);
                                        ObjectOutputStream oos = new ObjectOutputStream(message_retriever.getOutputStream());
                                        oos.writeUnshared(reply);
                                        oos.flush();
                                        oos.reset();
                                        oos.close();
                                        if (reply.getProperty("uid", "").equals(ServerBeat.this.uid) && !ServerBeat.this.master) {
                                            if (ServerBeat.this.offline_time == 0L) {
                                                ServerBeat.this.offline_time = System.currentTimeMillis();
                                            }
                                            long delay = Long.parseLong(ServerBeat.this.server_item.getProperty("delay_master", "10")) * 1000L;
                                            if (System.currentTimeMillis() - ServerBeat.this.offline_time > delay) {
                                                Log.log("SERVER_BEAT", 0, "We are the oldest, and we are supposed to become master, but we are the controller...so locally promote ourself to master:" + ServerBeat.this.beat_tracker.get(ServerBeat.this.uid));
                                                try {
                                                    Worker.startWorker(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            try {
                                                                ServerBeat.this.becomeMaster((this).ServerBeat.this.listen_ip, (this).ServerBeat.this.index1);
                                                            }
                                                            catch (Exception e) {
                                                                Log.log("SERVER_BEAT", 1, e);
                                                            }
                                                        }
                                                    });
                                                }
                                                catch (Exception exception) {}
                                            } else {
                                                Log.log("SERVER_BEAT", 0, "WAITING:(" + (System.currentTimeMillis() - ServerBeat.this.offline_time) + "ms of " + delay + "ms) We are the oldest, and we are supposed to become master, but we are the controller...so locally promote ourself to master:" + ServerBeat.this.beat_tracker.get(ServerBeat.this.uid));
                                                Thread.sleep(1000L);
                                            }
                                        }
                                    }
                                    finally {
                                        ois.close();
                                        message_retriever.close();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            ++x;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }, "Serverbeat pinger:" + this.server_sock.getLocalPort());
            while (this.socket_created && this.die_now.length() == 0) {
                Thread.sleep(1000L);
                if (this.error != null) {
                    throw this.error;
                }
                this.updateStatus();
            }
        }
        catch (Exception e) {
            if (e.getMessage() == null || e.getMessage().indexOf("socket closed") < 0) {
                Log.log("SERVER_BEAT", 1, e);
            }
            Log.log("SERVER_BEAT", 3, e);
        }
        this.socket_created = false;
        this.kill();
        this.updateStatus();
        if (this.restart) {
            this.restart = false;
            this.die_now = new StringBuffer();
            new Thread(this).start();
        }
    }

    public Properties buildMessage() {
        Properties msg = new Properties();
        msg.put("time", String.valueOf(System.currentTimeMillis()));
        msg.put("start_millis", String.valueOf(this.start_millis));
        msg.put("ip", this.listen_ip);
        msg.put("uid", this.uid);
        msg.put("master", String.valueOf(this.master));
        msg.put("priority", this.server_item.getProperty("priority", "1"));
        msg.put("hostname", System.getProperty("crushftp.hostname"));
        return msg;
    }

    public Properties runMasterLogic(Properties msg) {
        this.beat_tracker.put(this.uid, this.buildMessage());
        this.beat_tracker.put(msg.getProperty("uid"), msg);
        long local_last_logged = this.last_logged;
        if (System.currentTimeMillis() - this.last_logged > 10000L) {
            this.last_logged = System.currentTimeMillis();
        }
        Enumeration<Object> keys = this.beat_tracker.keys();
        while (keys.hasMoreElements()) {
            String key = "" + keys.nextElement();
            msg = (Properties)this.beat_tracker.get(key);
            if (System.currentTimeMillis() - Long.parseLong(msg.getProperty("time", "0")) <= 5000L) continue;
            Log.log("SERVER_BEAT", 0, "Clearing out dead ServerBeat server since we haven't heard from them in 5 seconds..." + this.beat_tracker.get(key));
            this.beat_tracker.remove(key);
        }
        if (System.currentTimeMillis() - this.start_millis > 5000L && this.beat_tracker.size() > 0) {
            Vector<String> master_uids = new Vector<String>();
            long oldest = this.start_millis;
            int highest_priority = Integer.parseInt(this.server_item.getProperty("priority", "0"));
            keys = this.beat_tracker.keys();
            while (keys.hasMoreElements()) {
                String key = "" + keys.nextElement();
                msg = (Properties)this.beat_tracker.get(key);
                if (Long.parseLong(msg.getProperty("start_millis")) < oldest) {
                    oldest = Long.parseLong(msg.getProperty("start_millis"));
                }
                if (Integer.parseInt(msg.getProperty("priority")) > highest_priority) {
                    highest_priority = Integer.parseInt(msg.getProperty("priority"));
                }
                if (!msg.getProperty("master", "").equals("true")) continue;
                master_uids.addElement(msg.getProperty("uid"));
            }
            if (oldest == this.start_millis) {
                Properties reply;
                if (System.currentTimeMillis() - local_last_logged > 10000L) {
                    Log.log("SERVER_BEAT", 2, "We are the oldest, so we act as the logic controller:" + this.beat_tracker.get(this.uid));
                }
                long oldest_high_priority = Long.MAX_VALUE;
                String oldest_high_priority_uid = "";
                keys = this.beat_tracker.keys();
                while (keys.hasMoreElements()) {
                    String key = "" + keys.nextElement();
                    msg = (Properties)this.beat_tracker.get(key);
                    if (!msg.getProperty("priority", "").equals(String.valueOf(highest_priority)) || Long.parseLong(msg.getProperty("start_millis")) >= oldest_high_priority) continue;
                    oldest_high_priority = Long.parseLong(msg.getProperty("start_millis"));
                    oldest_high_priority_uid = key;
                }
                if (master_uids.size() == 1 && master_uids.elementAt(0).equals(oldest_high_priority_uid)) {
                    if (System.currentTimeMillis() - local_last_logged > 10000L) {
                        Log.log("SERVER_BEAT", 2, "The current master is what is expected, so we do nothing:" + this.beat_tracker.get(oldest_high_priority_uid));
                    }
                    reply = new Properties();
                    reply.put("command", "info");
                    reply.put("uid", oldest_high_priority_uid);
                    return reply;
                }
                Log.log("SERVER_BEAT", 0, "We noticed the current master is not the oldest, highest priority...telling them to become master:" + this.beat_tracker.get(oldest_high_priority_uid));
                reply = new Properties();
                reply.put("command", "become_master");
                reply.put("uid", oldest_high_priority_uid);
                return reply;
            }
            if (System.currentTimeMillis() - local_last_logged > 10000L) {
                Log.log("SERVER_BEAT", 3, "We are not the oldest...so we do nothing:" + this.beat_tracker);
            }
        } else {
            Log.log("SERVER_BEAT", 2, "We don't have enough info yet...waiting to allow more servers to report in..." + this.beat_tracker);
        }
        return new Properties();
    }

    public void init(String vip, String index1, int port, String netmask, String adapter) {
        this.vip = vip;
        this.index1 = index1;
        this.port = port;
        this.netmask = netmask;
        this.adapter = adapter;
        try {
            this.master = this.disableMaster(vip, index1, adapter, netmask, ServerStatus.SG("serverbeat_command_disable"), ServerStatus.SG("serverbeat_ifdown_command"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.localIp = Common.getLocalIP();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startBeat() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ServerBeat.this.die_now.append(String.valueOf(System.currentTimeMillis()));
                    Thread.sleep(1000L);
                    Log.log("SERVER_BEAT", 1, "Serverbeat:releasing " + ServerBeat.this.vip + "...");
                    ServerBeat.this.master = ServerBeat.this.disableMaster(ServerBeat.this.vip, ServerBeat.this.index1, ServerBeat.this.adapter, ServerBeat.this.netmask, ServerStatus.SG("serverbeat_command_disable"), ServerStatus.SG("serverbeat_ifdown_command"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Log.log("SERVER_BEAT", 1, "Serverbeat:released " + ServerBeat.this.vip + ".");
            }
        }));
    }

    public void kill() {
        try {
            this.master = this.disableMaster(this.vip, this.index1, this.adapter, this.netmask, ServerStatus.SG("serverbeat_command_disable"), ServerStatus.SG("serverbeat_ifdown_command"));
        }
        catch (Exception e) {
            Log.log("SERVER_BEAT", 1, e);
        }
    }

    public void becomeMaster(String ip, String index) throws Exception {
        this.offline_time = 0L;
        if (this.die_now.length() > 0) {
            return;
        }
        String ifconfig = ServerStatus.SG("serverbeat_command");
        this.master = true;
        ServerStatus.siPUT("current_master", String.valueOf(this.master));
        System.getProperties().put("serverbeat.current_master", String.valueOf(this.master));
        Thread.sleep(2000L);
        Log.log("SERVER_BEAT", 0, "ServerBeat: becoming Master..." + ip + " on " + System.getProperty("crushftp.hostname"));
        if (crushftp.handlers.Common.machine_is_windows()) {
            if (!ifconfig.equals("netsh")) {
                this.exec(new String[]{"cmd", "/C", ifconfig}, this.vip, this.adapter, this.netmask, index);
            } else {
                this.exec(new String[]{"cmd", "/C", String.valueOf(ifconfig) + " interface ip add address name=\"{adapter}\" addr={vip} mask={netmask}"}, this.vip, this.adapter, this.netmask, index);
            }
        } else if (crushftp.handlers.Common.machine_is_solaris() || crushftp.handlers.Common.machine_is_linux()) {
            String ifup = ServerStatus.SG("serverbeat_ifup_command");
            if (!ifup.equals("ifup") && !ifup.equals("/sbin/ifup")) {
                this.exec(ifup.split(" "), this.vip, this.adapter, this.netmask, index);
            } else {
                this.exec((String.valueOf(ServerStatus.SG("serverbeat_ifup_command")) + " {adapter}:{index}").split(" "), this.vip, this.adapter, this.netmask, index);
            }
            if (!ifconfig.equals("ifconfig") && !ifconfig.equals("/sbin/ifconfig")) {
                this.exec(ifconfig.split(" "), this.vip, this.adapter, this.netmask, index);
            } else {
                this.exec((String.valueOf(ifconfig) + " {adapter}:{index} {vip} netmask {netmask} up").split(" "), this.vip, this.adapter, this.netmask, index);
            }
        } else {
            this.exec((String.valueOf(ifconfig) + " {adapter} alias {vip} netmask {netmask}").split(" "), this.vip, this.adapter, this.netmask, index);
        }
        this.master = true;
        ServerStatus.siPUT("current_master", String.valueOf(this.master));
        System.getProperties().put("serverbeat.current_master", String.valueOf(this.master));
        String command = ServerStatus.SG("serverbeat_post_command");
        if (!command.equals("")) {
            command = crushftp.handlers.Common.replace_str(command, "{vip}", ip);
            command = crushftp.handlers.Common.replace_str(command, "{adapter}", this.adapter);
            this.exec(command.split(" "), this.vip, this.adapter, this.netmask, index);
        }
        if (ServerStatus.BG("serverbeat_start_ports")) {
            ServerStatus.thisObj.start_all_servers(true);
        }
        this.changeStateAlert(true);
    }

    public boolean disableMaster(String vip, String index, String adapter, String netmask, String ifconfig_down, String ifdown) throws Exception {
        this.master = false;
        ServerStatus.siPUT("current_master", String.valueOf(this.master));
        System.getProperties().put("serverbeat.current_master", String.valueOf(this.master));
        Log.log("SERVER_BEAT", 0, "ServerBeat: disabling Master..." + vip + " on " + System.getProperty("crushftp.hostname"));
        if (crushftp.handlers.Common.machine_is_windows()) {
            if (!ifconfig_down.equals("netsh")) {
                this.exec(new String[]{"cmd", "/C", ifconfig_down}, vip, adapter, netmask, index);
            } else {
                this.exec(new String[]{"cmd", "/C", String.valueOf(ifconfig_down) + " interface ip delete address name=\"{adapter}\" addr={vip}"}, vip, adapter, netmask, index);
            }
        } else if (crushftp.handlers.Common.machine_is_solaris() || crushftp.handlers.Common.machine_is_linux()) {
            if (!ifconfig_down.equals("ifconfig") && !ifconfig_down.equals("/sbin/ifconfig")) {
                this.exec(ifconfig_down.split(" "), vip, adapter, netmask, index);
            } else {
                this.exec((String.valueOf(ifconfig_down) + " {adapter}:{index} {vip} netmask {netmask} down").split(" "), vip, adapter, netmask, index);
            }
            if (!ifdown.equals("ifdown") && !ifdown.equals("/sbin/ifdown")) {
                this.exec(ifdown.split(" "), vip, adapter, netmask, index);
            } else {
                this.exec((String.valueOf(ifdown) + " {adapter}:{index}").split(" "), vip, adapter, netmask, index);
            }
        } else {
            this.exec((String.valueOf(ifconfig_down) + " {adapter} -alias {vip} netmask {netmask}").split(" "), vip, adapter, netmask, index);
        }
        this.master = false;
        ServerStatus.siPUT("current_master", String.valueOf(this.master));
        System.getProperties().put("serverbeat.current_master", String.valueOf(this.master));
        this.changeStateAlert(false);
        return this.master;
    }

    public void changeStateAlert(boolean becoming) {
        if (this.master != becoming && System.currentTimeMillis() - this.state_change_time > 30000L) {
            try {
                Properties info = new Properties();
                info.put("alert_type", "Master change.  Current:" + this.master + " New:" + becoming);
                info.put("alert_sub_type", "Server IP:" + this.listen_ip);
                info.put("alert_timeout", "0");
                info.put("alert_max", "0");
                info.put("alert_msg", this.server_item.getProperty("display"));
                ServerStatus.thisObj.runAlerts("serverbeat_alert", info, null, null);
            }
            catch (Exception ee) {
                Log.log("BAN", 1, ee);
            }
        }
        this.state_change_time = System.currentTimeMillis();
    }

    public String exec(String[] c, String vip, String adapter, String netmask, String index) throws Exception {
        if (vip.toUpperCase().indexOf("JOB") >= 0) {
            return "";
        }
        Common.check_exec();
        String s = "";
        int x = 0;
        while (x < c.length) {
            c[x] = crushftp.handlers.Common.replace_str(c[x], "{vip}", vip);
            c[x] = crushftp.handlers.Common.replace_str(c[x], "{netmask}", netmask);
            c[x] = crushftp.handlers.Common.replace_str(c[x], "{index}", index);
            c[x] = crushftp.handlers.Common.replace_str(c[x], "{adapter}", adapter);
            s = String.valueOf(s) + c[x] + " ";
            ++x;
        }
        Log.log("SERVER_BEAT", 0, "ServerBeat exec: " + s.trim());
        Process proc = Runtime.getRuntime().exec(c);
        BufferedReader br1 = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        String result = "";
        String lastLine = "";
        while ((result = br1.readLine()) != null) {
            Log.log("SERVER_BEAT", 0, "ServerBeat: " + result);
            lastLine = result;
        }
        proc.waitFor();
        try {
            proc.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lastLine;
    }
}

