/*
 * Decompiled with CFR 0.152.
 */
package crushftp.server;

import com.crushftp.client.Common;
import com.crushftp.client.Worker;
import crushftp.handlers.Log;
import crushftp.handlers.WebTransfer;
import crushftp.server.ServerSessionHTTP;
import crushftp.server.ServerStatus;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class WebSocket {
    ServerSessionHTTP parent_http = null;
    Vector local_outbound_queue = new Vector();
    Vector outbound_queue = null;
    String transfer_key = null;
    WebTransfer transfer_lock = null;
    String transfer_direction = "";
    boolean closed = false;
    long last_chunk_resend_check = 0L;
    int web_sock_num = 0;

    public WebSocket(ServerSessionHTTP parent_http) {
        this.parent_http = parent_http;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleWebSockets(String header0) throws Exception {
        block17: {
            if (header0.indexOf("/U/") >= 0) {
                this.transfer_key = crushftp.handlers.Common.url_decode(header0.substring(header0.indexOf("/U/") + "/U/".length(), header0.lastIndexOf(" ")));
                this.transfer_lock = this.parent_http.processUploadSegment(null, this.transfer_key, 0, 0, null, false);
                this.transfer_direction = "upload";
            } else if (header0.indexOf("/DOWNLOAD/") >= 0) {
                this.transfer_direction = "download";
                this.transfer_key = crushftp.handlers.Common.url_decode(header0.substring(header0.indexOf("/DOWNLOAD/") + "/DOWNLOAD/".length(), header0.lastIndexOf(" ")));
            }
            if (this.transfer_direction.equals("download")) {
                Properties html5_transfers = ServerStatus.siPG("html5_transfers");
                int x = 0;
                while (x < 200 && this.transfer_lock == null) {
                    this.transfer_lock = (WebTransfer)html5_transfers.get(String.valueOf(this.parent_http.thisSession.getId()) + "_" + this.transfer_key.split("~")[0]);
                    if (this.transfer_lock != null) break;
                    Thread.sleep(x < 100 ? x : 100);
                    ++x;
                }
                if (this.transfer_lock == null) {
                    throw new Exception("No open file found for transfer_id:" + this.transfer_key);
                }
                if (this.transfer_lock.getVal("status", "").startsWith("ERROR:")) {
                    throw new Exception(this.transfer_lock.getVal("status", ""));
                }
            }
            this.parent_http.original_os = new BufferedOutputStream(this.parent_http.original_os);
            if (this.transfer_key.indexOf("~") >= 0) {
                this.transfer_key = this.transfer_key.substring(0, this.transfer_key.indexOf("~")).trim();
            }
            String websocket_key = crushftp.handlers.Common.getSHA1Base64(new ByteArrayInputStream((String.valueOf(this.parent_http.headerLookup.getProperty("SEC-WEBSOCKET-KEY").trim()) + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes("UTF8")));
            this.parent_http.write_command_http("HTTP/1.1 101 Switching Protocols");
            this.parent_http.write_command_http("Upgrade: websocket");
            this.parent_http.write_command_http("Connection: Upgrade");
            this.parent_http.write_command_http("Sec-WebSocket-Accept: " + websocket_key);
            this.parent_http.write_command_http("");
            this.parent_http.done = true;
            try {
                if (this.transfer_lock == null) break block17;
                WebTransfer webTransfer = this.transfer_lock;
                synchronized (webTransfer) {
                    if (this.transfer_lock.getObj("outbound_queue") == null) {
                        this.transfer_lock.putObj("outbound_queue", new Vector());
                    }
                    this.outbound_queue = (Vector)this.transfer_lock.getObj("outbound_queue");
                    this.web_sock_num = Integer.parseInt(this.transfer_lock.getVal("web_sock_num", String.valueOf(this.web_sock_num)));
                    ++this.web_sock_num;
                    this.transfer_lock.putObj("web_sock_num", String.valueOf(this.web_sock_num));
                }
                this.startupOutboundProcessor();
                if (this.transfer_direction.equals("download")) {
                    this.startDownloadPusher();
                }
                Thread.currentThread().setName(String.valueOf(Thread.currentThread().getName()) + ":processIncomingPackets");
                this.processIncomingPackets();
            }
            finally {
                if (!this.closed) {
                    this.writeWebSocketClose();
                }
            }
        }
    }

    public void startupOutboundProcessor() throws Exception {
        Worker.startWorker(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String thread_name = Thread.currentThread().getName();
                int delay = 1;
                while (!WebSocket.this.parent_http.sock.isClosed() && !WebSocket.this.closed) {
                    try {
                        Properties p;
                        Thread.currentThread().setName(String.valueOf(thread_name) + ":local_outbound_queue=" + WebSocket.this.local_outbound_queue.size() + ":outbound_queue=" + WebSocket.this.outbound_queue.size() + ":delay=" + delay + ":web_sock_num=" + WebSocket.this.web_sock_num + "/" + WebSocket.this.transfer_lock.getVal("web_sock_num"));
                        while (WebSocket.this.local_outbound_queue.size() > 0 && !WebSocket.this.closed) {
                            p = (Properties)WebSocket.this.local_outbound_queue.remove(0);
                            WebSocket.this.writePacket(p);
                            delay = 1;
                        }
                        while (WebSocket.this.outbound_queue.size() > 0 && !WebSocket.this.closed) {
                            p = null;
                            Vector vector = WebSocket.this.outbound_queue;
                            synchronized (vector) {
                                if (WebSocket.this.outbound_queue.size() > 0) {
                                    p = (Properties)WebSocket.this.outbound_queue.remove(0);
                                }
                            }
                            if (p != null) {
                                WebSocket.this.writePacket(p);
                            }
                            delay = 1;
                        }
                        WebSocket.this.parent_http.original_os.flush();
                    }
                    catch (Exception e) {
                        Log.log("HTTP_SERVER", 1, "WebSocket Error:" + e);
                        Log.log("HTTP_SERVER", 1, e);
                        try {
                            WebSocket.this.writeWebSocketClose();
                        }
                        catch (Exception e1) {
                            Log.log("HTTP_SERVER", 1, e1);
                        }
                        try {
                            WebSocket.this.parent_http.sock.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.sleep(delay++);
                        if (delay <= 100) continue;
                        delay = 100;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }, String.valueOf(Thread.currentThread().getName()) + ":WebSocketOutboundWriter");
    }

    public void writePacket(Properties p) throws Exception {
        byte[] msg = (byte[])p.get("msg");
        byte[] payload = (byte[])p.get("payload");
        Log.log("HTTP_SERVER", 2, this.parent_http.sock + ":Writing WebSocket message:" + String.format("%8s", Integer.toBinaryString(msg[0] & 0xFF)).replace(' ', '0') + "_" + String.format("%8s", Integer.toBinaryString(msg[1] & 0xFF)).replace(' ', '0') + ":payload_len=" + (payload == null ? 0 : payload.length));
        this.parent_http.original_os.write(msg);
        if (payload != null) {
            this.parent_http.original_os.write(payload);
        }
    }

    public void processIncomingPackets() throws Exception {
        String thread_name = Thread.currentThread().getName();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean fragmented = false;
        int last_opcode = 0;
        while (!this.closed) {
            byte[] b1;
            byte[] b;
            Thread.currentThread().setName(String.valueOf(thread_name) + ":transfer_direction=" + this.transfer_direction + ":local_outbound_queue=" + this.local_outbound_queue.size() + ":outbound_queue=" + this.outbound_queue.size() + ":web_sock_num=" + this.web_sock_num + "/" + this.transfer_lock.getVal("web_sock_num"));
            byte[] fin_rsv123_opcode = new byte[1];
            byte[] mask_payload = new byte[1];
            int i = 0;
            i = Common.readFully(this.parent_http.original_is, fin_rsv123_opcode);
            if (i < 0) break;
            int fin = (fin_rsv123_opcode[0] & 0x80) == 128 ? 1 : 0;
            int opcode = fin_rsv123_opcode[0] & 0xF;
            i = Common.readFully(this.parent_http.original_is, mask_payload);
            if (i < 0) break;
            boolean mask = (mask_payload[0] & 0x80) == 128;
            long payload_len = mask_payload[0] & 0x7F;
            if (payload_len == 126L) {
                b = new byte[2];
                i = Common.readFully(this.parent_http.original_is, b);
                if (i < 0) break;
                payload_len = (b[0] & 0xFF) << 8 | b[1] & 0xFF;
            } else if (payload_len == 127L) {
                b = new byte[8];
                i = Common.readFully(this.parent_http.original_is, b);
                if (i < 0) break;
                payload_len = (b[0] & 0xFF) << 64 | (b[1] & 0xFF) << 48 | (b[2] & 0xFF) << 40 | (b[3] & 0xFF) << 32 | (b[4] & 0xFF) << 24 | (b[5] & 0xFF) << 16 | (b[6] & 0xFF) << 8 | b[7] & 0xFF;
            }
            if (payload_len < 0L) break;
            Log.log("HTTP_SERVER", 2, this.parent_http.sock + ":Read WebSocket message:" + String.format("%8s", Integer.toBinaryString(fin_rsv123_opcode[0] & 0xFF)).replace(' ', '0') + ":opcode=" + opcode + ":fin=" + fin + ":payload_len=" + payload_len);
            byte[] masking_key = new byte[4];
            if (mask) {
                i = Common.readFully(this.parent_http.original_is, masking_key);
            }
            if (i < 0 || (i = Common.readFully(this.parent_http.original_is, b1 = new byte[(int)payload_len])) < 0) break;
            if (fin == 0 && !fragmented) {
                fragmented = true;
                last_opcode = opcode;
            }
            if (opcode == 8) {
                this.writeWebSocketClose();
                this.closed = true;
                break;
            }
            if (opcode == 1 || opcode == 2 || opcode == 0 && last_opcode == 2 && fragmented) {
                byte[] b2;
                IntStream.rangeClosed(0, b1.length - 1).boxed().collect(Collectors.toList()).parallelStream().forEach(x -> {
                    int n = x;
                    byte by = byArray[n] = (byte)(b1[n] ^ masking_key[x % 4]);
                });
                baos.write(b1);
                if (fin == 1 && this.transfer_direction.equals("upload")) {
                    b2 = baos.toByteArray();
                    ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                    baos2.write(b2, 4, b2.length - 4);
                    int chunk_num = (b2[0] & 0xFF) << 24 | (b2[1] & 0xFF) << 16 | (b2[2] & 0xFF) << 8 | b2[3] & 0xFF;
                    Log.log("HTTP_SERVER", 2, this.parent_http.sock + ":Processing WebSocket Upload:transfer_key=" + this.transfer_key + ":chunk_num=" + chunk_num + ":chunk_size=" + baos2.toByteArray().length);
                    try {
                        this.parent_http.processUploadSegment(this.transfer_lock, String.valueOf(this.transfer_key) + "~" + chunk_num, chunk_num, baos2.toByteArray().length, baos2, false);
                    }
                    catch (Exception e) {
                        Log.log("HTTP_SERVER", 1, "WebSocket Error:" + e);
                        Log.log("HTTP_SERVER", 1, e);
                        Properties p = new Properties();
                        byte[] data = ("ERROR:" + e).getBytes("UTF8");
                        p.put("payload", data);
                        byte[] msg = new byte[]{-127, (byte)data.length};
                        p.put("msg", msg);
                        this.outbound_queue.addElement(p);
                        msg = new byte[]{-120, 0};
                        p = new Properties();
                        p.put("msg", msg);
                        this.outbound_queue.addElement(p);
                        continue;
                    }
                    Properties p = new Properties();
                    byte[] data = String.valueOf(chunk_num).getBytes("UTF8");
                    p.put("payload", data);
                    byte[] msg = new byte[]{-127, (byte)data.length};
                    p.put("msg", msg);
                    this.outbound_queue.addElement(p);
                } else if (fin == 1 && this.transfer_direction.equals("download")) {
                    b2 = baos.toByteArray();
                    int chunk_num = (b2[0] & 0xFF) << 24 | (b2[1] & 0xFF) << 16 | (b2[2] & 0xFF) << 8 | b2[3] & 0xFF;
                    Properties chunk = (Properties)this.transfer_lock.removeChunk(String.valueOf(chunk_num));
                    if (chunk != null) {
                        chunk.remove("b");
                    }
                    Log.log("HTTP_SERVER", 2, this.parent_http.sock + ":WebSocket Download...Acknowledged:transfer_key=" + this.transfer_key + ":chunk_num=" + chunk_num + ":websocket_chunk_num=" + this.transfer_lock.getObj("websocket_chunk_num") + ":total_chunks=" + this.transfer_lock.getVal("total_chunks"));
                }
            } else if (opcode == 9) {
                Properties p = new Properties();
                byte[] msg = new byte[2];
                msg[0] = -118;
                ByteArrayOutputStream pong_msg = new ByteArrayOutputStream();
                int x2 = 0;
                while (x2 < b1.length) {
                    pong_msg.write((byte)(b1[x2] ^ masking_key[x2 % 4]));
                    ++x2;
                }
                msg[1] = (byte)pong_msg.toByteArray().length;
                p.put("msg", msg);
                p.put("payload", pong_msg.toByteArray());
                Log.log("HTTP_SERVER", 2, this.parent_http.sock + ":PING/PONG WebSocket:" + String.format("%8s", Integer.toBinaryString(msg[0] & 0xFF)).replace(' ', '0') + "_" + String.format("%8s", Integer.toBinaryString(msg[1] & 0xFF)).replace(' ', '0') + ":pong_msg=" + new String(pong_msg.toByteArray()));
                this.local_outbound_queue.insertElementAt(p, 0);
            }
            if (fin != 1) continue;
            fragmented = false;
            last_opcode = 0;
            baos.reset();
        }
    }

    public void startDownloadPusher() throws Exception {
        Worker.startWorker(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WebTransfer webTransfer = WebSocket.this.transfer_lock;
                synchronized (webTransfer) {
                    if (WebSocket.this.transfer_lock.getObj("websocket_chunk_num") == null) {
                        WebSocket.this.transfer_lock.putObj("websocket_chunk_num", "0");
                    }
                }
                WebSocket.this.last_chunk_resend_check = 0L;
                int delay = 0;
                String thread_name = Thread.currentThread().getName();
                while (WebSocket.this.transfer_lock.getVal("blockDownloads", "false").equals("false") && !WebSocket.this.closed) {
                    try {
                        int chunk_num = WebSocket.this.getNextChunkNum();
                        if (chunk_num == 0 && !WebSocket.this.transfer_lock.getVal("status", "").startsWith("ERROR:")) {
                            if (delay > 1000) {
                                Log.log("HTTP_SERVER", 2, WebSocket.this.parent_http.sock + ":Retrying WebSocket Download...no data available:transfer_key=" + WebSocket.this.transfer_key + ":chunk_num=" + chunk_num + ":websocket_chunk_num=" + WebSocket.this.transfer_lock.getObj("websocket_chunk_num") + ":total_chunks=" + WebSocket.this.transfer_lock.getVal("total_chunks"));
                            }
                            Thread.sleep(delay);
                            if ((delay += 100) <= 5000) continue;
                            delay = 5000;
                            continue;
                        }
                        Thread.currentThread().setName(String.valueOf(thread_name) + ":chunk_num=" + chunk_num + ":web_sock_num=" + WebSocket.this.web_sock_num + "/" + WebSocket.this.transfer_lock.getVal("web_sock_num"));
                        Object o = null;
                        try {
                            o = WebSocket.this.parent_http.parseDownloadSegment(String.valueOf(WebSocket.this.transfer_key) + "~" + chunk_num, true, true, WebSocket.this.transfer_lock);
                            delay = 0;
                        }
                        catch (Exception e) {
                            Log.log("HTTP_SERVER", 1, "WebSocket Error:" + e);
                            Log.log("HTTP_SERVER", 1, e);
                            o = e;
                        }
                        if (o instanceof WebTransfer) {
                            int chunk_num_tmp = chunk_num;
                            if (WebSocket.this.transfer_lock.hasObj("total_chunks")) {
                                chunk_num_tmp = Integer.parseInt(WebSocket.this.transfer_lock.getVal("total_chunks"));
                            }
                            if (WebSocket.this.transfer_lock.hasObj("total_chunks") && chunk_num > Integer.parseInt(WebSocket.this.transfer_lock.getVal("total_chunks"))) {
                                WebSocket.this.queueWebSocketChunkBytePacket(chunk_num, new byte[0]);
                            }
                            Log.log("HTTP_SERVER", 2, WebSocket.this.parent_http.sock + ":Processing WebSocket Download Completed:transfer_key=" + WebSocket.this.transfer_key + ":chunk_num=" + chunk_num);
                            String chunks_list = "";
                            int x = 0;
                            while (x <= chunk_num_tmp) {
                                Properties chunk = (Properties)WebSocket.this.transfer_lock.getChunk(String.valueOf(x));
                                if (chunk != null && System.currentTimeMillis() - Long.parseLong(chunk.getProperty("time")) > 10000L) {
                                    chunks_list = String.valueOf(chunks_list) + x + ",";
                                }
                                ++x;
                            }
                            if (!chunks_list.equals("")) {
                                Log.log("HTTP_SERVER", 2, WebSocket.this.parent_http.sock + ":Processing WebSocket Download PENDING 10sec ACK LIST END:transfer_key=" + WebSocket.this.transfer_key + ":pending_chunk_num_ack=" + chunks_list + ":chunk_num=" + chunk_num + ":total_chunks=" + WebSocket.this.transfer_lock.getVal("total_chunks"));
                            }
                            if (chunks_list.equals("")) break;
                            Thread.sleep(1000L);
                        } else if (o instanceof Exception) {
                            Log.log("HTTP_SERVER", 0, WebSocket.this.parent_http.sock + ":Processing WebSocket Download Error:transfer_key=" + WebSocket.this.transfer_key + ":chunk_num=" + chunk_num + ":Error=" + o + ":total_chunks=" + WebSocket.this.transfer_lock.getVal("total_chunks"));
                            byte[] msg = new byte[2];
                            msg[0] = -120;
                            String s = "ERROR:" + o;
                            if (s.length() > 125) {
                                s = s.substring(0, 125);
                            }
                            msg[1] = (byte)s.length();
                            try {
                                WebSocket.this.parent_http.original_os.write(msg);
                                WebSocket.this.parent_http.original_os.write(s.getBytes("UTF8"));
                                WebSocket.this.parent_http.original_os.flush();
                                WebSocket.this.writeWebSocketClose();
                            }
                            catch (Exception e) {
                                Log.log("HTTP_SERVER", 1, "WebSocket Error:" + e);
                                Log.log("HTTP_SERVER", 1, e);
                            }
                            WebSocket.this.transfer_lock.putObj("blockDownloads", "true");
                            break;
                        }
                        if (o instanceof String) {
                            Log.log("HTTP_SERVER", 2, WebSocket.this.parent_http.sock + ":Retrying WebSocket Download Warning:transfer_key=" + WebSocket.this.transfer_key + ":chunk_num=" + chunk_num + ":Error=" + o + ":total_chunks=" + WebSocket.this.transfer_lock.getVal("total_chunks"));
                            Thread.sleep(delay);
                            if ((delay += 100) <= 5000) continue;
                            delay = 5000;
                            continue;
                        }
                        if (!(o instanceof byte[])) continue;
                        WebSocket.this.queueWebSocketChunkBytePacket(chunk_num, (byte[])o);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Log.log("HTTP_SERVER", 1, "WebSocket Error:" + e);
                        Log.log("HTTP_SERVER", 1, e);
                    }
                }
            }
        }, String.valueOf(Thread.currentThread().getName()) + ":WebSocketDownloadChunkGenerator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextChunkNum() throws Exception {
        int chunk_num;
        block17: {
            chunk_num = 0;
            int old_count = 0;
            String chunks_list = "";
            int max_chunks = ServerStatus.IG("max_html5_pending_download_chunks");
            int chunk_num_tmp = Integer.parseInt(this.transfer_lock.getObj("websocket_chunk_num").toString());
            WebTransfer webTransfer = this.transfer_lock;
            synchronized (webTransfer) {
                if (this.transfer_lock.getChunkCount() > max_chunks || System.currentTimeMillis() - this.last_chunk_resend_check > 10000L) {
                    int x = 0;
                    while (x <= chunk_num_tmp) {
                        Properties chunk = (Properties)this.transfer_lock.getChunk(String.valueOf(x));
                        if (chunk != null && System.currentTimeMillis() - Long.parseLong(chunk.getProperty("time")) > 10000L) {
                            chunks_list = String.valueOf(chunks_list) + x + ",";
                        }
                        if (chunk != null && System.currentTimeMillis() - Long.parseLong(chunk.getProperty("time")) > 30000L && old_count++ == 0) {
                            chunk_num = x;
                            chunk.put("time", String.valueOf(System.currentTimeMillis()));
                        }
                        ++x;
                    }
                    if (old_count <= 1 && System.currentTimeMillis() - this.last_chunk_resend_check > 10000L) {
                        this.last_chunk_resend_check = System.currentTimeMillis();
                    }
                }
            }
            if (chunk_num != 0) {
                Log.log("HTTP_SERVER", 2, this.parent_http.sock + ":Processing WebSocket Download RETRY SEND:transfer_key=" + this.transfer_key + ":retry_chunk_num=" + chunk_num + ":total_chunks=" + this.transfer_lock.getVal("total_chunks"));
            }
            if (old_count > 0 && !chunks_list.equals("")) {
                Log.log("HTTP_SERVER", 2, this.parent_http.sock + ":Processing WebSocket Download PENDING 10sec ACK LIST:transfer_key=" + this.transfer_key + ":pending_chunk_num_ack=" + chunks_list + ":chunk_num=" + chunk_num_tmp + ":total_chunks=" + this.transfer_lock.getVal("total_chunks"));
            }
            if (chunk_num == 0 && this.transfer_lock.getChunkCount() > max_chunks) {
                Log.log("HTTP_SERVER", 1, "WARNING!  Slowing outbound WebSocket HTTP download due to chunks not being acknowledged (max chunk count used). Pending ACK:" + this.transfer_lock.getChunkCount() + ".  This HTTP session buffer:" + Common.format_bytes_short(this.transfer_lock.getBytes()) + " Total for all HTTP sessions:" + Common.format_bytes_short(ServerStatus.siLG("ram_pending_bytes")) + " max_html5_pending_download_chunks=" + max_chunks + ":total_chunks=" + this.transfer_lock.getVal("total_chunks"));
                Thread.sleep(1000L);
            }
            webTransfer = this.transfer_lock;
            synchronized (webTransfer) {
                block16: {
                    if (chunk_num != 0) break block17;
                    chunk_num = Integer.parseInt(this.transfer_lock.getObj("websocket_chunk_num").toString());
                    if (this.transfer_lock.hasObj("total_chunks") && ++chunk_num > Integer.parseInt(this.transfer_lock.getVal("total_chunks"))) {
                        return chunk_num;
                    }
                    if (this.transfer_lock.hasChunk(String.valueOf(chunk_num))) break block16;
                    return 0;
                }
                this.transfer_lock.putObj("websocket_chunk_num", String.valueOf(chunk_num));
            }
        }
        return chunk_num;
    }

    public void queueWebSocketChunkBytePacket(int chunk_num, byte[] b) {
        Log.log("HTTP_SERVER", 2, this.parent_http.sock + ":Processing WebSocket Download:SENDING:transfer_key=" + this.transfer_key + ":chunk_num=" + chunk_num + ":chunk_size=" + (b.length + 8));
        Properties p = new Properties();
        byte[] msg = new byte[2];
        msg[0] = -126;
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putInt(chunk_num);
        buffer.putInt(b.length);
        byte[] data = new byte[b.length + 8];
        System.arraycopy(buffer.array(), 0, data, 0, 8);
        System.arraycopy(b, 0, data, 8, b.length);
        if (data.length < 126) {
            msg[1] = (byte)data.length;
        } else if (data.length < 65535) {
            buffer = ByteBuffer.allocate(2);
            buffer.putShort((short)data.length);
            byte[] btmp = buffer.array();
            msg = new byte[]{msg[0], 126, btmp[0], btmp[1]};
        } else {
            buffer = ByteBuffer.allocate(8);
            buffer.putLong(data.length);
            byte[] btmp = buffer.array();
            msg = new byte[]{msg[0], 127, btmp[0], btmp[1], btmp[2], btmp[3], btmp[4], btmp[5], btmp[6], btmp[7]};
        }
        p.put("payload", data);
        p.put("msg", msg);
        this.outbound_queue.addElement(p);
    }

    public void writeWebSocketClose() throws Exception {
        this.closed = true;
        byte[] msg = new byte[]{-120, 0};
        this.parent_http.original_os.write(msg);
        this.parent_http.original_os.flush();
        Log.log("HTTP_SERVER", 2, this.parent_http.sock + ":Closing WebSocket:" + String.format("%8s", Integer.toBinaryString(msg[0] & 0xFF)).replace(' ', '0') + "_" + String.format("%8s", Integer.toBinaryString(msg[1] & 0xFF)).replace(' ', '0'));
    }
}

