/*
 * Decompiled with CFR 0.152.
 */
package crushftp.reports8;

import crushftp.handlers.Common;
import crushftp.handlers.Log;
import crushftp.server.AdminControls;
import crushftp.server.ServerStatus;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class JobSchedulesHistory {
    Properties server_info = null;
    Properties server_settings = null;

    public void init(Properties server_settings, Properties server_info) {
        this.server_settings = server_settings;
        this.server_info = server_info;
    }

    public void generate(Properties stats, Properties params, StringBuffer sb, Properties status) {
        try {
            Common.setupReportDates(params, params.getProperty("show", ""), params.getProperty("startDate"), params.getProperty("endDate"));
            sorter cd1 = new sorter();
            cd1.setObj(new Properties(), "scheduleName");
            Vector jobs = new Vector();
            Properties request = (Properties)params.clone();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss", Locale.US);
            request.put("start_time", String.valueOf(sdf.parse(request.getProperty("startDate")).getTime()));
            request.put("end_time", String.valueOf(sdf.parse(request.getProperty("endDate")).getTime()));
            jobs = AdminControls.getJobsSummary(request, "");
            int x = jobs.size() - 1;
            while (x >= 0) {
                Properties p = (Properties)jobs.get(x);
                if (p.getProperty("status").equals("running") && params.getProperty("showRunning", "").equals("false")) {
                    jobs.remove(x);
                } else if (p.getProperty("status").equals("paused") && params.getProperty("showPaused", "").equals("false")) {
                    jobs.remove(x);
                } else if (p.getProperty("status").equals("cancelled") && params.getProperty("showCancelled", "").equals("false")) {
                    jobs.remove(x);
                } else if (p.getProperty("status").equals("completed") && params.getProperty("showCompleted", "").equals("false")) {
                    jobs.remove(x);
                } else if (p.getProperty("status").equals("completed-errors") && params.getProperty("showCompletedWithErrors", "").equals("false")) {
                    jobs.remove(x);
                }
                --x;
            }
            jobs = this.doSort(jobs, cd1);
            Properties results = new Properties();
            results.put("jobs", jobs);
            results.put("export", params.getProperty("export", ""));
            results.put("params", Common.removeNonStrings(params).toString());
            results.put("paramsObj", Common.removeNonStrings(params));
            status.put("report_empty", "false");
            Common cfr_ignored_0 = ServerStatus.thisObj.common_code;
            sb.append(Common.getXMLString(results, "results", "WebInterface/Reports/JobSchedulesHistory.xsl"));
        }
        catch (Exception e) {
            Log.log("REPORT", 1, e);
        }
    }

    public Vector doSort(Vector v, sorter c) {
        Object[] objs = v.toArray();
        Arrays.sort(objs, c);
        v.removeAllElements();
        int x = 0;
        while (x < objs.length) {
            v.addElement(objs[x]);
            ++x;
        }
        return v;
    }

    class sorter
    implements Comparator {
        Properties allItems = null;
        String sort = null;

        sorter() {
        }

        public void setObj(Properties allItems, String sort) {
            this.allItems = allItems;
            this.sort = sort;
        }

        public int compare(Object p1, Object p2) {
            String val1 = ((Properties)p1).getProperty(this.sort, "0");
            String val2 = ((Properties)p2).getProperty(this.sort, "0");
            try {
                if (Float.parseFloat(val1) > Float.parseFloat(val2)) {
                    return -1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (Float.parseFloat(val1) < Float.parseFloat(val2)) {
                    return 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return val1.compareTo(val2) * 1;
        }
    }
}

