/*
 * Decompiled with CFR 0.152.
 */
package crushftp.handlers;

import com.crushftp.client.Base64;
import com.crushftp.client.File_S;
import com.crushftp.client.URLConnection;
import com.crushftp.client.VRL;
import com.crushftp.client.Worker;
import crushftp.handlers.Common;
import crushftp.handlers.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class UpdateHandler {
    static final long serialVersionUID = 0L;
    public long updateMaxSize = 51200L;
    public long updateCurrentLoc = 0L;
    public static String updateCurrentStatus = "";
    boolean stopNow = false;
    SimpleDateFormat MMddyyHHmmss = new SimpleDateFormat("MMddyyHHmmss", Locale.US);

    public void cancel() {
        this.stopNow = true;
    }

    public boolean doSilentUpdate(boolean earlyAccess, String thisVersion, boolean webOnly) throws Exception {
        this.stopNow = false;
        this.updateCurrentLoc = 0L;
        updateCurrentStatus = "Building list of files...";
        int minMd5Size = 262144;
        String fname = String.valueOf(System.getProperty("appname", "CrushFTP")) + Common.V();
        updateCurrentStatus = "Building list of files..." + fname;
        String url = "https://www." + System.getProperty("appname", "CrushFTP").toLowerCase() + ".com/";
        String username = "early" + Common.V();
        String password = "early" + Common.V();
        final String home = System.getProperty("crushftp.home");
        final String homeF = new File_S(home).getCanonicalPath();
        final String backup2 = String.valueOf(System.getProperty("crushftp.backup")) + "backup/" + this.MMddyyHHmmss.format(new Date()) + "_" + thisVersion + " Files/";
        new File_S(backup2).mkdirs();
        final Properties backup_status = new Properties();
        try {
            Worker.startWorker(new Runnable(){

                @Override
                public void run() {
                    try {
                        UpdateHandler.this.backupCurrentZip(home, backup2);
                        backup_status.put("status", "DONE");
                    }
                    catch (Exception e) {
                        Log.log("SERVER", 0, e);
                        backup_status.put("error", e);
                        backup_status.put("status", "ERROR");
                    }
                }
            });
        }
        catch (Exception e) {
            Log.log("SERVER", 0, e);
        }
        if (!new File_S(String.valueOf(home) + fname + "_new.zip").exists() && !new File_S(String.valueOf(home) + fname + "_PC_new.zip").exists()) {
            Vector files2 = new Vector();
            int loops = 0;
            while (files2.size() == 0 && loops++ < 5) {
                files2 = this.getServerFileInfo(fname, username, password, url);
                if (files2.size() != 0) continue;
                Thread.sleep(3000L);
            }
            final Vector files = files2;
            files.removeElementAt(files.size() - 1);
            int x = files.size() - 1;
            while (x >= 0) {
                updateCurrentStatus = "Building list of files...:" + x;
                Properties p = (Properties)files.elementAt(x);
                if (p.getProperty("name").equals(String.valueOf(System.getProperty("appname", "CrushFTP").toLowerCase()) + "_init.sh")) {
                    files.remove(x);
                } else if (p.getProperty("name").equals("Info.plist")) {
                    files.remove(x);
                } else if (p.getProperty("name").equals(String.valueOf(System.getProperty("appname", "CrushFTP")) + ".command")) {
                    files.remove(x);
                } else if (p.getProperty("name").equalsIgnoreCase(".DS_Store")) {
                    files.remove(x);
                } else if (p.getProperty("name").equalsIgnoreCase("thumbs.db")) {
                    files.remove(x);
                } else if (p.getProperty("name").equalsIgnoreCase("logo.png")) {
                    files.remove(x);
                } else if (p.getProperty("name").equalsIgnoreCase("mime_types.txt")) {
                    files.remove(x);
                } else if (p.getProperty("name").equalsIgnoreCase("expired.html")) {
                    files.remove(x);
                } else if (p.getProperty("name").equalsIgnoreCase("favicon.ico")) {
                    files.remove(x);
                } else if (p.getProperty("name").equalsIgnoreCase("win_service.jar") && Common.machine_is_x()) {
                    files.remove(x);
                } else if (p.getProperty("path").toUpperCase().indexOf("/USERS/") >= 0) {
                    files.remove(x);
                } else if (webOnly && p.getProperty("path").indexOf("/WebInterface/") < 0) {
                    files.remove(x);
                }
                if (this.stopNow) {
                    return false;
                }
                --x;
            }
            final StringBuffer localStatus = new StringBuffer();
            Worker.startWorker(new Runnable(){

                @Override
                public void run() {
                    int x = 0;
                    while (x < files.size()) {
                        updateCurrentStatus = "Building list of file differences...:" + (x + 1) + " of " + (files.size() + 1);
                        if (UpdateHandler.this.stopNow) break;
                        Properties p = (Properties)files.elementAt(x);
                        String tmpPath = p.getProperty("path");
                        tmpPath = tmpPath.substring(tmpPath.indexOf("/", 1));
                        if (new File_S(String.valueOf(homeF) + tmpPath).exists()) {
                            p.put("localSize", String.valueOf(new File_S(String.valueOf(homeF) + tmpPath).length()));
                            p.put("localModified", String.valueOf(new File_S(String.valueOf(homeF) + tmpPath).lastModified()));
                            if (p.getProperty("type").equals("FILE")) {
                                try {
                                    p.put("localMd5", Common.getMD5(new FileInputStream(new File_S(String.valueOf(homeF) + tmpPath))).trim().toUpperCase().substring(24));
                                }
                                catch (Exception e) {
                                    Log.log("UPDATE", 0, e);
                                }
                            }
                        }
                        ++x;
                    }
                    localStatus.append("done");
                }
            });
            int x2 = 0;
            while (x2 < files.size()) {
                updateCurrentStatus = "Building list of server differences...:" + (x2 + 1) + " of " + (files.size() + 1);
                Properties p = (Properties)files.elementAt(x2);
                if (p.getProperty("type").equals("FILE") && !p.containsKey("md5")) {
                    Log.log("UPDATE", 0, "Looking up file md5:" + p);
                    URLConnection urlc = UpdateHandler.getURLConnection(username, password, url, "?command=getMd5s&chunked=false&path=" + Base64.encodeBytes(p.getProperty("path").getBytes("UTF8")), "GET");
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    com.crushftp.client.Common.copyStreams(urlc.getInputStream(), baos, true, true);
                    if (urlc != null) {
                        urlc.disconnect();
                    }
                    p.put("md5", "");
                    try {
                        p.put("md5", new String(baos.toByteArray()).trim().toUpperCase().substring(24));
                    }
                    catch (Exception e) {
                        Log.log("SERVER", 1, e);
                    }
                }
                if (this.stopNow) {
                    return false;
                }
                ++x2;
            }
            while (localStatus.length() == 0) {
                Thread.sleep(100L);
            }
            StringBuffer paths = new StringBuffer();
            int largeFiles = 0;
            int smallFiles = 0;
            long totalBytes = 0L;
            int x3 = 0;
            while (x3 < files.size()) {
                Properties p = (Properties)files.elementAt(x3);
                if (p.getProperty("type").equals("DIR")) {
                    String tmpPath = p.getProperty("path");
                    tmpPath = tmpPath.substring(tmpPath.indexOf("/", 1));
                    if (!new File_S(String.valueOf(homeF) + tmpPath).exists()) {
                        new File_S(String.valueOf(homeF) + tmpPath).mkdirs();
                    }
                } else if (!p.getProperty("md5", "1").trim().equalsIgnoreCase(p.getProperty("localMd5", "2").trim())) {
                    paths.append(p.getProperty("path"));
                    if (x3 < files.size() - 1) {
                        paths.append(":");
                    }
                    totalBytes += Long.parseLong(p.getProperty("size"));
                    if (p.getProperty("name").endsWith(".jar") || Long.parseLong(p.getProperty("size")) > 262144L) {
                        Log.log("UPDATE", 0, "Update needed on larger file:" + p.getProperty("path"));
                        ++largeFiles;
                    } else {
                        ++smallFiles;
                    }
                }
                if (this.stopNow) {
                    return false;
                }
                ++x3;
            }
            this.updateMaxSize = totalBytes;
            Log.log("UPDATE", 0, "Updating " + smallFiles + " small files, and " + largeFiles + " large files:" + com.crushftp.client.Common.format_bytes_short2(this.updateMaxSize));
            if (this.stopNow) {
                return false;
            }
            Log.log("UPDATE", 0, "Updating files:" + paths);
            try {
                updateCurrentStatus = "Downloading " + (smallFiles + largeFiles) + " files.";
                this.getFileHTTP(home, fname, "zip", url, paths.toString(), username, password);
                updateCurrentStatus = "Unzipping " + (smallFiles + largeFiles) + " files.";
            }
            finally {
                this.updateCurrentLoc = 0L;
                this.updateMaxSize = 51200L;
                this.stopNow = false;
            }
            Common.recurseCopy(String.valueOf(home) + fname + "_new.zip", String.valueOf(backup2) + fname + "_new.zip", true);
        } else {
            if (new File_S(String.valueOf(home) + fname + "_PC_new.zip").exists() && !new File_S(String.valueOf(home) + fname + "_new.zip").exists()) {
                fname = String.valueOf(System.getProperty("appname", "CrushFTP")) + Common.V() + "_PC";
            }
            updateCurrentStatus = "Using local offline file...: " + fname + "_new.zip";
            Thread.sleep(1000L);
        }
        try {
            updateCurrentStatus = "Waiting for completion of full_app.zip...";
            while (backup_status.getProperty("status", "").equals("")) {
                Thread.sleep(100L);
            }
            if (backup_status.containsKey("error")) {
                throw (Exception)backup_status.get("error");
            }
            updateCurrentStatus = "Performing update with " + fname + "_new.zip...";
            UpdateHandler.doUpdate(home, backup2, String.valueOf(fname) + "_new.zip");
            new File_S(String.valueOf(home) + fname + "_new.zip").delete();
            if (this.stopNow) {
                return false;
            }
        }
        catch (Exception e) {
            Log.log("SERVER", 0, e);
            e.printStackTrace();
        }
        finally {
            this.updateCurrentLoc = 0L;
            this.updateMaxSize = 51200L;
            this.stopNow = false;
        }
        updateCurrentStatus = "COMPLETE";
        Thread.sleep(2000L);
        if (webOnly) {
            new File_S(String.valueOf(home) + fname + "_new.zip").delete();
        }
        Worker.startWorker(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                updateCurrentStatus = "";
            }
        });
        return true;
    }

    public void backupCurrentZip(String home, String backup2) throws Exception {
        Vector<File_S> list = new Vector<File_S>();
        list.add(new File_S(String.valueOf(home) + System.getProperty("appname", "CrushFTP") + ".jar"));
        Common.appendListing(String.valueOf(home) + "plugins/", list, "", 99, true);
        Common.appendListing(String.valueOf(home) + "WebInterface/", list, "", 99, true);
        Vector<Properties> list2 = new Vector<Properties>();
        Properties history_hash = new Properties();
        int x = 0;
        while (x < list.size()) {
            Properties p = new Properties();
            String url1 = "" + ((File_S)list.elementAt(x)).toURI().toURL();
            p.put("url", Common.replace_str(url1, "/./", "/"));
            if (!history_hash.containsKey(url1)) {
                list2.addElement(p);
            }
            history_hash.put(url1, "");
            ++x;
        }
        Common.zip(home, list2, String.valueOf(backup2) + "full_app.zip", false);
    }

    public Vector getServerFileInfo(String f, String username, String password, String url) {
        Vector<Properties> serverFileList = new Vector<Properties>();
        URLConnection urlc = null;
        try {
            try {
                URL u = new URL(String.valueOf(url) + f + "/:filetree");
                Log.log("UPDATE", 0, "Getting folder contents information " + u.toExternalForm());
                urlc = UpdateHandler.getURLConnection(username, password, url, String.valueOf(f) + "/:filetree", "GET");
                InputStream in = urlc.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF8"));
                String data = "";
                while ((data = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(data);
                    Properties p = new Properties();
                    p.put("permissions", st.nextToken());
                    if (p.getProperty("permissions").startsWith("d")) {
                        p.put("type", "DIR");
                    } else {
                        p.put("type", "FILE");
                    }
                    st.nextToken();
                    String owner = st.nextToken();
                    String group = st.nextToken();
                    if (owner.equalsIgnoreCase("MD5")) {
                        p.put("md5", group);
                    }
                    long tempfileSize = Long.parseLong(st.nextToken());
                    p.put("modified", st.nextToken());
                    st.nextToken();
                    String year = st.nextToken();
                    String rootdir = data.substring(data.indexOf(String.valueOf(year) + " /") + (String.valueOf(year) + " ").length()).trim();
                    p.put("path", rootdir);
                    p.put("name", Common.last(rootdir));
                    p.put("size", String.valueOf(tempfileSize));
                    serverFileList.addElement(p);
                }
            }
            catch (Exception e) {
                Log.log("UPDATE", 0, e);
                try {
                    if (urlc != null) {
                        urlc.disconnect();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (urlc != null) {
                    urlc.disconnect();
                }
            }
            catch (IOException iOException) {}
        }
        return serverFileList;
    }

    public String getFileHTTP(String localPath, String name, String ext, String url, String paths, String username, String password) throws Exception {
        URLConnection urlc = null;
        try {
            urlc = UpdateHandler.getURLConnection(username, password, url, "command=downloadAsZip&path_shortening=false&paths=" + paths, "POST");
            int code = urlc.getResponseCode();
            if (code < 200 || code > 299) {
                String response = URLConnection.consumeResponse(urlc.getInputStream());
                throw new Exception("Update: Error: Responde code: " + code + " Error message: " + response + " URL" + new VRL(url).safe());
            }
        }
        catch (Exception e) {
            Log.log("UPDATE", 1, e);
            if (urlc != null) {
                urlc.disconnect();
            }
            throw e;
        }
        new File_S(String.valueOf(localPath) + name + "_new." + ext).delete();
        String out_file = String.valueOf(name) + "_new." + ext;
        InputStream di = urlc.getInputStream();
        RandomAccessFile of_stream = new RandomAccessFile(new File_S(String.valueOf(localPath) + out_file), "rw");
        try {
            of_stream.setLength(0L);
            int bytes_read = 0;
            byte[] b = new byte[0x100000];
            this.updateCurrentLoc = 0L;
            while (bytes_read >= 0 && !this.stopNow) {
                bytes_read = di.read(b);
                if (bytes_read <= 0) continue;
                this.updateCurrentLoc += (long)bytes_read;
                of_stream.write(b, 0, bytes_read);
            }
            di.close();
        }
        finally {
            of_stream.close();
            if (urlc != null) {
                urlc.disconnect();
            }
        }
        if (this.stopNow) {
            return "cancelled";
        }
        this.updateCurrentLoc = this.updateMaxSize;
        return "";
    }

    public static URLConnection getURLConnection(String username, String password, String url, String query, String verb) throws Exception {
        String use_dmz = "false";
        if (com.crushftp.client.Common.dmz_mode && use_dmz.equals("false")) {
            use_dmz = "(current_server)";
        }
        if (!System.getProperty("https.proxyHost", "").equals("")) {
            use_dmz = "http://lookup:lookup@" + System.getProperty("https.proxyHost", "") + ":" + System.getProperty("https.proxyPort", "");
        } else if (!System.getProperty("http.proxyHost", "").equals("")) {
            use_dmz = "http://lookup:lookup@" + System.getProperty("http.proxyHost", "") + ":" + System.getProperty("http.proxyPort", "");
        }
        URLConnection urlc = null;
        int retry_loops = 0;
        while (retry_loops++ < 6) {
            Properties config = new Properties();
            config.put("use_dmz", use_dmz);
            urlc = URLConnection.openConnection(new VRL(String.valueOf(url) + (verb.equals("POST") ? "" : query)), config);
            try {
                int code;
                if (!username.equals("")) {
                    urlc.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes((String.valueOf(username) + ":" + password).getBytes()));
                }
                urlc.setRequestMethod(verb);
                urlc.setReadTimeout(70000);
                if (verb.equals("POST")) {
                    urlc.setDoOutput(true);
                    urlc.getOutputStream().write(query.getBytes("UTF8"));
                    urlc.getOutputStream().close();
                }
                if ((code = urlc.getResponseCode()) >= 200 && code <= 299) break;
                String response = URLConnection.consumeResponse(urlc.getInputStream());
                throw new Exception(" Update: Error: Responde code: " + code + " Error message: " + response + " URL" + new VRL(url).safe());
            }
            catch (Exception e) {
                Log.log("UPDATE", 1, e.toString());
                if (retry_loops > 2) {
                    if (com.crushftp.client.Common.dmz_mode) {
                        Log.log("UPDATE", 1, "DMZ mode: Retry with internal connection.");
                        use_dmz = "internal://";
                    } else {
                        Vector dmzs = (Vector)com.crushftp.client.Common.System2.get("crushftp.dmz.hosts");
                        if (dmzs == null || dmzs.size() == 0) {
                            Log.log("UPDATE", 2, "Retry: No DMZ available.");
                        } else {
                            use_dmz = "true";
                        }
                    }
                }
                if (urlc == null) continue;
                urlc.disconnect();
            }
        }
        return urlc;
    }

    public static void doUpdate(String home, String backup, String zip) throws Exception {
        Vector errors = new Vector();
        if (UpdateHandler.unzip(String.valueOf(home) + zip, errors, backup)) {
            String batch = "";
            if (Common.machine_is_windows()) {
                batch = String.valueOf(batch) + "net stop \"" + System.getProperty("appname", "CrushFTP") + " Server\"\r\nping 127.0.0.1 -n 5\r\n";
            }
            int x = 0;
            while (x < errors.size()) {
                Properties p = (Properties)errors.elementAt(x);
                String source = p.getProperty("source");
                String dest = p.getProperty("dest");
                String back = p.getProperty("backup");
                if (Common.machine_is_windows()) {
                    source = source.replace('/', '\\');
                    dest = dest.replace('/', '\\');
                    back = back.replace('/', '\\');
                    batch = String.valueOf(batch) + "move \"" + dest + "\" \"" + back + "\"\r\n";
                    batch = String.valueOf(batch) + "move \"" + source + "\" \"" + dest + "\"\r\n";
                    batch = Common.replace_str(batch, "\\\\", "\\");
                }
                ++x;
            }
            if (Common.machine_is_windows()) {
                batch = String.valueOf(batch) + "net start \"" + System.getProperty("appname", "CrushFTP") + " Server\"\r\nping 127.0.0.1 -n 10\r\n";
            }
        }
    }

    public static boolean unzip(String sourcePath, Vector errors, String destPath) throws Exception {
        String error = "";
        int x = 0;
        while (x < 3) {
            block53: {
                error = "";
                ZipInputStream zin = new ZipInputStream(new FileInputStream(new File_S(sourcePath)));
                Log.log("UPDATE", 3, "Unzipping:" + sourcePath);
                sourcePath = Common.all_but_last(sourcePath);
                try {
                    ZipEntry entry;
                    while ((entry = zin.getNextEntry()) != null) {
                        String path2 = entry.getName();
                        updateCurrentStatus = "Unzipping " + path2 + "...";
                        path2 = path2.replace('\\', '/');
                        path2 = path2.replace('\\', '/');
                        path2 = Common.replace_str(path2, "..", "");
                        path2 = path2.substring(path2.indexOf("/", 1));
                        if (entry.isDirectory()) {
                            new File_S(String.valueOf(sourcePath) + path2).mkdirs();
                            if (path2.indexOf("WebInterface") < 0) {
                                Common.updateOSXInfo(String.valueOf(sourcePath) + path2);
                            }
                            Log.log("UPDATE", 0, "Updating directory:" + sourcePath + path2);
                            continue;
                        }
                        if (new File_S(Common.all_but_last(String.valueOf(sourcePath) + path2)).mkdirs() && path2.indexOf("WebInterface") < 0) {
                            Common.updateOSXInfo(Common.all_but_last(String.valueOf(sourcePath) + path2));
                        }
                        byte[] b = new byte[32768];
                        int bytes_read = 0;
                        String ext = "_tmp";
                        if ((String.valueOf(sourcePath) + path2).indexOf("/WebInterface/") >= 0) {
                            ext = "";
                        }
                        new File_S(String.valueOf(sourcePath) + path2 + "_tmp").delete();
                        RandomAccessFile out = new RandomAccessFile(new File_S(String.valueOf(sourcePath) + path2 + ext), "rw");
                        if ((String.valueOf(sourcePath) + path2).indexOf("/WebInterface/localizations/") >= 0 && out.length() > 0L) {
                            out.close();
                            out = null;
                        }
                        if ((String.valueOf(sourcePath) + path2).indexOf("/WebInterface/new-ui/localizations/") >= 0 && out.length() > 0L) {
                            out.close();
                            out = null;
                        }
                        boolean skip_update = false;
                        if (path2.endsWith(String.valueOf(System.getProperty("appname", "CrushFTP").toLowerCase()) + "_init.sh")) {
                            skip_update = true;
                        } else if (path2.endsWith("Info.plist")) {
                            skip_update = true;
                        } else if (path2.endsWith(String.valueOf(System.getProperty("appname", "CrushFTP")) + ".command")) {
                            skip_update = true;
                        } else if (path2.endsWith(".DS_Store")) {
                            skip_update = true;
                        } else if (path2.endsWith("thumbs.db")) {
                            skip_update = true;
                        } else if (path2.endsWith("logo.png")) {
                            skip_update = true;
                        } else if (path2.endsWith("mime_types.txt")) {
                            skip_update = true;
                        } else if (path2.endsWith("favicon.ico")) {
                            skip_update = true;
                        } else if (path2.endsWith("win_service.jar") && Common.machine_is_x()) {
                            skip_update = true;
                        } else if (path2.toUpperCase().indexOf("/USERS/") >= 0) {
                            skip_update = true;
                        }
                        if (skip_update) {
                            out.close();
                            out = null;
                            File_S f = new File_S(String.valueOf(sourcePath) + path2 + ext);
                            if (f.getName().endsWith("_tmp")) {
                                f.delete();
                            }
                        }
                        if (out != null) {
                            out.setLength(0L);
                            if (path2.indexOf("WebInterface") < 0) {
                                Common.updateOSXInfo(String.valueOf(sourcePath) + path2 + ext);
                            }
                        }
                        while (bytes_read >= 0) {
                            bytes_read = zin.read(b);
                            if (bytes_read <= 0 || out == null) continue;
                            out.write(b, 0, bytes_read);
                        }
                        boolean ok0 = true;
                        boolean ok1 = false;
                        boolean ok2 = false;
                        if (out != null) {
                            out.close();
                            new File_S(String.valueOf(sourcePath) + path2 + ext).setLastModified(entry.getTime());
                            Log.log("UPDATE", 0, "Updating:" + sourcePath + path2 + "    to:" + Common.all_but_last(String.valueOf(destPath) + path2));
                            if (new File_S(Common.all_but_last(String.valueOf(destPath) + path2)).mkdirs() && path2.indexOf("WebInterface") < 0) {
                                Common.updateOSXInfo(Common.all_but_last(String.valueOf(destPath) + path2));
                            }
                            if (!ext.equals("")) {
                                block52: {
                                    if (path2.endsWith(".jar")) {
                                        ZipFile jar_file = null;
                                        try {
                                            try {
                                                jar_file = new JarFile(String.valueOf(sourcePath) + path2 + ext);
                                                Manifest manifest = ((JarFile)jar_file).getManifest();
                                                ok0 = manifest != null;
                                            }
                                            catch (Exception e) {
                                                Log.log("UPDATE", 1, " Error: Invalid jar file: " + sourcePath + path2 + ext + " Error: " + e);
                                                ok0 = false;
                                                if (jar_file != null) {
                                                    jar_file.close();
                                                }
                                                break block52;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            if (jar_file != null) {
                                                jar_file.close();
                                            }
                                            throw throwable;
                                        }
                                        if (jar_file != null) {
                                            jar_file.close();
                                        }
                                    }
                                }
                                if (ok0) {
                                    ok1 = new File_S(String.valueOf(sourcePath) + path2).renameTo(new File_S(String.valueOf(destPath) + path2));
                                    boolean bl = ok2 = !new File_S(String.valueOf(sourcePath) + path2).exists();
                                }
                            }
                        }
                        if (ok1 || ok2 || ext.equals("") || out == null) {
                            if (out == null) continue;
                            if (!ext.equals("")) {
                                new File_S(String.valueOf(sourcePath) + path2 + ext).renameTo(new File_S(String.valueOf(sourcePath) + path2));
                            }
                            if (path2.indexOf("WebInterface") < 0) {
                                Common.updateOSXInfo(String.valueOf(sourcePath) + path2);
                            }
                            Log.log("UPDATE", 3, "OK");
                            new File_S(String.valueOf(sourcePath) + path2).setLastModified(entry.getTime());
                            continue;
                        }
                        Log.log("UPDATE", 0, "DEFERRED:" + sourcePath + path2 + "    to:" + Common.all_but_last(String.valueOf(destPath) + path2));
                        if (new File_S(Common.all_but_last(String.valueOf(sourcePath) + "UpdateTemp/" + path2)).mkdirs() && path2.indexOf("WebInterface") < 0) {
                            Common.updateOSXInfo(Common.all_but_last(String.valueOf(sourcePath) + "UpdateTemp/" + path2));
                        }
                        new File_S(String.valueOf(sourcePath) + path2 + "_tmp").renameTo(new File_S(String.valueOf(sourcePath) + "UpdateTemp/" + path2));
                        if (path2.indexOf("WebInterface") < 0) {
                            Common.updateOSXInfo(String.valueOf(sourcePath) + "UpdateTemp/" + path2);
                        }
                        Properties p = new Properties();
                        p.put("source", String.valueOf(sourcePath) + "UpdateTemp/" + path2);
                        p.put("dest", String.valueOf(sourcePath) + path2);
                        p.put("backup", new File_S(String.valueOf(destPath) + path2).getCanonicalPath());
                        errors.addElement(p);
                        Log.log("UPDATE", 3, "Updating for later:" + sourcePath + "UpdateTemp/" + path2);
                    }
                    updateCurrentStatus = "Unzipping complete...";
                    Common.updateOSXInfo(String.valueOf(sourcePath) + "WebInterface/", "-R");
                }
                catch (Exception e) {
                    Log.log("SERVER", 0, "UPDATE FAILED!!!");
                    Log.log("SERVER", 0, e);
                    Log.log("SERVER", 0, "UPDATE FAILED!!!");
                    zin.close();
                    error = e.toString();
                    break block53;
                }
                zin.close();
                break;
            }
            ++x;
        }
        return error.equals("");
    }

    public static void checkForUpdate(Properties info) {
        try {
            String url = "https://www." + System.getProperty("appname", "CrushFTP").toLowerCase() + ".com/version" + Common.V() + (info.getProperty("check_build", "false").equals("true") ? "_build" : "") + ".html";
            URLConnection urlc = UpdateHandler.getURLConnection("", "", url, "", "GET");
            InputStream in = urlc.getContent();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            com.crushftp.client.Common.streamCopier(in, baos, false, true, true);
            String html = new String(baos.toByteArray(), "UTF8");
            if (html.equals("") || !html.startsWith("Version " + Common.V() + ".")) {
                Log.log("SERVER", 1, " Check for update Error: Invalid server response! Response: " + html);
                if (html.length() > 200) {
                    html = html.substring(0, 199);
                }
                throw new Exception("Error: Invalid server response! Response: " + html);
            }
            String serverVersion = html.substring(0, html.indexOf("\r") > 0 ? html.indexOf("\r") : html.indexOf("\n")).trim();
            html = html.substring(html.indexOf("<")).trim();
            info.put("version", serverVersion);
            info.put("html", html);
        }
        catch (Exception e) {
            Log.log("SERVER", 0, "Unable to check for update. " + e.toString());
            info.put("update_check_error_message", "Unable to check for update. " + e.toString());
        }
    }
}

