/*
 * Decompiled with CFR 0.152.
 */
package crushftp.handlers;

import com.crushftp.client.URLConnection;
import com.crushftp.client.VRL;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import crushftp.handlers.Common;
import crushftp.handlers.Log;
import crushftp.server.ServerStatus;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import javax.imageio.ImageIO;

public class TimeBasedOneTimePassword {
    public static String generateSecret() {
        byte[] b = new byte[10];
        Common.rn.nextBytes(b);
        return com.crushftp.client.Common.encodeBase32(b);
    }

    public static ByteArrayOutputStream generateQrCode(String hostString, String username, String secret) throws Exception {
        String dataUri = "otpauth://totp/" + hostString + ":" + username + "?secret=" + secret + "&issuer=" + hostString + "&algorithm=SHA1&digits=6&period=" + TimeBasedOneTimePassword.getPeriod();
        BitMatrix bitMatrix = new QRCodeWriter().encode(dataUri, BarcodeFormat.QR_CODE, 200, 200);
        ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 12);
        int onColor = -16777216;
        int offColor = -1;
        int x = 0;
        while (x < width) {
            int xx = 0;
            while (xx < height) {
                image.setRGB(x, xx, bitMatrix.get(x, xx) ? onColor : offColor);
                ++xx;
            }
            ++x;
        }
        ImageIO.write((RenderedImage)image, "PNG", pngOutputStream);
        return pngOutputStream;
    }

    public static ByteArrayOutputStream generateQrCodeByGoogleCharts(String hostString, String username, String secret) throws Exception {
        ByteArrayOutputStream qr_baos;
        block9: {
            String qr_url = "https://chart.googleapis.com/chart?chs=200x200&chld=M%7C0&cht=qr&chl=otpauth%3A%2F%2Ftotp%2F" + hostString + "%3A" + username + "%3Fsecret%3D" + secret + "%26issuer%3D" + hostString + "%26algorithm%3D" + "SHA1" + "%26digits%3D" + 6 + "%26period%3D" + TimeBasedOneTimePassword.getPeriod();
            Properties config = new Properties();
            qr_baos = new ByteArrayOutputStream();
            try {
                URLConnection urlc = URLConnection.openConnection(new VRL(qr_url), config);
                urlc.setRequestMethod("GET");
                urlc.setReadTimeout(5000);
                int code = urlc.getResponseCode();
                if (code == 302) {
                    urlc.disconnect();
                    Log.log("HTTP_SERVER", 1, " QR code : Redirect.");
                    String location = urlc.getHeaderField("Location");
                    urlc = URLConnection.openConnection(new VRL(location), config);
                    urlc.setRequestMethod("GET");
                    urlc.setReadTimeout(5000);
                }
                Common.streamCopier(urlc.getInputStream(), qr_baos, false, true, true);
                if (qr_baos.size() == 0) {
                    Log.log("HTTP_SERVER", 1, " QR code : Retry.");
                    URL url_java = new URL(qr_url);
                    HttpURLConnection urlc2 = (HttpURLConnection)url_java.openConnection();
                    urlc2.setRequestMethod("GET");
                    urlc2.setReadTimeout(5000);
                    Common.streamCopier(urlc2.getInputStream(), qr_baos, false, true, true);
                }
            }
            catch (Exception e) {
                Log.log("HTTP_SERVER", 1, e);
                Log.log("HTTP_SERVER", 1, "QR code : dmz reroute");
                config.put("use_dmz", "true");
                try {
                    URLConnection urlc = URLConnection.openConnection(new VRL(qr_url), config);
                    urlc.setRequestMethod("GET");
                    urlc.setReadTimeout(5000);
                    int code = urlc.getResponseCode();
                    if (code == 302) {
                        urlc.disconnect();
                        Log.log("HTTP_SERVER", 1, " QR code : DMZ reroute. Redirect.");
                        String location = urlc.getHeaderField("Location");
                        urlc = URLConnection.openConnection(new VRL(location), config);
                        urlc.setRequestMethod("GET");
                        urlc.setReadTimeout(5000);
                    }
                    Common.streamCopier(urlc.getInputStream(), qr_baos, false, true, true);
                }
                catch (Exception ee) {
                    Log.log("HTTP_SERVER", 1, ee);
                }
                if (qr_baos.size() != 0) break block9;
                try {
                    URL url_java = new URL(qr_url);
                    HttpURLConnection urlc2 = (HttpURLConnection)url_java.openConnection();
                    urlc2.setRequestMethod("GET");
                    urlc2.setReadTimeout(5000);
                    Common.streamCopier(urlc2.getInputStream(), qr_baos, false, true, true);
                }
                catch (Exception ee) {
                    Log.log("HTTP_SERVER", 1, ee);
                }
            }
        }
        return qr_baos;
    }

    public static int getPeriod() {
        int period = 30;
        try {
            period = Integer.parseInt(ServerStatus.SG("totp_refresh_period"));
            if (period > 300) {
                period = 300;
            }
        }
        catch (Exception e) {
            Log.log("SERVER", 1, e);
        }
        return period;
    }
}

