/*
 * Decompiled with CFR 0.152.
 */
package crushftp.handlers;

import com.crushftp.client.File_B;
import com.crushftp.client.File_S;
import com.crushftp.client.File_U;
import com.crushftp.client.VRL;
import com.crushftp.client.Worker;
import com.crushftp.job.JobBroker;
import com.crushftp.job.JobFilesHandler;
import com.didisoft.pgp.KeyStore;
import crushftp.db.SearchHandler;
import crushftp.handlers.AlertTools;
import crushftp.handlers.Common;
import crushftp.handlers.JobScheduler;
import crushftp.handlers.Log;
import crushftp.handlers.SharedSessionReplicated;
import crushftp.handlers.UserTools;
import crushftp.server.AdminControls;
import crushftp.server.ServerSessionAJAX;
import crushftp.server.ServerStatus;
import crushftp.server.VFS;
import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class TaskBridge {
    static long last_load_server_properties = 0L;
    static long pending_add_bytes_received = 0L;
    static long pending_add_bytes_sent = 0L;
    static long last_send_time = System.currentTimeMillis();
    static Object last_send_lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runAgent(String agent_name, String response_id, Properties job_tmp) {
        String result;
        block10: {
            if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
                Properties p = new Properties();
                p.put("class", "Taskbridge");
                p.put("method", "runAgent");
                p.put("agent", agent_name);
                p.put("response_id", response_id);
                p.put("job_tmp", job_tmp);
                JobBroker.jobs_to_server_queue.addElement(p);
                JobBroker.waitResponse(p, 30);
                return p.getProperty("result");
            }
            result = "";
            try {
                Vector agents = ServerStatus.siVG("registeredAgents");
                if (agents == null) {
                    agents = new Vector();
                }
                ServerStatus.siPUT("registeredAgents", agents);
                Vector queue = null;
                Properties responses = null;
                Vector vector = agents;
                synchronized (vector) {
                    int x = 0;
                    while (x < agents.size()) {
                        Properties agent = (Properties)agents.elementAt(x);
                        if (agent.getProperty("name").equals(agent_name)) {
                            queue = (Vector)agent.get("queue");
                            responses = (Properties)agent.get("responses");
                        }
                        ++x;
                    }
                }
                if (queue != null) {
                    job_tmp.put("response_id", response_id);
                    job_tmp.put("job_log_date_format", System.getProperty("crushftp.log_date_format", "MM/dd/yyyy hh:mm:ss aa"));
                    responses.put(response_id, job_tmp);
                    queue.addElement(job_tmp);
                    break block10;
                }
                throw new Exception("Agent not found!");
            }
            catch (Exception e) {
                result = "Agent Error: " + e.getMessage();
                com.crushftp.client.Common.log("SERVER", 1, e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkIfAgentSartedToWorkOnJOb(String agent_name, String response_id) {
        String result;
        block13: {
            if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
                Properties p = new Properties();
                p.put("class", "Taskbridge");
                p.put("method", "checkIfAgentSartedToWorkOnJOb");
                p.put("agent", agent_name);
                p.put("response_id", response_id);
                JobBroker.jobs_to_server_queue.addElement(p);
                JobBroker.waitResponse(p, 30);
                return p.getProperty("result");
            }
            result = "Still pending!";
            try {
                int x;
                Vector agents = ServerStatus.siVG("registeredAgents");
                if (agents == null) {
                    agents = new Vector();
                }
                ServerStatus.siPUT("registeredAgents", agents);
                Vector queue = null;
                Properties responses = null;
                Vector vector = agents;
                synchronized (vector) {
                    x = 0;
                    while (x < agents.size()) {
                        Properties agent = (Properties)agents.elementAt(x);
                        if (agent.getProperty("name").equals(agent_name)) {
                            queue = (Vector)agent.get("queue");
                            responses = (Properties)agent.get("responses");
                        }
                        ++x;
                    }
                }
                if (queue != null) {
                    boolean found = false;
                    x = 0;
                    while (x < queue.size()) {
                        Properties job = (Properties)queue.elementAt(x);
                        if (job.getProperty("response_id", "").equals(response_id)) {
                            found = true;
                        }
                        ++x;
                    }
                    if (!found) {
                        result = "";
                    }
                    break block13;
                }
                throw new Exception("Agent not found!");
            }
            catch (Exception e) {
                result = "Agent Error: " + e.getMessage();
                com.crushftp.client.Common.log("SERVER", 1, e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAgentResponse(String agent_name, String response_id) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "getAgentResponse");
            p.put("agent", agent_name);
            p.put("response_id", response_id);
            JobBroker.jobs_to_server_queue.addElement(p);
            JobBroker.waitResponse(p, 30);
            return p.getProperty("result");
        }
        String result = "";
        try {
            Vector agents = ServerStatus.siVG("registeredAgents");
            if (agents == null) {
                agents = new Vector();
            }
            ServerStatus.siPUT("registeredAgents", agents);
            Properties responses = null;
            Vector vector = agents;
            synchronized (vector) {
                int x = 0;
                while (x < agents.size()) {
                    Properties job_temp;
                    Properties agent = (Properties)agents.elementAt(x);
                    if (agent.getProperty("name").equals(agent_name) && (job_temp = (Properties)(responses = (Properties)agent.get("responses")).get(response_id)).getProperty("response_received", "false").equals("true")) {
                        result = job_temp.getProperty("log", "");
                        responses.remove(response_id);
                    }
                    ++x;
                }
            }
        }
        catch (Exception e) {
            result = "Agent Error: " + e.getMessage();
            com.crushftp.client.Common.log("SERVER", 1, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeResponseFromAgent(String agent_name, String response_id) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "removeResponseFromAgent");
            p.put("agent", agent_name);
            p.put("response_id", response_id);
            JobBroker.jobs_to_server_queue.addElement(p);
        } else {
            String result = "";
            try {
                Vector agents = ServerStatus.siVG("registeredAgents");
                if (agents == null) {
                    agents = new Vector();
                }
                ServerStatus.siPUT("registeredAgents", agents);
                Properties responses = null;
                Vector vector = agents;
                synchronized (vector) {
                    int x = 0;
                    while (x < agents.size()) {
                        Properties agent = (Properties)agents.elementAt(x);
                        if (agent.getProperty("name").equals(agent_name) && (responses = (Properties)agent.get("responses")).containsKey(response_id)) {
                            responses.remove(response_id);
                        }
                        ++x;
                    }
                }
            }
            catch (Exception e) {
                result = "Agent Error: " + e.getMessage();
                com.crushftp.client.Common.log("SERVER", 1, e);
            }
        }
    }

    public static String doShare(String body, Vector itemsFound, Properties info) throws Exception {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "doShare");
            p.put("body", body);
            p.put("itemsFound", itemsFound);
            if (info != null) {
                Properties info2 = (Properties)info.clone();
                info2.remove("ServerSessionObject");
                info2.remove("ServerSession");
                info2.remove("running_threads");
                p.put("info", info2);
            }
            JobBroker.jobs_to_server_queue.addElement(p);
            JobBroker.waitResponse(p, 30);
            return p.getProperty("result");
        }
        String original_share_key = "";
        String share_key = "";
        if (body.indexOf("{share:") >= 0) {
            original_share_key = share_key = body.substring(body.indexOf("{share:") + 1, body.indexOf("}", body.indexOf("{share:")));
        } else {
            original_share_key = share_key = body.substring(body.indexOf("{share_") + 1, body.indexOf("}", body.indexOf("{share_")));
            share_key = share_key.replace('_', ':');
        }
        Vector web_customizations = null;
        String user_name = "default";
        String linkedServer = null;
        Properties user = null;
        Properties user_info = null;
        Properties server_item = null;
        String user_ip = null;
        if (info != null) {
            user = (Properties)info.get("user");
            user_info = (Properties)info.get("user_info");
            server_item = (Properties)info.get("server_item");
            if (user_info != null) {
                web_customizations = (Vector)user.get("web_customizations");
                user_name = user_info.getProperty("user_name", "default");
                if (server_item != null) {
                    linkedServer = server_item.getProperty("linkedServer");
                }
                user_ip = user_info.getProperty("user_ip");
            }
        }
        if (user_name.equals("default") && share_key.split(":").length > 3) {
            user_name = share_key.split(":")[3];
        }
        SimpleDateFormat ex1 = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        try {
            ((Calendar)cal).add(5, Integer.parseInt(share_key.split(":")[2]));
        }
        catch (Exception e) {
            throw new Exception(e + share_key);
        }
        Properties request = new Properties();
        request.put("expire", ex1.format(cal.getTime()));
        String share_paths = "";
        String share_user = user_name;
        if (share_user.equals("default")) {
            share_user = info.getProperty("share_user", share_user);
        }
        request.put("paths", share_paths);
        request.put("baseUrl", "");
        request.put("direct_link", "false");
        request.put("emailTo", info.getProperty("emailTo", ""));
        request.put("emailCc", info.getProperty("emailCc", ""));
        request.put("emailBcc", info.getProperty("emailBcc", ""));
        request.put("emailFrom", info.getProperty("emailFrom", ""));
        request.put("emailSubject", "");
        request.put("emailBody", "{web_link}");
        request.put("sendEmail", "false");
        request.put("shareUsername", "false");
        request.put("allowUploads", "false");
        request.put("attach", "false");
        if (user_ip == null) {
            user_ip = info.getProperty("share_ip", "0.0.0.0");
        }
        request.put("share_user_ip", user_ip);
        String string = linkedServer = linkedServer == null ? "MainUsers" : linkedServer;
        if (share_key.split(":")[1].equals("reference")) {
            request.put("publishType", "reference");
        } else if (share_key.split(":")[1].equals("move")) {
            request.put("publishType", "move");
        } else if (share_key.split(":")[1].equals("copy")) {
            request.put("publishType", "copy");
        }
        if (share_key.split(":").length > 4 && share_key.split(":")[4].equalsIgnoreCase("full")) {
            request.put("allowUploads", "true");
        }
        if (share_key.split(":").length > 5 && !share_key.split(":")[5].equalsIgnoreCase("")) {
            request.put("logins", share_key.split(":")[5].trim());
        }
        String response = "";
        try {
            response = ServerSessionAJAX.createShare(itemsFound, request, web_customizations, user_name, linkedServer, user, null, null);
        }
        catch (Exception e) {
            com.crushftp.client.Common.log("SERVER", 1, e);
            return "SHARE ERROR: " + e;
        }
        String share_msg = com.crushftp.client.Common.url_decode(response.substring(response.indexOf("<message>") + 9, response.indexOf("</message>")));
        String share_url = com.crushftp.client.Common.url_decode(response.substring(response.indexOf("<url>") + 5, response.indexOf("</url>")));
        if (share_msg.indexOf("{share_complete}") < 0) {
            share_url = "";
        }
        body = com.crushftp.client.Common.replace_str(body, "{" + original_share_key + "}", share_url);
        body = com.crushftp.client.Common.replace_str(body, "{" + original_share_key + "_message}", share_msg);
        body = com.crushftp.client.Common.replace_str(body, "{" + original_share_key + ":message}", share_msg);
        int x = 0;
        while (x < itemsFound.size()) {
            Properties item = (Properties)itemsFound.elementAt(x);
            Properties p = (Properties)request.clone();
            p.putAll((Map<?, ?>)item);
            item.putAll((Map<?, ?>)p);
            ++x;
        }
        return body;
    }

    public static String convertFormEmail(String the_line, Vector lastUploadStats) {
        Properties formEmail = Common.buildFormEmail(ServerStatus.server_settings, lastUploadStats);
        return Common.replaceFormVariables(formEmail, the_line);
    }

    public static String convertSessionVars(String the_line, Properties info) {
        Properties user = null;
        Properties user_info = null;
        if (info != null) {
            user = (Properties)info.get("user");
            user_info = (Properties)info.get("user_info");
        }
        if (user_info != null) {
            the_line = ServerStatus.change_vars_to_values_static(the_line, user, user_info, null);
        }
        return the_line;
    }

    public static String convertCustomData(String the_line, String r1, String r2) {
        while (the_line.indexOf(String.valueOf(r1) + "customData_") >= 0) {
            String custom = the_line.substring(the_line.indexOf(String.valueOf(r1) + "customData_") + (String.valueOf(r1) + "customData_").length());
            custom = custom.substring(0, custom.indexOf(r2));
            Properties customData = (Properties)ServerStatus.server_settings.get("customData");
            String val = customData.getProperty(custom, "");
            the_line = com.crushftp.client.Common.replace_str(the_line, String.valueOf(r1) + "customData_" + custom + r2, val);
        }
        return the_line;
    }

    /*
     * Unable to fully structure code
     */
    public static String convertUserManager(String the_line, String r1, String r2) {
        if (the_line.indexOf(String.valueOf(r1) + "group") < 0 && the_line.indexOf(String.valueOf(r1) + "reload") < 0) {
            return the_line;
        }
        if (!System.getProperty("crushftp.remote_job_broker", "false").equals("true")) ** GOTO lbl48
        p = new Properties();
        p.put("class", "Taskbridge");
        p.put("method", "convertUserManager");
        p.put("the_line", the_line);
        p.put("r1", r1);
        p.put("r2", r2);
        JobBroker.jobs_to_server_queue.addElement(p);
        JobBroker.waitResponse(p, 60);
        return p.getProperty("result");
lbl-1000:
        // 1 sources

        {
            block27: {
                params = the_line.substring(the_line.indexOf(String.valueOf(r1) + "group_start") + (String.valueOf(r1) + "group_start").length());
                params = params.substring(0, params.indexOf("}"));
                result_type = "user_name:MainUsers";
                if (params.indexOf(":") >= 0) {
                    result_type = params.substring(params.indexOf(":") + 1).trim();
                }
                inner = the_line.substring(the_line.indexOf(String.valueOf(r1) + "group_start" + params + r2) + (String.valueOf(r1) + "group_start" + params + r2).length(), the_line.indexOf(String.valueOf(r1) + "group_end" + r2));
                r = "";
                groups = UserTools.getGroups(result_type.split(":")[1]);
                if (groups == null || (users = (Vector)groups.get(inner.trim())) == null) break block27;
                separator = result_type.split(":")[2].trim();
                xx = 0;
                while (xx < users.size()) {
                    block30: {
                        block29: {
                            block28: {
                                if (!result_type.split(":")[0].equals("user_name")) break block28;
                                r = String.valueOf(r) + users.elementAt(xx).toString();
                                break block29;
                            }
                            u = UserTools.ut.getUser(result_type.split(":")[1], users.elementAt(xx).toString(), true);
                            if (u == null || Integer.parseInt(u.getProperty("max_logins", "0")) < 0) break block30;
                            if (!u.getProperty(result_type.split(":")[0], "").equals("")) {
                                r = String.valueOf(r) + u.getProperty(result_type.split(":")[0], "");
                            }
                        }
                        r = String.valueOf(r) + separator;
                    }
                    ++xx;
                }
                if (r.endsWith(separator)) {
                    r = r.substring(0, r.length() - 1);
                }
            }
            the_line = String.valueOf(the_line.substring(0, the_line.indexOf(String.valueOf(r1) + "group_start" + params + r2))) + r + the_line.substring(the_line.indexOf(String.valueOf(r1) + "group_end" + r2) + (String.valueOf(r1) + "group_end" + r2).length());
lbl48:
            // 2 sources

            ** while (the_line.indexOf((String)(String.valueOf((Object)r1) + "group_start")) >= 0 && the_line.indexOf((String)(String.valueOf((Object)r1) + "group_end" + r2)) >= 0)
        }
lbl49:
        // 2 sources

        while (the_line.indexOf(String.valueOf(r1) + "group_add_start") >= 0 && the_line.indexOf(String.valueOf(r1) + "group_add_end" + r2) >= 0) {
            params = the_line.substring(the_line.indexOf(String.valueOf(r1) + "group_add_start") + (String.valueOf(r1) + "group_add_start").length());
            params = params.substring(0, params.indexOf("}"));
            result_type = "MainUsers:no_user_to_add";
            if (params.indexOf(":") >= 0) {
                result_type = params.substring(params.indexOf(":") + 1).trim();
            }
            error = "";
            try {
                serverGroup = result_type.split(":")[0];
                username = result_type.split(":")[1];
                inner = the_line.substring(the_line.indexOf(String.valueOf(r1) + "group_add_start" + params + r2) + (String.valueOf(r1) + "group_add_start" + params + r2).length(), the_line.indexOf(String.valueOf(r1) + "group_add_end" + r2));
                groups = UserTools.getGroups(serverGroup);
                if (groups != null) {
                    users = groups.get(inner.trim());
                    if (users == null) {
                        users = new Vector<String>();
                        groups.put(inner.trim(), users);
                        if (!username.equals("no_user_to_add") && UserTools.ut.getUser(serverGroup, username, false) != null && !users.contains(username)) {
                            users.add(username);
                        }
                        UserTools.writeGroups(serverGroup, groups);
                    } else if (!username.equals("no_user_to_add") && UserTools.ut.getUser(serverGroup, username, false) != null && !users.contains(username)) {
                        users.add(username);
                        UserTools.writeGroups(serverGroup, groups);
                    }
                }
            }
            catch (Exception e) {
                error = "Error on group create : " + e.getMessage();
                com.crushftp.client.Common.log("SERVER", 1, e);
            }
            the_line = String.valueOf(the_line.substring(0, the_line.indexOf(String.valueOf(r1) + "group_add_start" + params + r2))) + error + the_line.substring(the_line.indexOf(String.valueOf(r1) + "group_add_end" + r2) + (String.valueOf(r1) + "group_add_end" + r2).length());
        }
        while (the_line.indexOf(String.valueOf(r1) + "group_remove_user_start") >= 0 && the_line.indexOf(String.valueOf(r1) + "group_remove_user_end" + r2) >= 0) {
            params = the_line.substring(the_line.indexOf(String.valueOf(r1) + "group_remove_user_start") + (String.valueOf(r1) + "group_remove_user_start").length());
            params = params.substring(0, params.indexOf("}"));
            result_type = "MainUsers:no_user_to_remove";
            if (params.indexOf(":") >= 0) {
                result_type = params.substring(params.indexOf(":") + 1).trim();
            }
            error = "";
            try {
                serverGroup = result_type.split(":")[0];
                username = result_type.split(":")[1];
                if (!username.equals("no_user_to_remove")) {
                    inner = the_line.substring(the_line.indexOf(String.valueOf(r1) + "group_remove_user_start" + params + r2) + (String.valueOf(r1) + "group_remove_user_start" + params + r2).length(), the_line.indexOf(String.valueOf(r1) + "group_remove_user_end" + r2));
                    groups = UserTools.getGroups(serverGroup);
                    if (groups != null && (users = groups.get(inner.trim())) != null && ((Vector)users).contains(username)) {
                        ((Vector)users).remove(username);
                        UserTools.writeGroups(serverGroup, groups);
                    }
                }
            }
            catch (Exception e) {
                error = "Error on remove user from group : " + e.getMessage();
                com.crushftp.client.Common.log("SERVER", 1, e);
            }
            the_line = String.valueOf(the_line.substring(0, the_line.indexOf(String.valueOf(r1) + "group_remove_user_start" + params + r2))) + error + the_line.substring(the_line.indexOf(String.valueOf(r1) + "group_remove_user_end" + r2) + (String.valueOf(r1) + "group_remove_user_end" + r2).length());
        }
        while (the_line.indexOf(String.valueOf(r1) + "reload_start") >= 0 && the_line.indexOf(String.valueOf(r1) + "reload_end" + r2) >= 0) {
            reload_user = the_line.substring(the_line.indexOf(String.valueOf(r1) + "reload_start" + r2) + (String.valueOf(r1) + "reload_start" + r2).length(), the_line.indexOf(String.valueOf(r1) + "reload_end" + r2));
            UserTools.ut.forceMemoryReloadUser(reload_user);
            the_line = String.valueOf(the_line.substring(0, the_line.indexOf(String.valueOf(r1) + "reload_start" + r2))) + the_line.substring(the_line.indexOf(String.valueOf(r1) + "reload_end" + r2) + (String.valueOf(r1) + "reload_end" + r2).length());
        }
        return the_line;
    }

    public static String convertServerInfo(String the_line, String r1, String r2, Properties info, String original_the_line) {
        Enumeration<Object> keys = ServerStatus.server_info.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String val = ServerStatus.server_info.getProperty(key);
            if (the_line.indexOf(String.valueOf(r1) + "server_" + key + r2) < 0) continue;
            boolean was_equal = original_the_line.equals(the_line);
            the_line = com.crushftp.client.Common.replace_str(the_line, String.valueOf(r1) + "server_" + key + r2, String.valueOf(val));
            if (!was_equal || the_line.indexOf(r1) >= 0) continue;
            info.put("last_scope", "static");
        }
        if (the_line.indexOf(String.valueOf(r1) + "thread_dump" + r2) >= 0) {
            the_line = com.crushftp.client.Common.replace_str(the_line, String.valueOf(r1) + "thread_dump" + r2, com.crushftp.client.Common.dumpStack("THREAD_DUMP"));
        }
        return the_line;
    }

    public static String createUser(String the_line, Properties tracker) {
        Properties user_dir;
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "createUser");
            p.put("lines", the_line);
            p.put("tracker", tracker);
            JobBroker.jobs_to_server_queue.addElement(p);
            JobBroker.waitResponse(p, 30);
            return p.getProperty("result");
        }
        Properties new_user = new Properties();
        Vector<Properties> user_dirs = new Vector<Properties>();
        Enumeration<Object> keys = tracker.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (key.indexOf("newuser_") < 0) continue;
            String user_key = key.substring("newuser_".length(), key.length());
            String user_value = tracker.getProperty(key);
            if (user_key.indexOf("dir") >= 0) {
                user_dir = new Properties();
                String user_dir_index = user_key.substring("dir".length(), user_key.length());
                String user_dir_priv = tracker.getProperty("newuser_priv" + user_dir_index);
                user_dir.put("dir", user_value);
                user_dir.put("priv", user_dir_priv);
                user_dirs.add(user_dir);
                continue;
            }
            new_user.put(user_key, user_value);
        }
        if (new_user.containsKey("password")) {
            String pass = new_user.getProperty("password", "");
            pass = ServerStatus.thisObj.common_code.encode_pass(pass, ServerStatus.SG("password_encryption"), new_user.getProperty("salt", ""));
            new_user.put("password", pass);
        }
        new_user.put("root_dir", "/");
        UserTools.writeUser(new_user.getProperty("serverGroup"), new_user.getProperty("username"), new_user);
        UserTools.ut.getUser(new_user.getProperty("serverGroup"), new_user.getProperty("username"), true);
        VFS vfs = UserTools.ut.getVFS(new_user.getProperty("serverGroup"), new_user.getProperty("username"));
        Properties virtual = (Properties)vfs.homes.elementAt(0);
        int x = 0;
        while (x < user_dirs.size()) {
            user_dir = (Properties)user_dirs.get(x);
            String dir = user_dir.getProperty("dir");
            if (dir.endsWith("/")) {
                dir = dir.substring(0, dir.length() - 1);
            }
            String name = com.crushftp.client.Common.last(dir);
            Properties item = new Properties();
            if (dir.indexOf("FILE:") >= 0) {
                Vector<Properties> vItems = new Vector<Properties>();
                Properties vItem = new Properties();
                vItem.put("url", user_dir.getProperty("dir"));
                vItem.put("type", "DIR");
                vItems.add(vItem);
                item.put("vItems", vItems);
                item.put("type", "FILE");
            } else {
                item.put("type", "DIR");
            }
            item.put("virtualPath", "/" + name);
            item.put("name", name);
            virtual.put("/" + name, item);
            Vector priv = (Vector)virtual.get("vfs_permissions_object");
            Properties priv_p = (Properties)priv.get(0);
            priv_p.put("/" + name.toUpperCase() + "/", user_dir.getProperty("priv"));
            ++x;
        }
        UserTools.writeVFS(new_user.getProperty("serverGroup"), new_user.getProperty("username"), vfs);
        return the_line;
    }

    public static String convertPreview(Properties item) {
        try {
            return com.crushftp.client.Common.dots(String.valueOf(SearchHandler.getPreviewPath(item.getProperty("url"), "1", 1)) + "../index.txt");
        }
        catch (Exception e) {
            com.crushftp.client.Common.log("SERVER", 1, e);
            return "" + e;
        }
    }

    public static String getPreviewPath(Properties item) {
        try {
            String the_dir = SearchHandler.getPreviewPath(item.getProperty("url").toString(), "1", 1);
            String index = String.valueOf(ServerStatus.SG("previews_path")) + the_dir.substring(1);
            String path_org = "";
            if (new File_U(com.crushftp.client.Common.all_but_last(index)).exists()) {
                path_org = index.substring(0, index.indexOf("/p1/"));
                return path_org;
            }
            return "Error: The specified preview path does not exists!";
        }
        catch (Exception e) {
            com.crushftp.client.Common.log("SERVER", 1, e);
            return "Error: " + e;
        }
    }

    public static String sendEmail(String to, String cc, String bcc, String from, String reply_to, String subject, String body, File_B[] files) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "sendEmail");
            if (to != null) {
                p.put("to", to);
            }
            if (cc != null) {
                p.put("cc", cc);
            }
            if (bcc != null) {
                p.put("bcc", bcc);
            }
            if (from != null) {
                p.put("from", from);
            }
            if (reply_to != null) {
                p.put("reply_to", reply_to);
            }
            if (subject != null) {
                p.put("subject", subject);
            }
            if (body != null) {
                p.put("body", body);
            }
            if (files != null) {
                p.put("files", files);
            }
            JobBroker.jobs_to_server_queue.addElement(p);
            JobBroker.waitResponse(p, 60);
            return p.getProperty("result");
        }
        return TaskBridge.sendEmail(to, cc, bcc, from, reply_to, subject, body, files, new Vector());
    }

    public static String sendEmail(String to, String cc, String bcc, String from, String reply_to, String subject, String body, File_B[] files, Vector fileMimeTypes) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "sendEmail");
            if (to != null) {
                p.put("to", to);
            }
            if (cc != null) {
                p.put("cc", cc);
            }
            if (bcc != null) {
                p.put("bcc", bcc);
            }
            if (from != null) {
                p.put("from", from);
            }
            if (reply_to != null) {
                p.put("reply_to", reply_to);
            }
            if (subject != null) {
                p.put("subject", subject);
            }
            if (body != null) {
                p.put("body", body);
            }
            if (files != null) {
                p.put("files", files);
            }
            if (fileMimeTypes != null) {
                p.put("fileMimeTypes", fileMimeTypes);
            }
            JobBroker.jobs_to_server_queue.addElement(p);
            JobBroker.waitResponse(p, 60);
            return p.getProperty("result");
        }
        return com.crushftp.client.Common.send_mail(ServerStatus.SG("discovered_ip"), to, cc, bcc, from, reply_to, subject, body, ServerStatus.SG("smtp_server"), ServerStatus.SG("smtp_user"), ServerStatus.SG("smtp_pass"), ServerStatus.BG("smtp_ssl"), ServerStatus.BG("smtp_html"), files, fileMimeTypes);
    }

    public static String sendEmail(String to, String cc, String bcc, String from, String reply_to, String subject, String body, File_B[] files, Vector fileMimeTypes, Vector remoteFiles) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "sendEmail");
            if (to != null) {
                p.put("to", to);
            }
            if (cc != null) {
                p.put("cc", cc);
            }
            if (bcc != null) {
                p.put("bcc", bcc);
            }
            if (from != null) {
                p.put("from", from);
            }
            if (reply_to != null) {
                p.put("reply_to", reply_to);
            }
            if (subject != null) {
                p.put("subject", subject);
            }
            if (body != null) {
                p.put("body", body);
            }
            if (files != null) {
                p.put("files", files);
            }
            if (fileMimeTypes != null) {
                p.put("fileMimeTypes", fileMimeTypes);
            }
            if (remoteFiles != null) {
                p.put("remoteFiles", remoteFiles);
            }
            JobBroker.jobs_to_server_queue.addElement(p);
            JobBroker.waitResponse(p, 60);
            return p.getProperty("result");
        }
        if (com.crushftp.client.Common.dmz_mode) {
            Vector queue = (Vector)com.crushftp.client.Common.System2.get("crushftp.dmz.queue");
            Properties action = new Properties();
            action.put("type", "PUT:SEND_EMAIL");
            action.put("id", com.crushftp.client.Common.makeBoundary(11));
            action.put("need_response", "true");
            action.put("to", to == null ? "" : to);
            action.put("cc", cc == null ? "" : cc);
            action.put("bcc", bcc == null ? "" : bcc);
            action.put("from", from == null ? "" : from);
            action.put("reply_to", reply_to == null ? "" : reply_to);
            action.put("subject", subject == null ? "" : subject);
            action.put("body", body == null ? "" : body);
            queue.addElement(action);
            Log.log("SERVER", 2, "PUT:SEND_EMAIL:Sending email over to Internal server..." + action);
            action = UserTools.waitResponse(action, 60);
            Log.log("SERVER", 2, "PUT:SEND_EMAIL:Got response.." + action);
            if (action != null && action.containsKey("email_response")) {
                return action.getProperty("email_response", "DMZ send through internal failed.");
            }
            return "DMZ send through internal failed.";
        }
        return com.crushftp.client.Common.send_mail(ServerStatus.SG("discovered_ip"), to, cc, bcc, from, reply_to, subject, body, ServerStatus.SG("smtp_server"), ServerStatus.SG("smtp_user"), ServerStatus.SG("smtp_pass"), ServerStatus.BG("smtp_ssl"), ServerStatus.BG("smtp_html"), files, fileMimeTypes, remoteFiles);
    }

    public static Properties runLinkedJob(Properties pp) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "runLinkedJob");
            p.put("pp", pp);
            JobBroker.jobs_to_server_queue.addElement(p);
            JobBroker.waitResponse(p, 6000);
            return (Properties)p.get("result");
        }
        if (SharedSessionReplicated.remote_host_ports.size() > 0) {
            SharedSessionReplicated.send(com.crushftp.client.Common.makeBoundary(7), "crushftp.JobScheduler.runJob", "info", pp);
            long start = System.currentTimeMillis();
            while (Integer.parseInt(pp.getProperty("response_num", "0")) < SharedSessionReplicated.remote_host_ports.size() && System.currentTimeMillis() - start < 3600000L) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return (Properties)pp.get("val");
        }
        return null;
    }

    public static Properties runOnDmz(Properties job_tmp, String use_dmz, Vector tempItems, Vector log) throws Exception {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "runOnDmz");
            p.put("job_tmp", job_tmp);
            p.put("use_dmz", use_dmz);
            if (tempItems != null) {
                p.put("tempItems", tempItems);
            }
            if (log != null) {
                p.put("log", log);
            }
            JobBroker.jobs_to_server_queue.addElement(p);
            JobBroker.waitResponse(p, 60000);
            return p;
        }
        tempItems = SharedSessionReplicated.runOnDmz(job_tmp, use_dmz, tempItems, log);
        Properties result = new Properties();
        result.put("log", log);
        result.put("tempItems", tempItems);
        return result;
    }

    public static void runPluginMessageAlert(String msg, Properties info) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "runPluginMessageAlert");
            p.put("msg", msg);
            p.put("info", info);
            JobBroker.jobs_to_server_queue.addElement(p);
        } else {
            Properties user = null;
            if (info != null && info.containsKey("alert_user")) {
                user = (Properties)info.remove("alert_user");
            }
            Properties user_info = null;
            if (info != null && info.containsKey("alert_user_info")) {
                user_info = (Properties)info.remove("alert_user_info");
            }
            AlertTools.runAlerts(msg, info, user_info, user, null, null, com.crushftp.client.Common.dmz_mode);
        }
    }

    public static Properties getEmailTemplate(String template_name) {
        return Common.get_email_template(template_name);
    }

    public static Object readJobXMLObject(File_S f) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            if (f.exists()) {
                return JobFilesHandler.readXMLObject(f);
            }
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "readJobXMLObject");
            p.put("f", f);
            JobBroker.jobs_to_server_queue.addElement(p);
            JobBroker.waitResponse(p, 60);
            return (Properties)p.get("result");
        }
        return JobFilesHandler.readXMLObject(f);
    }

    public static Object readJobXMLObject(Properties p2) {
        return JobFilesHandler.readXMLObject(p2, false);
    }

    public static void writeXMLObject(String path, Object obj, String root) {
        TaskBridge.writeXMLObject(path, obj, root, "false");
    }

    public static void writeXMLObject(String path, Object obj, String root, String cache) {
        JobFilesHandler.writeXMLObject(path, obj, root, false);
        if (cache != null && cache.equals("true") && System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "addToCache");
            p.put("path", path);
            p.put("obj", obj);
            JobBroker.jobs_to_server_queue.addElement(p);
        }
    }

    public static void addToCache(String path, Object obj) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "addToCache");
            p.put("path", path);
            p.put("obj", obj);
            JobBroker.jobs_to_server_queue.addElement(p);
        } else {
            JobFilesHandler.addToCache(path, obj);
        }
    }

    public static void updateRefreshToken(String token_key, String token_val, String replicate) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            com.crushftp.client.Common.refresh_tokens.put(token_key, token_val);
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "updateRefreshToken");
            p.put("token_key", token_key);
            p.put("token_val", token_val);
            JobBroker.jobs_to_server_queue.addElement(p);
        } else {
            com.crushftp.client.Common.refresh_tokens.put(token_key, token_val);
            Properties action_val = new Properties();
            action_val.put("token_key", token_key);
            action_val.put("token_val", token_val);
            JobBroker.sendJobbrokerCommand("updateRefreshToken", action_val);
            if (replicate != null && replicate.equalsIgnoreCase("true")) {
                Properties p = new Properties();
                p.put("token_key", token_key);
                p.put("token_val", token_val);
                p.put("need_response", "false");
                SharedSessionReplicated.send(com.crushftp.client.Common.makeBoundary(11), "crushftp.AdminControls.updateRefreshToken", "info", p);
            }
        }
    }

    public static void setRefreshTokens(Properties refresh_tokens) {
        if (com.crushftp.client.Common.refresh_tokens != null && refresh_tokens != null) {
            com.crushftp.client.Common.refresh_tokens.putAll((Map<?, ?>)refresh_tokens);
        } else if (refresh_tokens != null) {
            com.crushftp.client.Common.refresh_tokens = refresh_tokens;
        }
    }

    public static Object change_vars_to_values_static(String s, Properties user, Properties user_info) {
        return ServerStatus.change_vars_to_values_static(s, user, user_info, null);
    }

    public static void setServerInfo(Properties server_info) {
        ServerStatus.server_info.putAll((Map<?, ?>)server_info);
    }

    public static void setServerSettings(Properties server_settings) {
        ServerStatus.server_settings = server_settings;
        ServerStatus.setupGlobalPrefs();
    }

    public static Properties getServerProperties(String type) {
        if (type.equals("server_settings")) {
            if (new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "prefs.XML").lastModified() == JobBroker.jobs_broker_prefs_last_modified) {
                return null;
            }
            JobBroker.jobs_broker_prefs_last_modified = new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "prefs.XML").lastModified();
            return ServerStatus.server_settings;
        }
        if (type.equals("refresh_tokens")) {
            return com.crushftp.client.Common.refresh_tokens == null ? new Properties() : com.crushftp.client.Common.refresh_tokens;
        }
        Properties server_info2 = (Properties)ServerStatus.server_info.clone();
        server_info2.remove("user_list");
        server_info2.remove("recent_user_list");
        server_info2.remove("plugins");
        server_info2.remove("ip_restrictions_temp");
        server_info2.remove("vfs_url_cache");
        server_info2.remove("server_list");
        server_info2.remove("knownBadTempAccounts");
        server_info2.remove("ram_free_history");
        server_info2.remove("server_cpu_history");
        server_info2.remove("connected_unique_ips_history");
        server_info2.remove("current_download_speed_history");
        server_info2.remove("open_files_history");
        server_info2.remove("ram_max_history");
        server_info2.remove("incoming_transfers_history");
        server_info2.remove("hammer_history");
        server_info2.remove("current_upload_speed_history");
        server_info2.remove("outgoing_transfers_history");
        server_info2.remove("logged_in_users_history");
        server_info2.remove("os_cpu_history");
        server_info2.remove("hammer_history_http");
        server_info2.remove("ram_free_history");
        server_info2.remove("html5_transfers");
        server_info2.put("common_encryption_password", new String(com.crushftp.client.Common.encryption_password));
        return server_info2;
    }

    public static Object BG(String s) {
        return String.valueOf(ServerStatus.BG(s));
    }

    public static String SG(String s) {
        return ServerStatus.SG(s);
    }

    public static Object siVG(String s) {
        return ServerStatus.siVG(s);
    }

    public static void setGlobalVariable(Object variable_key, Object variable_val) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "setGlobalVariable");
            p.put("variable_key", variable_key);
            p.put("variable_val", variable_val);
            JobBroker.jobs_to_server_queue.addElement(p);
        } else {
            if (com.crushftp.client.Common.System2.get("global_variables") == null) {
                com.crushftp.client.Common.System2.put("global_variables", new Properties());
            }
            Properties global_variables = (Properties)com.crushftp.client.Common.System2.get("global_variables");
            global_variables.put(variable_key, variable_val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTotalBytesReceived(String s) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Object object = last_send_lock;
            synchronized (object) {
                if (System.currentTimeMillis() - last_send_time < 10000L) {
                    pending_add_bytes_received += Long.parseLong(s);
                    s = null;
                } else {
                    s = String.valueOf(pending_add_bytes_received + Long.parseLong(s));
                    pending_add_bytes_received = 0L;
                    last_send_time = System.currentTimeMillis();
                }
            }
            if (s != null) {
                Properties p = new Properties();
                p.put("class", "Taskbridge");
                p.put("method", "addTotalBytesReceived");
                p.put("bytes", s);
                JobBroker.jobs_to_server_queue.addElement(p);
            }
        } else {
            ServerStatus.thisObj.total_server_bytes_received += Long.parseLong(s);
            if (ServerStatus.BG("save_server_bytes_in_out")) {
                ServerStatus.siPUT2("total_server_bytes_received", String.valueOf(ServerStatus.thisObj.total_server_bytes_received));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTotalBytesSent(String s) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Object object = last_send_lock;
            synchronized (object) {
                if (System.currentTimeMillis() - last_send_time < 10000L) {
                    pending_add_bytes_sent += Long.parseLong(s);
                    s = null;
                } else {
                    s = String.valueOf(pending_add_bytes_sent + Long.parseLong(s));
                    pending_add_bytes_sent = 0L;
                    last_send_time = System.currentTimeMillis();
                }
            }
            if (s != null) {
                Properties p = new Properties();
                p.put("class", "Taskbridge");
                p.put("method", "addTotalBytesSent");
                p.put("bytes", s);
                JobBroker.jobs_to_server_queue.addElement(p);
            }
        } else {
            ServerStatus.thisObj.total_server_bytes_sent += Long.parseLong(s);
            if (ServerStatus.BG("save_server_bytes_in_out")) {
                ServerStatus.siPUT2("total_server_bytes_sent", String.valueOf(ServerStatus.thisObj.total_server_bytes_sent));
            }
        }
    }

    public static Object add_login_stat(String username, String user_ip, String session_id) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "add_login_stat");
            if (username != null) {
                p.put("username", username);
            }
            if (user_ip != null) {
                p.put("user_ip", user_ip);
            }
            if (session_id != null) {
                p.put("session_id", session_id);
            }
            JobBroker.jobs_to_server_queue.addElement(p);
            JobBroker.waitResponse(p, 30);
            return p.get("result");
        }
        ServerStatus serverStatus = ServerStatus.thisObj;
        long rid = serverStatus.statTools.u();
        try {
            ServerStatus.thisObj.statTools.add_login_stat("Job", username, user_ip, true, session_id, rid);
        }
        catch (Exception e) {
            com.crushftp.client.Common.log("SERVER", 1, e);
        }
        return String.valueOf(rid);
    }

    public static Object add_item_stat(String session_id, String rid, Properties item2, String direction) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "add_item_stat");
            p.put("rid", rid);
            p.put("item2", item2);
            p.put("direction", direction);
            if (session_id != null) {
                p.put("session_id", session_id);
            }
            JobBroker.jobs_to_server_queue.addElement(p);
        } else {
            ServerStatus.thisObj.statTools.add_item_stat("127.0.0.2", session_id, rid, item2, direction);
        }
        return rid;
    }

    public static Object stats_update_sessions(String rid) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "stats_update_sessions");
            p.put("rid", rid);
            JobBroker.jobs_to_server_queue.addElement(p);
        } else if (ServerStatus.BG("job_statistics_enabled")) {
            ServerStatus.thisObj.statTools.update_session_end_time(rid);
        }
        return String.valueOf(rid);
    }

    public static void updateSpecificJobCache(Properties summaryJob, String path, String replicate) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "updateSpecificJobCache");
            p.put("summaryJob", summaryJob);
            p.put("path", path);
            p.put("replicate", replicate);
            JobBroker.jobs_to_server_queue.addElement(p);
        } else {
            JobScheduler.updateSpecificJobCache(summaryJob, path, replicate.equals("true"));
        }
    }

    public static void updateJobJVMStats(Properties p) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "updateJobJVMStats");
            p.put("job_ram_max", String.valueOf(Runtime.getRuntime().maxMemory()));
            p.put("job_ram_free", String.valueOf(Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory()));
            p.put("job_ram_used", String.valueOf(Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory())));
            String cpu_usage = com.crushftp.client.Common.getCpuUsage();
            p.put("job_thread_pool_available", String.valueOf(Worker.availableWorkers.size()));
            p.put("job_thread_pool_busy", String.valueOf(Worker.busyWorkers.size()));
            p.put("job_server_cpu", "0");
            p.put("job_os_cpu", "0");
            p.put("job_open_files", "0");
            p.put("job_max_open_files", "0");
            if (!cpu_usage.equals("")) {
                p.put("job_server_cpu", String.valueOf((int)Float.parseFloat(cpu_usage.split(":")[0])));
                p.put("job_os_cpu", String.valueOf((int)Float.parseFloat(cpu_usage.split(":")[1])));
                if (cpu_usage.split(":").length > 2) {
                    p.put("job_open_files", cpu_usage.split(":")[2]);
                }
                if (cpu_usage.split(":").length > 3) {
                    p.put("job_max_open_files", cpu_usage.split(":")[3]);
                }
            }
            JobBroker.jobs_to_server_queue.addElement(p);
        } else {
            Enumeration<Object> keys = p.keys();
            while (keys.hasMoreElements()) {
                String key = "" + keys.nextElement();
                String val = p.getProperty(key);
                ServerStatus.siPUT(key, val);
            }
        }
    }

    public static Object runReport(Properties params) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "runReport");
            p.put("params", params);
            JobBroker.jobs_to_server_queue.addElement(p);
            JobBroker.waitResponse(p, 300);
            return p.get("result");
        }
        Object reportItem = ServerStatus.thisObj.rt.getReportItem(params.getProperty("reportName"), ServerStatus.server_settings);
        Vector<String> v = new Vector<String>();
        String s = "";
        if (params.containsKey("usernames")) {
            String[] usernames = com.crushftp.client.Common.html_clean_usernames(params.getProperty("usernames").split(","));
            int x = 0;
            while (x < usernames.length) {
                s = usernames[x].trim();
                if (!s.equals("")) {
                    v.addElement(s);
                }
                ++x;
            }
            params.put("usernames", v);
        }
        params.put("usernames", v);
        params.put("server_settings", ServerStatus.server_settings);
        Properties status = new Properties();
        String xml = ServerStatus.thisObj.rt.writeReport(params.getProperty("reportFilename"), params.getProperty("reportFolder"), status, params, reportItem, ServerStatus.server_settings, params.getProperty("export", "false").equals("true"), params.getProperty("reportName"), params);
        if (status.getProperty("report_empty", "true").equals("true")) {
            xml = status.remove("report_text").toString();
            xml = String.valueOf(xml) + "<hr/><center><h1>No data to report.</h1></center><hr/>";
        }
        return xml;
    }

    public static Object getPGPKeystore() {
        try {
            if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
                Properties p = new Properties();
                p.put("class", "Taskbridge");
                p.put("method", "getPGPKeystore");
                JobBroker.jobs_to_server_queue.addElement(p);
                JobBroker.waitResponse(p, 300);
                byte[] b = (byte[])p.get("result");
                KeyStore k = new KeyStore();
                k.loadFromStream(new ByteArrayInputStream(b));
                return k;
            }
            return AdminControls.getPGPKeystore();
        }
        catch (Exception e) {
            Log.log("SERVER", 1, e);
            return null;
        }
    }

    public static Properties doEventPlugin(Properties info, Properties event, Vector items, String receive_progress_updates, String update_at_end_only) {
        if (System.getProperty("crushftp.remote_job_broker", "false").equals("true")) {
            Properties p = new Properties();
            p.put("class", "Taskbridge");
            p.put("method", "doEventPlugin");
            p.put("info", info);
            p.put("event", event);
            p.put("items", items);
            p.put("receive_progress_updates", receive_progress_updates);
            p.put("update_at_end_only", update_at_end_only);
            JobBroker.jobs_to_server_queue.addElement(p);
            JobBroker.waitResponse(p, 300);
            return (Properties)p.get("result");
        }
        return JobScheduler.doEventPlugin(info, event, null, items, receive_progress_updates.equals("true"), update_at_end_only.equals("true"));
    }

    public static Properties doEventItem(Properties fileItem, String event_type, String user_ip, String sessionID, String SESSION_RID) {
        fileItem = (Properties)fileItem.clone();
        VRL vrl = new VRL(fileItem.getProperty("url"));
        Log.log("FTP_SERVER", 2, "Tracking " + event_type + ":" + vrl.getPath());
        fileItem.put("the_command", event_type);
        if (fileItem.containsKey("root_dir")) {
            fileItem.put("the_file_path", String.valueOf(fileItem.getProperty("root_dir")) + fileItem.getProperty("the_file_name", fileItem.getProperty("name")) + (fileItem.getProperty("type").equals("DIR") ? "/" : ""));
        } else {
            fileItem.put("the_file_path", vrl.getPath());
        }
        fileItem.put("the_command_data", fileItem.getProperty("the_file_path"));
        fileItem.put("the_file_name", fileItem.getProperty("name"));
        fileItem.put("the_file_size", fileItem.getProperty("size"));
        fileItem.put("the_file_speed", "0");
        fileItem.put("the_file_start", String.valueOf(new Date().getTime()));
        fileItem.put("the_file_end", String.valueOf(new Date().getTime()));
        fileItem.put("the_file_error", "");
        fileItem.put("the_file_type", fileItem.getProperty("type", ""));
        fileItem.put("the_file_status", "SUCCESS");
        ServerStatus.thisObj.statTools.add_item_stat(user_ip, sessionID, SESSION_RID, fileItem, event_type, new Date());
        return fileItem;
    }
}

