/*
 * Decompiled with CFR 0.152.
 */
package crushftp.handlers;

import com.crushftp.client.File_S;
import com.crushftp.client.File_U;
import com.crushftp.client.GlacierClient;
import com.crushftp.client.S3CrushClient;
import com.crushftp.client.VRL;
import com.crushftp.client.Worker;
import com.didisoft.pgp.KeyStore;
import crushftp.handlers.Common;
import crushftp.handlers.JobScheduler;
import crushftp.handlers.Log;
import crushftp.handlers.QuotaWorker;
import crushftp.handlers.SessionCrush;
import crushftp.handlers.SharedSession;
import crushftp.handlers.TaskBridge;
import crushftp.handlers.UserTools;
import crushftp.server.AdminControls;
import crushftp.server.ServerSessionAJAX;
import crushftp.server.ServerStatus;
import crushftp.server.daemon.DMZServerCommon;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class SharedSessionReplicated {
    public static Vector pending_pref_sync = new Vector();
    public static Vector pending_user_sync = new Vector();
    public static Vector pending_job_sync = new Vector();
    public static Vector pending_share_sync = new Vector();
    public static Properties send_queues = new Properties();
    public static Vector remote_host_ports = new Vector();
    static SSLSocketFactory factory = null;
    static Vector replicatedItems = new Vector();
    static long sync_delay = 0L;
    static long lastActive = 0L;
    static Properties pendingResponses = new Properties();
    static int reconnects = 0;
    static ServerSocket ss = null;
    static String allowed_ips = "";
    static String replicate_session_host_port = "";
    static boolean enterprise_enabled = false;
    public static Properties remote_host_ports_socks = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset_sockets() {
        if (!ServerStatus.shutting_down) {
            if (replicate_session_host_port.equals(ServerStatus.SG("replicate_session_host_port")) && enterprise_enabled == ServerStatus.siIG("enterprise_level") >= 0) {
                return;
            }
        }
        if (!replicate_session_host_port.equals("")) {
            Vector vector = pending_pref_sync;
            synchronized (vector) {
                pending_pref_sync.clear();
                new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_pref_sync.xml").delete();
            }
            vector = pending_user_sync;
            synchronized (vector) {
                pending_user_sync.clear();
                new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_user_sync.xml").delete();
            }
            vector = pending_job_sync;
            synchronized (vector) {
                pending_job_sync.clear();
                new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_job_sync.xml").delete();
            }
            vector = pending_share_sync;
            synchronized (vector) {
                pending_share_sync.clear();
                new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_share_sync.xml").delete();
            }
        }
        enterprise_enabled = ServerStatus.siIG("enterprise_level") >= 0;
        replicate_session_host_port = ServerStatus.SG("replicate_session_host_port");
        remote_host_ports.clear();
        send_queues.clear();
        int x22 = 0;
        while (x22 < replicate_session_host_port.split(",").length) {
            if (!replicate_session_host_port.split(",")[x22].trim().equals("")) {
                if (replicate_session_host_port.indexOf(",") >= 0 && replicate_session_host_port.split(",")[x22].trim().toUpperCase().indexOf(System.getProperty("crushftp.hostname", "").toUpperCase()) < 0) {
                    remote_host_ports.addElement(replicate_session_host_port.split(",")[x22].trim());
                } else if (replicate_session_host_port.indexOf(",") < 0 && replicate_session_host_port.split(":")[0].trim().toUpperCase().indexOf(System.getProperty("crushftp.hostname", "").toUpperCase()) < 0) {
                    remote_host_ports.addElement(replicate_session_host_port.split(",")[x22].trim());
                }
            }
            ++x22;
        }
        ServerStatus.server_info.put("replicated_servers", "" + remote_host_ports);
        ServerStatus.server_info.put("replicated_servers_count", String.valueOf(remote_host_ports.size()));
        try {
            if (ss != null) {
                ss.close();
            }
        }
        catch (IOException x22) {
            // empty catch block
        }
        ss = null;
        allowed_ips = ServerStatus.SG("replicated_server_ips");
        if (allowed_ips.equals("*")) {
            String new_allowed = ",";
            int x = 0;
            while (x < replicate_session_host_port.split(",").length) {
                String host = replicate_session_host_port.split(",")[x].split(":")[0].trim();
                try {
                    new_allowed = String.valueOf(new_allowed) + InetAddress.getByName(host).getHostAddress() + ",";
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    Log.log("SERVER", 0, e);
                }
                ++x;
            }
            allowed_ips = new_allowed;
        }
        if (!enterprise_enabled) {
            Log.log("SERVER", 0, "Replication only allowed for enterprise licenses.");
        }
        if (remote_host_ports.size() == 0 || !enterprise_enabled || ServerStatus.shutting_down) {
            return;
        }
        int xx = 0;
        while (xx < remote_host_ports.size()) {
            send_queues.put(remote_host_ports.elementAt(xx), new Vector());
            ++xx;
        }
        try {
            String remote_host_port = remote_host_ports.elementAt(0).toString();
            int bind_port = 0;
            bind_port = remote_host_port.split(":").length > 2 ? Integer.parseInt(remote_host_port.split(":")[0]) : Integer.parseInt(remote_host_port.split(":")[1]);
            if (bind_port == 443) {
                throw new Exception("443 is not valid for replication!  This is not a HTTP/HTTPS port, it must be an unused port!");
            }
            if (System.getProperty("crushftp.sharedsession.ssl", "true").equals("true")) {
                ss = ServerStatus.thisObj.common_code.getServerSocket(bind_port, System.getProperty("crushftp.sharedsession.bindip", "0.0.0.0"), "builtin", "crushftp", "crushftp", "", false, 1, true, false, null);
                Common.configureSSLTLSSocket(ss);
            } else {
                ss = new ServerSocket(bind_port, 1000, InetAddress.getByName(System.getProperty("crushftp.sharedsession.bindip", "0.0.0.0")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.log("SERVER", 0, e);
        }
    }

    public static void init() {
        Properties p;
        int x;
        try {
            replicatedItems.addElement("crushftp.usernames");
            replicatedItems.addElement("crushftp.sessions");
            SharedSessionReplicated.reset_sockets();
            Worker.startWorker(new Runnable(){

                @Override
                public void run() {
                    try {
                        String current_name = Thread.currentThread().getName();
                        while (!ServerStatus.shutting_down) {
                            try {
                                if (ss != null) {
                                    if (current_name.equals("SharedSessionReplicatedReceiver")) {
                                        current_name = "SharedSessionReplicatedReceiver:" + remote_host_ports.elementAt(0) + "|" + ss + ":";
                                    }
                                    Thread.currentThread().setName(current_name);
                                    final Socket sock = ss.accept();
                                    String incoming_ip = sock.getInetAddress().getHostAddress();
                                    if (!allowed_ips.equals("") && !com.crushftp.client.Common.do_search(allowed_ips, incoming_ip, false, 0) && allowed_ips.indexOf(incoming_ip) < 0) {
                                        String msg = "IP " + sock.getInetAddress().getHostAddress() + " was from an untrusted host and was denied replication control. Allowed IPs: " + allowed_ips;
                                        sock.close();
                                        System.out.println(msg);
                                        Log.log("SERVER", 0, msg);
                                        continue;
                                    }
                                    sock.setSoTimeout(10000);
                                    final String parent_thread_name = current_name;
                                    Worker.startWorker(new Runnable(){

                                        @Override
                                        public void run() {
                                            Thread.currentThread().setName(String.valueOf(parent_thread_name) + ":" + sock + ": reconnects=" + reconnects);
                                            try {
                                                ObjectInputStream ois = new ObjectInputStream(sock.getInputStream());
                                                long received = 0L;
                                                while (!ServerStatus.shutting_down) {
                                                    Properties p = (Properties)ois.readUnshared();
                                                    if (p.getProperty("action").equalsIgnoreCase("CLOSE")) break;
                                                    p.put("source_socket", "" + sock);
                                                    SharedSessionReplicated.receive(p);
                                                    Thread.currentThread().setName(String.valueOf(parent_thread_name) + ":" + sock + ": reconnects=" + reconnects + " received=" + ++received + " pending_pref_sync=" + pending_pref_sync.size() + " pending_user_sync=" + pending_user_sync.size() + " pending_job_sync=" + pending_job_sync.size() + " pendingResponses=" + pendingResponses.size());
                                                }
                                                ois.close();
                                            }
                                            catch (Exception e) {
                                                Log.log("SERVER", 0, e);
                                            }
                                            try {
                                                sock.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                            ++reconnects;
                                        }
                                    });
                                    continue;
                                }
                                Thread.sleep(1000L);
                            }
                            catch (Exception e) {
                                Log.log("SERVER", 0, e);
                                Thread.sleep(1000L);
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.log("SERVER", 0, e);
                    }
                }
            }, "SharedSessionReplicatedReceiver");
            Worker.startWorker(new Runnable(){

                @Override
                public void run() {
                    block2: while (!ServerStatus.shutting_down) {
                        SharedSessionReplicated.flushNow();
                        boolean empty = true;
                        int delay = 10;
                        while (empty) {
                            if (delay > 100) {
                                delay = 100;
                            }
                            try {
                                Thread.sleep(delay++);
                                Vector remote_host_ports2 = (Vector)remote_host_ports.clone();
                                int xx = 0;
                                while (xx < remote_host_ports2.size()) {
                                    Vector v = (Vector)send_queues.get(remote_host_ports2.elementAt(xx));
                                    if (v != null && v.size() > 0) {
                                        empty = false;
                                    }
                                    ++xx;
                                }
                            }
                            catch (Exception e) {
                                empty = false;
                            }
                            if (!empty) continue block2;
                        }
                    }
                }
            }, "SharedSessionReplicatedSender:");
            Worker.startWorker(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long lastSync = System.currentTimeMillis();
                    while (!ServerStatus.shutting_down) {
                        block29: {
                            try {
                                Properties p;
                                int x;
                                if (System.currentTimeMillis() - lastSync <= 10000L) break block29;
                                Vector vector = pending_pref_sync;
                                synchronized (vector) {
                                    Vector pending_pref_sync2 = (Vector)pending_pref_sync.clone();
                                    x = 0;
                                    while (x < pending_pref_sync2.size()) {
                                        p = (Properties)pending_pref_sync2.elementAt(x);
                                        if (System.currentTimeMillis() - Long.parseLong(p.getProperty("time")) > 40000L) {
                                            pending_pref_sync.remove(p);
                                            SharedSessionReplicated.send(p.getProperty("id"), p.getProperty("action"), p.get("key"), p.get("val"));
                                        }
                                        ++x;
                                    }
                                    if (pending_pref_sync2.size() != pending_pref_sync.size()) {
                                        SharedSessionReplicated.flushPendingPrefSync();
                                    }
                                    ServerStatus.server_info.put("replicated_servers_pending_pref_sync", String.valueOf(pending_pref_sync.size()));
                                }
                                vector = pending_user_sync;
                                synchronized (vector) {
                                    Vector pending_user_sync2 = (Vector)pending_user_sync.clone();
                                    x = 0;
                                    while (x < pending_user_sync2.size()) {
                                        p = (Properties)pending_user_sync2.elementAt(x);
                                        if (System.currentTimeMillis() - Long.parseLong(p.getProperty("time")) > 40000L) {
                                            pending_user_sync.remove(p);
                                            SharedSessionReplicated.send(p.getProperty("id"), p.getProperty("action"), p.get("key"), p.get("val"));
                                        }
                                        ++x;
                                    }
                                    if (pending_user_sync2.size() != pending_user_sync.size()) {
                                        SharedSessionReplicated.flushPendingUserSync();
                                    }
                                    ServerStatus.server_info.put("replicated_servers_pending_user_sync", String.valueOf(pending_user_sync.size()));
                                }
                                vector = pending_job_sync;
                                synchronized (vector) {
                                    Vector pending_job_sync2 = (Vector)pending_job_sync.clone();
                                    x = 0;
                                    while (x < pending_job_sync2.size()) {
                                        p = (Properties)pending_job_sync2.elementAt(x);
                                        if (System.currentTimeMillis() - Long.parseLong(p.getProperty("time")) > 40000L) {
                                            pending_job_sync.remove(p);
                                            SharedSessionReplicated.send(p.getProperty("id"), p.getProperty("action"), p.get("key"), p.get("val"));
                                        }
                                        ++x;
                                    }
                                    if (pending_job_sync2.size() != pending_job_sync.size()) {
                                        SharedSessionReplicated.flushPendingJobSync();
                                    }
                                    ServerStatus.server_info.put("replicated_servers_pending_job_sync", String.valueOf(pending_job_sync.size()));
                                }
                                vector = pending_share_sync;
                                synchronized (vector) {
                                    Vector pending_share_sync2 = (Vector)pending_share_sync.clone();
                                    x = 0;
                                    while (x < pending_share_sync2.size()) {
                                        p = (Properties)pending_share_sync2.elementAt(x);
                                        if (System.currentTimeMillis() - Long.parseLong(p.getProperty("time")) > 40000L) {
                                            pending_share_sync.remove(p);
                                            SharedSessionReplicated.send(p.getProperty("id"), p.getProperty("action"), p.get("key"), p.get("val"));
                                        }
                                        ++x;
                                    }
                                    if (pending_share_sync2.size() != pending_share_sync.size()) {
                                        SharedSessionReplicated.flushPendingShareSync();
                                    }
                                    ServerStatus.server_info.put("replicated_servers_pending_share_sync", String.valueOf(pending_share_sync.size()));
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }, "SharedSessionReplicatedPendingSender:");
            Worker.startWorker(new Runnable(){

                @Override
                public void run() {
                    long lastSync = System.currentTimeMillis();
                    while (!ServerStatus.shutting_down) {
                        try {
                            if (System.currentTimeMillis() - lastSync > 10000L) {
                                Enumeration<Object> keys = pendingResponses.keys();
                                while (keys.hasMoreElements()) {
                                    String key = keys.nextElement().toString();
                                    Properties val = (Properties)pendingResponses.get(key);
                                    if (System.currentTimeMillis() - Long.parseLong(val.getProperty("time", "0")) <= 10000L) continue;
                                    val.put("response_num", "-1");
                                    pendingResponses.remove(key);
                                }
                                ServerStatus.server_info.put("replicated_servers_pendingResponses", String.valueOf(pendingResponses.size()));
                                lastSync = System.currentTimeMillis();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }, "SharedSessionReplicatedResponseCleaner:");
        }
        catch (Exception e) {
            Log.log("SERVER", 0, e);
        }
        if (new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_pref_sync.xml").exists()) {
            Vector pending_pref_sync2 = (Vector)Common.readXMLObject(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_pref_sync.xml");
            if (pending_pref_sync2 != null) {
                x = 0;
                while (x < pending_pref_sync2.size()) {
                    p = (Properties)pending_pref_sync2.elementAt(x);
                    SharedSessionReplicated.send(p.getProperty("id"), p.getProperty("action"), p.get("key"), p.get("val"));
                    ++x;
                }
            }
            ServerStatus.server_info.put("replicated_servers_pending_pref_sync", String.valueOf(pending_pref_sync.size()));
        }
        if (new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_user_sync.xml").exists()) {
            Vector pending_user_sync2 = (Vector)Common.readXMLObject(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_user_sync.xml");
            if (pending_user_sync2 != null) {
                x = 0;
                while (x < pending_user_sync2.size()) {
                    p = (Properties)pending_user_sync2.elementAt(x);
                    SharedSessionReplicated.send(p.getProperty("id"), p.getProperty("action"), p.get("key"), p.get("val"));
                    ++x;
                }
            }
            ServerStatus.server_info.put("replicated_servers_pending_user_sync", String.valueOf(pending_user_sync.size()));
        }
        if (new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_job_sync.xml").exists()) {
            Vector pending_job_sync2 = (Vector)Common.readXMLObject(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_job_sync.xml");
            if (pending_job_sync2 != null) {
                x = 0;
                while (x < pending_job_sync2.size()) {
                    p = (Properties)pending_job_sync2.elementAt(x);
                    SharedSessionReplicated.send(p.getProperty("id"), p.getProperty("action"), p.get("key"), p.get("val"));
                    ++x;
                }
            }
            ServerStatus.server_info.put("replicated_servers_pending_job_sync", String.valueOf(pending_job_sync.size()));
        }
        if (new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_share_sync.xml").exists()) {
            Vector pending_share_sync2 = (Vector)Common.readXMLObject(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_share_sync.xml");
            if (pending_share_sync2 != null) {
                x = 0;
                while (x < pending_share_sync2.size()) {
                    p = (Properties)pending_share_sync2.elementAt(x);
                    SharedSessionReplicated.send(p.getProperty("id"), p.getProperty("action"), p.get("key"), p.get("val"));
                    ++x;
                }
            }
            ServerStatus.server_info.put("replicated_servers_pending_share_sync", String.valueOf(pending_share_sync.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushNow() {
        try {
            if (factory == null && System.getProperty("crushftp.sharedsession.ssl", "true").equals("true")) {
                factory = ServerStatus.thisObj.common_code.getSSLContext("builtin", null, "crushftp", "crushftp", "TLS", false, true).getSocketFactory();
            }
        }
        catch (Exception e) {
            Log.log("SERVER", 0, e);
        }
        Vector remote_host_ports2 = (Vector)remote_host_ports.clone();
        int xx = 0;
        while (xx < remote_host_ports2.size()) {
            final String remote_host_port = remote_host_ports2.elementAt(xx).toString();
            final int remote_host_port_index = xx;
            lastActive = System.currentTimeMillis();
            final Vector send_queue = (Vector)send_queues.get(remote_host_ports2.elementAt(xx));
            ServerStatus.server_info.put("replicated_servers_queue_" + remote_host_port_index, String.valueOf(send_queue.size()));
            if (send_queue.size() > 0 && !remote_host_ports_socks.getProperty(String.valueOf(remote_host_port) + "_locked", "false").equals("true")) {
                Object send_queue_lock = null;
                Vector vector = send_queue;
                synchronized (vector) {
                    send_queue_lock = remote_host_ports_socks.get(String.valueOf(remote_host_port) + "_lock");
                    if (send_queue_lock == null) {
                        remote_host_ports_socks.put(String.valueOf(remote_host_port) + "_lock", new Object());
                    }
                }
                try {
                    Worker.startWorker(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            String dest_host = "";
                            int dest_port = 0;
                            if (remote_host_port.split(":").length > 2) {
                                dest_host = remote_host_port.split(":")[1];
                                dest_port = Integer.parseInt(remote_host_port.split(":")[2]);
                            } else {
                                dest_host = remote_host_port.split(":")[0];
                                dest_port = Integer.parseInt(remote_host_port.split(":")[1]);
                            }
                            Socket sock = null;
                            boolean in_error = false;
                            Object send_queue_lock = remote_host_ports_socks.get(String.valueOf(remote_host_port) + "_lock");
                            Thread.currentThread().setName("Waiting to lock send queue for replication server:" + dest_host + ":" + dest_port);
                            Object object = send_queue_lock;
                            synchronized (object) {
                                block32: {
                                    try {
                                        remote_host_ports_socks.put(String.valueOf(remote_host_port) + "_locked", "true");
                                        Thread.currentThread().setName("Connecting to replication server:" + dest_host + ":" + dest_port);
                                        if (send_queue.size() > 0) {
                                            ObjectOutputStream oos = null;
                                            if (!remote_host_ports_socks.containsKey(String.valueOf(remote_host_port) + "_sock")) {
                                                sock = new Socket();
                                                sock.setSoTimeout(5000);
                                                sock.connect(new InetSocketAddress(dest_host, dest_port));
                                                if (System.getProperty("crushftp.sharedsession.ssl", "true").equals("true")) {
                                                    sock = (SSLSocket)factory.createSocket(sock, dest_host, dest_port, true);
                                                }
                                                sock.setSoTimeout(10000);
                                                oos = new ObjectOutputStream(sock.getOutputStream());
                                            } else {
                                                sock = (Socket)remote_host_ports_socks.remove(String.valueOf(remote_host_port) + "_sock");
                                                oos = (ObjectOutputStream)remote_host_ports_socks.remove(String.valueOf(remote_host_port) + "_oos");
                                            }
                                            final Properties status = new Properties();
                                            final ObjectOutputStream oos_f = oos;
                                            Thread.currentThread().setName("Sending queued messages to replication server:" + dest_host + ":" + dest_port + ":");
                                            while (send_queue.size() > 0 && !ServerStatus.shutting_down) {
                                                Thread.currentThread().setName(String.valueOf(Thread.currentThread().getName().substring(0, Thread.currentThread().getName().lastIndexOf(":") + 1)) + send_queue.size());
                                                final Properties p = (Properties)send_queue.elementAt(0);
                                                if (!p.getProperty("action", "").equals("crushftp.session.update")) {
                                                    Log.log("SERVER", 2, "SharedSession:Send:" + p.getProperty("id") + ":" + p.getProperty("action") + ":" + p.getProperty("key") + ":" + p.getProperty("size", "0") + " bytes");
                                                }
                                                status.remove("error");
                                                status.remove("status");
                                                Worker.startWorker(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        try {
                                                            oos_f.writeUnshared(p);
                                                            oos_f.flush();
                                                            oos_f.reset();
                                                            status.put("status", "");
                                                        }
                                                        catch (Exception e) {
                                                            status.put("error", e);
                                                            status.put("status", "ERROR:" + e);
                                                        }
                                                    }
                                                }, "SharedSession:Send:" + p.getProperty("id") + ":" + p.getProperty("action") + ":" + p.getProperty("key") + ":" + p.getProperty("size", "0") + " bytes:" + dest_host + ":" + dest_port);
                                                int loops = 10;
                                                long start = System.currentTimeMillis();
                                                while (!status.containsKey("status") && System.currentTimeMillis() - start < 10000L) {
                                                    Thread.sleep(loops++);
                                                    if (loops <= 1000) continue;
                                                    loops = 1000;
                                                }
                                                if (status.containsKey("error")) {
                                                    throw (Exception)status.get("error");
                                                }
                                                if (!status.containsKey("status")) {
                                                    throw new Exception("Timeout sending replication object:" + sock + ":SharedSession:Send:" + p.getProperty("id") + ":" + p.getProperty("action") + ":" + p.getProperty("key") + ":" + p.getProperty("size", "0") + " bytes");
                                                }
                                                send_queue.remove(0);
                                                sync_delay = System.currentTimeMillis() - Long.parseLong(p.getProperty("queued"));
                                                lastActive = System.currentTimeMillis();
                                            }
                                            lastActive = System.currentTimeMillis();
                                            ServerStatus.server_info.put("replicated_servers_lastActive", String.valueOf(lastActive));
                                            ServerStatus.server_info.put("replicated_servers_sent_" + remote_host_port_index, String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_servers_" + remote_host_port_index, "0")) + 1));
                                            remote_host_ports_socks.put(String.valueOf(remote_host_port) + "_sock", sock);
                                            remote_host_ports_socks.put(String.valueOf(remote_host_port) + "_oos", oos);
                                        }
                                    }
                                    catch (SocketException e) {
                                        lastActive = 0L;
                                        send_queue.removeAllElements();
                                        try {
                                            Thread.sleep(100L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        in_error = true;
                                        remote_host_ports_socks.put(String.valueOf(remote_host_port) + "_locked", "false");
                                        break block32;
                                    }
                                    catch (Exception e) {
                                        try {
                                            in_error = true;
                                            lastActive = 0L;
                                            Log.log("SERVER", 0, "ReplicationSocket:" + sock + ":" + remote_host_port + ":" + remote_host_port_index);
                                            Log.log("SERVER", 0, e);
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                // empty catch block
                                            }
                                            break block32;
                                        }
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                        finally {
                                            remote_host_ports_socks.put(String.valueOf(remote_host_port) + "_locked", "false");
                                        }
                                    }
                                    remote_host_ports_socks.put(String.valueOf(remote_host_port) + "_locked", "false");
                                }
                            }
                            if (in_error) {
                                remote_host_ports_socks.remove(String.valueOf(remote_host_port) + "_sock");
                                try {
                                    if (sock != null) {
                                        sock.close();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    if (remote_host_ports_socks.containsKey(String.valueOf(remote_host_port) + "_oos")) {
                                        ((ObjectOutputStream)remote_host_ports_socks.remove(String.valueOf(remote_host_port) + "_oos")).close();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++xx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receive(Properties p) {
        if (!enterprise_enabled || ServerStatus.shutting_down) {
            return;
        }
        long ms = System.currentTimeMillis() - Long.parseLong(p.getProperty("queued"));
        if (!p.getProperty("action", "").equals("crushftp.session.update")) {
            Log.log("SERVER", 2, "SharedSession:Receive:" + p.getProperty("id") + ":" + p.getProperty("action") + ":" + p.getProperty("key") + ":" + p.getProperty("size", "0") + " bytes:" + ms + "ms");
        }
        ServerStatus.server_info.put("replicated_received_message_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_received_message_count", "0")) + 1));
        if (p.getProperty("action").equalsIgnoreCase("RESPONSE")) {
            Properties pp;
            if (pendingResponses.containsKey(p.getProperty("id"))) {
                Properties val;
                Properties properties = val = (Properties)pendingResponses.get(p.getProperty("id"));
                synchronized (properties) {
                    int response_num = Integer.parseInt(val.getProperty("response_num", "0"));
                    ++response_num;
                    if (p.containsKey("val") && p.get("val") instanceof Properties) {
                        Properties val2 = (Properties)p.remove("val");
                        val.putAll((Map<?, ?>)p);
                        if (val.containsKey("val") && val.get("val") instanceof Properties) {
                            ((Properties)val.get("val")).putAll((Map<?, ?>)val2);
                        } else {
                            val.put("val", val2);
                        }
                    } else {
                        val.putAll((Map<?, ?>)p);
                    }
                    val.put("response_num", String.valueOf(response_num));
                }
                ServerStatus.server_info.put("replicated_servers_pendingResponses", String.valueOf(pendingResponses.size()));
            }
            int x = pending_pref_sync.size() - 1;
            while (x >= 0) {
                pp = (Properties)pending_pref_sync.elementAt(x);
                if (p.getProperty("id").equals(pp.getProperty("id"))) {
                    pending_pref_sync.remove(x);
                    SharedSessionReplicated.flushPendingPrefSync();
                }
                --x;
            }
            ServerStatus.server_info.put("replicated_servers_pending_pref_sync", String.valueOf(pending_pref_sync.size()));
            x = pending_user_sync.size() - 1;
            while (x >= 0) {
                pp = (Properties)pending_user_sync.elementAt(x);
                if (p.getProperty("id").equals(pp.getProperty("id"))) {
                    pending_user_sync.remove(x);
                    SharedSessionReplicated.flushPendingUserSync();
                }
                --x;
            }
            ServerStatus.server_info.put("replicated_servers_pending_user_sync", String.valueOf(pending_user_sync.size()));
            x = pending_job_sync.size() - 1;
            while (x >= 0) {
                pp = (Properties)pending_job_sync.elementAt(x);
                if (p.getProperty("id").equals(pp.getProperty("id"))) {
                    pending_job_sync.remove(x);
                    SharedSessionReplicated.flushPendingJobSync();
                }
                --x;
            }
            ServerStatus.server_info.put("replicated_servers_pending_job_sync", String.valueOf(pending_job_sync.size()));
            x = pending_share_sync.size() - 1;
            while (x >= 0) {
                pp = (Properties)pending_share_sync.elementAt(x);
                if (p.getProperty("id").equals(pp.getProperty("id"))) {
                    pending_share_sync.remove(x);
                    SharedSessionReplicated.flushPendingShareSync();
                }
                --x;
            }
            ServerStatus.server_info.put("replicated_servers_pending_share_sync", String.valueOf(pending_share_sync.size()));
        } else if (p.getProperty("action", "").equals("WRITE_PREFS")) {
            Properties prefs = (Properties)p.remove("val");
            try {
                Common.write_server_settings(prefs, p.getProperty("key"));
                DMZServerCommon.last_prefs_time.put(p.getProperty("key"), String.valueOf(new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "prefs_" + p.getProperty("key") + ".XML").lastModified()));
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_write_prefs_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_write_prefs_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.setServerItem")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.setServerItem((Properties)pp.remove("request"), (String)pp.remove("site"), false);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_write_prefs_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_write_prefs_count", "0")) + 1));
        } else if (p.getProperty("action", "").startsWith("BAN_IP")) {
            try {
                Properties params = (Properties)((Properties)p.get("val")).get("params");
                if (p.getProperty("action", "").endsWith("V4")) {
                    ServerStatus.thisObj.ban_ipv4(params.getProperty("ip"), Integer.parseInt(params.getProperty("timeout")), params.getProperty("onlyRealBan").equals("true"), params.getProperty("reason"), false);
                } else if (p.getProperty("action", "").endsWith("V6")) {
                    ServerStatus.thisObj.ban_ipv6(params.getProperty("ip"), Integer.parseInt(params.getProperty("timeout")), params.getProperty("onlyRealBan").equals("true"), params.getProperty("reason"), false);
                }
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_write_prefs_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_write_prefs_count", "0")) + 1));
        } else if (p.getProperty("action", "").startsWith("SYNC_CRUSHSSO_TOKENS")) {
            try {
                Properties tokens = (Properties)p.get("val");
                Properties crushSSO_tokens = ServerStatus.siPG("crushSSO_tokens");
                if (crushSSO_tokens == null) {
                    crushSSO_tokens = new Properties();
                    ServerStatus.siPUT("crushSSO_tokens", crushSSO_tokens);
                }
                Enumeration<Object> keys = tokens.keys();
                while (keys.hasMoreElements()) {
                    String key = "" + keys.nextElement();
                    if (crushSSO_tokens.containsKey(key)) continue;
                    crushSSO_tokens.put(key, tokens.get(key));
                    Log.log("SERVER", 0, "CrushSSO:Added replicated token:" + key);
                }
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").startsWith("SYNC_LOGIN_FREQUENCY")) {
            try {
                Properties login_frequency;
                Properties sync_info = (Properties)p.get("val");
                Properties keys = login_frequency = ServerStatus.siPG("login_frequency");
                synchronized (keys) {
                    login_frequency.put(sync_info.getProperty("user_name").toLowerCase(), (Properties)sync_info.get("login_prop"));
                }
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").startsWith("SYNC_LOGIN_ATTEMPT_FREQUENCY")) {
            try {
                Properties login_frequency;
                Properties sync_info = (Properties)p.get("val");
                Properties keys = login_frequency = ServerStatus.siPG("login_attempt_frequency");
                synchronized (keys) {
                    login_frequency.put(sync_info.getProperty("user_name").toLowerCase(), (Properties)sync_info.get("login_prop"));
                }
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.saveReport")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.saveReport((Properties)pp.remove("request"), "", false);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.unblockUsername")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.unblockUsername((Properties)pp.remove("request"), "", false);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.blockUsername")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.blockUsername((Properties)pp.remove("request"), "", false);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.renameJob")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.renameJob((Properties)pp.remove("request"), (String)pp.remove("site"), false);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_job_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_job_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.removeJob")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.removeJob((Properties)pp.remove("request"), (String)pp.remove("site"), false);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_job_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_job_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.addJob")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.addJob((Properties)pp.remove("request"), (String)pp.remove("site"), false);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_job_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_job_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.newFolder")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.newFolder((Properties)pp.remove("request"), (String)pp.remove("site"), false);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.renameItem")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.renameItem((Properties)pp.remove("request"), (String)pp.remove("site"), false);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.duplicateItem")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.duplicateItem((Properties)pp.remove("request"), (String)pp.remove("site"), false);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.deleteItem")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.deleteItem((Properties)pp.remove("request"), (String)pp.remove("site"), false);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.registerAgent")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.registerAgent((Properties)pp.remove("request"), false);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.getActionFromAgentQueue")) {
            try {
                Properties pp = (Properties)p.get("val");
                Properties result = AdminControls.getActionFromAgentQueue((Properties)pp.remove("request"), false);
                if (result != null && result.size() > 0) {
                    Properties response = new Properties();
                    response.put("result", result);
                    SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "result", response);
                }
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.getAgentResponse")) {
            try {
                Properties pp = (Properties)p.get("val");
                Properties result = AdminControls.getAgentResponse((Properties)pp.remove("request"), false);
                Properties response = new Properties();
                response.put("result", result);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "result", response);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.s3CrushClient.writeFs")) {
            try {
                Properties pp = (Properties)p.get("val");
                S3CrushClient.writeFs(System.getProperty("crushftp.s3_root", "./s3/"), pp.getProperty("bucketName0"), null, pp.getProperty("path"), (Properties)pp.get("data"));
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.doExtraUpdateActions.ping")) {
            try {
                Properties pp = (Properties)p.get("val");
                ServerStatus.siPUT("ping_" + pp.getProperty("hostname"), String.valueOf(System.currentTimeMillis()));
                Properties response = new Properties();
                response.put("pong_" + System.getProperty("crushftp.hostname"), "pong");
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "result", response);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.glacierCrushClient.writeFs")) {
            try {
                Properties pp = (Properties)p.get("val");
                GlacierClient.writeFs(System.getProperty("crushftp.glacier_root", "./glacier/"), pp.getProperty("vaultName0"), null, pp.getProperty("path"), (Properties)pp.get("data"));
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.QuotaWorker.getStatus")) {
            try {
                String id = p.getProperty("id");
                Properties response = new Properties();
                response.put("quota_status", String.valueOf(QuotaWorker.getStatus()));
                SharedSessionReplicated.send(id, "RESPONSE", "", response);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.QuotaWorker.receiveSharedQuota")) {
            try {
                QuotaWorker.receiveSharedQuota((Properties)p.get("val"));
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.JobScheduler.jobRunningCount")) {
            try {
                String id = p.getProperty("id");
                Properties val = (Properties)p.get("val");
                int jobRunningCount = JobScheduler.jobRunningCount(val.getProperty("scheduleName", ""), val.getProperty("hostname", ""));
                Properties response = new Properties();
                response.put("scheduleName", val.getProperty("scheduleName"));
                response.put("hostname", System.getProperty("crushftp.hostname", ""));
                String uid = Common.makeBoundary();
                response.put("hostname_" + uid, System.getProperty("crushftp.hostname", ""));
                response.put("running_" + uid, String.valueOf(jobRunningCount));
                SharedSessionReplicated.send(id, "RESPONSE", "", response);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.JobScheduler.ram_free")) {
            if (!ServerStatus.BG("job_scheduler_enabled")) {
                try {
                    String id = p.getProperty("id");
                    Properties val = (Properties)p.get("val");
                    long free = ServerStatus.siLG("ram_free");
                    Properties response = new Properties();
                    response.put("hostname", System.getProperty("crushftp.hostname", ""));
                    String uid = Common.makeBoundary();
                    response.put("hostname_" + uid, System.getProperty("crushftp.hostname", ""));
                    response.put("free_" + uid, String.valueOf(free));
                    SharedSessionReplicated.send(id, "RESPONSE", "", response);
                }
                catch (Exception e) {
                    Log.log("SERVER", 0, e);
                }
            }
        } else if (p.getProperty("action", "").equals("crushftp.JobScheduler.updateSpecificJobCache")) {
            try {
                Properties val = (Properties)p.get("val");
                JobScheduler.updateSpecificJobCache((Properties)val.get("summaryJob"), val.getProperty("path"), false);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.JobScheduler.runJob")) {
            try {
                final Properties p_f2 = p;
                p_f2.put("type", "RESPONSE");
                final Properties info = (Properties)p.remove("val");
                Worker.startWorker(new Runnable(){

                    @Override
                    public void run() {
                        String uid;
                        byte[] b = null;
                        Properties event = (Properties)info.remove("data");
                        Log.log("SERVER", 0, "crushftp.JobScheduler.runJob:" + info.getProperty("use_dmz", "") + ":" + p_f2.getProperty("source_socket", "") + ":" + event.getProperty("scheduleName"));
                        Vector items = (Vector)info.remove("items");
                        if (info.getProperty("use_dmz", "").equalsIgnoreCase("All DMZ Recursive") || info.getProperty("use_dmz", "").equalsIgnoreCase("All")) {
                            Enumeration<Object> keys = DMZServerCommon.dmzInstanceNames.keys();
                            while (keys.hasMoreElements()) {
                                Vector log = new Vector();
                                try {
                                    String the_dmz = keys.nextElement().toString();
                                    Log.log("SERVER", 0, "crushftp.JobScheduler.runJob:" + info.getProperty("use_dmz", "") + ":" + p_f2.getProperty("source_socket", "") + ":" + event.getProperty("scheduleName") + ":" + the_dmz);
                                    Vector newItems = SharedSessionReplicated.runOnDmz(event, the_dmz, items, log);
                                    info.put("newItems", newItems);
                                    Vector log2 = (Vector)log.clone();
                                    String log_str = "";
                                    while (log2.size() > 0) {
                                        log_str = String.valueOf(log_str) + log2.remove(0) + "\r\n";
                                    }
                                    Log.log("SERVER", 1, log_str);
                                    b = log_str.getBytes("UTF8");
                                    p_f2.put("data", info);
                                }
                                catch (Exception e) {
                                    Log.log("SERVER", 0, e);
                                }
                            }
                            uid = Common.makeBoundary();
                            p_f2.put("log_" + uid, new String(b));
                            p_f2.put("data_" + uid, info);
                        }
                        if (!info.getProperty("use_dmz", "").equalsIgnoreCase("All DMZ Recursive")) {
                            event.put("event_plugin_list", "CrushTask (User Defined)");
                            event.put("name", event.getProperty("scheduleName"));
                            Properties info2 = JobScheduler.doEventPlugin(null, event, null, items, true, true);
                            info2.put("newItems", items);
                            p_f2.put("data", info2);
                            try {
                                RandomAccessFile raf = new RandomAccessFile(new File_S(info2.getProperty("log_file")), "r");
                                b = new byte[(int)raf.length()];
                                raf.readFully(b);
                                raf.close();
                            }
                            catch (Throwable e) {
                                Log.log("SERVER", 0, e);
                                b = new byte[]{};
                            }
                            uid = Common.makeBoundary();
                            p_f2.put("type", "RESPONSE");
                            p_f2.put("log_" + uid, new String(b));
                            p_f2.put("data_" + uid, info2);
                        }
                        SharedSessionReplicated.send(p_f2.getProperty("id"), "RESPONSE", "", p_f2);
                    }
                });
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_job_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_job_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.JobScheduler.runDistributedJob")) {
            final Properties info = (Properties)p.remove("val");
            if (!info.getProperty("hostname", "NONE").equals(System.getProperty("crushftp.hostname", "unknown"))) {
                Log.log("SERVER", 0, "Skipping job " + info.getProperty("scheduleName") + " on this server as the targetted hostname is:" + info.getProperty("hostname", "NONE"));
            } else {
                Log.log("SERVER", 0, "Running job " + info.getProperty("scheduleName") + " on this server as the targetted hostname matches ours:" + info.getProperty("hostname", "NONE"));
                try {
                    final Properties p_f2 = p;
                    Worker.startWorker(new Runnable(){

                        @Override
                        public void run() {
                            Properties event = (Properties)info.remove("data");
                            Log.log("SERVER", 0, "crushftp.JobScheduler.runJob:" + info.getProperty("use_dmz", "") + ":" + p_f2.getProperty("source_socket", "") + ":" + event.getProperty("scheduleName"));
                            event.put("event_plugin_list", "CrushTask (User Defined)");
                            event.put("name", event.getProperty("scheduleName"));
                            Properties info2 = JobScheduler.doEventPlugin(null, event, null, new Vector(), true, true);
                            long start = System.currentTimeMillis();
                            while (!info2.containsKey("tracker") && System.currentTimeMillis() - start < 86400000L) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            ZipArchiveOutputStream zip = new ZipArchiveOutputStream((OutputStream)baos);
                            Properties tracker = (Properties)info2.get("tracker");
                            if (tracker != null) {
                                try {
                                    ZipArchiveEntry ze = new ZipArchiveEntry(Common.last(tracker.getProperty("log_file")));
                                    if (new File_S(tracker.getProperty("log_file")).exists()) {
                                        zip.putArchiveEntry(ze);
                                        com.crushftp.client.Common.copyStreams(new FileInputStream(tracker.getProperty("log_file")), zip, true, false);
                                        zip.closeArchiveEntry();
                                    }
                                    if (new File_S(tracker.getProperty("history_obj_path")).exists()) {
                                        ze = new ZipArchiveEntry(Common.last(tracker.getProperty("history_obj_path")));
                                        zip.putArchiveEntry(ze);
                                        com.crushftp.client.Common.copyStreams(new FileInputStream(tracker.getProperty("history_obj_path")), zip, true, false);
                                        zip.closeArchiveEntry();
                                    }
                                }
                                catch (Exception e) {
                                    Log.log("SERVER", 0, e);
                                }
                            }
                            try {
                                zip.finish();
                                zip.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            p_f2.put("zip_result", baos.toByteArray());
                            SharedSessionReplicated.send(p_f2.getProperty("id"), "RESPONSE", "", p_f2);
                        }
                    });
                }
                catch (Exception e) {
                    Log.log("SERVER", 0, e);
                }
            }
            ServerStatus.server_info.put("replicated_job_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_job_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").startsWith("crushftp.handlers.")) {
            String id;
            block255: {
                id = p.getProperty("id");
                try {
                    String action = p.getProperty("action");
                    p = (Properties)p.remove("val");
                    Log.log("SERVER", 2, "" + p);
                    if (action.endsWith(".writeGroups")) {
                        Log.log("SERVER", 0, String.valueOf(action) + ":" + p.getProperty("serverGroup"));
                        UserTools.writeGroups(p.getProperty("serverGroup"), (Properties)p.get("groups"), false);
                        break block255;
                    }
                    if (action.endsWith(".writeUser")) {
                        Log.log("SERVER", 0, String.valueOf(action) + ":" + p.getProperty("serverGroup") + ":" + p.getProperty("username") + ":" + p.getProperty("backup", ""));
                        UserTools.writeUser(p.getProperty("serverGroup"), p.getProperty("username"), (Properties)p.get("user"), false, p.getProperty("backup", "").equals("true"));
                        break block255;
                    }
                    if (action.endsWith(".writeInheritance")) {
                        Log.log("SERVER", 0, String.valueOf(action) + ":" + p.getProperty("serverGroup"));
                        UserTools.writeInheritance(p.getProperty("serverGroup"), (Properties)p.get("inheritance"), false);
                        break block255;
                    }
                    if (action.endsWith(".deleteUser")) {
                        Log.log("SERVER", 0, String.valueOf(action) + ":" + p.getProperty("serverGroup") + ":" + p.getProperty("username"));
                        UserTools.deleteUser(p.getProperty("serverGroup"), p.getProperty("username"), false);
                        break block255;
                    }
                    if (action.endsWith(".addFolder")) {
                        Log.log("SERVER", 0, String.valueOf(action) + ":" + p.getProperty("serverGroup") + ":" + p.getProperty("username") + ":" + p.getProperty("path") + ":" + p.getProperty("name"));
                        UserTools.addFolder(p.getProperty("serverGroup"), p.getProperty("username"), p.getProperty("path"), p.getProperty("name"), false);
                        break block255;
                    }
                    if (action.endsWith(".addItem")) {
                        try {
                            Log.log("SERVER", 0, String.valueOf(action) + ":" + p.getProperty("serverGroup") + ":" + p.getProperty("username") + ":" + p.getProperty("path") + ":" + p.getProperty("name") + ":" + new VRL(p.getProperty("url")).safe());
                        }
                        catch (Exception e) {
                            Log.log("SERVER", 1, e);
                        }
                        UserTools.addItem(p.getProperty("serverGroup"), p.getProperty("username"), p.getProperty("path"), p.getProperty("name"), p.getProperty("url"), p.getProperty("type"), (Properties)p.get("moreItems"), p.getProperty("encrypted").equals("true"), p.getProperty("encrypted_class"), false);
                        break block255;
                    }
                    if (action.endsWith(".writeVFS")) {
                        Log.log("SERVER", 0, String.valueOf(action) + ":" + p.getProperty("serverGroup") + ":" + p.getProperty("username"));
                        UserTools.writeVFS(p.getProperty("serverGroup"), p.getProperty("username"), (Properties)p.get("virtual"), false);
                    }
                }
                catch (Exception e) {
                    Log.log("SERVER", 0, e);
                }
            }
            SharedSessionReplicated.send(id, "RESPONSE", "", null);
            ServerStatus.server_info.put("replicated_user_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_user_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.session.update")) {
            try {
                SessionCrush thisSession = (SessionCrush)SharedSession.find("crushftp.sessions").get(p.getProperty("id"));
                if (thisSession != null) {
                    thisSession.put(p.getProperty("key"), p.get("val"), false);
                }
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.server.ServerSessionAjax.doFileAbortBlock")) {
            try {
                final Properties p_f2 = p;
                Worker.startWorker(new Runnable(){

                    @Override
                    public void run() {
                        Properties pp = (Properties)p_f2.get("val");
                        SessionCrush thisSession = (SessionCrush)SharedSession.find("crushftp.sessions").get(pp.remove("CrushAuth"));
                        try {
                            if (thisSession != null) {
                                thisSession.doFileAbortBlock((String)pp.remove("the_command_data"), false);
                            }
                        }
                        catch (Exception e) {
                            Log.log("SERVER", 0, e);
                        }
                    }
                });
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.session.remove_user")) {
            block256: {
                try {
                    SessionCrush thisSession = (SessionCrush)SharedSession.find("crushftp.sessions").remove(p.getProperty("id"), false);
                    if (thisSession != null) {
                        ServerStatus.thisObj.remove_user(thisSession.user_info, true);
                        break block256;
                    }
                    ServerStatus e = ServerStatus.thisObj;
                    synchronized (e) {
                        int loops = 0;
                        while (loops < 30) {
                            try {
                                int x = ServerStatus.siVG("user_list").size() - 1;
                                while (x >= 0) {
                                    Properties user_info = (Properties)ServerStatus.siVG("user_list").elementAt(x);
                                    if (user_info.getProperty("CrushAuth", "").equals(p.getProperty("id"))) {
                                        ServerStatus.thisObj.remove_user(user_info);
                                    }
                                    --x;
                                }
                                break;
                            }
                            catch (Exception exception) {
                                Thread.sleep(100L);
                                ++loops;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Log.log("SERVER", 0, e);
                }
            }
            ServerStatus.server_info.put("replicated_user_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_user_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.share.create")) {
            try {
                String action = p.getProperty("action");
                Properties pp = (Properties)p.remove("val");
                Log.log("SERVER", 2, "" + p);
                new File_U(String.valueOf(pp.getProperty("userHome")) + "VFS/").mkdirs();
                new File_U(pp.getProperty("userStorage")).mkdirs();
                Common.writeXMLObject_U_Safe(String.valueOf(pp.getProperty("userHome")) + "VFS.XML", pp.get("permissions"), "VFS");
                Common.writeXMLObject_U_Safe(String.valueOf(pp.getProperty("userHome")) + "INFO.XML", pp.get("request"), "INFO");
                Common.writeXMLObject_U_Safe(String.valueOf(pp.getProperty("userHome")) + "VFS/" + pp.getProperty("itemName") + pp.getProperty("uid"), pp.get("v"), "VFS");
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_user_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_user_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.share.removeTempAccount")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.removeTempAccount((Properties)pp.remove("request"), (String)pp.remove("site"), false);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_share_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_share_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.share.removeTempAccountFile")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.removeTempAccountFile((Properties)pp.remove("request"), (String)pp.remove("site"), false);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_share_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_share_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.share.addTempAccount")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.addTempAccount((Properties)pp.remove("request"), (String)pp.remove("site"), false);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_share_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_share_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.share.addTempAccountFile")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.addTempAccountFile((Properties)pp.remove("request"), (String)pp.remove("site"), false);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_share_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_share_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.delete.share")) {
            try {
                Properties pp = (Properties)p.get("val");
                ServerSessionAJAX.deleteShare((Properties)pp.remove("request"), (String)pp.remove("userGroup"), (String)pp.remove("username"));
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_share_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_share_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.edit.share")) {
            try {
                Properties pp = (Properties)p.get("val");
                ServerSessionAJAX.editShare((Properties)pp.remove("request"), (String)pp.remove("username"), (Vector)pp.remove("web_customizations"));
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_share_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_share_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.pgp.savePGPKeystore")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.savePGPKeystore((KeyStore)pp.remove("keystore"), false, pp.getProperty("pgp_password"), pp.getProperty("deleted", "false").equals("true"));
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            ServerStatus.server_info.put("replicated_pgp_changes_count", String.valueOf(Integer.parseInt(ServerStatus.server_info.getProperty("replicated_pgp_changes_count", "0")) + 1));
        } else if (p.getProperty("action", "").equals("crushftp.jks.update")) {
            try {
                Properties pp = (Properties)p.get("val");
                byte[] jks_bytes = (byte[])pp.get("jks_bytes");
                if (new VRL(pp.getProperty("keystore_path", "")).getProtocol().toUpperCase().equals("FILE") && !new File_S(pp.getProperty("keystore_path", "")).exists()) {
                    RandomAccessFile out = new RandomAccessFile(new File_S(pp.getProperty("keystore_path", "")), "rw");
                    out.setLength(0L);
                    out.write(jks_bytes);
                    out.close();
                }
                if (com.crushftp.client.Common.System2.containsKey("crushftp.keystores." + pp.getProperty("keystore_path", "").replace('\\', '/'))) {
                    Properties jks = (Properties)com.crushftp.client.Common.System2.get("crushftp.keystores." + pp.getProperty("keystore_path", "").replace('\\', '/'));
                    jks.put("bytes", jks_bytes);
                }
                if (!pp.getProperty("instance", "").equals("")) {
                    try {
                        DMZServerCommon.sendFileToMemory(pp.getProperty("keystore_path", ""), pp.getProperty("instance", ""));
                    }
                    catch (Exception e) {
                        Log.log("SERVER", 1, e);
                    }
                }
                Properties request = new Properties();
                request.put("instance", pp.getProperty("instance", ""));
                AdminControls.restartAllHttpsPorts(request);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.saveHttpChallengeToken")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.saveHttpChallengeToken((Properties)pp.get("request"));
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.updateRefreshToken")) {
            try {
                Properties pp = (Properties)p.get("val");
                TaskBridge.updateRefreshToken(pp.getProperty("token_key"), pp.getProperty("token_val"), "false");
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.putTLSALPNChallengeJKS")) {
            try {
                Properties pp = (Properties)p.get("val");
                Properties le_tls_challange_server_item = AdminControls.putTLSALPNChallengeJKS((Properties)pp.get("request"));
                ServerStatus.server_info.put("le_tls_challange_server_item", le_tls_challange_server_item);
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.removeTLSALPNChallengeJKS")) {
            try {
                Properties pp = (Properties)p.get("val");
                Properties request = (Properties)pp.get("request");
                if (ServerStatus.server_info.containsKey("le_tls_challange_server_item")) {
                    request.put("server_item_original", ServerStatus.server_info.get("le_tls_challange_server_item"));
                    AdminControls.removeTLSALPNChallengeJKS(request);
                } else {
                    Log.log("SERVER", 0, "Error: LetsEncrypt: Replication: Missing original server settings! Remove tls alpn server settings failed.");
                }
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else if (p.getProperty("action", "").equals("crushftp.AdminControls.resetHttpRedrirect")) {
            try {
                Properties pp = (Properties)p.get("val");
                AdminControls.resetHttpRedrirect((Properties)pp.get("request"));
                SharedSessionReplicated.send(p.getProperty("id"), "RESPONSE", "", null);
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
        } else {
            SharedSession ss = SharedSession.find(p.getProperty("id"));
            if (p.getProperty("action").equals("put")) {
                ss.put(p.get("key"), p.get("val"), false);
            } else if (p.getProperty("action").equals("remove")) {
                ss.remove(p.get("key"), false);
            } else if (p.getProperty("action").equals("anyPassToken")) {
                UserTools.addAnyPassToken(p.getProperty("val"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(String id1, String action, Object key, Object val) {
        if (!enterprise_enabled || remote_host_ports.size() == 0 || ServerStatus.shutting_down) {
            return;
        }
        try {
            Properties p = new Properties();
            p.put("action", action);
            p.put("id", id1);
            p.put("key", key);
            if (val != null) {
                p.put("val", val);
            }
            Log.log("SERVER", 2, "SHAREDSESSION:" + id1 + ":" + action + ":" + key);
            p.put("time", String.valueOf(System.currentTimeMillis()));
            byte[] b = null;
            Object object = SharedSession.sessionLockClone;
            synchronized (object) {
                b = com.crushftp.client.Common.CLONE1(p);
            }
            Properties p2 = (Properties)com.crushftp.client.Common.CLONE2(b);
            p2.put("size", String.valueOf(b.length));
            Vector remote_host_ports2 = (Vector)remote_host_ports.clone();
            String allowed_hosts = "";
            try {
                Properties request;
                if (val != null && val instanceof Properties && (request = (Properties)((Properties)val).get("request")) != null) {
                    String[] ui_save_preferences = request.getProperty("ui_save_preferences", "").split(";");
                    String ui_save_preferences_item = request.getProperty("ui_save_preferences_item", "");
                    if (!request.containsKey("ui_save_preferences")) {
                        ui_save_preferences = new String[]{request.getProperty("ui_save_preferences_item", "")};
                        ui_save_preferences_item = ui_save_preferences_item.split("=")[0];
                    }
                    int x = 0;
                    while (x < ui_save_preferences.length) {
                        if (!ui_save_preferences[x].equals("")) {
                            String ui_item = ui_save_preferences[x].split("=")[0].trim();
                            if (ui_item.endsWith(":")) {
                                ui_item = ui_item.substring(0, ui_item.length() - 1);
                            }
                            if (ui_item.equals(ui_save_preferences_item)) {
                                allowed_hosts = "," + ui_save_preferences[x].split("=")[1].trim() + ",";
                            }
                        }
                        ++x;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.log("SERVER", 0, e);
            }
            int xx = 0;
            while (xx < remote_host_ports2.size()) {
                String id2 = id1;
                String remote_host_port = remote_host_ports2.elementAt(xx).toString();
                String remote_host = remote_host_port.split(":")[0].trim();
                String remote_host_only = "";
                if (id2.indexOf(":") >= 0 && !action.equals("RESPONSE")) {
                    remote_host_only = id2.split(":")[1].trim();
                }
                if (remote_host_only.equals("") || remote_host.equals(remote_host_only)) {
                    if (id2.indexOf(":") < 0) {
                        id2 = String.valueOf(id2) + ":" + remote_host;
                    }
                    p2.put("id", id2);
                    if (allowed_hosts.equals("") || allowed_hosts.indexOf("," + remote_host + ",") >= 0) {
                        Vector vector;
                        if (action.startsWith("crushftp.AdminControls.setServerItem")) {
                            if (ServerStatus.BG("replicate_preferences")) {
                                p2.put("need_response", "true");
                                vector = pending_pref_sync;
                                synchronized (vector) {
                                    pending_pref_sync.addElement(p2.clone());
                                    SharedSessionReplicated.flushPendingPrefSync();
                                    ServerStatus.server_info.put("replicated_servers_pending_pref_sync", String.valueOf(pending_pref_sync.size()));
                                }
                            }
                        } else if (action.startsWith("crushftp.handlers.")) {
                            if (ServerStatus.BG("replicate_users")) {
                                p2.put("need_response", "true");
                                vector = pending_user_sync;
                                synchronized (vector) {
                                    pending_user_sync.addElement(p2.clone());
                                    SharedSessionReplicated.flushPendingUserSync();
                                    ServerStatus.server_info.put("replicated_servers_pending_user_sync", String.valueOf(pending_user_sync.size()));
                                }
                            }
                        } else if (action.equals("crushftp.AdminControls.renameJob") || action.equals("crushftp.AdminControls.removeJob") || action.equals("crushftp.AdminControls.addJob")) {
                            if (ServerStatus.BG("replicate_jobs")) {
                                p2.put("need_response", "true");
                                vector = pending_job_sync;
                                synchronized (vector) {
                                    pending_job_sync.addElement(p2.clone());
                                    SharedSessionReplicated.flushPendingJobSync();
                                    ServerStatus.server_info.put("replicated_servers_pending_job_sync", String.valueOf(pending_job_sync.size()));
                                }
                            }
                        } else if (action.startsWith("crushftp.share.")) {
                            if (ServerStatus.BG("replicate_shares")) {
                                p2.put("need_response", "true");
                                vector = pending_share_sync;
                                synchronized (vector) {
                                    pending_share_sync.addElement(p2.clone());
                                    SharedSessionReplicated.flushPendingShareSync();
                                    ServerStatus.server_info.put("replicated_servers_pending_share_sync", String.valueOf(pending_share_sync.size()));
                                }
                            }
                        } else {
                            Properties val2;
                            if (val != null && val instanceof Properties && ((val2 = (Properties)val).getProperty("need_response", "").equals("true") || p2.getProperty("need_response", "").equals("true"))) {
                                val2.put("time", String.valueOf(System.currentTimeMillis()));
                                pendingResponses.put(p2.getProperty("id"), val2);
                                ServerStatus.server_info.put("replicated_servers_pendingResponses", String.valueOf(pendingResponses.size()));
                            }
                            Vector send_queue = (Vector)send_queues.get(remote_host_port);
                            p2.put("queued", String.valueOf(System.currentTimeMillis()));
                            send_queue.addElement(p2.clone());
                            ServerStatus.server_info.put("replicated_servers_queue_" + xx, String.valueOf(send_queue.size()));
                        }
                    }
                }
                ++xx;
            }
            if (sync_delay > 3000L && System.currentTimeMillis() - lastActive < 10000L) {
                SharedSessionReplicated.flushNow();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.log("SERVER", 0, e);
        }
    }

    public static Vector runOnDmz(Properties job_tmp, String use_dmz, Vector tempItems, Vector log) throws Exception {
        String id = Common.makeBoundary(11);
        Log.log("SERVER", 0, "crushftp.JobScheduler.runJob:dmz_name=" + use_dmz + ":RUN:JOB:" + id);
        Properties request = new Properties();
        request.put("data", job_tmp);
        request.put("items", tempItems);
        DMZServerCommon.sendCommand(use_dmz, request, "RUN:JOB", id);
        Properties p = DMZServerCommon.getResponse(id, 600);
        String log_str = "" + p.remove("log");
        BufferedReader br = new BufferedReader(new StringReader(log_str));
        String data = "";
        while ((data = br.readLine()) != null) {
            log.addElement(String.valueOf(use_dmz) + ":" + data);
        }
        Properties result_info = (Properties)p.get("data");
        tempItems = (Vector)result_info.remove("newItems");
        Log.log("SERVER", 0, "crushftp.JobScheduler.runJob:dmz_name=" + use_dmz + ":RUN:JOB:" + id + ":complete");
        if (result_info.containsKey("errors")) {
            throw new Exception("" + result_info.get("errors"));
        }
        return tempItems;
    }

    public static void flushPendingPrefSync() {
        if (!enterprise_enabled) {
            return;
        }
        try {
            if (pending_pref_sync.size() == 0) {
                new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_pref_sync.xml").delete();
            } else if (ServerStatus.BG("replicate_preferences")) {
                Common.writeXMLObject(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_pref_sync.xml", (Object)pending_pref_sync, "pending_pref_sync");
            }
        }
        catch (Exception e) {
            Log.log("SERVER", 0, e);
        }
    }

    public static void flushPendingUserSync() {
        if (!enterprise_enabled) {
            return;
        }
        try {
            if (pending_user_sync.size() == 0) {
                new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_user_sync.xml").delete();
            } else if (ServerStatus.BG("replicate_users")) {
                Common.writeXMLObject(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_user_sync.xml", (Object)pending_user_sync, "pending_user_sync");
            }
        }
        catch (Exception e) {
            Log.log("SERVER", 0, e);
        }
    }

    public static void flushPendingJobSync() {
        if (!enterprise_enabled) {
            return;
        }
        try {
            if (pending_job_sync.size() == 0) {
                new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_job_sync.xml").delete();
            } else if (ServerStatus.BG("replicate_jobs")) {
                Common.writeXMLObject(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_job_sync.xml", (Object)pending_job_sync, "pending_job_sync");
            }
        }
        catch (Exception e) {
            Log.log("SERVER", 0, e);
        }
    }

    public static void flushPendingShareSync() {
        if (!enterprise_enabled) {
            return;
        }
        try {
            if (pending_share_sync.size() == 0) {
                new File_S(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_share_sync.xml").delete();
            } else if (ServerStatus.BG("replicate_shares")) {
                Common.writeXMLObject(String.valueOf(System.getProperty("crushftp.prefs")) + "cluster_share_sync.xml", (Object)pending_share_sync, "pending_share_sync");
            }
        }
        catch (Exception e) {
            Log.log("SERVER", 0, e);
        }
    }
}

