/*
 * Decompiled with CFR 0.152.
 */
package crushftp.handlers;

import com.crushftp.client.File_U;
import com.crushftp.client.GenericClient;
import com.crushftp.client.VRL;
import crushftp.handlers.Common;
import crushftp.handlers.Log;
import crushftp.handlers.UserTools;
import crushftp.server.AdminControls;
import crushftp.server.ServerStatus;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class PluginTools {
    public static boolean checkPortAndUserGroupOnLoginAction(Properties settings, Properties info) {
        if (info.getProperty("action", "").equals("login")) {
            Properties user_info = (Properties)info.get("user_info");
            if (user_info == null) {
                user_info = new Properties();
            }
            boolean found = false;
            String[] server_items = settings.getProperty("server_item", "All").trim().split(",");
            int x = 0;
            while (x < server_items.length) {
                String s = server_items[x];
                if (s.trim().equalsIgnoreCase("All") || s.trim().length() == 0 || (String.valueOf(user_info.getProperty("bind_ip_config", "")) + "_" + user_info.getProperty("bind_port", "")).equals(s.trim())) {
                    found = true;
                }
                ++x;
            }
            server_items = settings.getProperty("user_connection_groups", "All").trim().split(",");
            boolean found2 = false;
            int x2 = 0;
            while (x2 < server_items.length) {
                String s = server_items[x2];
                if (s.trim().equalsIgnoreCase("All") || s.trim().length() == 0 || info.getProperty("ServerGroup", "").equals(s.trim())) {
                    found2 = true;
                }
                ++x2;
            }
            if (found && found2) {
                return true;
            }
        }
        return false;
    }

    public static void makeFolder(String path, Properties con_settings, Properties clientCache) {
        if (new VRL(path).getProtocol().toUpperCase().equals("FILE")) {
            Log.log("SERVER", 2, "Making folder at local URL:" + new VRL(path).safe());
            Properties request = new Properties();
            request.put("name", new File_U(new VRL(path).getPath()).getName());
            request.put("path", com.crushftp.client.Common.all_but_last(new VRL(path).getPath()));
            AdminControls.newFolder(request, "(CONNECT)", true);
        } else {
            VRL folder_vrl = new VRL(path);
            Log.log("SERVER", 2, "Making folder at URL:" + folder_vrl.safe());
            GenericClient c_folder = null;
            if (!clientCache.containsKey(com.crushftp.client.Common.getBaseUrl(path))) {
                c_folder = com.crushftp.client.Common.getClient(com.crushftp.client.Common.getBaseUrl(folder_vrl.toString()), "CrushFTP", new Vector());
                if (folder_vrl.getConfig().size() > 0) {
                    c_folder.setConfigObj(folder_vrl.getConfig());
                } else {
                    c_folder.setConfigObj((Properties)com.crushftp.client.Common.CLONE(con_settings));
                }
                try {
                    c_folder.login(folder_vrl.getUsername(), folder_vrl.getPassword(), "");
                }
                catch (Exception e) {
                    Log.log("SERVER", 1, e);
                }
                clientCache.put(com.crushftp.client.Common.getBaseUrl(path), c_folder);
            } else {
                c_folder = (GenericClient)clientCache.get(com.crushftp.client.Common.getBaseUrl(path));
            }
            try {
                c_folder.makedirs(folder_vrl.getPath());
            }
            catch (Exception e) {
                Log.log("SERVER", 1, e);
            }
        }
    }

    public static boolean home_exists(String path, Properties con_settings, Properties clientCache) {
        GenericClient c_folder;
        VRL folder_vrl;
        block10: {
            if (new VRL(path).getProtocol().toUpperCase().equals("FILE")) {
                return new File_U(new VRL(path).getPath()).exists();
            }
            folder_vrl = new VRL(path);
            Log.log("SERVER", 2, "Check folder at URL:" + folder_vrl.safe());
            c_folder = null;
            if (!clientCache.containsKey(com.crushftp.client.Common.getBaseUrl(path))) {
                c_folder = com.crushftp.client.Common.getClient(com.crushftp.client.Common.getBaseUrl(folder_vrl.toString()), "CrushFTP", new Vector());
                if (folder_vrl.getConfig().size() > 0) {
                    c_folder.setConfigObj(folder_vrl.getConfig());
                } else {
                    c_folder.setConfigObj((Properties)com.crushftp.client.Common.CLONE(con_settings));
                }
                try {
                    c_folder.login(folder_vrl.getUsername(), folder_vrl.getPassword(), "");
                }
                catch (Exception e) {
                    Log.log("SERVER", 1, e);
                    return false;
                }
                clientCache.put(com.crushftp.client.Common.getBaseUrl(path), c_folder);
            } else {
                c_folder = (GenericClient)clientCache.get(com.crushftp.client.Common.getBaseUrl(path));
            }
            try {
                if (folder_vrl.getPath().equals("/")) break block10;
                Properties p = c_folder.stat(folder_vrl.getPath());
                return p != null;
            }
            catch (Exception e) {
                Log.log("SERVER", 1, e);
                return false;
            }
        }
        c_folder.list(folder_vrl.getPath(), new Vector());
        return true;
    }

    public static boolean isEnterprise() {
        try {
            Common common_code = new Common();
            String name = ServerStatus.SG("registration_name");
            String email = ServerStatus.SG("registration_email");
            String code = ServerStatus.SG("registration_code");
            common_code.register(name, email, code);
            int enterpriseLevel = Integer.parseInt(common_code.getRegistrationAccess("E", ServerStatus.SG("registration_code")));
            if (enterpriseLevel <= 0) {
                throw new Exception("Not enterprise:" + enterpriseLevel);
            }
            return true;
        }
        catch (Exception e) {
            Log.log("SERVER", 1, e);
            return false;
        }
    }

    public static boolean check_username(String[] filters, String username) throws Exception {
        int x = 0;
        while (x < filters.length) {
            String filter = filters[x];
            if (!filter.equals("") && com.crushftp.client.Common.do_search(filter, username, false, 0)) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public static boolean roleCheck(String roles, Properties idp_user_info, Vector linked_vfs, Vector log) throws Exception {
        if (!roles.equals("")) {
            BufferedReader br = new BufferedReader(new StringReader(roles));
            String role = "";
            boolean role_match = false;
            while ((role = br.readLine()) != null) {
                log.add("Search role: " + role);
                boolean found = false;
                String temp_username = "default";
                try {
                    if (role.contains(" : ") && role.split(" : ").length == 2) {
                        temp_username = role.split(" : ")[1];
                    }
                }
                catch (Exception e) {
                    log.add(" Search role: Role: " + role + " Error on parsing template user. " + e);
                }
                if ((role = role.split(" : ")[0]).endsWith(",")) {
                    role = role.substring(0, role.length() - 1);
                }
                if (role.contains(",")) {
                    String[] elements = role.split(",");
                    int x = 0;
                    while (x < elements.length) {
                        found = PluginTools.checkElement(elements[x], idp_user_info, log);
                        if (found) {
                            ++x;
                            continue;
                        }
                        break;
                    }
                } else {
                    found = PluginTools.checkElement(role, idp_user_info, log);
                }
                if (!found) continue;
                if (!temp_username.equals("default")) {
                    linked_vfs.add(temp_username);
                }
                role_match = true;
            }
            br.close();
            return role_match;
        }
        return false;
    }

    public static boolean checkElement(String element, Properties idp_user_info, Vector log) {
        if (element.contains("=") && element.split("=").length == 2) {
            String key = element.split("=")[0].trim();
            String value = element.split("=")[1].trim();
            if (idp_user_info.containsKey(key)) {
                String idp_value = idp_user_info.getProperty(key, "");
                idp_value = com.crushftp.client.Common.replace_str(idp_value, "{", "");
                idp_value = com.crushftp.client.Common.replace_str(idp_value, "}", "");
                idp_value = com.crushftp.client.Common.replace_str(idp_value, "(", "");
                idp_value = com.crushftp.client.Common.replace_str(idp_value, ")", "");
                idp_value = com.crushftp.client.Common.replace_str(idp_value, "[", "");
                idp_value = com.crushftp.client.Common.replace_str(idp_value, "]", "");
                idp_value = com.crushftp.client.Common.replace_str(idp_value, "\"", "");
                if (!value.startsWith("REGEX:") && value.indexOf("*") < 0 && value.indexOf("?") < 0) {
                    if (idp_value.contains(",")) {
                        String[] s = idp_value.split(",");
                        int x = 0;
                        while (x < s.length) {
                            if (s[x].equals(value)) {
                                log.add("Element matched. Key: " + key + " Value: " + idp_value + " Filter : " + value);
                                return true;
                            }
                            ++x;
                        }
                    } else if (idp_value.equals(value)) {
                        log.add("Element matched. Key: " + key + " Value: " + idp_value + " Filter : " + value);
                        return true;
                    }
                } else if (com.crushftp.client.Common.do_search(value, idp_value, false, 0)) {
                    log.add("Element matched. Key: " + key + " Value: " + idp_value + " Filter : " + value);
                    return true;
                }
            } else {
                log.add("Element matched. Key: " + key + " Value: " + " Filter : " + value);
            }
        } else {
            log.add("Invalid role format! Role : " + element);
        }
        return false;
    }

    public static void loadTemplateUser(String username, Properties user, Properties info, Vector linked_vfs, Vector log) {
        try {
            Properties server_item = (Properties)info.get("server_item");
            String listen_ip_port = server_item.getProperty("linkedServer");
            log.add("Searching for template user in user group: " + listen_ip_port);
            log.add("Load template user : " + username);
            Properties p = null;
            try {
                p = UserTools.ut.getUser(listen_ip_port, username, false, false);
            }
            catch (Exception e) {
                log.add(e.toString());
            }
            if (p != null) {
                Enumeration<Object> keys = p.keys();
                log.add("Template user's settings:" + p.size());
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement().toString();
                    if (key.equalsIgnoreCase("username") || key.equalsIgnoreCase("user_name") || key.equalsIgnoreCase("password")) continue;
                    try {
                        user.put(key, p.get(key));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (user.getProperty("max_logins", "0").equals("-1")) {
                    user.put("max_logins", "0");
                }
            } else {
                log.add("Template user not found.");
            }
        }
        catch (Exception e) {
            log.add(e.toString());
        }
        user.put("virtualUser", "true");
        if (linked_vfs != null && linked_vfs.size() > 0) {
            info.put("linked_vfs", linked_vfs);
        }
    }

    public static void load_user_home(Properties settings, Vector vfsItems, Properties privs, String username, Properties user, Vector log) throws Exception {
        Properties con_settings;
        Properties dir_item;
        String unique_name;
        String homeDirField = settings.getProperty("UserHome", "");
        if (settings.getProperty("useLocalDirectory", "true").equalsIgnoreCase("false") || homeDirField.equals("")) {
            return;
        }
        homeDirField = PluginTools.replace_vars(homeDirField, username, user, log);
        Properties user_home_config = (Properties)settings.get("user_home_config");
        Enumeration<Object> keys = user_home_config.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String value = user_home_config.getProperty(key, "");
            if (value.equals("") || !value.contains("{") || !value.contains("}")) continue;
            user_home_config.put(key, PluginTools.replace_vars(value, username, user, log));
        }
        Properties clientCache = new Properties();
        if (settings.getProperty("createFolder", "true").equals("true") && !PluginTools.home_exists(homeDirField, user_home_config, clientCache)) {
            PluginTools.makeFolder(homeDirField, user_home_config, clientCache);
        }
        if (settings.getProperty("appendUsername", "true").equals("true")) {
            homeDirField = String.valueOf(homeDirField) + username + "/";
            if (settings.getProperty("createFolder", "true").equals("true") && !PluginTools.home_exists(homeDirField, user_home_config, clientCache)) {
                PluginTools.makeFolder(homeDirField, user_home_config, clientCache);
            }
        }
        if (PluginTools.home_exists(homeDirField, user_home_config, clientCache)) {
            unique_name = new VRL(homeDirField).getName();
            if (unique_name.equals("")) {
                unique_name = "root";
            }
            String buildPrivs = PluginTools.replace_vars(settings.getProperty("privs", ""), username, user, log);
            privs.put("/" + unique_name.toUpperCase() + "/", buildPrivs);
            dir_item = new Properties();
            String url = new VRL(homeDirField).toString();
            if (!url.endsWith("/")) {
                url = String.valueOf(url) + "/";
            }
            url = !new VRL(homeDirField).getProtocol().toUpperCase().equals("FILE") ? new VRL(homeDirField).getOriginalUrl() : VRL.fileFix(url);
            dir_item.put("url", url);
            dir_item.put("type", "dir");
            con_settings = user_home_config;
            if (con_settings.containsKey("logged_out")) {
                con_settings.remove("logged_out");
            }
        } else {
            throw new Exception("Error : The specified user home location is invalid.");
        }
        dir_item.putAll((Map<?, ?>)con_settings);
        Vector<Properties> v = new Vector<Properties>();
        v.addElement(dir_item);
        Properties p = new Properties();
        p.put("dir", "/");
        p.put("name", unique_name);
        p.put("data", v);
        vfsItems.addElement(p);
        log.add("Added home folder : " + new VRL(homeDirField).safe());
    }

    public static String replace_vars(String s, String username, Properties info, Vector log) throws Exception {
        s = com.crushftp.client.Common.replace_str(s, "{user_name}", username);
        s = com.crushftp.client.Common.replace_str(s, "{user}", username);
        s = com.crushftp.client.Common.replace_str(s, "{username}", username);
        s = com.crushftp.client.Common.replace_str(s, "{username_encoded}", com.crushftp.client.Common.url_encode(username));
        if (info != null) {
            Enumeration<Object> keys = info.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                String val = "";
                if (info.get(key) instanceof Vector) {
                    Vector v = (Vector)info.get(key);
                    int x = 0;
                    while (x < v.size()) {
                        if (x > 0) {
                            val = String.valueOf(val) + ",";
                        }
                        val = String.valueOf(val) + v.elementAt(x).toString().trim();
                        ++x;
                    }
                } else {
                    val = info.getProperty(key);
                }
                if (val == null) continue;
                s = com.crushftp.client.Common.replace_str(s, "{user_" + key + "}", val);
                s = com.crushftp.client.Common.replace_str(s, "{" + key + "}", val);
            }
        }
        try {
            s = com.crushftp.client.Common.textFunctions(s, "{", "}");
        }
        catch (Exception e) {
            log.add(e.toString());
        }
        return s;
    }
}

