/*
 * Decompiled with CFR 0.152.
 */
package crushftp.handlers;

import com.crushftp.client.File_S;
import com.crushftp.client.Worker;
import com.crushftp.job.JobBroker;
import com.crushftp.job.JobFilesHandler;
import crushftp.gui.LOC;
import crushftp.handlers.AlertTools;
import crushftp.handlers.Common;
import crushftp.handlers.Log;
import crushftp.handlers.SessionCrush;
import crushftp.handlers.SharedSessionReplicated;
import crushftp.server.ServerStatus;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class JobScheduler {
    static long lastOldCheck = 0L;
    static final long day = 86400000L;
    public static transient Object job_sheduler_sync = new Object();
    public static Vector runningSchedules = new Vector();
    public static Properties eventPluginCache = new Properties();
    static boolean scanning_cache = false;

    public static void startScheduler() {
        if (System.getProperties().containsKey("crushftp.update.jobs_cache.jobs_summary_cache")) {
            JobFilesHandler.jobs_summary_cache = (Properties)System.getProperties().remove("crushftp.update.jobs_cache.jobs_summary_cache");
        }
        if (System.getProperties().containsKey("crushftp.update.jobs_cache.jobs_summary_cache_size")) {
            JobFilesHandler.jobs_summary_cache_size = (String)System.getProperties().remove("crushftp.update.jobs_cache.jobs_summary_cache_size");
        }
        try {
            Worker.startWorker(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName("JobScheduler");
                    String last_m = "";
                    while (!ServerStatus.shutting_down) {
                        try {
                            SimpleDateFormat mm = new SimpleDateFormat("mm");
                            String current_m = mm.format(new Date());
                            if (!last_m.equals(current_m)) {
                                last_m = current_m;
                                Thread.sleep(3000L);
                                Worker.startWorker(new Runnable(){

                                    @Override
                                    public void run() {
                                        JobScheduler.runSchedules(new Properties());
                                    }
                                }, "Scanning for jobs that need to be run...(every minute) " + new Date());
                            }
                        }
                        catch (Exception e) {
                            System.out.println("" + new Date());
                            e.printStackTrace();
                            Log.log("SERVER", 0, e);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Vector getJobList(boolean include_events) {
        return JobScheduler.getJobList(include_events, String.valueOf(System.getProperty("crushftp.jobs_location")) + "jobs/");
    }

    public static Vector getJobList(boolean include_events, String base_path) {
        Vector jobs = new Vector();
        String[] list = new File_S(base_path).list();
        JobScheduler.addJobs(base_path, list, jobs, include_events);
        return jobs;
    }

    public static void addJobs(String path, String[] list, Vector jobs, boolean include_events) {
        if (list != null) {
            Arrays.sort(list);
        }
        int x = 0;
        while (list != null && x < list.length) {
            File_S f = new File_S(String.valueOf(path) + list[x]);
            if (!(f.isFile() || !include_events && f.getName().startsWith("__"))) {
                if (!new File_S(String.valueOf(f.getPath()) + "/job.XML").exists()) {
                    String[] sub_list = f.list();
                    JobScheduler.addJobs(String.valueOf(path) + f.getName() + "/", sub_list, jobs, include_events);
                }
                jobs.addElement(f);
            }
            ++x;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void runSchedules(Properties pp) {
        if (!ServerStatus.BG("job_scheduler_enabled")) {
            return;
        }
        if (ServerStatus.siBG("update_when_idle")) {
            return;
        }
        if (ServerStatus.siBG("restart_when_idle")) {
            return;
        }
        if (ServerStatus.siBG("shutdown_when_idle")) {
            return;
        }
        if (!ServerStatus.siBG("allow_logins")) {
            return;
        }
        if (System.getProperty("crushftp.singleuser", "false").equals("true")) {
            return;
        }
        if (new File("./jobs_blocked").exists()) {
            return;
        }
        if (new File("./jobs_BLOCKED").exists()) {
            return;
        }
        day_lookup = new Properties();
        day_lookup.put("SUN", "(1)");
        day_lookup.put("MON", "(2)");
        day_lookup.put("TUE", "(3)");
        day_lookup.put("WED", "(4)");
        day_lookup.put("THU", "(5)");
        day_lookup.put("FRI", "(6)");
        day_lookup.put("SAT", "(7)");
        NOW_DATE = new Date();
        running_jobs_threads = new Vector<File_S>();
        jobs = JobScheduler.getJobList(false);
        if (System.getProperty("serverbeat.current_master", "true").equals("false")) {
            if (ServerStatus.BG("single_job_scheduler_serverbeat")) {
                return;
            }
        }
        Log.log("JOB_SCHEDULER", 0, "Got jobs list (" + jobs.size() + " items), scanning through run times using " + ServerStatus.IG("job_start_threads") + " threads...");
        x = 0;
        ** GOTO lbl66
        {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException var6_7) {
                // empty catch block
            }
            do {
                if (running_jobs_threads.size() > ServerStatus.IG("job_start_threads") && !ServerStatus.shutting_down) continue block6;
                if (ServerStatus.shutting_down) {
                    return;
                }
                job = (File_S)jobs.elementAt(x);
                if (!job.getName().startsWith("_")) {
                    running_jobs_threads.add(job);
                    try {
                        Worker.startWorker(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            @Override
                            public void run() {
                                block82: {
                                    block84: {
                                        block83: {
                                            time = new SimpleDateFormat("hh:mm aa", Locale.US);
                                            runSchedule = false;
                                            p = null;
                                            yyMMddHHmm = new SimpleDateFormat("yyMMddHHmm z", Locale.US);
                                            yyMMdd = new SimpleDateFormat("yyMMdd", Locale.US);
                                            c = new GregorianCalendar();
                                            lock = null;
                                            var8_9 = JobFilesHandler.log_writing_lock_retriever;
                                            synchronized (var8_9) {
                                                lock = JobFilesHandler.job_writing_lock.get(String.valueOf(job.getPath()) + "/job.XML");
                                                if (lock == null) {
                                                    lock = new Object();
                                                    JobFilesHandler.job_writing_lock.put(String.valueOf(job.getPath()) + "/job.XML", lock);
                                                }
                                            }
                                            var8_9 = lock;
                                            synchronized (var8_9) {
                                                p = (Properties)JobFilesHandler.readXMLObject(String.valueOf(job.getPath()) + "/job.XML");
                                            }
                                            if (p == null) break block82;
                                            Log.log("JOB_SCHEDULER", 0, "Checking time on job:" + job.getName());
                                            p.put("scheduleName", JobScheduler.jobName(job));
                                            enabled = p.getProperty("enabled", "");
                                            if (!enabled.equalsIgnoreCase("true") && !enabled.equalsIgnoreCase("false")) {
                                                enabled = ServerStatus.change_vars_to_values_static(enabled, null, null, null);
                                            }
                                            if (enabled.trim().equalsIgnoreCase("true")) break block83;
                                            running_jobs_threads.remove(job);
                                            return;
                                        }
                                        lastRun = 0L;
                                        try {
                                            lastRun = Long.parseLong(p.getProperty("lastRun", "0"));
                                        }
                                        catch (Exception var11_11) {
                                            // empty catch block
                                        }
                                        if (lastRun == 0L || NOW_DATE.getTime() <= lastRun) break block84;
                                        p.put("enabled", "false");
                                        if (JobFilesHandler.writeXMLObject(String.valueOf(job.getPath()) + "/job.XML", (Properties)com.crushftp.client.Common.CLONE2(com.crushftp.client.Common.CLONE1(p)), "job")) {
                                            // empty if block
                                        }
                                        Log.log("JOB_SCHEDULER", 0, "Skipping job because lastRun time is in the past now:" + job.getName());
                                        running_jobs_threads.remove(job);
                                        return;
                                    }
                                    try {
                                        block86: {
                                            block85: {
                                                nextRun = Long.parseLong(p.getProperty("nextRun", "0"));
                                                if (nextRun > NOW_DATE.getTime()) {
                                                    Log.log("JOB_SCHEDULER", 0, "Next run of the job: " + job.getName() + ": " + new Date(nextRun));
                                                }
                                                c.setTimeInMillis(yyMMddHHmm.parse(yyMMddHHmm.format(NOW_DATE)).getTime());
                                                if (p.getProperty("scheduleTime", "").trim().startsWith(",")) {
                                                    p.put("scheduleTime", p.getProperty("scheduleTime", "").trim().substring(1));
                                                }
                                                if (p.getProperty("scheduleTime", "").trim().endsWith(",")) {
                                                    p.put("scheduleTime", p.getProperty("scheduleTime", "").trim().substring(p.getProperty("scheduleTime", "").trim().length() - 1));
                                                }
                                                if (!p.getProperty("scheduleType", "").equals("minutely") || NOW_DATE.getTime() <= nextRun) break block85;
                                                Log.log("JOB_SCHEDULER", 0, "Calculating next run of job: " + job.getName());
                                                Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Minutely: " + "Scheduled time minutely amount: " + p.getProperty("minutelyAmount", ""));
                                                Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Minutely: Before the calculation: " + ":" + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                minutes = Integer.parseInt(p.getProperty("minutelyAmount"));
                                                if (minutes == 0) {
                                                    minutes = 1;
                                                }
                                                if (minutes > 0) {
                                                    c.add(12, minutes);
                                                } else {
                                                    c.add(13, minutes * -1);
                                                }
                                                runSchedule = true;
                                                Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Minutely: Next run of the job: " + ":" + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                break block86;
                                            }
                                            if (p.getProperty("scheduleType", "").equals("minutely")) break block86;
                                            schedule_time = p.getProperty("scheduleTime", "").split(",");
                                            if (p.getProperty("scheduleTime", "").indexOf(",0:") >= 0) {
                                                schedule_time2 = "";
                                                xx = 0;
                                                while (xx < schedule_time.length) {
                                                    next_time = schedule_time[xx].trim();
                                                    if (next_time.startsWith("0:")) {
                                                        next_time = "12:" + next_time.substring(2);
                                                    }
                                                    schedule_time2 = String.valueOf(schedule_time2) + (xx == 0 ? "" : ",") + next_time;
                                                    ++xx;
                                                }
                                                p.put("scheduleTime", schedule_time2);
                                                schedule_time = p.getProperty("scheduleTime", "").split(",");
                                            }
                                            xx = 0;
                                            while (!(xx >= schedule_time.length || runSchedule && nextRun != -1L)) {
                                                block87: {
                                                    block88: {
                                                        block90: {
                                                            block93: {
                                                                block92: {
                                                                    block91: {
                                                                        block89: {
                                                                            v2 = last_time = xx == schedule_time.length - 1;
                                                                            if (schedule_time[xx].trim().equals("")) break block87;
                                                                            if (nextRun != -1L && !time.format(NOW_DATE).equals(time.format(time.parse(schedule_time[xx].trim()))) || NOW_DATE.getTime() <= nextRun) break block88;
                                                                            if (nextRun == -1L) {
                                                                                Log.log("JOB_SCHEDULER", 0, "Calculating next run of job: " + job.getName());
                                                                            } else {
                                                                                Log.log("JOB_SCHEDULER", 0, "Scheduled to run:" + job.getName());
                                                                            }
                                                                            Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Scheduled type: " + p.getProperty("scheduleType", ""));
                                                                            Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Scheduled time: " + p.getProperty("scheduleTime", ""));
                                                                            if (!p.getProperty("scheduleType", "").equals("daily")) break block89;
                                                                            Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Daily: Before the calculation: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                                            Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Daily: Checking last_time on job: " + last_time);
                                                                            next_time = null;
                                                                            if (last_time) {
                                                                                if (nextRun != -1L) {
                                                                                    c.add(12, -1);
                                                                                    c.add(5, Integer.parseInt(p.getProperty("dailyAmount")));
                                                                                }
                                                                                c.setTimeInMillis(yyMMdd.parse(yyMMdd.format(c.getTime())).getTime());
                                                                                Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Daily: Midnight of the day specified: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                                                next_time = schedule_time[0];
                                                                            } else {
                                                                                if (nextRun >= 0L) {
                                                                                    c.add(12, 1);
                                                                                    Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Daily: Advance one minute: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                                                }
                                                                                next_time = nextRun < 0L ? schedule_time[xx] : schedule_time[xx + 1];
                                                                            }
                                                                            if (nextRun == -1L) {
                                                                                xxx = 0;
                                                                                while (xxx < schedule_time.length) {
                                                                                    daily_time = schedule_time[xxx];
                                                                                    if (time.parse(daily_time.trim()).getTime() > time.parse(time.format(c.getTime())).getTime()) {
                                                                                        next_time = daily_time;
                                                                                        break;
                                                                                    }
                                                                                    ++xxx;
                                                                                }
                                                                            }
                                                                            Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Daily: Checking next time on job: " + next_time + ":" + time.format(time.parse(next_time.trim())));
                                                                            JobScheduler.advance_up_to_next_time(c, schedule_time, next_time);
                                                                            runSchedule = true;
                                                                            if (nextRun == -1L && NOW_DATE.getTime() > c.getTimeInMillis()) {
                                                                                before = time.format(c.getTime());
                                                                                c.add(5, Integer.parseInt(p.getProperty("dailyAmount")));
                                                                                after = time.format(c.getTime());
                                                                                if (!before.equals(after) && time.parse(before).getTime() > time.parse(after).getTime()) {
                                                                                    nex_time_date2 = time.parse(before.trim());
                                                                                    while (!time.format(c.getTime()).equals(time.format(nex_time_date2))) {
                                                                                        before_one_min = c.getTimeZone().inDaylightTime(new Date(c.getTimeInMillis()));
                                                                                        c.add(12, 1);
                                                                                        after_one_min = c.getTimeZone().inDaylightTime(new Date(c.getTimeInMillis()));
                                                                                        if (before_one_min == after_one_min || before_one_min) continue;
                                                                                        nex_time_date2 = new Date(nex_time_date2.getTime() + (long)c.getTimeZone().getDSTSavings());
                                                                                    }
                                                                                }
                                                                            }
                                                                            Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Daily: Checking calendar on job: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                                            break block88;
                                                                        }
                                                                        if (!p.getProperty("scheduleType", "").equals("weekly")) break block90;
                                                                        day = day_lookup.getProperty(new SimpleDateFormat("EEE", Locale.US).format(NOW_DATE).toUpperCase());
                                                                        if (!p.getProperty("weekDays", "").trim().equals("")) break block91;
                                                                        Log.log("SERVER", 0, "Cannot schedule " + job.getName() + " because of an invalid schedule configuration.  No week days chosen.");
                                                                        break block88;
                                                                    }
                                                                    Log.log("JOB_SCHEDULER", 2, String.valueOf(job.getName()) + ":" + " nextRun:" + nextRun + ", last_time:" + last_time);
                                                                    if (nextRun != -1L && p.getProperty("weekDays", "").indexOf(day) < 0) break block88;
                                                                    Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Weekly:" + " Week days:" + p.getProperty("weekDays", ""));
                                                                    c.setTime(NOW_DATE);
                                                                    Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Weekly: Before the calculation: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                                    weekDays = p.getProperty("weekDays", "").split("\\)");
                                                                    if (day.indexOf(weekDays[weekDays.length - 1]) < 0 || !last_time) break block92;
                                                                    while (c.get(12) != 0) {
                                                                        c.add(12, -1);
                                                                    }
                                                                    while (c.get(7) != 1) {
                                                                        c.add(10, -1);
                                                                    }
                                                                    while (c.get(7) == 1) {
                                                                        c.add(10, -1);
                                                                    }
                                                                    c.add(10, 1);
                                                                    Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Weekly: " + " Scheduled time weekly amount: " + p.getProperty("weeklyAmount", ""));
                                                                    loops = 0;
                                                                    ** GOTO lbl210
                                                                    {
                                                                        c.add(10, 1);
                                                                        do {
                                                                            if (c.get(7) == 1) continue block26;
                                                                            while (c.get(7) != 1) {
                                                                                c.add(10, 1);
                                                                            }
                                                                            ++loops;
lbl210:
                                                                            // 2 sources

                                                                        } while (loops < Integer.parseInt(p.getProperty("weeklyAmount")));
                                                                    }
                                                                    c.setTimeInMillis(yyMMdd.parse(yyMMdd.format(c.getTime())).getTime());
                                                                    Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Weekly: " + " Day from week days: " + day + ":" + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                                    break block93;
                                                                }
                                                                if (last_time && nextRun != -1L) {
                                                                    c.add(12, -1);
                                                                    c.add(5, 1);
                                                                    c.setTimeInMillis(yyMMdd.parse(yyMMdd.format(c.getTime())).getTime());
                                                                    Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Weekly: added one day : " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                                }
                                                            }
                                                            next_time = null;
                                                            if (last_time || nextRun == -1L) {
                                                                next_time = schedule_time[0];
                                                            } else {
                                                                c.add(12, 1);
                                                                next_time = schedule_time[xx + 1];
                                                                Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Weekly: Advance one minute: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()) + "  next_time:" + next_time);
                                                            }
                                                            Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Weekly: Next time : " + next_time);
                                                            if (nextRun == -1L) {
                                                                time_matched = false;
                                                                next_time2 = next_time;
                                                                Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Weekly: Next time for calculation: " + next_time + ", Time start:" + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                                startDSTDay = JobScheduler.isStartOfDSTDay(c.getTime());
                                                                if (startDSTDay) {
                                                                    c.add(5, -1);
                                                                }
                                                                loops = 0;
                                                                while (!time_matched && loops < 11520) {
                                                                    ++loops;
                                                                    xxx = 0;
                                                                    while (xxx < schedule_time.length && !time_matched) {
                                                                        next_time2 = schedule_time[xxx];
                                                                        dow = day_lookup.getProperty(new SimpleDateFormat("EEE", Locale.US).format(c.getTime()).toUpperCase());
                                                                        if (time.format(c.getTime()).equals(time.format(time.parse(next_time2.trim()))) && p.getProperty("weekDays", "").indexOf(dow) >= 0) {
                                                                            time_matched = true;
                                                                        }
                                                                        ++xxx;
                                                                    }
                                                                    if (time_matched) continue;
                                                                    c.add(12, 1);
                                                                }
                                                                if (startDSTDay) {
                                                                    c.add(5, 1);
                                                                }
                                                                Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Weekly: Calculated next scheduled time: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()) + " next_time2:" + next_time2);
                                                            } else {
                                                                Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Weekly Days: Next time: " + next_time);
                                                                JobScheduler.advance_up_to_next_time(c, schedule_time, next_time);
                                                                Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Weekly: Next scheduled time: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()) + " next_time:" + next_time);
                                                            }
                                                            if (nextRun == -1L || last_time) {
                                                                recalculate_last_day = false;
                                                                day = day_lookup.getProperty(new SimpleDateFormat("EEE", Locale.US).format(c.getTime()).toUpperCase());
                                                                while (p.getProperty("weekDays", "").indexOf(day) < 0) {
                                                                    before = c.getTimeZone().inDaylightTime(new Date(c.getTimeInMillis()));
                                                                    c.add(5, 1);
                                                                    day = day_lookup.getProperty(new SimpleDateFormat("EEE", Locale.US).format(c.getTime()).toUpperCase());
                                                                    after = c.getTimeZone().inDaylightTime(new Date(c.getTimeInMillis()));
                                                                    recalculate_last_day = before ^ after;
                                                                }
                                                                if (!recalculate_last_day && time.parse(time.format(c.getTime())).getTime() < time.parse(next_time.trim()).getTime()) {
                                                                    recalculate_last_day = true;
                                                                }
                                                                if (recalculate_last_day) {
                                                                    c.set(11, 0);
                                                                    c.set(12, 0);
                                                                    JobScheduler.advance_up_to_next_time(c, schedule_time, next_time);
                                                                }
                                                            }
                                                            runSchedule = true;
                                                            Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Weekly: Checking calendar on job: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()) + " next_time:" + next_time);
                                                            break block88;
                                                        }
                                                        if (p.getProperty("scheduleType", "").equals("monthly")) {
                                                            dd = new SimpleDateFormat("dd", Locale.US);
                                                            d = new SimpleDateFormat("d", Locale.US);
                                                            day1 = "(" + d.format(NOW_DATE) + ")";
                                                            day2 = "(" + dd.format(NOW_DATE) + ")";
                                                            if (p.getProperty("monthDays", "").trim().equals("")) {
                                                                Log.log("SERVER", 0, "Cannot schedule " + job.getName() + " because of an invalid schedule configuration.  No month days chosen.");
                                                            } else if (nextRun == -1L || p.getProperty("monthDays", "").indexOf(day1) >= 0 || p.getProperty("monthDays", "").indexOf(day2) >= 0) {
                                                                Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Monthly: Before the calculation: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                                Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Monthly: Month days: " + p.getProperty("monthDays", ""));
                                                                monthDays = p.getProperty("monthDays", "").split("\\)");
                                                                if (last_time && (day1.indexOf(monthDays[monthDays.length - 1]) >= 0 || day2.indexOf(monthDays[monthDays.length - 1]) >= 0)) {
                                                                    Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Monthly: day1: " + day1);
                                                                    Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Monthly: day2: " + day2);
                                                                    c.setTime(NOW_DATE);
                                                                    while (c.get(5) != 1) {
                                                                        c.add(5, -1);
                                                                    }
                                                                    if (nextRun != -1L) {
                                                                        c.add(2, Integer.parseInt(p.getProperty("monthlyAmount")));
                                                                    }
                                                                    c.setTimeInMillis(yyMMdd.parse(yyMMdd.format(c.getTime())).getTime());
                                                                    Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Monthly: After processed days: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                                }
                                                                next_time = null;
                                                                if (last_time || nextRun == -1L) {
                                                                    next_time = schedule_time[0];
                                                                } else {
                                                                    c.add(12, 1);
                                                                    Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Monthly: One minute in advance: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                                    next_time = schedule_time[xx + 1];
                                                                    Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Monthly: Next time: " + next_time);
                                                                }
                                                                if (nextRun == -1L) {
                                                                    xxx = 0;
                                                                    while (xxx < schedule_time.length) {
                                                                        daily_time = schedule_time[xxx];
                                                                        if (time.parse(daily_time.trim()).getTime() > time.parse(time.format(c.getTime())).getTime()) {
                                                                            next_time = daily_time;
                                                                            break;
                                                                        }
                                                                        ++xxx;
                                                                    }
                                                                    Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Monthly: Nearest next time: " + next_time);
                                                                }
                                                                next_time = JobScheduler.advance_up_to_next_time(c, schedule_time, next_time);
                                                                Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Monthly: Advance it up to the first time interval: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                                if (nextRun == -1L) {
                                                                    day1 = "(" + d.format(c.getTime()) + ")";
                                                                    day2 = "(" + dd.format(c.getTime()) + ")";
                                                                    while (p.getProperty("monthDays", "").indexOf(day1) < 0 && p.getProperty("monthDays", "").indexOf(day2) < 0) {
                                                                        c.add(12, 1);
                                                                        day1 = "(" + d.format(c.getTime()) + ")";
                                                                        day2 = "(" + dd.format(c.getTime()) + ")";
                                                                    }
                                                                    next_time = JobScheduler.advance_up_to_next_time(c, schedule_time, next_time);
                                                                    if (NOW_DATE.getTime() > c.getTimeInMillis()) {
                                                                        c.add(2, Integer.parseInt(p.getProperty("monthlyAmount")));
                                                                    }
                                                                }
                                                                runSchedule = true;
                                                                Log.log("JOB_SCHEDULER", 1, String.valueOf(job.getName()) + ":" + " Monthly: Checking calendar on job: " + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                                            }
                                                        }
                                                    }
                                                    if (nextRun == -1L) break;
                                                }
                                                ++xx;
                                            }
                                        }
                                        if (!runSchedule && nextRun != -1L) break block82;
                                        c.setTimeInMillis(yyMMddHHmm.parse(yyMMddHHmm.format(c.getTime())).getTime());
                                        p.put("nextRun", String.valueOf(c.getTimeInMillis()));
                                        Log.log("JOB_SCHEDULER", 1, "Calculated next run of the job:" + job.getName() + ":" + c.getTimeInMillis() + ":" + new Date(c.getTimeInMillis()));
                                        b = null;
                                        xx = JobScheduler.job_sheduler_sync;
                                        synchronized (xx) {
                                            b = com.crushftp.client.Common.CLONE1(p);
                                        }
                                        if (JobFilesHandler.writeXMLObject(String.valueOf(job.getPath()) + "/job.XML", (Properties)com.crushftp.client.Common.CLONE2(b), "job")) {
                                            if (ServerStatus.siIG("enterprise_level") <= 0) {
                                                throw new Exception("Job Scheduler feature is only for Enterprise licenses.");
                                            }
                                            if (nextRun >= 0L) {
                                                p2 = p;
                                                Worker.startWorker(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        JobScheduler.runSchedule(p2);
                                                    }
                                                });
                                            }
                                            break block82;
                                        }
                                        throw new Exception("Job Scheduler failed to update next run time for job, cancelling scheduled time:" + job);
                                        {
                                            catch (Exception e) {
                                                Log.log("SERVER", 0, e);
                                                Log.log("SERVER", 0, "" + p);
                                            }
                                        }
                                    }
                                    catch (Throwable var25_44) {
                                        throw var25_44;
                                    }
                                    finally {
                                        running_jobs_threads.remove(job);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        Log.log("SERVER", 0, e);
                    }
                }
                ++x;
lbl66:
                // 2 sources

            } while (x < jobs.size());
        }
        v0 = purge_old = System.currentTimeMillis() - JobScheduler.lastOldCheck > 3600000L;
        if (purge_old) {
            JobScheduler.lastOldCheck = System.currentTimeMillis();
            try {
                Worker.startWorker(new Runnable(){

                    @Override
                    public void run() {
                        Vector jobs = JobScheduler.getJobList(true);
                        lastOldCheck = System.currentTimeMillis();
                        long time_amount = ServerStatus.LG("recent_temp_job_days") * 86400000L;
                        if (time_amount < 900000L) {
                            time_amount = 900000L;
                        }
                        int x = 0;
                        while (x < jobs.size()) {
                            File_S job2 = (File_S)jobs.elementAt(x);
                            lastOldCheck = System.currentTimeMillis();
                            String name = job2.getName();
                            if (name.startsWith("__")) {
                                try {
                                    lastOldCheck = System.currentTimeMillis();
                                    Long.parseLong(name.substring(name.length() - 13));
                                    if (new File_S(String.valueOf(job2.getPath()) + "/job.XML").exists()) {
                                        if (System.currentTimeMillis() - new File_S(String.valueOf(job2.getPath()) + "/job.XML").lastModified() >= time_amount) {
                                            Log.log("JOB_SCHEDULER", 0, "Deleting expired temp job folder1:" + job2.getPath());
                                            Common.recurseDelete(String.valueOf(job2.getPath()) + "/", false);
                                        }
                                    } else if (new File_S(String.valueOf(job2.getPath()) + "/inprogress/").exists()) {
                                        if (System.currentTimeMillis() - new File_S(String.valueOf(job2.getPath()) + "/inprogress/").lastModified() >= time_amount) {
                                            Log.log("JOB_SCHEDULER", 0, "Deleting expired temp job folder2:" + job2.getPath());
                                            Common.recurseDelete(String.valueOf(job2.getPath()) + "/", false);
                                        }
                                    } else if (System.currentTimeMillis() - new File_S(String.valueOf(job2.getPath()) + "/").lastModified() >= time_amount) {
                                        Log.log("JOB_SCHEDULER", 0, "Deleting expired temp job folder3:" + job2.getPath());
                                        Common.recurseDelete(String.valueOf(job2.getPath()) + "/", false);
                                    }
                                }
                                catch (Exception e) {
                                    Log.log("JOB_SCHEDULER", 1, e);
                                }
                            }
                            lastOldCheck = System.currentTimeMillis();
                            File_S[] olds = (File_S[])job2.listFiles();
                            lastOldCheck = System.currentTimeMillis();
                            time_amount = ServerStatus.LG("recent_job_days") * 86400000L;
                            if (time_amount < 3600000L) {
                                time_amount = 3600000L;
                            }
                            int xx = 0;
                            while (olds != null && xx < olds.length) {
                                lastOldCheck = System.currentTimeMillis();
                                File_S old = olds[xx];
                                name = old.getName();
                                if (name.toUpperCase().endsWith(".XML") && !name.equalsIgnoreCase("job.XML") && !name.equalsIgnoreCase("inprogress.XML") && !name.equalsIgnoreCase("inprogress") && System.currentTimeMillis() - old.lastModified() > time_amount && System.currentTimeMillis() - old.lastModified() > 300000L) {
                                    Log.log("JOB_SCHEDULER", 0, "Deleting expired job history item:" + old.getPath());
                                    old.delete();
                                }
                                ++xx;
                            }
                            lastOldCheck = System.currentTimeMillis();
                            ++x;
                        }
                        ServerStatus.server_info.put("last_job_cache_clean", "0");
                    }
                }, "PurgeOldJobsChecker");
            }
            catch (IOException e) {
                Log.log("JOB_SCHEDULER", 0, e);
            }
        }
    }

    public static void refreshJobsCache() {
        if (!ServerStatus.BG("job_scheduler_enabled")) {
            return;
        }
        if (scanning_cache) {
            return;
        }
        scanning_cache = true;
        long start = System.currentTimeMillis();
        long total_xml_bytes = 0L;
        String thread_name = Thread.currentThread().getName();
        long count = 0L;
        try {
            ServerStatus.server_info.put("last_job_cache_clean", String.valueOf(System.currentTimeMillis()));
            Properties jobs_summary_cache_new = new Properties();
            Vector jobs = JobScheduler.getJobList(true);
            int x = 0;
            while (x < jobs.size()) {
                block13: {
                    ServerStatus.server_info.put("last_job_cache_clean", String.valueOf(System.currentTimeMillis()));
                    try {
                        File_S f = (File_S)jobs.elementAt(x);
                        if (!f.isDirectory()) break block13;
                        File_S[] f2 = (File_S[])f.listFiles();
                        int xx = 0;
                        while (f2 != null && xx < f2.length) {
                            try {
                                ServerStatus.server_info.put("last_job_cache_clean", String.valueOf(System.currentTimeMillis()));
                                Properties summaryJob = (Properties)JobFilesHandler.jobs_summary_cache.get(f2[xx].getPath());
                                if (summaryJob == null || !summaryJob.getProperty("modified").equals(String.valueOf(f2[xx].lastModified()))) {
                                    Thread.currentThread().setName("last_job_cache_clean:" + count + " of last " + JobFilesHandler.jobs_summary_cache_size + ":" + (System.currentTimeMillis() - start) + "ms" + ":Processing:" + f2[xx].getPath() + ":size=" + com.crushftp.client.Common.format_bytes_short(f2[xx].length()) + ":total=" + com.crushftp.client.Common.format_bytes_short(total_xml_bytes));
                                    summaryJob = JobFilesHandler.addToCache(f2[xx].getPath(), null);
                                    total_xml_bytes += f2[xx].length();
                                }
                                Thread.currentThread().setName("last_job_cache_clean:" + count + " of last " + JobFilesHandler.jobs_summary_cache_size + ":" + (System.currentTimeMillis() - start) + "ms" + ":" + f2[xx].getPath() + ":size=" + com.crushftp.client.Common.format_bytes_short(f2[xx].length()) + ":total=" + com.crushftp.client.Common.format_bytes_short(total_xml_bytes));
                                if (summaryJob != null) {
                                    ++count;
                                    JobFilesHandler.jobs_summary_cache.put(f2[xx].getPath(), summaryJob);
                                    jobs_summary_cache_new.put(f2[xx].getPath(), summaryJob);
                                }
                            }
                            catch (Exception e) {
                                Log.log("JOB_SCHEDULER", 2, e);
                            }
                            ++xx;
                        }
                    }
                    catch (Exception e) {
                        Log.log("JOB_SCHEDULER", 2, e);
                    }
                }
                ++x;
            }
            ServerStatus.server_info.put("last_job_cache_clean", String.valueOf(System.currentTimeMillis()));
            JobFilesHandler.jobs_summary_cache = jobs_summary_cache_new;
        }
        finally {
            JobFilesHandler.jobs_summary_cache_size = "count=" + count + ":time=" + (System.currentTimeMillis() - start) + "ms:total=" + com.crushftp.client.Common.format_bytes_short(total_xml_bytes);
            Thread.currentThread().setName(thread_name);
            scanning_cache = false;
        }
    }

    public static void updateSpecificJobCache(Properties summaryJob, String path, boolean replicate) {
        if (replicate) {
            if (ServerStatus.BG("jobs_replicate_cache_cluster")) {
                Properties pp = new Properties();
                pp.put("summaryJob", summaryJob);
                pp.put("path", path);
                pp.put("need_response", "false");
                SharedSessionReplicated.send(Common.makeBoundary(), "crushftp.JobScheduler.updateSpecificJobCache", "info", pp);
            }
        }
        if (!ServerStatus.BG("job_scheduler_enabled")) {
            return;
        }
        JobFilesHandler.jobs_summary_cache.put(path, summaryJob);
    }

    public static int jobRunningCount(String scheduleName, String hostname) {
        int running_count = 0;
        File_S[] inprogress = null;
        try {
            File_S ff = new File_S(String.valueOf(ServerStatus.SG("jobs_location")) + "jobs/" + scheduleName + "/inprogress/");
            if (ff.exists()) {
                inprogress = (File_S[])ff.listFiles();
            }
        }
        catch (Exception e) {
            Log.log("SERVER", 1, e);
        }
        if (inprogress != null) {
            int x = 0;
            while (x < inprogress.length) {
                if (inprogress[x].getName().toUpperCase().endsWith(".XML") && !inprogress[x].getName().startsWith(".")) {
                    ++running_count;
                }
                ++x;
            }
        }
        Vector job_names = JobBroker.getActiveJobNames();
        int x = 0;
        while (x < job_names.size()) {
            String job_name = (String)job_names.elementAt(x);
            if ((hostname.equals(System.getProperty("crushftp.hostname")) || hostname.equals("")) && (scheduleName.equalsIgnoreCase(job_name) || scheduleName.equals(""))) {
                ++running_count;
            }
            ++x;
        }
        return running_count;
    }

    public static void runSchedule(Properties job_params) {
        boolean ok = true;
        int running_count = JobScheduler.jobRunningCount(job_params.getProperty("scheduleName", ""), "");
        if (job_params.getProperty("scheduleName", "").toUpperCase().endsWith("_SINGLE") || job_params.getProperty("single", "").equals("true")) {
            boolean bl = ok = running_count == 0;
        }
        if (job_params.getProperty("singleServer", "").equals("true") && ok) {
            boolean bl = ok = running_count == 0;
            if (ok) {
                Properties pp = new Properties();
                pp.put("scheduleName", job_params.getProperty("scheduleName"));
                pp.put("hostname", "");
                pp.put("need_response", "true");
                SharedSessionReplicated.send(Common.makeBoundary(), "crushftp.JobScheduler.jobRunningCount", "info", pp);
                long start = System.currentTimeMillis();
                while (pp.getProperty("response_num", "0").equals("0") && System.currentTimeMillis() - start < 5000L) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Properties val = (Properties)pp.get("val");
                if (val != null) {
                    Enumeration<Object> keys = val.keys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement().toString();
                        if (!key.startsWith("running_") || Integer.parseInt(val.getProperty(key, "0")) <= 0) continue;
                        ok = false;
                    }
                }
            }
        }
        if (ServerStatus.BG("distributed_jobs") && ok) {
            Properties pp;
            long most_free = 0L;
            String best_hostname = "";
            if (SharedSessionReplicated.remote_host_ports.size() > 0) {
                pp = new Properties();
                pp.put("hostname", "");
                pp.put("need_response", "true");
                SharedSessionReplicated.send(Common.makeBoundary(), "crushftp.JobScheduler.ram_free", "info", pp);
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start < 5000L) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Properties hostnames = new Properties();
                Properties val = (Properties)pp.get("val");
                if (val != null) {
                    String key;
                    Enumeration<Object> keys = val.keys();
                    while (keys.hasMoreElements()) {
                        key = keys.nextElement().toString();
                        if (!key.startsWith("free_") && !key.startsWith("hostname_")) continue;
                        String uid = key.split("_")[1];
                        hostnames.put(val.getProperty("hostname_" + uid), val.getProperty("free_" + uid));
                    }
                    keys = hostnames.keys();
                    while (keys.hasMoreElements()) {
                        key = keys.nextElement().toString();
                        if (Long.parseLong(hostnames.getProperty(key)) <= most_free) continue;
                        most_free = Long.parseLong(hostnames.getProperty(key));
                        best_hostname = key;
                    }
                }
            }
            if (!best_hostname.equals("")) {
                pp = new Properties();
                pp.put("data", job_params);
                pp.put("scheduleName", job_params.getProperty("scheduleName"));
                pp.put("need_response", "true");
                pp.put("use_dmz", "");
                pp.put("hostname", best_hostname);
                Log.log("JOB_SCHEDULER", 0, "Sending requests to replicated server to run job:" + best_hostname + ":" + job_params.getProperty("scheduleName"));
                SharedSessionReplicated.send(Common.makeBoundary(7), "crushftp.JobScheduler.runDistributedJob", "info", pp);
                Log.log("JOB_SCHEDULER", 0, "JOB " + job_params.getProperty("scheduleName") + " running on distributed server:" + best_hostname);
                long start = System.currentTimeMillis();
                long day = 86400000L;
                while (pp.getProperty("response_num", "0").equals("0") && System.currentTimeMillis() - start < day) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception keys) {
                        // empty catch block
                    }
                }
                Properties val = (Properties)pp.get("val");
                if (val != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream((byte[])val.get("zip_result"));
                    ZipArchiveInputStream zip = new ZipArchiveInputStream((InputStream)bais);
                    try {
                        ZipArchiveEntry ze = zip.getNextZipEntry();
                        while (ze != null) {
                            if (ze.getName().toUpperCase().endsWith(".XML")) {
                                Common.streamCopier((InputStream)zip, new FileOutputStream(String.valueOf(System.getProperty("crushftp.jobs_location")) + "jobs/" + job_params.getProperty("scheduleName") + "/" + ze.getName(), false), false, false, true);
                            } else if (ze.getName().toLowerCase().endsWith(".log")) {
                                Common.streamCopier((InputStream)zip, new FileOutputStream(String.valueOf(new File_S(ServerStatus.change_vars_to_values_static(System.getProperty("crushftp.log_location"), null, null, null)).getCanonicalFile().getParentFile().getPath()) + "/logs/jobs/" + ze.getName(), false), false, false, true);
                            }
                            ze = zip.getNextZipEntry();
                        }
                        zip.close();
                    }
                    catch (Exception e) {
                        Log.log("SERVER", 1, e);
                    }
                }
                return;
            }
            Log.log("SERVER", 0, "JOB " + job_params.getProperty("scheduleName") + " FAILED TO RUN!  NO DISTRIBUTED JOB SERVERS AVAILABLE AND DISTRIBUTED JOB RUNNING IS ENABLED!!!");
            try {
                final Properties job_info = job_params;
                Worker.startWorker(new Runnable(){

                    @Override
                    public void run() {
                        AlertTools.runAlerts("skipped_scheduled_job", job_info, null, null, null, null, com.crushftp.client.Common.dmz_mode);
                    }
                });
            }
            catch (IOException e) {
                Log.log("SERVER", 1, e);
            }
            return;
        }
        if (ok) {
            try {
                class Runner
                implements Runnable {
                    Properties params;

                    public Runner(Properties params) {
                        this.params = params;
                    }

                    @Override
                    public void run() {
                        if (Log.log("JOB_SCHEDULER", 2, "")) {
                            Properties log_params = (Properties)com.crushftp.client.Common.CLONE(this.params);
                            JobFilesHandler.encryptDecryptData(log_params, true);
                            Log.log("JOB_SCHEDULER", 2, "" + log_params);
                        }
                        Properties event = new Properties();
                        event.putAll((Map<?, ?>)this.params);
                        event.put("event_plugin_list", this.params.getProperty("plugin"));
                        event.put("name", "ScheduledPluginEvent:" + this.params.getProperty("scheduleName"));
                        JobScheduler.doEventPlugin(null, event, null, new Vector(), false, false);
                    }
                }
                Worker.startWorker(new Runner(job_params), "schedule:" + job_params.getProperty("scheduleName") + ":" + new Date());
            }
            catch (Exception e) {
                Log.log("SERVER", 0, e);
            }
            Log.log("SERVER", 0, LOC.G("Ran Schedule") + ":" + job_params.getProperty("scheduleName") + ":" + new Date());
            Properties log_params = (Properties)com.crushftp.client.Common.CLONE(job_params);
            JobFilesHandler.encryptDecryptData(log_params, true);
            log_params.remove("audit_trail");
            Log.log("JOB_SCHEDULER", 1, " :" + log_params.toString());
        } else {
            Log.log("SERVER", 0, "JOB_SCHEDULER:Skipping scheduled job since its still running:" + job_params.getProperty("scheduleName"));
            final Properties job_info = job_params;
            try {
                Worker.startWorker(new Runnable(){

                    @Override
                    public void run() {
                        AlertTools.runAlerts("skipped_scheduled_job", job_info, null, null, null, null, com.crushftp.client.Common.dmz_mode);
                    }
                });
            }
            catch (IOException e) {
                Log.log("SERVER", 1, e);
            }
        }
    }

    public static String safeName(String scheduleName) {
        scheduleName = Common.url_decode(scheduleName);
        scheduleName = Common.replace_str(scheduleName, ":", "_");
        scheduleName = Common.replace_str(scheduleName, "#", "_");
        scheduleName = Common.replace_str(scheduleName, "@", "_");
        scheduleName = Common.replace_str(scheduleName, "!", "_");
        scheduleName = Common.replace_str(scheduleName, "&", "_");
        scheduleName = Common.replace_str(scheduleName, "\\", "_");
        scheduleName = Common.replace_str(scheduleName, ";", "_");
        scheduleName = Common.replace_str(scheduleName, "<", "_");
        scheduleName = Common.replace_str(scheduleName, ">", "_");
        return scheduleName;
    }

    public static boolean isStartOfDSTDay(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        boolean before = ((Calendar)c).getTimeZone().inDaylightTime(date);
        ((Calendar)c).add(5, 1);
        boolean after = ((Calendar)c).getTimeZone().inDaylightTime(c.getTime());
        return before != after && !before;
    }

    static String advance_up_to_next_time(Calendar c, String[] schedule_time, String next_time) throws Exception {
        SimpleDateFormat time = new SimpleDateFormat("hh:mm aa", Locale.US);
        Date nex_time_date = time.parse(next_time.trim());
        boolean dst_start = false;
        boolean match = false;
        while (!time.format(c.getTime()).equals(time.format(nex_time_date)) && !match) {
            boolean before = c.getTimeZone().inDaylightTime(new Date(c.getTimeInMillis()));
            c.add(12, 1);
            boolean after = c.getTimeZone().inDaylightTime(new Date(c.getTimeInMillis()));
            if (before != after && !before) {
                dst_start = true;
            }
            if (!dst_start) continue;
            int xxx = 0;
            while (xxx < schedule_time.length) {
                String next_time2 = schedule_time[xxx];
                Date nex_time2_date = new Date(time.parse(next_time2.trim()).getTime() + (long)(time.parse(time.format(c.getTime())).getTime() > time.parse(next_time2.trim()).getTime() ? c.getTimeZone().getDSTSavings() : 0));
                if (time.format(c.getTime()).equals(time.format(nex_time2_date))) {
                    if (!next_time.equals(time.format(nex_time2_date))) {
                        next_time = time.format(nex_time2_date);
                    }
                    match = true;
                }
                ++xxx;
            }
        }
        return next_time;
    }

    public static String jobName(File_S f) {
        return f.getPath().replace('\\', '/').substring((String.valueOf(System.getProperty("crushftp.jobs_location")) + "jobs/").length());
    }

    public static Properties doEventPlugin(Properties info, Properties event, SessionCrush the_user, Vector items, boolean receive_progress_updates) {
        return JobScheduler.doEventPlugin(info, event, the_user, items, receive_progress_updates, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static Properties doEventPlugin(Properties info, Properties event, SessionCrush the_user, Vector items, boolean receive_progress_updates, boolean update_at_end_only) {
        try {
            Vector<Properties> cache;
            Properties cachedPlugin;
            String subItem;
            String pluginName;
            block47: {
                block48: {
                    Thread.currentThread().setName("Event:PLUGIN " + event.getProperty("name"));
                    StackTraceElement[] ste = Thread.currentThread().getStackTrace();
                    String horizontal_thread = "";
                    int x = 0;
                    while (x < ste.length && x < 4) {
                        horizontal_thread = String.valueOf(horizontal_thread) + "|" + ste[x].getFileName() + ":" + ste[x].getMethodName() + ":" + ste[x].getLineNumber();
                        ++x;
                    }
                    Log.log("EVENT", 0, "Event:PLUGIN " + event.getProperty("name") + ":" + horizontal_thread);
                    if (info == null) {
                        info = new Properties();
                    }
                    info.put("action", "event");
                    info.put("server_settings", ServerStatus.server_settings);
                    info.put("event", event);
                    info.put("trigger_name", Common.replace_str(event.getProperty("name", ""), ":", "_"));
                    if (the_user != null && the_user.user != null) {
                        info.put("user", the_user.user);
                    }
                    if (the_user != null && the_user.user_info != null) {
                        info.put("user_info", the_user.user_info);
                    }
                    if (the_user != null && the_user.server_item != null) {
                        info.put("server_item", the_user.server_item);
                    }
                    info.put("items", items);
                    pluginName = event.getProperty("event_plugin_list", "");
                    subItem = "";
                    if (pluginName.indexOf(":") >= 0) {
                        subItem = pluginName.substring(pluginName.indexOf(":") + 1);
                        pluginName = pluginName.substring(0, pluginName.indexOf(":"));
                    }
                    if (!pluginName.toLowerCase().startsWith("crushtask") || !pluginName.equalsIgnoreCase("Job")) {
                        if (the_user != null) {
                            info.put("ServerSession", the_user);
                        }
                        if (the_user != null) {
                            info.put("ServerSessionObject", the_user);
                        }
                    }
                    cachedPlugin = null;
                    cache = null;
                    if (!pluginName.equalsIgnoreCase("Job")) break block48;
                    event = (Properties)event.clone();
                    Vector jobs = JobScheduler.getJobList(false);
                    File job = null;
                    int x2 = 0;
                    while (job == null && x2 < jobs.size()) {
                        block50: {
                            File_S f;
                            block49: {
                                f = (File_S)jobs.elementAt(x2);
                                String path = f.getAbsolutePath();
                                if (Common.machine_is_windows()) {
                                    path = com.crushftp.client.Common.winPath(path);
                                }
                                if (subItem.contains("/") && path.endsWith(subItem)) break block49;
                                if (!f.getName().equalsIgnoreCase(subItem)) break block50;
                                if (!f.getParentFile().getCanonicalPath().equals(new File_S(String.valueOf(ServerStatus.SG("jobs_location")) + "jobs/").getCanonicalPath())) break block50;
                            }
                            job = f;
                        }
                        ++x2;
                    }
                    Properties params = null;
                    int x3 = 0;
                    while (x3 < 30) {
                        try {
                            params = (Properties)JobFilesHandler.readXMLObject(String.valueOf(job.getPath()) + "/job.XML");
                            break;
                        }
                        catch (Exception path) {
                            Thread.sleep(1000L);
                            ++x3;
                        }
                    }
                    params.put("new_job_id", Common.makeBoundary(20));
                    try {
                        Cloneable cloneable;
                        event.putAll((Map<?, ?>)params);
                        event.put("event_plugin_list", params.getProperty("plugin", params.getProperty("event_plugin_list")));
                        event.put("name", "ScheduledPluginEvent:" + params.getProperty("scheduleName"));
                        boolean override = false;
                        if (event.getProperty("async", "").equals("no")) {
                            int loops = 0;
                            while (loops++ < 600) {
                                cloneable = runningSchedules;
                                synchronized (cloneable) {
                                    if (runningSchedules.indexOf(params.getProperty("scheduleName")) < 0) {
                                        override = true;
                                        runningSchedules.addElement(params.getProperty("scheduleName"));
                                        break;
                                    }
                                }
                                Thread.sleep(1000L);
                            }
                        }
                        if (!event.getProperty("async", "").equalsIgnoreCase("no")) {
                            override = true;
                        }
                        if (runningSchedules.indexOf(params.getProperty("scheduleName")) < 0 || override) {
                            try {
                                if (!override) {
                                    runningSchedules.addElement(params.getProperty("scheduleName"));
                                }
                                cloneable = JobScheduler.doEventPlugin(info, event, null, items, receive_progress_updates, update_at_end_only);
                                return cloneable;
                            }
                            finally {
                                runningSchedules.remove(params.getProperty("scheduleName"));
                            }
                        }
                        break block47;
                    }
                    catch (Exception e) {
                        Log.log("HTTP_SERVER", 1, e);
                    }
                    break block47;
                }
                if (pluginName.endsWith(" (User Defined)")) {
                    pluginName = pluginName.substring(0, pluginName.indexOf(" (User Defined)"));
                    info.put("job_max_runtime_hours", ServerStatus.SG("job_max_runtime_hours"));
                    info.put("job_max_runtime_minutes", ServerStatus.SG("job_max_runtime_minutes"));
                    info.put("task_max_runtime_hours", ServerStatus.SG("task_max_runtime_hours"));
                    info.put("task_max_runtime_minutes", ServerStatus.SG("task_max_runtime_minutes"));
                    Log.log("EVENT", 0, "Event:PLUGIN " + event.getProperty("name") + ":" + pluginName + ":" + subItem + ":");
                    if (pluginName.equalsIgnoreCase("CrushTask")) {
                        if (info.getProperty("scheduleName", "").equals("")) {
                            info.put("scheduleName", event.getProperty("scheduleName", info.getProperty("event_name")));
                        }
                        if (com.crushftp.client.Common.dmz_mode) {
                            String scheduleName = info.getProperty("scheduleName", "CrushTask");
                            String job_id = info.getProperty("id", Common.makeBoundary(10));
                            info = JobBroker.runLocalJob(event, scheduleName, job_id, items, null, info, cachedPlugin, subItem, receive_progress_updates);
                        } else {
                            info = JobBroker.runRemoteJob(info, receive_progress_updates, update_at_end_only);
                        }
                        return info;
                    }
                    Object thePlugin = null;
                    cache = (Vector)eventPluginCache.get(pluginName);
                    Properties job_id = eventPluginCache;
                    synchronized (job_id) {
                        if (cache == null) {
                            cache = new Vector<Properties>();
                        }
                        eventPluginCache.put(pluginName, cache);
                        if (cache.size() > 0) {
                            cachedPlugin = (Properties)cache.remove(0);
                            thePlugin = cachedPlugin.get("plugin");
                            subItem = cachedPlugin.getProperty("subItem");
                            Properties defaultPrefs = (Properties)cachedPlugin.get("defaultPrefs");
                            defaultPrefs = (Properties)com.crushftp.client.Common.CLONE(defaultPrefs);
                            defaultPrefs.putAll((Map<?, ?>)event);
                            Common.setPluginSettings(thePlugin, defaultPrefs);
                        }
                    }
                    if (thePlugin == null) {
                        subItem = Common.makeBoundary(10);
                        thePlugin = Common.getPlugin(pluginName, new File_S(String.valueOf(System.getProperty("crushftp.plugins")) + "plugins/").toURI().toURL().toExternalForm(), subItem);
                        Properties defaultPrefs = Common.getPluginDefaultPrefs(pluginName, subItem);
                        cachedPlugin = new Properties();
                        cachedPlugin.put("plugin", thePlugin);
                        cachedPlugin.put("defaultPrefs", com.crushftp.client.Common.CLONE(defaultPrefs));
                        cachedPlugin.put("subItem", subItem);
                        defaultPrefs.putAll((Map<?, ?>)event);
                        Common.setPluginSettings(thePlugin, defaultPrefs);
                    }
                }
            }
            Common.runPlugin(pluginName, info, subItem);
            if (cachedPlugin != null && cache != null) {
                cache.addElement(cachedPlugin);
            }
            return info;
        }
        catch (Exception e) {
            Log.log("EVENT", 1, e);
            Log.log("EVENT", 0, "FAILURE:" + event.getProperty("name") + ":" + e + "\r\n");
            return info;
        }
    }
}

