/*
 * Decompiled with CFR 0.152.
 */
package crushftp.handlers;

import com.crushftp.client.Common;
import com.crushftp.client.Worker;
import crushftp.handlers.Log;
import crushftp.server.ServerStatus;
import java.util.Enumeration;
import java.util.Properties;

public class GeoIP {
    boolean enabled = false;
    public String server_lat = "0";
    public String server_lon = "0";

    public void init(String server_ip) {
        try {
            if (ServerStatus.SG("geoip_access_key").equals("")) {
                Log.log("SERVER", 0, "Skipping GEOIP lookups GEOIP accesskey not configured in Preferences, Misc.");
            } else {
                if (System.getProperties().containsKey("crushftp.update.geo_ip_cache")) {
                    Common.ip_lookup_cache = (Properties)System.getProperties().remove("crushftp.update.geo_ip_cache");
                    Worker.startWorker(new Runnable(){

                        @Override
                        public void run() {
                            long half_year = 15552000000L;
                            Enumeration<Object> keys = Common.ip_lookup_cache.keys();
                            while (keys.hasMoreElements()) {
                                String key = keys.nextElement().toString();
                                Properties ip_info = (Properties)Common.ip_lookup_cache.get(key);
                                if (System.currentTimeMillis() - Long.parseLong(ip_info.getProperty("time", "0")) <= half_year) continue;
                                Common.ip_lookup_cache.remove(key);
                            }
                        }
                    });
                }
                Properties data = Common.geo_ip_lookup(server_ip, -1);
                this.server_lat = data.getProperty("lat", "0");
                this.server_lon = data.getProperty("lon", "0");
                this.enabled = true;
            }
        }
        catch (Throwable e) {
            System.out.println(e);
        }
    }

    public Properties getLoc(String ip) throws Exception {
        Properties loc = new Properties();
        loc.put("lat", "0");
        loc.put("lon", "0");
        loc.put("ip", ip);
        loc.put("country", "UNKNOWN");
        loc.put("t", String.valueOf(System.currentTimeMillis()));
        if (this.enabled && !ip.equals("127.0.0.1")) {
            Properties data = Common.geo_ip_lookup(ip, Integer.parseInt(System.getProperty("crushftp.geo_ip.max", "1000000")));
            loc.put("lat", data.getProperty("lat", "0"));
            loc.put("lon", data.getProperty("lon", "0"));
            loc.put("country", data.getProperty("country", "UNKNOWN"));
        }
        return loc;
    }
}

