/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.SshX509PublicKey;
import com.maverick.ssh.components.jce.Ssh2EcdsaSha2NistPublicKey;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.ECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SshX509EcdsaSha2NistPublicKeyRfc6187
extends Ssh2EcdsaSha2NistPublicKey
implements SshX509PublicKey {
    static Logger log = LoggerFactory.getLogger(SshX509EcdsaSha2NistPublicKeyRfc6187.class);
    Certificate[] certs;

    public SshX509EcdsaSha2NistPublicKeyRfc6187(String name, String spec, String curve, String nistpCurve) {
        super(name, spec, curve, nistpCurve);
    }

    public SshX509EcdsaSha2NistPublicKeyRfc6187(ECPublicKey pk, String curve) throws IOException {
        super(pk, curve);
    }

    public SshX509EcdsaSha2NistPublicKeyRfc6187(Certificate[] chain, String curve) throws IOException {
        super((ECPublicKey)chain[0].getPublicKey(), curve);
        this.certs = chain;
    }

    @Override
    public int getPriority() {
        return super.getPriority() + 50;
    }

    @Override
    public void init(byte[] blob, int start, int len) throws SshException {
        ByteArrayReader reader = new ByteArrayReader(blob, start, len);
        try {
            String alg = reader.readString();
            if (!alg.equals(this.getAlgorithm())) {
                throw new SshException("Public key blob is not a " + this.getAlgorithm() + " formatted key [" + alg + "]", 4);
            }
            int certificateCount = (int)reader.readInt();
            if (log.isDebugEnabled()) {
                log.debug("Expecting chain of " + certificateCount);
            }
            if (certificateCount <= 0) {
                throw new SshException("There are no certificats present in the public key blob", 17);
            }
            this.certs = new Certificate[certificateCount];
            for (int i = 0; i < certificateCount; ++i) {
                byte[] certBlob = reader.readBinaryString();
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                this.certs[i] = certFactory.generateCertificate(new ByteArrayInputStream(certBlob));
            }
            this.pub = (ECPublicKey)this.certs[0].getPublicKey();
        }
        catch (CertificateException ex) {
            throw new SshException("Failed to generate or read certificate from public key blob: " + ex.getMessage(), 5, ex);
        }
        catch (IOException ex) {
            throw new SshException("Failed to read public key blob; expected format " + this.getAlgorithm(), 5, ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public Certificate getCertificate() {
        return this.certs[0];
    }

    @Override
    public Certificate[] getCertificateChain() {
        return this.certs;
    }

    @Override
    public abstract String getAlgorithm();

    @Override
    public byte[] getEncoded() throws SshException {
        ByteArrayWriter writer = new ByteArrayWriter();
        try {
            writer.writeString(this.getAlgorithm());
            writer.writeInt(this.certs.length);
            for (Certificate c : this.certs) {
                writer.writeBinaryString(c.getEncoded());
            }
            writer.writeInt(0);
            byte[] byArray = writer.toByteArray();
            return byArray;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new SshException("Failed to encode certificate chain", 5, certificateEncodingException);
        }
        catch (IOException iOException) {
            throw new SshException("Failed to write certificate chain", 5, iOException);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }
}

