/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh;

import com.maverick.ssh.LicenseVerification;
import com.maverick.ssh.components.SshPublicKey;
import com.maverick.ssh.components.Utils;
import com.maverick.util.ByteArrayWriter;
import com.sshtools.publickey.SshPublicKeyFile;
import com.sshtools.publickey.SshPublicKeyFileFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Date;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LicenseVerification2 {
    String licensee;
    String license;
    String comments;
    String description;
    String hash;
    long expires;
    long created;
    String productName;
    long updatesUntil;
    public static final int EXPIRED = 1;
    public static final int INVALID = 2;
    public static final int OK = 4;
    public static final int NOT_LICENSED = 8;
    public static final int EXPIRED_MAINTENANCE = 16;
    static final int LICENSE_VERIFICATION_MASK = 31;
    static final int LICENSE_TYPE_MASK = -32;
    int status = 8;
    private static final String BEGIN_MARKER = "----BEGIN";
    private static final String END_MARKER = "----END";
    Date verifyDate;
    static Logger log = LoggerFactory.getLogger(LicenseVerification.class);

    LicenseVerification2(Date verifyDate) {
        this.verifyDate = verifyDate;
        this.loadLicenses();
    }

    LicenseVerification2() {
        this(new Date(System.currentTimeMillis()));
    }

    void loadLicenses() {
    }

    void loadLicense(InputStream in) throws IOException {
        String fullText = this.readToString(in);
        while (!fullText.startsWith(BEGIN_MARKER)) {
            fullText = fullText.substring(1);
        }
        while (!fullText.endsWith(END_MARKER)) {
            fullText = fullText.substring(0, fullText.length() - 1);
        }
        StringBuffer buf = new StringBuffer();
        boolean inQuote = false;
        boolean escape = false;
        for (int i = 0; i < fullText.length(); ++i) {
            int ch = fullText.charAt(i);
            if (ch == 34 && !inQuote && !escape) {
                inQuote = true;
                continue;
            }
            if (ch == 34 && inQuote && !escape) {
                inQuote = false;
                continue;
            }
            if (inQuote) {
                if (!escape && ch == 92) {
                    escape = true;
                    continue;
                }
                if (inQuote && escape) {
                    if (ch == 114) {
                        ch = 13;
                    } else if (ch == 110) {
                        ch = 10;
                    }
                    escape = false;
                }
                buf.append((char)ch);
                continue;
            }
            buf.append((char)ch);
        }
        this.license = buf.toString();
    }

    final void setLicense(String license) {
        this.license = license;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addLicense(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.license = this.readToString(in);
        }
        catch (IOException ex) {
            this.license = "";
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String readToString(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int read;
            while ((read = in.read()) > -1) {
                out.write(read);
            }
            String string = new String(out.toByteArray(), "UTF8");
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final int verifyLicense(long releaseDate) {
        try {
            if (Utils.isBlank(this.license)) {
                return this.status;
            }
            String productKey = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDakFlNnnzCmXX32gWPd6GxbsBZc6GyBMmKRaaCJOsBRX88DZmOPqHhsLKyuPKY0MFWLqw7rUiLy214oGs1SrPDC37qpm2BDVo1PVpnOE/kJN/DTx4PC/7ztndN+aqdUWnRSqtDQexGbIP7UZBLA5CtbfjBjr8nv5ZmBaIaBK1gZQLjvrAUBPbkZEyUNMjfByAxHZnHw6WAEcbYzoq0YbL3ngdl0evNp5xjwlysFP8UB4UyZVFOvcVR/HyFsEEAAMCKM9oeE01Y20k4P2ieGqj5uuQ4rxtPTOQS2btsgP0wXLVaMMRMrcKsCDRFJkXondh040/YgH+22oAQ7KbMfs/t";
            SshPublicKeyFile file = SshPublicKeyFileFactory.parse(productKey.getBytes("UTF8"));
            SshPublicKey key = file.toPublicKey();
            BufferedReader reader = new BufferedReader(new StringReader(this.license));
            String line = reader.readLine();
            if (!line.startsWith(BEGIN_MARKER)) {
                this.status = 2;
                return 2;
            }
            String licensee = "";
            String comments = "";
            String validfrom = null;
            StringBuffer keydataBuffer = new StringBuffer("");
            while ((line = reader.readLine()) != null && !line.startsWith(END_MARKER)) {
                int idx = line.indexOf(58);
                if (idx > -1) {
                    String header = line.substring(0, idx).trim();
                    String value = line.substring(idx + 1).trim();
                    if (header.equals("Licensee")) {
                        licensee = value;
                        log.debug(String.format("Licensee: %s", licensee));
                        continue;
                    }
                    if (header.equals("Comments")) {
                        comments = value;
                        log.debug(String.format("Comments: %s", comments));
                        continue;
                    }
                    if (header.equals("Created")) {
                        validfrom = value;
                        log.debug(String.format("Created: %s", validfrom));
                        continue;
                    }
                    if (header.equals("Type")) {
                        this.description = value;
                        log.debug(String.format("Type: %s", this.description));
                        continue;
                    }
                    if (header.equals("Product")) {
                        this.productName = value;
                        log.debug(String.format("Product: %s", this.productName));
                        continue;
                    }
                    if (header.equals("License Expires") || header.equals("Support Expires")) continue;
                    log.debug(String.format("Data: %s", header));
                    keydataBuffer.append(header);
                    for (int i = header.length(); i < 15; ++i) {
                        keydataBuffer.append(' ');
                    }
                    keydataBuffer.append(": " + value);
                    continue;
                }
                keydataBuffer.append(line);
            }
            String keydata = keydataBuffer.toString();
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            int pos = 0;
            while (pos < keydata.length()) {
                if (keydata.charAt(pos) == '\r' || keydata.charAt(pos) == '\n') {
                    ++pos;
                    continue;
                }
                buf.write(Integer.parseInt(keydata.substring(pos, pos + 2), 16));
                pos += 2;
            }
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(buf.toByteArray()));
            byte[] tmp = new byte[24];
            din.readFully(tmp);
            byte[] xor = new byte[]{55, -121, 33, 9, 68, 73, 11, -37, -39, -1, 12, 48, 99, 49, 11, 55, 0, 45, 12, 87, 25, 23, 21, 11};
            for (int i = 0; i < 24; ++i) {
                int n = i;
                tmp[n] = (byte)(tmp[n] ^ xor[i]);
            }
            DataInputStream din2 = new DataInputStream(new ByteArrayInputStream(tmp));
            long startdate = din2.readLong();
            long enddate = din2.readLong();
            long supportdate = din2.readLong();
            byte[] signature = new byte[din.available()];
            din.readFully(signature);
            this.expires = enddate;
            this.created = startdate;
            Vector<Integer> types = new Vector<Integer>();
            types.add(0);
            types.add(32);
            types.add(64);
            types.add(128);
            int i = 0;
            while (true) {
                if (i >= 23) {
                    log.debug("Sorry but license is invalid.");
                    this.status = 2;
                    return 2;
                }
                int type = 256 << i;
                for (Integer t : types) {
                    try (ByteArrayWriter dout = new ByteArrayWriter();){
                        dout.writeString(this.productName, "UTF-8");
                        dout.writeString("JADAPTIVE Limited", "UTF-8");
                        dout.writeString(comments, "UTF-8");
                        dout.writeString(licensee, "UTF-8");
                        dout.writeInt(type + t);
                        dout.writeString(this.description, "UTF-8");
                        dout.writeUINT64(startdate);
                        dout.writeUINT64(enddate);
                        dout.writeUINT64(supportdate);
                        if (enddate > this.verifyDate.getTime()) {
                            this.comments = comments;
                            this.licensee = licensee;
                            this.updatesUntil = supportdate;
                            byte[] s = dout.toByteArray();
                            log.trace(String.format("Verifying signature for type %d", type + t));
                            if (!key.verifySignature(signature, s)) continue;
                            if (type + t == 256 && enddate > supportdate) {
                                if (supportdate > 0L && releaseDate > supportdate) {
                                    log.debug("License is out of support");
                                    int n = this.status = 1 | type + t;
                                    return n;
                                }
                                log.debug("License is OK");
                                int n = this.status = 4 | type + t;
                                return n;
                            }
                            if (supportdate > 0L && releaseDate > supportdate) {
                                log.debug("License is out of support");
                                int n = this.status = 0x10 | type + t;
                                return n;
                            }
                            log.debug("License is OK");
                            int n = this.status = 4 | type + t;
                            return n;
                        }
                        log.debug("License is Expired");
                        int n = this.status = 1 | type + t;
                        return n;
                    }
                }
                ++i;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.status = 2;
            return 2;
        }
    }

    String getDescription() {
        return this.description;
    }

    String getComments() {
        return this.comments;
    }

    String getLicensee() {
        return this.licensee;
    }

    int getStatus() {
        return this.status & 0x1F;
    }

    int getType() {
        return this.status & 0xFFFFFFE0;
    }

    String getProduct() {
        return this.productName;
    }

    long getExpiryDate() {
        return this.expires;
    }

    String getHash() {
        return this.hash;
    }

    long getUpdatesUntil() {
        return this.updatesUntil;
    }

    boolean isPerpetual() {
        return this.expires == Long.MAX_VALUE;
    }

    long getCreated() {
        return this.created;
    }

    public boolean isValidStatus() {
        return this.getStatus() == 4 || this.getStatus() == 16;
    }

    public static boolean isModern(String license) {
        return license.contains("Support Expires");
    }
}

