/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh;

import com.maverick.ssh.AdaptiveConfiguration;
import com.maverick.ssh.DefaultSecurityPolicy;
import com.maverick.ssh.IncompatibleAlgorithm;
import com.maverick.ssh.SecurityLevel;
import com.maverick.ssh.SecurityPolicy;
import com.maverick.ssh.SshException;
import com.maverick.ssh.components.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveSecurityPolicy
implements SecurityPolicy {
    static Logger log = LoggerFactory.getLogger(DefaultSecurityPolicy.class);
    SecurityLevel minimumSecurity = this.getAdaptiveSecurityPolicy(SecurityLevel.WEAK, new String[0]);
    boolean managedSecurity = this.getManagedSecuritySetting(false, new String[0]);
    boolean dropSecurityAsLastResort = this.getDropSecuritySetting(false, new String[0]);

    private SecurityLevel getAdaptiveSecurityPolicy(SecurityLevel defaultValue, String ... matches) throws SshException {
        String tmp;
        switch (tmp = AdaptiveConfiguration.getProperty("SecurityLevel", defaultValue.name(), matches)) {
            case "PARANOID": 
            case "STRONG": 
            case "WEAK": {
                break;
            }
            default: {
                throw new SshException(4, "Invalid value " + tmp + " for SecurityLevel directive!");
            }
        }
        return SecurityLevel.valueOf(tmp);
    }

    @Override
    public void configure(String ... matches) throws SshException {
        this.minimumSecurity = this.getAdaptiveSecurityPolicy(this.minimumSecurity, matches);
        this.managedSecurity = this.getManagedSecuritySetting(this.managedSecurity, matches);
        this.dropSecurityAsLastResort = this.getDropSecuritySetting(this.dropSecurityAsLastResort, matches);
    }

    private boolean getManagedSecuritySetting(boolean defaultValue, String ... matches) {
        return AdaptiveConfiguration.getBoolean("ManagedSecurity", defaultValue, matches);
    }

    private boolean getDropSecuritySetting(boolean defaultValue, String ... matches) {
        return AdaptiveConfiguration.getBoolean("DropSecurityAsLastResort", defaultValue, matches);
    }

    @Override
    public SecurityLevel getMinimumSecurityLevel() {
        return this.minimumSecurity;
    }

    @Override
    public boolean isManagedSecurity() {
        return this.managedSecurity;
    }

    @Override
    public boolean isDropSecurityAsLastResort() {
        return this.dropSecurityAsLastResort;
    }

    @Override
    public void onIncompatibleSecurity(String host, int port, String remoteIdentification, IncompatibleAlgorithm ... reports) {
        log.error("Connection to {}:{} could not be established due to incompatible security protocols", (Object)host, (Object)port);
        log.error("The remote host identified itself as {}", (Object)remoteIdentification);
        log.error("The following algorithms could not be negotiated:");
        for (IncompatibleAlgorithm report : reports) {
            log.error("{} could not be negotiated from remote algorithms {}", (Object)report.getType().name(), (Object)Utils.csv(report.getRemoteAlgorithms()));
        }
    }
}

