/*
 * Decompiled with CFR 0.152.
 */
package com.didisoft.pgp.bc;

import com.didisoft.pgp.PGPException;
import com.didisoft.pgp.SecureRandomSource;
import com.didisoft.pgp.bc.DefaultSecureRandomSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import lw.bouncycastle.bcpg.ArmoredOutputStream;
import lw.bouncycastle.openpgp.PGPPublicKeyRing;
import lw.bouncycastle.openpgp.PGPSecretKeyRing;

public class IOUtil {
    private static SecureRandomSource randomSource = new DefaultSecureRandomSource();

    public static void closeStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean isPossiblyBase64(String string) {
        if (string == null || "".equals(string.trim())) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (IOUtil.isPossiblyBase64(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isPossiblyBase64(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57 || n == 43 || n == 47 || n == 13 || n == 10;
    }

    public static InputStream readFileOrAsciiString(String string, String string2) throws IOException {
        if (string != null && !"".equals(string.trim())) {
            if (string.indexOf("BEGIN") != -1 && string.indexOf("PGP") != -1 || string.length() >= 256 && IOUtil.isPossiblyBase64(string)) {
                return new ByteArrayInputStream(string.getBytes("ASCII"));
            }
            if (string.indexOf("\n") != -1 || string.indexOf("\r") != -1) {
                return new ByteArrayInputStream(string.getBytes("UTF-8"));
            }
            if (new File(string).exists()) {
                return new BufferedInputStream(new FileInputStream(string));
            }
            throw new FileNotFoundException("File not found at the specified location: " + string);
        }
        throw new IllegalArgumentException(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exportPublicKeyRing(PGPPublicKeyRing pGPPublicKeyRing, String string, boolean bl, String string2) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            IOUtil.exportPublicKeyRing(pGPPublicKeyRing, fileOutputStream, bl, string2);
            Object var6_5 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.flush();
            try {
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        fileOutputStream.flush();
        try {
            ((OutputStream)fileOutputStream).close();
            return;
        }
        catch (IOException iOException) {}
    }

    /*
     * Loose catch block
     */
    public static void exportPublicKeyRing(PGPPublicKeyRing pGPPublicKeyRing, OutputStream outputStream, boolean bl, String string) throws IOException {
        block12: {
            OutputStream outputStream2;
            block11: {
                outputStream2 = null;
                if (bl) {
                    outputStream2 = outputStream;
                    outputStream = new ArmoredOutputStream(outputStream);
                    ((ArmoredOutputStream)outputStream).setHeader("Version", string);
                }
                pGPPublicKeyRing.encode(outputStream);
                Object var7_5 = null;
                if (outputStream == null) break block11;
                outputStream.flush();
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (outputStream2 != null) {
                outputStream2.close();
            }
            break block12;
            {
                catch (IOException iOException) {
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (outputStream != null) {
                    outputStream.flush();
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (outputStream2 != null) {
                    outputStream2.close();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public static void exportPrivateKey(PGPSecretKeyRing pGPSecretKeyRing, String string, boolean bl, String string2) throws IOException {
        block15: {
            IOException iOException2222;
            FileOutputStream fileOutputStream;
            FileOutputStream fileOutputStream2;
            block14: {
                fileOutputStream2 = null;
                fileOutputStream = null;
                fileOutputStream2 = new FileOutputStream(string);
                if (bl) {
                    fileOutputStream = fileOutputStream2;
                    fileOutputStream2 = new ArmoredOutputStream((OutputStream)fileOutputStream2);
                    ((ArmoredOutputStream)fileOutputStream2).setHeader("Version", string2);
                }
                pGPSecretKeyRing.encode((OutputStream)fileOutputStream2);
                Object var8_6 = null;
                if (fileOutputStream2 == null) break block14;
                try {
                    fileOutputStream2.flush();
                    ((OutputStream)fileOutputStream2).close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException2222) {}
            }
            break block15;
            {
                catch (IOException iOException3) {
                    throw iOException3;
                }
            }
            catch (Throwable throwable) {
                IOException iOException42222;
                Object var8_7 = null;
                if (fileOutputStream2 != null) {
                    try {
                        fileOutputStream2.flush();
                        ((OutputStream)fileOutputStream2).close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.flush();
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public static void exportPrivateKey(PGPSecretKeyRing pGPSecretKeyRing, OutputStream outputStream, boolean bl, String string) throws IOException {
        block15: {
            IOException iOException2222;
            OutputStream outputStream2;
            block14: {
                outputStream2 = null;
                if (bl) {
                    outputStream2 = outputStream;
                    outputStream = new ArmoredOutputStream(outputStream);
                    ((ArmoredOutputStream)outputStream).setHeader("Version", string);
                }
                pGPSecretKeyRing.encode(outputStream);
                Object var7_5 = null;
                if (outputStream == null) break block14;
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (bl) {
                try {
                    outputStream2.flush();
                    outputStream2.close();
                }
                catch (IOException iOException2222) {}
            }
            break block15;
            {
                catch (IOException iOException3) {
                    throw iOException3;
                }
            }
            catch (Throwable throwable) {
                IOException iOException42222;
                Object var7_6 = null;
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                if (bl) {
                    try {
                        outputStream2.flush();
                        outputStream2.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public static PGPException newPGPException(lw.bouncycastle.openpgp.PGPException pGPException) {
        if (pGPException instanceof PGPException) {
            return (PGPException)pGPException;
        }
        return new PGPException(pGPException.getMessage() + (pGPException.getUnderlyingException() != null ? " : " + pGPException.getUnderlyingException().getMessage() : ""), pGPException.getUnderlyingException());
    }

    public static SecureRandom getSecureRandom() {
        return IOUtil.getRandomSource().getSecureRandom();
    }

    public static SecureRandomSource getRandomSource() {
        return randomSource;
    }

    public static void setRandomSource(SecureRandomSource secureRandomSource) {
        if (secureRandomSource == null) {
            throw new IllegalArgumentException("Parameter randomSource cannot be null!");
        }
        randomSource = secureRandomSource;
    }
}

