/*
 * Decompiled with CFR 0.152.
 */
package com.didisoft.pgp.bc;

import java.io.IOException;
import java.io.InputStream;

public class AsciiStringInputStream
extends InputStream {
    private String str = null;
    private static final int READ_COUNT = 1024;
    private byte[] buffer = new byte[4096];
    private int strPos = 0;
    private int bufferPos = 0;
    private int bufferLen = 0;

    public AsciiStringInputStream(String string) {
        this.str = string;
        try {
            this.fillBuffer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fillBuffer() throws IOException {
        int n = this.strPos + 1024 >= this.str.length() ? this.str.length() : this.strPos + 1024;
        byte[] byArray = new byte[n - this.strPos];
        this.str.getBytes(this.strPos, n, byArray, 0);
        System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
        this.strPos = n;
        this.bufferPos = 0;
        this.bufferLen = byArray.length;
        byArray = null;
    }

    private boolean stringEnded() {
        return this.strPos >= this.str.length();
    }

    public int read() throws IOException {
        if (this.bufferPos < this.bufferLen) {
            byte by = this.buffer[this.bufferPos];
            ++this.bufferPos;
            return by;
        }
        if (this.strPos >= this.str.length()) {
            return -1;
        }
        this.fillBuffer();
        byte by = this.buffer[this.bufferPos];
        ++this.bufferPos;
        return by;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.bufferLen - this.bufferPos;
        if (n3 > n2) {
            System.arraycopy(this.buffer, this.bufferPos, byArray, n, n2);
            this.bufferPos += n2;
            return n2;
        }
        int n4 = 0;
        while (n3 < n2 && !this.stringEnded()) {
            System.arraycopy(this.buffer, this.bufferPos, byArray, n, n3);
            n2 -= n3;
            n += n3;
            n4 += n3;
            this.fillBuffer();
            n3 = this.bufferLen - this.bufferPos;
        }
        if (n3 > 0 && n2 > 0) {
            System.arraycopy(this.buffer, this.bufferPos, byArray, n, n3);
            this.bufferPos += n3;
            n4 += n3;
        }
        return n4;
    }
}

