/*
 * Decompiled with CFR 0.152.
 */
package com.didisoft.pgp;

import com.didisoft.pgp.CompressionAlgorithm;
import com.didisoft.pgp.CypherAlgorithm;
import com.didisoft.pgp.HashAlgorithm;
import com.didisoft.pgp.KeyPairInformation;
import com.didisoft.pgp.KeyStore;
import com.didisoft.pgp.PGPException;
import com.didisoft.pgp.PGPKeyPair;
import com.didisoft.pgp.SignatureCheckResult;
import com.didisoft.pgp.bc.BCFactory;
import com.didisoft.pgp.bc.BaseLib;
import com.didisoft.pgp.bc.DirectByteArrayOutputStream;
import com.didisoft.pgp.bc.DummyStream;
import com.didisoft.pgp.bc.IOUtil;
import com.didisoft.pgp.bc.PGP2xPBEEncryptedData;
import com.didisoft.pgp.bc.PGPObjectFactory2;
import com.didisoft.pgp.bc.PGPPublicKeyExt;
import com.didisoft.pgp.exceptions.DetachedSignatureException;
import com.didisoft.pgp.exceptions.FileIsEncryptedException;
import com.didisoft.pgp.exceptions.FileIsPBEEncryptedException;
import com.didisoft.pgp.exceptions.IntegrityCheckException;
import com.didisoft.pgp.exceptions.KeyIsExpiredException;
import com.didisoft.pgp.exceptions.KeyIsRevokedException;
import com.didisoft.pgp.exceptions.NoPrivateKeyFoundException;
import com.didisoft.pgp.exceptions.NoPublicKeyFoundException;
import com.didisoft.pgp.exceptions.NonPGPDataException;
import com.didisoft.pgp.exceptions.WrongPasswordException;
import com.didisoft.pgp.exceptions.WrongPrivateKeyException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.security.SignatureException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import lw.bouncycastle.bcpg.ArmoredInputStream;
import lw.bouncycastle.bcpg.ArmoredOutputStream;
import lw.bouncycastle.bcpg.BCPGOutputStream;
import lw.bouncycastle.openpgp.PGPCompressedData;
import lw.bouncycastle.openpgp.PGPCompressedDataGenerator;
import lw.bouncycastle.openpgp.PGPDataValidationException;
import lw.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import lw.bouncycastle.openpgp.PGPEncryptedDataList;
import lw.bouncycastle.openpgp.PGPLiteralData;
import lw.bouncycastle.openpgp.PGPLiteralDataGenerator;
import lw.bouncycastle.openpgp.PGPMarker;
import lw.bouncycastle.openpgp.PGPObjectFactory;
import lw.bouncycastle.openpgp.PGPOnePassSignature;
import lw.bouncycastle.openpgp.PGPOnePassSignatureList;
import lw.bouncycastle.openpgp.PGPPBEEncryptedData;
import lw.bouncycastle.openpgp.PGPPrivateKey;
import lw.bouncycastle.openpgp.PGPPublicKey;
import lw.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import lw.bouncycastle.openpgp.PGPPublicKeyRing;
import lw.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import lw.bouncycastle.openpgp.PGPSecretKey;
import lw.bouncycastle.openpgp.PGPSecretKeyRing;
import lw.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import lw.bouncycastle.openpgp.PGPSignature;
import lw.bouncycastle.openpgp.PGPSignatureGenerator;
import lw.bouncycastle.openpgp.PGPSignatureList;
import lw.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import lw.bouncycastle.openpgp.PGPUtil;
import lw.bouncycastle.openpgp.PGPV3SignatureGenerator;
import lw.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPLib
extends BaseLib {
    private static final String DEFAULT_MESSAGE_FILE_NAME = "message.txt";
    private BCFactory bcFactory = new BCFactory(false);
    private static final int LEGACY_RSA_KEY = 3;
    private List<Integer> hash = new LinkedList<Integer>();
    private List<Integer> cypher = new LinkedList<Integer>();
    private String hashString = "";
    private String cypherString = "";
    private List<Integer> compression = new LinkedList<Integer>();
    private String compressionString = "";
    private boolean useExpiredKeys = false;
    private boolean useRevokedKeys = false;
    private static final Logger log = Logger.getLogger(PGPLib.class.getName());
    private String asciiVersionHeader = null;
    private char contentType = (char)98;
    private Level debugLevel = Level.FINE;
    protected boolean pgp2Compatible = false;
    private boolean extractEmbeddedTar = true;
    private boolean overrideKeyAlgorithmPreferences = false;
    private boolean integrityProtect = true;
    private ArrayList masterKeysList = new ArrayList();

    public PGPLib() {
        this.asciiVersionHeader = version;
        this.cypher.add(9);
        this.compression.add(1);
        this.hash.add(8);
        this.syncCypherString();
        this.syncCompressionString();
    }

    private void syncHashString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.hash.size(); ++i) {
            stringBuilder.append(HashAlgorithm.Enum.fromInt(this.hash.get(i)).name());
            if (i >= this.hash.size() - 1) continue;
            stringBuilder.append(",");
        }
        this.hashString = stringBuilder.toString();
        this.Debug("Preferred hash(es) set to {0}", this.hashString);
    }

    private void syncCypherString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.cypher.size(); ++i) {
            stringBuilder.append(CypherAlgorithm.Enum.fromInt(this.cypher.get(i)).name());
            if (i >= this.cypher.size() - 1) continue;
            stringBuilder.append(",");
        }
        this.cypherString = stringBuilder.toString();
        this.Debug("Preferred cypher(s) set to {0}", this.cypherString);
    }

    private void syncCompressionString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.compression.size(); ++i) {
            stringBuilder.append(HashAlgorithm.Enum.fromInt(this.compression.get(i)).name());
            if (i >= this.compression.size() - 1) continue;
            stringBuilder.append(",");
        }
        this.compressionString = stringBuilder.toString();
        this.Debug("Preferred compression(s) set to {0}", this.compressionString);
    }

    public int getMasterKeysCount() {
        return this.masterKeysList.size();
    }

    public KeyPairInformation getMasterKey(int n) {
        if (n < 0 || n > this.getMasterKeysCount() - 1) {
            throw new IndexOutOfBoundsException();
        }
        return (KeyPairInformation)this.masterKeysList.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPairInformation addMasterKey(String string) throws IOException, lw.bouncycastle.openpgp.PGPException {
        InputStream inputStream = null;
        try {
            inputStream = PGPLib.readFileOrAsciiString(string, "publicKeyFileName");
            KeyPairInformation keyPairInformation = this.addMasterKey(inputStream);
            return keyPairInformation;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public KeyPairInformation addMasterKey(InputStream inputStream) throws IOException, lw.bouncycastle.openpgp.PGPException {
        PGPPublicKey pGPPublicKey = this.readPublicKeyForEncryption(inputStream);
        KeyPairInformation keyPairInformation = new KeyPairInformation(new PGPPublicKeyRing(pGPPublicKey.getEncoded(), staticBCFactory.CreateKeyFingerPrintCalculator()));
        this.masterKeysList.add(keyPairInformation);
        return keyPairInformation;
    }

    public KeyPairInformation addMasterKey(KeyPairInformation keyPairInformation) {
        this.masterKeysList.add(keyPairInformation);
        return keyPairInformation;
    }

    public void deleteMasterKey(int n) {
        if (n < 0 || n > this.getMasterKeysCount() - 1) {
            throw new IndexOutOfBoundsException();
        }
        this.masterKeysList.remove(n);
    }

    public char getContentType() {
        return this.contentType;
    }

    public void setContentType(char c) {
        if ('b' != c && 't' != c && 'u' != c) {
            this.Debug("Invalid content type {0}", String.valueOf(c));
            this.Debug("Content type remains {0}", String.valueOf(this.contentType));
            return;
        }
        this.contentType = c;
        this.Debug("Content type set to {0}", String.valueOf(this.contentType));
    }

    public Level getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebuglevel(Level level) {
        this.debugLevel = level;
    }

    public boolean isUseExpiredKeys() {
        return this.useExpiredKeys;
    }

    public void setUseExpiredKeys(boolean bl) {
        this.useExpiredKeys = bl;
    }

    public boolean isUseRevokedKeys() {
        return this.useRevokedKeys;
    }

    public void setUseRevokedKeys(boolean bl) {
        this.useRevokedKeys = bl;
    }

    public void setHash(String string) {
        List<Integer> list = KeyStore.listOfPrefferedHashes(string);
        if (list.contains(-1)) {
            throw new InvalidParameterException("Wrong value for parameter 'hash': " + string + ". Must be one of: SHA1, SHA256, SHA224, SHA384, SHA512, MD5");
        }
        this.hash = list;
        this.syncHashString();
        this.Debug("Preferred hash set to {0}", this.hashString);
    }

    public void setHash(HashAlgorithm.Enum enum_) {
        this.hash.clear();
        this.hash.add(enum_.intValue());
        this.Debug("Preferred hash set to {0}", enum_.name());
    }

    public void setHash(HashAlgorithm.Enum[] enumArray) {
        if (enumArray == null || enumArray.length == 0) {
            throw new InvalidParameterException("Parameter 'hashes' cannot be empty");
        }
        this.hash.clear();
        for (int i = 0; i < enumArray.length; ++i) {
            this.hash.add(enumArray[i].intValue());
        }
        this.syncHashString();
    }

    public String getHash() {
        if (this.hash.size() > 0) {
            return HashAlgorithm.Enum.fromInt(this.hash.get(0)).name();
        }
        return "";
    }

    public HashAlgorithm.Enum getHashEnum() {
        if (this.hash.size() > 0) {
            return HashAlgorithm.Enum.fromInt(this.hash.get(0));
        }
        return null;
    }

    public HashAlgorithm.Enum[] getHashes() {
        LinkedList<HashAlgorithm.Enum> linkedList = new LinkedList<HashAlgorithm.Enum>();
        for (int i = 0; i < this.hash.size(); ++i) {
            linkedList.add(HashAlgorithm.Enum.fromInt(this.hash.get(i)));
        }
        return linkedList.toArray(new HashAlgorithm.Enum[linkedList.size()]);
    }

    public String getCypher() {
        return this.cypherString;
    }

    public CypherAlgorithm.Enum[] getCyphers() {
        LinkedList<CypherAlgorithm.Enum> linkedList = new LinkedList<CypherAlgorithm.Enum>();
        for (int i = 0; i < this.cypher.size(); ++i) {
            linkedList.add(CypherAlgorithm.Enum.fromInt(this.cypher.get(i)));
        }
        return linkedList.toArray(new CypherAlgorithm.Enum[linkedList.size()]);
    }

    public void setCypher(String string) {
        List<Integer> list = KeyStore.listOfPrefferedCyphers(string);
        if (list.contains(-1)) {
            throw new InvalidParameterException("Wrong value for parameter 'cypher': " + string + ". Must be one of: TRIPLE_DES, CAST5, BLOWFISH, AES_128, AES_192, AES_256, TWOFISH, DES, IDEA, SAFER");
        }
        this.cypher = list;
        this.syncCypherString();
    }

    public void setCyphers(CypherAlgorithm.Enum[] enumArray) {
        if (enumArray == null || enumArray.length == 0) {
            throw new InvalidParameterException("Parameter 'cyphers' cannot be empty");
        }
        this.cypher.clear();
        for (int i = 0; i < enumArray.length; ++i) {
            this.cypher.add(enumArray[i].intValue());
        }
        this.syncCypherString();
    }

    public String getAsciiCommentHeader() {
        return "";
    }

    public String getAsciiVersionHeader() {
        return "Version: " + this.asciiVersionHeader;
    }

    public void setAsciiVersionHeader(String string) {
        this.Debug("ASCII version header set to " + string);
        this.asciiVersionHeader = string;
    }

    protected void setAsciiVersionHeader(OutputStream outputStream) {
        if (outputStream instanceof ArmoredOutputStream) {
            ((ArmoredOutputStream)outputStream).setHeader("Version", this.asciiVersionHeader);
        }
    }

    public String getCompression() {
        return this.compressionString;
    }

    public CompressionAlgorithm.Enum[] getCompressions() {
        LinkedList<CompressionAlgorithm.Enum> linkedList = new LinkedList<CompressionAlgorithm.Enum>();
        for (int i = 0; i < this.compression.size(); ++i) {
            linkedList.add(CompressionAlgorithm.Enum.fromInt(this.compression.get(i)));
        }
        return linkedList.toArray(new CompressionAlgorithm.Enum[linkedList.size()]);
    }

    public void setCompression(String string) {
        List<Integer> list = KeyStore.listOfPrefferedCompressions(string);
        if (list.contains(-1)) {
            throw new InvalidParameterException("Wrong value for parameter 'compressions': " + string + ". Must be one of: ZIP, ZLIB, UNCOMPRESSED, BZIP2");
        }
        this.compression = list;
        this.syncCompressionString();
    }

    public void setCompressions(CompressionAlgorithm.Enum[] enumArray) {
        if (enumArray == null || enumArray.length == 0) {
            throw new InvalidParameterException("Parameter 'compressions' cannot be empty");
        }
        this.compression.clear();
        for (int i = 0; i < enumArray.length; ++i) {
            this.compression.add(enumArray[i].intValue());
        }
        this.syncCompressionString();
    }

    public boolean detachedVerifyStream(InputStream inputStream, InputStream inputStream2, InputStream inputStream3) throws PGPException, IOException {
        InputStream inputStream4 = PGPUtil.getDecoderStream((InputStream)(inputStream2 = PGPLib.cleanGnuPGBackupKeys(inputStream2)));
        if (inputStream4 instanceof ArmoredInputStream) {
            ((ArmoredInputStream)inputStream4).setDetectMissingCRC(false);
        }
        PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream4);
        Object object = null;
        try {
            object = pGPObjectFactory.nextObject();
        }
        catch (IOException iOException) {
            throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
        }
        if (object instanceof PGPSignatureList) {
            PGPSignatureList pGPSignatureList = (PGPSignatureList)object;
            PGPSignature pGPSignature = null;
            PGPPublicKey pGPPublicKey = null;
            for (int i = 0; i < pGPSignatureList.size(); ++i) {
                pGPSignature = pGPSignatureList.get(i);
                if (pGPSignature == null) {
                    throw new NonPGPDataException("The supplied data is not a valid OpenPGP message: no signature in signature list");
                }
                pGPPublicKey = this.readPublicVerificationKey(inputStream3, pGPSignature.getKeyID());
                if (pGPPublicKey != null) break;
            }
            if (pGPPublicKey == null) {
                return false;
            }
            try {
                int n;
                this.bcFactory.initVerify(pGPSignature, pGPPublicKey);
                byte[] byArray = new byte[65536];
                while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    pGPSignature.update(byArray, 0, n);
                }
                return pGPSignature.verify();
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
        }
        throw new PGPException("Unknown message format: " + object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult detachedVerify(String string, String string2, String string3, String string4) throws IOException, PGPException, FileIsEncryptedException {
        if (string == null) {
            throw new IllegalArgumentException("The data parameter cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The signature parameter cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            SignatureCheckResult signatureCheckResult;
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes(string4));
            inputStream = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            inputStream2 = PGPLib.readFileOrAsciiString(string3, "publicKeyFile");
            SignatureCheckResult signatureCheckResult2 = signatureCheckResult = this.detachedVerify((InputStream)byteArrayInputStream, inputStream, inputStream2);
            return signatureCheckResult2;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult detachedVerify(String string, String string2, KeyStore keyStore, String string3) throws IOException, PGPException, FileIsEncryptedException {
        if (string == null) {
            throw new IllegalArgumentException("The data parameter cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The signature parameter cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = null;
        InputStream inputStream = null;
        try {
            SignatureCheckResult signatureCheckResult;
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes(string3));
            inputStream = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            SignatureCheckResult signatureCheckResult2 = signatureCheckResult = this.detachedVerify((InputStream)byteArrayInputStream, inputStream, keyStore);
            return signatureCheckResult2;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean detachedVerifyString(String string, String string2, String string3) throws IOException, PGPException, FileIsEncryptedException {
        return this.detachedVerifyString(string, string2, string3, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detachedVerifyString(String string, String string2, String string3, String string4) throws IOException, PGPException, FileIsEncryptedException {
        if (string == null) {
            throw new IllegalArgumentException("The data parameter cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The signature parameter cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            boolean bl;
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes(string4));
            inputStream = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            inputStream2 = PGPLib.readFileOrAsciiString(string3, "publicKeyFile");
            boolean bl2 = bl = this.detachedVerifyStream((InputStream)byteArrayInputStream, inputStream, inputStream2);
            return bl2;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean detachedVerifyString(String string, String string2, KeyStore keyStore) throws IOException, PGPException, FileIsEncryptedException {
        return this.detachedVerifyString(string, string2, keyStore, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detachedVerifyString(String string, String string2, KeyStore keyStore, String string3) throws IOException, PGPException, FileIsEncryptedException {
        if (string == null) {
            throw new IllegalArgumentException("The data parameter cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The signature parameter cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = null;
        InputStream inputStream = null;
        try {
            boolean bl;
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes(string3));
            inputStream = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            boolean bl2 = bl = this.detachedVerifyStream((InputStream)byteArrayInputStream, inputStream, keyStore);
            return bl2;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean detachedVerifyStream(InputStream inputStream, InputStream inputStream2, KeyStore keyStore) throws PGPException, IOException {
        InputStream inputStream3 = PGPLib.cleanGnuPGBackupKeys(inputStream2);
        InputStream inputStream4 = PGPUtil.getDecoderStream((InputStream)inputStream3);
        PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream4);
        Object object = null;
        try {
            object = pGPObjectFactory.nextObject();
        }
        catch (IOException iOException) {
            inputStream3.close();
            inputStream4.close();
            throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
        }
        if (object instanceof PGPSignatureList) {
            try {
                int n;
                int n2;
                this.Debug("Detached signature found");
                PGPSignatureList pGPSignatureList = (PGPSignatureList)object;
                PGPSignature pGPSignature = null;
                PGPPublicKey pGPPublicKey = null;
                for (n2 = 0; n2 < pGPSignatureList.size(); ++n2) {
                    pGPSignature = pGPSignatureList.get(n2);
                    this.Debug("Detached signature for key ID {0}", KeyPairInformation.keyId2Hex(pGPSignature.getKeyID()));
                    pGPPublicKey = PGPLib.readPublicVerificationKey(keyStore, pGPSignature.getKeyID());
                    if (pGPPublicKey != null) break;
                }
                if (pGPPublicKey == null) {
                    this.Debug("No matching public key found");
                    n2 = 0;
                    return n2 != 0;
                }
                this.bcFactory.initVerify(pGPSignature, pGPPublicKey);
                byte[] byArray = new byte[65536];
                while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    pGPSignature.update(byArray, 0, n);
                }
                if (pGPSignature.verify()) {
                    this.Debug("Signature verified");
                    boolean bl = true;
                    return bl;
                }
                this.Debug("Signature cannot be verified. Probably is tampered.");
                boolean bl = false;
                return bl;
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
            finally {
                inputStream3.close();
                inputStream4.close();
            }
        }
        inputStream3.close();
        inputStream4.close();
        throw new PGPException("Unknown message format: " + object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult detachedVerify(String string, String string2, String string3) throws PGPException, IOException {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        InputStream inputStream3 = null;
        try {
            inputStream = PGPLib.readFileOrAsciiString(string, "message");
            inputStream2 = PGPLib.readFileOrAsciiString(string3, "publicKeyFile");
            inputStream3 = PGPLib.readFileOrAsciiString(string2, "detachedSignature");
            SignatureCheckResult signatureCheckResult = this.detachedVerify(inputStream, inputStream3, inputStream2);
            return signatureCheckResult;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream3 != null) {
                try {
                    inputStream3.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult detachedVerify(String string, String string2, KeyStore keyStore) throws PGPException, IOException {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            inputStream = PGPLib.readFileOrAsciiString(string, "message");
            inputStream2 = PGPLib.readFileOrAsciiString(string2, "detachedSignature");
            SignatureCheckResult signatureCheckResult = this.detachedVerify(inputStream, inputStream2, keyStore);
            return signatureCheckResult;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public SignatureCheckResult detachedVerify(InputStream inputStream, InputStream inputStream2, InputStream inputStream3) throws PGPException, IOException {
        InputStream inputStream4 = PGPUtil.getDecoderStream((InputStream)inputStream2);
        PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream4);
        Object object = null;
        try {
            object = pGPObjectFactory.nextObject();
        }
        catch (IOException iOException) {
            throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
        }
        if (object instanceof PGPSignatureList) {
            PGPSignatureList pGPSignatureList = (PGPSignatureList)object;
            PGPSignature pGPSignature = null;
            PGPPublicKey pGPPublicKey = null;
            for (int i = 0; i < pGPSignatureList.size() && (pGPPublicKey = this.readPublicVerificationKey(inputStream3, (pGPSignature = pGPSignatureList.get(i)).getKeyID())) == null; ++i) {
            }
            if (pGPPublicKey == null) {
                return SignatureCheckResult.PublicKeyNotMatching;
            }
            try {
                int n;
                pGPSignature.init(this.bcFactory.CreatePGPContentVerifierBuilderProvider(), pGPPublicKey);
                byte[] byArray = new byte[65536];
                while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    pGPSignature.update(byArray, 0, n);
                }
                if (pGPSignature.verify()) {
                    return SignatureCheckResult.SignatureVerified;
                }
                return SignatureCheckResult.SignatureBroken;
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
        }
        throw new PGPException("Unknown message format: " + object);
    }

    public SignatureCheckResult detachedVerify(InputStream inputStream, InputStream inputStream2, KeyStore keyStore) throws PGPException, IOException {
        InputStream inputStream3 = PGPUtil.getDecoderStream((InputStream)inputStream2);
        PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream3);
        Object object = null;
        try {
            object = pGPObjectFactory.nextObject();
        }
        catch (IOException iOException) {
            throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
        }
        if (object instanceof PGPSignatureList) {
            this.Debug("Detached signature found");
            PGPSignatureList pGPSignatureList = (PGPSignatureList)object;
            PGPSignature pGPSignature = null;
            PGPPublicKey pGPPublicKey = null;
            for (int i = 0; i < pGPSignatureList.size(); ++i) {
                pGPSignature = pGPSignatureList.get(i);
                this.Debug("Detached signature for key ID {0}", KeyPairInformation.keyId2Hex(pGPSignature.getKeyID()));
                pGPPublicKey = PGPLib.readPublicVerificationKey(keyStore, pGPSignature.getKeyID());
                if (pGPPublicKey != null) break;
            }
            if (pGPPublicKey == null) {
                this.Debug("No matching public key found");
                return SignatureCheckResult.PublicKeyNotMatching;
            }
            try {
                int n;
                pGPSignature.init(this.bcFactory.CreatePGPContentVerifierBuilderProvider(), pGPPublicKey);
                byte[] byArray = new byte[65536];
                while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    pGPSignature.update(byArray, 0, n);
                }
                if (pGPSignature.verify()) {
                    this.Debug("Signature verified");
                    return SignatureCheckResult.SignatureVerified;
                }
                this.Debug("Signature verified failed. Probably it was tampered.");
                return SignatureCheckResult.SignatureBroken;
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
        }
        throw new PGPException("Unknown message format: " + object);
    }

    public void detachedSignFile(String string, String string2, String string3, String string4, boolean bl) throws PGPException, IOException {
        FileInputStream fileInputStream = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        boolean bl2 = false;
        try {
            fileInputStream = new FileInputStream(string);
            inputStream = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
            outputStream = new FileOutputStream(string4);
            this.detachedSignStream(fileInputStream, inputStream, string3, outputStream, bl);
        }
        catch (PGPException pGPException) {
            bl2 = true;
            throw pGPException;
        }
        catch (IOException iOException) {
            bl2 = true;
            throw iOException;
        }
        finally {
            File file;
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bl2 && (file = new File(string4)).exists()) {
                file.delete();
            }
        }
    }

    public void detachedSignFile(String string, KeyStore keyStore, long l, String string2, String string3, boolean bl) throws PGPException, IOException {
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        boolean bl2 = false;
        try {
            fileInputStream = new FileInputStream(string);
            outputStream = new FileOutputStream(string3);
            this.detachedSignStream((InputStream)fileInputStream, keyStore, l, string2, outputStream, bl);
        }
        catch (PGPException pGPException) {
            bl2 = true;
            throw pGPException;
        }
        catch (IOException iOException) {
            bl2 = true;
            throw iOException;
        }
        finally {
            File file;
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
            outputStream.flush();
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bl2 && (file = new File(string3)).exists()) {
                file.delete();
            }
        }
    }

    public void detachedSignFile(String string, KeyStore keyStore, String string2, String string3, String string4, boolean bl) throws PGPException, IOException {
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        boolean bl2 = false;
        try {
            fileInputStream = new FileInputStream(string);
            outputStream = new FileOutputStream(string4);
            this.detachedSignStream((InputStream)fileInputStream, keyStore, string2, string3, outputStream, bl);
        }
        catch (PGPException pGPException) {
            bl2 = true;
            throw pGPException;
        }
        catch (IOException iOException) {
            bl2 = true;
            throw iOException;
        }
        finally {
            File file;
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bl2 && (file = new File(string4)).exists()) {
                file.delete();
            }
        }
    }

    public void detachedSignStream(InputStream inputStream, InputStream inputStream2, String string, OutputStream outputStream, boolean bl) throws PGPException, IOException {
        PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
        this.internalDetachedSignStream(inputStream, pGPSecretKey, string, outputStream, bl);
    }

    protected void internalDetachedSignStream(InputStream inputStream, PGPSecretKey pGPSecretKey, String string, OutputStream outputStream, boolean bl) throws PGPException, IOException {
        OutputStream outputStream2 = null;
        if (bl) {
            outputStream2 = outputStream;
            outputStream = new ArmoredOutputStream(outputStream2);
            this.setAsciiVersionHeader(outputStream);
        }
        BCPGOutputStream bCPGOutputStream = null;
        PGPV3SignatureGenerator pGPV3SignatureGenerator = null;
        try {
            PGPPrivateKey pGPPrivateKey = PGPLib.extractPrivateKey(pGPSecretKey, string);
            int n = this.selectPreferredHash();
            if (this.pgp2Compatible) {
                n = 1;
            }
            this.Debug("Signing with private key {0}", KeyPairInformation.keyId2Hex(pGPPrivateKey.getKeyID()));
            this.Debug("Signature has is {0}", KeyStore.hashToString(n));
            pGPV3SignatureGenerator = this.bcFactory.CreatePGPV3SignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), n);
            this.bcFactory.initSign(pGPV3SignatureGenerator, 0, pGPPrivateKey);
            bCPGOutputStream = new BCPGOutputStream(outputStream);
            byte[] byArray = new byte[65536];
            int n2 = 0;
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) > 0) {
                pGPV3SignatureGenerator.update(byArray, 0, n2);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (pGPV3SignatureGenerator != null) {
                pGPV3SignatureGenerator.generate().encode((OutputStream)bCPGOutputStream);
            }
            if (bCPGOutputStream != null) {
                try {
                    bCPGOutputStream.flush();
                    bCPGOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            outputStream.flush();
            if (bl && outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
    }

    public void detachedSignStream(InputStream inputStream, KeyStore keyStore, long l, String string, OutputStream outputStream, boolean bl) throws PGPException, IOException {
        PGPSecretKey pGPSecretKey = this.readSecretSigningKey(keyStore, l);
        this.internalDetachedSignStream(inputStream, pGPSecretKey, string, outputStream, bl);
    }

    public void detachedSignStream(InputStream inputStream, KeyStore keyStore, String string, String string2, OutputStream outputStream, boolean bl) throws PGPException, NoPrivateKeyFoundException, IOException {
        long l = keyStore.getKeyIdForUserId(string);
        if (l < 0L) {
            throw new NoPrivateKeyFoundException("No private key pair was found with Id: " + string);
        }
        PGPSecretKey pGPSecretKey = this.readSecretSigningKey(keyStore, keyStore.getKeyIdForUserId(string));
        this.internalDetachedSignStream(inputStream, pGPSecretKey, string2, outputStream, bl);
    }

    public void clearSignStream(InputStream inputStream, InputStream inputStream2, String string, String string2, OutputStream outputStream) throws PGPException, IOException, WrongPasswordException {
        this.Debug("Clear text signing stream");
        BufferedInputStream bufferedInputStream = null;
        InputStream inputStream3 = null;
        BufferedOutputStream bufferedOutputStream = null;
        int n = KeyStore.parseHashAlgorithm(string2);
        if (n < 0) {
            throw new InvalidParameterException("Wrong value for parameter 'hashingAlgorithm': " + string2 + ". Must be one of: SHA256, SHA384, SHA512, SHA224, SHA1, MD5, RIPEMD160, MD2");
        }
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            inputStream3 = inputStream2;
            bufferedOutputStream = new BufferedOutputStream(outputStream);
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream3);
            clearSignedHelper.sign(bufferedInputStream, pGPSecretKey, string, n, bufferedOutputStream);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public void clearSignFile(String string, String string2, String string3, String string4, String string5) throws PGPException, IOException, WrongPasswordException {
        this.Debug("Clear text signing file {0}", string);
        this.Debug("Output file is {0}", string5);
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        OutputStream outputStream = null;
        boolean bl = false;
        int n = KeyStore.parseHashAlgorithm(string4);
        if (n < 0) {
            throw new InvalidParameterException("Wrong value for parameter 'hashingAlgorithm': " + string4 + ". Must be one of: SHA256, SHA384, SHA512, SHA224, SHA1, MD5, RIPEMD160, MD2");
        }
        try {
            inputStream = new BufferedInputStream(new FileInputStream(string), 65536);
            inputStream2 = new FileInputStream(string2);
            outputStream = new BufferedOutputStream(new FileOutputStream(string5), 65536);
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
            clearSignedHelper.sign(inputStream, pGPSecretKey, string3, n, outputStream);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            bl = true;
            throw IOUtil.newPGPException(pGPException);
        }
        catch (IOException iOException) {
            bl = true;
            throw iOException;
        }
        finally {
            File file;
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                outputStream.flush();
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bl && (file = new File(string5)).exists()) {
                file.delete();
            }
        }
    }

    public void clearSignFileVersion3(String string, String string2, String string3, String string4, String string5) throws PGPException, IOException, WrongPasswordException {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        OutputStream outputStream = null;
        boolean bl = false;
        int n = KeyStore.parseHashAlgorithm(string4);
        if (n < 0) {
            throw new InvalidParameterException("Wrong value for parameter 'hashingAlgorithm': " + string4 + ". Must be one of: SHA256, SHA384, SHA512, SHA224, SHA1, MD5, RIPEMD160, MD2");
        }
        try {
            inputStream = new BufferedInputStream(new FileInputStream(string), 65536);
            inputStream2 = new FileInputStream(string2);
            outputStream = new BufferedOutputStream(new FileOutputStream(string5), 65536);
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
            clearSignedHelper.signV3(inputStream, pGPSecretKey, string3, n, outputStream);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            bl = true;
            throw IOUtil.newPGPException(pGPException);
        }
        catch (IOException iOException) {
            bl = true;
            throw iOException;
        }
        finally {
            File file;
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bl && (file = new File(string5)).exists()) {
                file.delete();
            }
        }
    }

    public String clearSignString(String string, String string2, String string3, String string4) throws PGPException, IOException, WrongPasswordException {
        int n = KeyStore.parseHashAlgorithm(string4);
        if (n < 0) {
            throw new InvalidParameterException("Wrong value for parameter 'hashingAlgorithm': " + string4 + ". Must be one of: SHA256, SHA384, SHA512, SHA224, SHA1, MD5, RIPEMD160, MD2");
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string2);
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            PGPSecretKey pGPSecretKey = this.readSecretSigningKey(fileInputStream);
            String string5 = clearSignedHelper.sign(string, pGPSecretKey, string3, n);
            return string5;
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String clearSignString(String string, InputStream inputStream, String string2, String string3) throws PGPException, IOException, WrongPasswordException {
        int n = KeyStore.parseHashAlgorithm(string3);
        if (n < 0) {
            throw new InvalidParameterException("Wrong value for parameter 'hashingAlgorithm': " + string3 + ". Must be one of: SHA256, SHA384, SHA512, SHA224, SHA1, MD5, RIPEMD160, MD2");
        }
        InputStream inputStream2 = null;
        try {
            inputStream2 = inputStream;
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
            String string4 = clearSignedHelper.sign(string, pGPSecretKey, string2, n);
            return string4;
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        finally {
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String clearSignStringVersion3(String string, String string2, String string3, String string4) throws PGPException, IOException, WrongPasswordException {
        int n = KeyStore.parseHashAlgorithm(string4);
        if (n < 0) {
            throw new InvalidParameterException("Wrong value for parameter 'hashingAlgorithm': " + string4 + ". Must be one of: SHA256, SHA384, SHA512, SHA224, SHA1, MD5, RIPEMD160, MD2");
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string2);
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            PGPSecretKey pGPSecretKey = this.readSecretSigningKey(fileInputStream);
            String string5 = clearSignedHelper.signV3(string, pGPSecretKey, string3, n);
            return string5;
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void signFile(KeyStore keyStore, String string, String string2, String string3, String string4) throws PGPException, WrongPasswordException, IOException {
        this.signFile(keyStore, string, keyStore.getKeyIdForKeyIdHex(string2), string3, string4);
    }

    public void signFile(KeyStore keyStore, String string, long l, String string2, String string3) throws PGPException, WrongPasswordException, IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            File file = new File(string);
            inputStream = new FileInputStream(string);
            outputStream = new FileOutputStream(string3);
            PGPSecretKey pGPSecretKey = keyStore.secCollection.getSecretKey(l);
            this.internalSignStream(inputStream, file.getName(), pGPSecretKey, string2, outputStream, false);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            bl = true;
            throw IOUtil.newPGPException(pGPException);
        }
        catch (IOException iOException) {
            bl = true;
            throw iOException;
        }
        finally {
            File file;
            inputStream.close();
            inputStream = null;
            outputStream.close();
            outputStream = null;
            if (bl && (file = new File(string3)).exists()) {
                file.delete();
            }
        }
    }

    public void signFile(String string, KeyStore keyStore, String string2, String string3, String string4, boolean bl) throws PGPException, WrongPasswordException, IOException {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        FileOutputStream fileOutputStream = null;
        boolean bl2 = false;
        try {
            inputStream2 = this.createPrivateRingStream(keyStore, string2);
            fileOutputStream = new FileOutputStream(string4);
            PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
            File file = new File(string);
            inputStream = new BufferedInputStream(new FileInputStream(string));
            this.internalSignStream(inputStream, file.getName(), pGPSecretKey, string3, fileOutputStream, bl);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            bl2 = true;
            throw IOUtil.newPGPException(pGPException);
        }
        catch (IOException iOException) {
            bl2 = true;
            throw iOException;
        }
        finally {
            File file;
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (bl2 && (file = new File(string4)).exists()) {
                file.delete();
            }
        }
    }

    public void signFile(String string, KeyStore keyStore, long l, String string2, String string3, boolean bl) throws PGPException, WrongPasswordException, IOException {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        FileOutputStream fileOutputStream = null;
        boolean bl2 = false;
        try {
            inputStream2 = this.createPrivateRingStream(keyStore, l);
            fileOutputStream = new FileOutputStream(string3);
            PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
            File file = new File(string);
            inputStream = new BufferedInputStream(new FileInputStream(string));
            this.internalSignStream(inputStream, file.getName(), pGPSecretKey, string2, fileOutputStream, bl);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            bl2 = true;
            throw IOUtil.newPGPException(pGPException);
        }
        catch (IOException iOException) {
            bl2 = true;
            throw iOException;
        }
        finally {
            File file;
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (bl2 && (file = new File(string3)).exists()) {
                file.delete();
            }
        }
    }

    public void signFile(String string, String string2, String string3, String string4, boolean bl) throws IOException, PGPException, WrongPasswordException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        boolean bl2 = false;
        try {
            inputStream = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
            outputStream = new BufferedOutputStream(new FileOutputStream(string4), 65536);
            this.signFile(string, inputStream, string3, outputStream, bl);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            bl2 = true;
            throw IOUtil.newPGPException(pGPException);
        }
        catch (IOException iOException) {
            bl2 = true;
            throw iOException;
        }
        finally {
            File file;
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bl2 && (file = new File(string4)).exists()) {
                file.delete();
            }
        }
    }

    public void signFile(String string, InputStream inputStream, String string2, OutputStream outputStream, boolean bl) throws IOException, PGPException, WrongPasswordException {
        PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream);
        InputStream inputStream2 = null;
        try {
            inputStream2 = new BufferedInputStream(new FileInputStream(string));
            this.internalSignStream(inputStream2, new File(string).getName(), pGPSecretKey, string2, outputStream, bl);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        finally {
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void signStream(InputStream inputStream, String string, InputStream inputStream2, String string2, OutputStream outputStream, boolean bl) throws IOException, PGPException, WrongPasswordException {
        PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
        try {
            this.internalSignStream(inputStream, string, pGPSecretKey, string2, outputStream, bl);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void signStream(InputStream inputStream, String string, KeyStore keyStore, String string2, String string3, OutputStream outputStream, boolean bl) throws IOException, PGPException, WrongPasswordException {
        InputStream inputStream2 = null;
        try {
            inputStream2 = this.createPrivateRingStream(keyStore, string2);
            PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
            this.internalSignStream(inputStream, string, pGPSecretKey, string3, outputStream, bl);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void signStream(InputStream inputStream, String string, KeyStore keyStore, long l, String string2, OutputStream outputStream, boolean bl) throws IOException, PGPException, WrongPasswordException {
        InputStream inputStream2 = null;
        try {
            inputStream2 = this.createPrivateRingStream(keyStore, l);
            PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
            this.internalSignStream(inputStream, string, pGPSecretKey, string2, outputStream, bl);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void signFileVersion3(String string, String string2, String string3, String string4, boolean bl) throws IOException, PGPException, WrongPasswordException {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        OutputStream outputStream = null;
        boolean bl2 = false;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(string), 65536);
            inputStream2 = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
            outputStream = new BufferedOutputStream(new FileOutputStream(string4), 65536);
            this.signStreamVersion3(inputStream, new File(string).getName(), inputStream2, string3, outputStream, bl);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            bl2 = true;
            throw IOUtil.newPGPException(pGPException);
        }
        catch (IOException iOException) {
            bl2 = true;
            throw iOException;
        }
        finally {
            File file;
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bl2 && (file = new File(string4)).exists()) {
                file.delete();
            }
        }
    }

    public void signStreamVersion3(InputStream inputStream, String string, InputStream inputStream2, String string2, OutputStream outputStream, boolean bl) throws IOException, PGPException, WrongPasswordException {
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator;
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
            this.setAsciiVersionHeader(outputStream);
        }
        PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
        this.checkKeyIsExpired(pGPSecretKey.getPublicKey());
        this.checkKeyIsRevoked(pGPSecretKey.getPublicKey());
        PGPPrivateKey pGPPrivateKey = PGPLib.extractPrivateKey(pGPSecretKey, string2);
        int n = this.selectPreferredHash();
        PGPSignatureGenerator pGPSignatureGenerator = null;
        try {
            pGPSignatureGenerator = this.bcFactory.CreatePGPSignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), n);
            this.bcFactory.initSign(pGPSignatureGenerator, 0, pGPPrivateKey);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        Iterator iterator = pGPSecretKey.getPublicKey().getRawUserIDs();
        if (iterator.hasNext()) {
            pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            pGPSignatureSubpacketGenerator.setSignerUserID(false, (byte[])iterator.next());
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
        }
        pGPSignatureSubpacketGenerator = new PGPCompressedDataGenerator(2);
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(pGPSignatureSubpacketGenerator.open(outputStream));
        DirectByteArrayOutputStream directByteArrayOutputStream = new DirectByteArrayOutputStream(65536);
        int n2 = 0;
        byte[] byArray = new byte[65536];
        while ((n2 = inputStream.read(byArray)) > 0) {
            directByteArrayOutputStream.write(byArray, 0, n2);
            pGPSignatureGenerator.update(byArray, 0, n2);
        }
        try {
            pGPSignatureGenerator.generate().encode((OutputStream)bCPGOutputStream);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        this.Debug("Signing content with file name label {0}. (version 3, old style signature)", string);
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream2 = pGPLiteralDataGenerator.open((OutputStream)bCPGOutputStream, this.getContentType(), string, (long)directByteArrayOutputStream.size(), new Date());
        outputStream2.write(directByteArrayOutputStream.getArray(), 0, directByteArrayOutputStream.size());
        pGPLiteralDataGenerator.close();
        pGPSignatureSubpacketGenerator.close();
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (directByteArrayOutputStream != null) {
            try {
                directByteArrayOutputStream.flush();
                directByteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (outputStream2 != null) {
            try {
                outputStream2.flush();
                outputStream2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bCPGOutputStream != null) {
            try {
                bCPGOutputStream.flush();
                bCPGOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        directByteArrayOutputStream = null;
        inputStream = null;
        outputStream2 = null;
        bCPGOutputStream = null;
        outputStream.flush();
        if (bl && outputStream != null) {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void signAndEncryptFile(String string, String string2, String string3, String string4, String string5, boolean bl) throws PGPException, WrongPasswordException, IOException {
        this.signAndEncryptFile(string, string2, string3, string4, string5, bl, this.integrityProtect);
    }

    /*
     * Loose catch block
     */
    public void signAndEncryptFile(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) throws PGPException, WrongPasswordException, IOException {
        block30: {
            Serializable serializable2222;
            boolean bl3;
            InputStream inputStream;
            InputStream inputStream2;
            OutputStream outputStream;
            InputStream inputStream3;
            block26: {
                this.Debug("Signing file {0}", string);
                inputStream3 = null;
                outputStream = null;
                inputStream2 = null;
                inputStream = null;
                bl3 = false;
                inputStream3 = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
                outputStream = new BufferedOutputStream(new FileOutputStream(string5), 65536);
                inputStream = new BufferedInputStream(new FileInputStream(string), 65536);
                inputStream2 = PGPLib.readFileOrAsciiString(string4, "publicKeyFile");
                this.signAndEncryptStream(inputStream, new File(string).getName(), inputStream3, string3, inputStream2, outputStream, bl, bl2);
                Object var15_13 = null;
                if (inputStream3 == null) break block26;
                try {
                    inputStream3.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (bl3 && ((File)(serializable2222 = new File(string5))).exists()) {
                ((File)serializable2222).delete();
            }
            break block30;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable32222;
                Object var15_14 = null;
                if (inputStream3 != null) {
                    try {
                        inputStream3.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (bl3 && ((File)(serializable32222 = new File(string5))).exists()) {
                    ((File)serializable32222).delete();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void signAndEncryptFiles(String[] stringArray, String string, String string2, String string3, String string4, boolean bl) throws PGPException, WrongPasswordException, IOException {
        block33: {
            Serializable serializable3222;
            boolean bl2;
            InputStream inputStream;
            InputStream inputStream2;
            BufferedOutputStream bufferedOutputStream;
            InputStream inputStream3;
            block28: {
                inputStream3 = null;
                bufferedOutputStream = null;
                inputStream2 = null;
                inputStream = null;
                bl2 = false;
                File file = null;
                try {
                    inputStream3 = PGPLib.readFileOrAsciiString(string, "privateKeyFileName");
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string4), 65536);
                    inputStream2 = PGPLib.readFileOrAsciiString(string3, "publicKeyFile");
                    file = this.createTarFile(stringArray);
                    String string5 = file.getAbsolutePath();
                    inputStream = new BufferedInputStream(new FileInputStream(string5), 65536);
                    this.signAndEncryptStreamWithMarker(inputStream, new File(string5).getName(), inputStream3, string2, inputStream2, bufferedOutputStream, bl, this.integrityProtect);
                    Object var15_16 = null;
                    if (file == null) break block28;
                    file.delete();
                }
                catch (Throwable throwable) {
                    Serializable serializable22222;
                    Object var15_17 = null;
                    if (file != null) {
                        file.delete();
                    }
                    if (inputStream3 != null) {
                        try {
                            inputStream3.close();
                        }
                        catch (IOException serializable22222) {
                            // empty catch block
                        }
                    }
                    if (bufferedOutputStream != null) {
                        try {
                            ((OutputStream)bufferedOutputStream).flush();
                            ((OutputStream)bufferedOutputStream).close();
                        }
                        catch (IOException serializable22222) {
                            // empty catch block
                        }
                    }
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (IOException serializable22222) {
                            // empty catch block
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException serializable22222) {
                            // empty catch block
                        }
                    }
                    if (bl2 && ((File)(serializable22222 = new File(string4))).exists()) {
                        ((File)serializable22222).delete();
                    }
                    throw throwable;
                }
            }
            if (inputStream3 != null) {
                try {
                    inputStream3.close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (bufferedOutputStream != null) {
                try {
                    ((OutputStream)bufferedOutputStream).flush();
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (bl2 && ((File)(serializable3222 = new File(string4))).exists()) {
                ((File)serializable3222).delete();
            }
            break block33;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl2 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl2 = true;
                    throw iOException;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public void signAndEncryptFile(String string, String string2, String string3, String[] stringArray, String string4, boolean bl, boolean bl2) throws PGPException, WrongPasswordException, IOException {
        block30: {
            File file;
            IOException iOException2222;
            boolean bl3;
            InputStream inputStream;
            InputStream[] inputStreamArray;
            OutputStream outputStream;
            InputStream inputStream2;
            block27: {
                this.Debug("Signing file {0}", string);
                inputStream2 = null;
                outputStream = null;
                inputStreamArray = new InputStream[stringArray.length];
                inputStream = null;
                bl3 = false;
                inputStream2 = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
                outputStream = new BufferedOutputStream(new FileOutputStream(string4), 65536);
                inputStream = new BufferedInputStream(new FileInputStream(string), 65536);
                for (int i = 0; i < stringArray.length; ++i) {
                    inputStreamArray[i] = PGPLib.readFileOrAsciiString(stringArray[i], "publicKeyFiles: " + i);
                }
                this.signAndEncryptStream(inputStream, new File(string).getName(), inputStream2, string3, inputStreamArray, outputStream, bl, bl2);
                Object var15_16 = null;
                if (inputStream2 == null) break block27;
                try {
                    inputStream2.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            outputStream.flush();
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            for (int i = 0; i < inputStreamArray.length; ++i) {
                InputStream inputStream3 = inputStreamArray[i];
                if (inputStream3 == null) continue;
                try {
                    inputStream3.close();
                    continue;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException4) {
                    // empty catch block
                }
            }
            if (bl3 && (file = new File(string4)).exists()) {
                file.delete();
            }
            break block30;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException5) {
                    bl3 = true;
                    throw iOException5;
                }
            }
            catch (Throwable throwable) {
                File file2;
                IOException iOException62222;
                Object var15_17 = null;
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException62222) {
                        // empty catch block
                    }
                }
                outputStream.flush();
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException62222) {
                        // empty catch block
                    }
                }
                for (int i = 0; i < inputStreamArray.length; ++i) {
                    InputStream inputStream4 = inputStreamArray[i];
                    if (inputStream4 == null) continue;
                    try {
                        inputStream4.close();
                        continue;
                    }
                    catch (IOException iOException7) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException8) {
                        // empty catch block
                    }
                }
                if (bl3 && (file2 = new File(string4)).exists()) {
                    file2.delete();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signAndEncryptFile(String string, InputStream inputStream, String string2, InputStream inputStream2, OutputStream outputStream, boolean bl, boolean bl2) throws IOException, PGPException, WrongPasswordException {
        IOException iOException3;
        block11: {
            BufferedInputStream bufferedInputStream = null;
            File file = new File(string);
            this.Debug("Signing file {0}", string);
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                this.signAndEncryptStream((InputStream)bufferedInputStream, file.getName(), inputStream, string2, inputStream2, outputStream, bl, bl2);
                Object var11_10 = null;
                if (bufferedInputStream == null) break block11;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var11_11 = null;
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (outputStream != null) {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException3) {}
        }
    }

    /*
     * Loose catch block
     */
    public void signAndEncryptStream(InputStream inputStream, String string, InputStream inputStream2, String string2, InputStream inputStream3, OutputStream outputStream, boolean bl, boolean bl2) throws IOException, PGPException, WrongPasswordException, NoPublicKeyFoundException, NoPrivateKeyFoundException {
        block34: {
            OutputStream outputStream2;
            block32: {
                block33: {
                    int n;
                    PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator;
                    PGPPublicKey pGPPublicKey;
                    if (this.pgp2Compatible) {
                        this.internalSignAndEncryptStreamPgp2x(inputStream, string, inputStream2, string2, new InputStream[]{inputStream3}, outputStream, new Date(), bl);
                        return;
                    }
                    if (!(outputStream instanceof BufferedOutputStream)) {
                        outputStream = new BufferedOutputStream(outputStream, 65536);
                    }
                    if (!inputStream3.markSupported()) {
                        inputStream3 = new BufferedInputStream(inputStream3);
                    }
                    if (!inputStream2.markSupported()) {
                        inputStream2 = new BufferedInputStream(inputStream2);
                    }
                    inputStream3.mark(65536);
                    inputStream2.mark(65536);
                    PGPPublicKey pGPPublicKey2 = this.readPublicKeyForEncryption(inputStream3);
                    PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
                    if (pGPPublicKey2.getVersion() == 3) {
                        inputStream3.reset();
                        inputStream2.reset();
                        this.Debug("Swithcing to version 3 signatures");
                        this.signAndEncryptStreamVersion3(inputStream, string, inputStream2, string2, inputStream3, outputStream, bl, bl2);
                        return;
                    }
                    outputStream2 = null;
                    int n2 = 65536;
                    if (bl) {
                        outputStream2 = outputStream;
                        outputStream = new ArmoredOutputStream(outputStream2);
                        this.setAsciiVersionHeader(outputStream);
                    }
                    int n3 = this.selectPreferredCypher(pGPPublicKey2);
                    this.Debug("Encrypting with cipher {0}", KeyStore.cypherToString(n3));
                    PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(this.bcFactory.CreatePGPDataEncryptorBuilder(n3, bl2, IOUtil.getSecureRandom()));
                    pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey2));
                    OutputStream outputStream3 = pGPEncryptedDataGenerator.open(outputStream, new byte[n2]);
                    for (int i = 0; i < this.getMasterKeysCount(); ++i) {
                        KeyPairInformation keyPairInformation = (KeyPairInformation)this.masterKeysList.get(i);
                        pGPPublicKey = this.readPublicKeyForEncryption(keyPairInformation.getPublicKeyRing());
                        pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey));
                        this.Debug("Encrypting with master key Id {0}", KeyPairInformation.keyId2Hex(pGPPublicKey.getKeyID()));
                    }
                    PGPPrivateKey pGPPrivateKey = PGPLib.extractPrivateKey(pGPSecretKey, string2);
                    int n4 = this.selectPreferredHash(pGPPublicKey2);
                    this.Debug("Signing with hash {0}", KeyStore.hashToString(n4));
                    pGPPublicKey = this.bcFactory.CreatePGPSignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), n4);
                    this.bcFactory.initSign((PGPSignatureGenerator)pGPPublicKey, 0, pGPPrivateKey);
                    Iterator iterator = pGPSecretKey.getPublicKey().getRawUserIDs();
                    while (iterator.hasNext()) {
                        byte[] byArray = (byte[])iterator.next();
                        pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
                        this.Debug("Signing with User ID {0}", BaseLib.toUserID(byArray));
                        pGPSignatureSubpacketGenerator.setSignerUserID(false, byArray);
                        pGPPublicKey.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
                    }
                    int n5 = this.selectPreferredCompression(pGPPublicKey2);
                    pGPSignatureSubpacketGenerator = new PGPCompressedDataGenerator(n5);
                    OutputStream outputStream4 = null;
                    PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
                    OutputStream outputStream5 = null;
                    if (n5 == 0) {
                        this.Debug("No compression.");
                        pGPPublicKey.generateOnePassVersion(false).encode(outputStream3);
                        outputStream5 = pGPLiteralDataGenerator.open(outputStream3, 'b', string, new Date(), new byte[65536]);
                    } else {
                        this.Debug("Compression is {0}", KeyStore.compressionToString(n5));
                        outputStream4 = pGPSignatureSubpacketGenerator.open(outputStream3, new byte[n2]);
                        pGPPublicKey.generateOnePassVersion(false).encode(outputStream4);
                        outputStream5 = pGPLiteralDataGenerator.open(outputStream4, 'b', string, new Date(), new byte[65536]);
                    }
                    this.Debug("Signing stream content with internal file name label: {0}", string);
                    byte[] byArray = new byte[n2];
                    while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                        outputStream5.write(byArray, 0, n);
                        pGPPublicKey.update(byArray, 0, n);
                    }
                    if (outputStream5 != null) {
                        try {
                            outputStream5.flush();
                            outputStream5.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    pGPLiteralDataGenerator.close();
                    if (outputStream4 == null) {
                        pGPPublicKey.generate().encode(outputStream3);
                    } else {
                        pGPPublicKey.generate().encode(outputStream4);
                    }
                    pGPSignatureSubpacketGenerator.close();
                    pGPEncryptedDataGenerator.close();
                    if (outputStream4 != null) {
                        try {
                            outputStream4.flush();
                            outputStream4.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (outputStream3 != null) {
                        try {
                            outputStream3.flush();
                            outputStream3.close();
                        }
                        catch (IOException iOException) {
                        }
                    }
                    Object var29_34 = null;
                    if (!bl) break block32;
                    if (outputStream == null) break block33;
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                outputStream2.flush();
                break block34;
            }
            outputStream.flush();
            {
                break block34;
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    throw IOUtil.newPGPException(pGPException);
                }
            }
            catch (Throwable throwable) {
                Object var29_35 = null;
                if (bl) {
                    if (outputStream != null) {
                        try {
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    outputStream2.flush();
                } else {
                    outputStream.flush();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void signAndEncryptStreamWithMarker(InputStream inputStream, String string, InputStream inputStream2, String string2, InputStream inputStream3, OutputStream outputStream, boolean bl, boolean bl2) throws IOException, PGPException, WrongPasswordException, NoPublicKeyFoundException, NoPrivateKeyFoundException {
        block34: {
            OutputStream outputStream2;
            block32: {
                block33: {
                    int n;
                    PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator;
                    PGPPublicKey pGPPublicKey;
                    if (this.pgp2Compatible) {
                        this.internalSignAndEncryptStreamPgp2x(inputStream, string, inputStream2, string2, new InputStream[]{inputStream3}, outputStream, new Date(), bl);
                        return;
                    }
                    if (!(outputStream instanceof BufferedOutputStream)) {
                        outputStream = new BufferedOutputStream(outputStream, 65536);
                    }
                    if (!inputStream3.markSupported()) {
                        inputStream3 = new BufferedInputStream(inputStream3);
                    }
                    if (!inputStream2.markSupported()) {
                        inputStream2 = new BufferedInputStream(inputStream2);
                    }
                    inputStream3.mark(65536);
                    inputStream2.mark(65536);
                    PGPPublicKey pGPPublicKey2 = this.readPublicKeyForEncryption(inputStream3);
                    PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
                    if (pGPPublicKey2.getVersion() == 3) {
                        inputStream3.reset();
                        inputStream2.reset();
                        this.Debug("Swithcing to version 3 signatures");
                        this.signAndEncryptStreamVersion3(inputStream, string, inputStream2, string2, inputStream3, outputStream, bl, bl2);
                        return;
                    }
                    outputStream2 = null;
                    int n2 = 65536;
                    if (bl) {
                        outputStream2 = outputStream;
                        outputStream = new ArmoredOutputStream(outputStream2);
                        this.setAsciiVersionHeader(outputStream);
                    }
                    BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(outputStream);
                    this.writeMarker(bCPGOutputStream);
                    bCPGOutputStream.flush();
                    int n3 = this.selectPreferredCypher(pGPPublicKey2);
                    this.Debug("Encrypting with cipher {0}", KeyStore.cypherToString(n3));
                    PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(this.bcFactory.CreatePGPDataEncryptorBuilder(n3, bl2, IOUtil.getSecureRandom()));
                    pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey2));
                    OutputStream outputStream3 = pGPEncryptedDataGenerator.open(outputStream, new byte[n2]);
                    for (int i = 0; i < this.getMasterKeysCount(); ++i) {
                        KeyPairInformation keyPairInformation = (KeyPairInformation)this.masterKeysList.get(i);
                        pGPPublicKey = this.readPublicKeyForEncryption(keyPairInformation.getPublicKeyRing());
                        pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey));
                        this.Debug("Encrypting with master key Id {0}", KeyPairInformation.keyId2Hex(pGPPublicKey.getKeyID()));
                    }
                    PGPPrivateKey pGPPrivateKey = PGPLib.extractPrivateKey(pGPSecretKey, string2);
                    int n4 = this.selectPreferredHash(pGPPublicKey2);
                    this.Debug("Signing with hash {0}", KeyStore.hashToString(n4));
                    pGPPublicKey = this.bcFactory.CreatePGPSignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), n4);
                    this.bcFactory.initSign((PGPSignatureGenerator)pGPPublicKey, 0, pGPPrivateKey);
                    Iterator iterator = pGPSecretKey.getPublicKey().getRawUserIDs();
                    while (iterator.hasNext()) {
                        byte[] byArray = (byte[])iterator.next();
                        pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
                        this.Debug("Signing with User ID {0}", BaseLib.toUserID(byArray));
                        pGPSignatureSubpacketGenerator.setSignerUserID(false, byArray);
                        pGPPublicKey.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
                    }
                    int n5 = this.selectPreferredCompression(pGPPublicKey2);
                    pGPSignatureSubpacketGenerator = new PGPCompressedDataGenerator(n5);
                    OutputStream outputStream4 = null;
                    PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
                    OutputStream outputStream5 = null;
                    if (n5 == 0) {
                        this.Debug("No compression.");
                        pGPPublicKey.generateOnePassVersion(false).encode(outputStream3);
                        outputStream5 = pGPLiteralDataGenerator.open(outputStream3, 'b', string, new Date(), new byte[65536]);
                    } else {
                        this.Debug("Compression is {0}", KeyStore.compressionToString(n5));
                        outputStream4 = pGPSignatureSubpacketGenerator.open(outputStream3, new byte[n2]);
                        pGPPublicKey.generateOnePassVersion(false).encode(outputStream4);
                        outputStream5 = pGPLiteralDataGenerator.open(outputStream4, 'b', string, new Date(), new byte[65536]);
                    }
                    this.Debug("Signing stream content with internal file name label: {0}", string);
                    byte[] byArray = new byte[n2];
                    while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                        outputStream5.write(byArray, 0, n);
                        pGPPublicKey.update(byArray, 0, n);
                    }
                    if (outputStream5 != null) {
                        try {
                            outputStream5.flush();
                            outputStream5.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    pGPLiteralDataGenerator.close();
                    if (outputStream4 == null) {
                        pGPPublicKey.generate().encode(outputStream3);
                    } else {
                        pGPPublicKey.generate().encode(outputStream4);
                    }
                    pGPSignatureSubpacketGenerator.close();
                    pGPEncryptedDataGenerator.close();
                    if (outputStream4 != null) {
                        try {
                            outputStream4.flush();
                            outputStream4.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (outputStream3 != null) {
                        try {
                            outputStream3.flush();
                            outputStream3.close();
                        }
                        catch (IOException iOException) {
                        }
                    }
                    Object var30_35 = null;
                    if (!bl) break block32;
                    if (outputStream == null) break block33;
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                outputStream2.flush();
                break block34;
            }
            outputStream.flush();
            {
                break block34;
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    throw IOUtil.newPGPException(pGPException);
                }
            }
            catch (Throwable throwable) {
                Object var30_36 = null;
                if (bl) {
                    if (outputStream != null) {
                        try {
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    outputStream2.flush();
                } else {
                    outputStream.flush();
                }
                throw throwable;
            }
        }
    }

    public void signAndEncryptStream(InputStream inputStream, String string, InputStream inputStream2, String string2, InputStream[] inputStreamArray, OutputStream outputStream, boolean bl, boolean bl2) throws IOException, PGPException, WrongPasswordException, NoPublicKeyFoundException, NoPrivateKeyFoundException {
        if (this.pgp2Compatible) {
            this.internalSignAndEncryptStreamPgp2x(inputStream, string, inputStream2, string2, inputStreamArray, outputStream, new Date(), bl);
            return;
        }
        int n = 65536;
        try {
            int n2;
            PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator;
            int n3;
            if (bl) {
                outputStream = new ArmoredOutputStream(outputStream);
                this.setAsciiVersionHeader(outputStream);
            }
            LinkedList<PGPPublicKey> linkedList = new LinkedList<PGPPublicKey>();
            List<Integer> list = new LinkedList<Integer>();
            List<Integer> list2 = new LinkedList<Integer>();
            List<Integer> list3 = new LinkedList<Integer>();
            for (n3 = 0; n3 < inputStreamArray.length; ++n3) {
                PGPPublicKey pGPPublicKey = this.readPublicKeyForEncryption(inputStreamArray[n3]);
                if (n3 == 0) {
                    list = this.listPreferredCyphers(pGPPublicKey);
                    list2 = this.listPreferredHashes(pGPPublicKey);
                    list3 = this.listPreferredCompressions(pGPPublicKey);
                } else {
                    list = this.intersectList(list, this.listPreferredCyphers(pGPPublicKey));
                    list2 = this.intersectList(list2, this.listPreferredHashes(pGPPublicKey));
                    list3 = this.intersectList(list3, this.listPreferredCompressions(pGPPublicKey));
                }
                this.Debug("Encrypting with public key {0}", KeyPairInformation.keyId2Hex(pGPPublicKey.getKeyID()));
                linkedList.add(pGPPublicKey);
            }
            n3 = this.selectPreferredCompression(list3);
            int n4 = this.selectPreferredCypher(list);
            int n5 = this.selectPreferredHash(list2);
            this.Debug("Encrypting with cipher {0}", KeyStore.cypherToString(n4));
            PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(this.bcFactory.CreatePGPDataEncryptorBuilder(n4, bl2, IOUtil.getSecureRandom()));
            for (int i = 0; i < linkedList.size(); ++i) {
                pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator((PGPPublicKey)linkedList.get(i)));
            }
            OutputStream outputStream2 = pGPEncryptedDataGenerator.open(outputStream, new byte[n]);
            PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
            PGPPrivateKey pGPPrivateKey = PGPLib.extractPrivateKey(pGPSecretKey, string2);
            this.Debug("Signing with hash {0}", HashAlgorithm.Enum.fromInt(n5).toString());
            PGPSignatureGenerator pGPSignatureGenerator = this.bcFactory.CreatePGPSignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), n5);
            this.bcFactory.initSign(pGPSignatureGenerator, 0, pGPPrivateKey);
            Iterator iterator = pGPSecretKey.getPublicKey().getRawUserIDs();
            while (iterator.hasNext()) {
                pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
                pGPSignatureSubpacketGenerator.setSignerUserID(false, (byte[])iterator.next());
                pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
            }
            pGPSignatureSubpacketGenerator = new PGPCompressedDataGenerator(n3);
            OutputStream outputStream3 = null;
            PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
            OutputStream outputStream4 = null;
            if (n3 == 0) {
                this.Debug("No Compression.");
                pGPSignatureGenerator.generateOnePassVersion(false).encode(outputStream2);
                outputStream4 = pGPLiteralDataGenerator.open(outputStream2, 'b', string, new Date(), new byte[65536]);
            } else {
                this.Debug("Compression is {0}", KeyStore.compressionToString(n3));
                outputStream3 = pGPSignatureSubpacketGenerator.open(outputStream2, new byte[n]);
                pGPSignatureGenerator.generateOnePassVersion(false).encode(outputStream3);
                outputStream4 = pGPLiteralDataGenerator.open(outputStream3, 'b', string, new Date(), new byte[65536]);
            }
            this.Debug("Signing stream content with internal file name label: {0}", string);
            byte[] byArray = new byte[n];
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) > 0) {
                outputStream4.write(byArray, 0, n2);
                pGPSignatureGenerator.update(byArray, 0, n2);
            }
            if (outputStream4 != null) {
                try {
                    outputStream4.flush();
                    outputStream4.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            pGPLiteralDataGenerator.close();
            if (outputStream3 == null) {
                pGPSignatureGenerator.generate().encode(outputStream2);
            } else {
                pGPSignatureGenerator.generate().encode(outputStream3);
            }
            pGPSignatureSubpacketGenerator.close();
            pGPEncryptedDataGenerator.close();
            if (outputStream3 != null) {
                try {
                    outputStream3.flush();
                    outputStream3.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (outputStream2 != null) {
                try {
                    outputStream2.flush();
                    outputStream2.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (bl) {
                outputStream.close();
            }
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
    }

    /*
     * Loose catch block
     */
    public void signAndEncryptFile(String string, KeyStore keyStore, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) throws IOException, PGPException {
        block30: {
            Serializable serializable2222;
            boolean bl3;
            OutputStream outputStream;
            InputStream inputStream;
            InputStream inputStream2;
            InputStream inputStream3;
            block26: {
                inputStream3 = null;
                inputStream2 = null;
                inputStream = null;
                outputStream = null;
                bl3 = false;
                this.Debug("Signing and encrypting file {0}", string);
                this.Debug("Output file is {0}", new File(string5).getAbsolutePath());
                inputStream3 = this.createPublicRingStream(keyStore, string4);
                inputStream2 = this.createPrivateRingStream(keyStore, string2);
                File file = new File(string);
                inputStream = new BufferedInputStream(new FileInputStream(string), 65536);
                outputStream = new BufferedOutputStream(new FileOutputStream(new File(string5)), 65536);
                this.signAndEncryptStream(inputStream, file.getName(), inputStream2, string3, inputStream3, outputStream, bl, bl2);
                Object var16_17 = null;
                if (inputStream == null) break block26;
                try {
                    inputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            outputStream.flush();
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (inputStream3 != null) {
                try {
                    inputStream3.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (bl3 && ((File)(serializable2222 = new File(string5))).exists()) {
                ((File)serializable2222).delete();
            }
            break block30;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable32222;
                Object var16_18 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                outputStream.flush();
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (inputStream3 != null) {
                    try {
                        inputStream3.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (bl3 && ((File)(serializable32222 = new File(string5))).exists()) {
                    ((File)serializable32222).delete();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void signAndEncryptFiles(String[] stringArray, KeyStore keyStore, String string, String string2, String string3, String string4, boolean bl) throws IOException, PGPException {
        block33: {
            Serializable serializable3222;
            boolean bl2;
            OutputStream outputStream;
            InputStream inputStream;
            InputStream inputStream2;
            InputStream inputStream3;
            block28: {
                inputStream3 = null;
                inputStream2 = null;
                inputStream = null;
                outputStream = null;
                bl2 = false;
                this.Debug("Output file is {0}", new File(string4).getAbsolutePath());
                File file = null;
                try {
                    inputStream3 = this.createPublicRingStream(keyStore, string3);
                    inputStream2 = this.createPrivateRingStream(keyStore, string);
                    file = this.createTarFile(stringArray);
                    String string5 = file.getAbsolutePath();
                    inputStream = new BufferedInputStream(new FileInputStream(string5), 65536);
                    outputStream = new BufferedOutputStream(new FileOutputStream(new File(string4)), 65536);
                    this.signAndEncryptStreamWithMarker(inputStream, file.getName(), inputStream2, string2, inputStream3, outputStream, bl, this.integrityProtect);
                    Object var16_17 = null;
                    if (file == null) break block28;
                    file.delete();
                }
                catch (Throwable throwable) {
                    Serializable serializable22222;
                    Object var16_18 = null;
                    if (file != null) {
                        file.delete();
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException serializable22222) {
                            // empty catch block
                        }
                    }
                    outputStream.flush();
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException serializable22222) {
                            // empty catch block
                        }
                    }
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (IOException serializable22222) {
                            // empty catch block
                        }
                    }
                    if (inputStream3 != null) {
                        try {
                            inputStream3.close();
                        }
                        catch (IOException serializable22222) {
                            // empty catch block
                        }
                    }
                    if (bl2 && ((File)(serializable22222 = new File(string4))).exists()) {
                        ((File)serializable22222).delete();
                    }
                    throw throwable;
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            outputStream.flush();
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (inputStream3 != null) {
                try {
                    inputStream3.close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (bl2 && ((File)(serializable3222 = new File(string4))).exists()) {
                ((File)serializable3222).delete();
            }
            break block33;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl2 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl2 = true;
                    throw iOException;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public void signAndEncryptFile(String string, KeyStore keyStore, String string2, String string3, String[] stringArray, String string4, boolean bl, boolean bl2) throws IOException, PGPException {
        block30: {
            File file;
            IOException iOException2222;
            boolean bl3;
            OutputStream outputStream;
            InputStream inputStream;
            InputStream inputStream2;
            InputStream[] inputStreamArray;
            block27: {
                inputStreamArray = new InputStream[stringArray.length];
                inputStream2 = null;
                inputStream = null;
                outputStream = null;
                bl3 = false;
                this.Debug("Signing and encrypting file {0}", string);
                this.Debug("Output file is {0}", new File(string4).getAbsolutePath());
                for (int i = 0; i < inputStreamArray.length; ++i) {
                    inputStreamArray[i] = this.createPublicRingStream(keyStore, stringArray[i]);
                }
                inputStream2 = this.createPrivateRingStream(keyStore, string2);
                File file2 = new File(string);
                inputStream = new BufferedInputStream(new FileInputStream(string), 65536);
                outputStream = new BufferedOutputStream(new FileOutputStream(string4), 65536);
                this.signAndEncryptStream(inputStream, file2.getName(), inputStream2, string3, inputStreamArray, outputStream, bl, bl2);
                Object var16_18 = null;
                if (inputStream == null) break block27;
                try {
                    inputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            for (int i = 0; i < inputStreamArray.length; ++i) {
                InputStream inputStream3 = inputStreamArray[i];
                if (inputStream3 == null) continue;
                try {
                    inputStream3.close();
                    continue;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
            if (bl3 && (file = new File(string4)).exists()) {
                file.delete();
            }
            break block30;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException4) {
                    bl3 = true;
                    throw iOException4;
                }
            }
            catch (Throwable throwable) {
                File file3;
                IOException iOException52222;
                Object var16_19 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                for (int i = 0; i < inputStreamArray.length; ++i) {
                    InputStream inputStream4 = inputStreamArray[i];
                    if (inputStream4 == null) continue;
                    try {
                        inputStream4.close();
                        continue;
                    }
                    catch (IOException iOException6) {
                        // empty catch block
                    }
                }
                if (bl3 && (file3 = new File(string4)).exists()) {
                    file3.delete();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void signAndEncryptFile(String string, KeyStore keyStore, long l, String string2, long[] lArray, String string3, boolean bl, boolean bl2) throws IOException, PGPException {
        block30: {
            File file;
            IOException iOException2222;
            boolean bl3;
            OutputStream outputStream;
            InputStream inputStream;
            InputStream inputStream2;
            InputStream[] inputStreamArray;
            block27: {
                inputStreamArray = new InputStream[lArray.length];
                inputStream2 = null;
                inputStream = null;
                outputStream = null;
                bl3 = false;
                this.Debug("Signing and encrypting file {0}", string);
                this.Debug("Output file is {0}", new File(string3).getAbsolutePath());
                for (int i = 0; i < inputStreamArray.length; ++i) {
                    inputStreamArray[i] = this.createPublicRingStream(keyStore, lArray[i]);
                }
                inputStream2 = this.createPrivateRingStream(keyStore, l);
                File file2 = new File(string);
                inputStream = new BufferedInputStream(new FileInputStream(string), 65536);
                outputStream = new BufferedOutputStream(new FileOutputStream(string3), 65536);
                this.signAndEncryptStream(inputStream, file2.getName(), inputStream2, string2, inputStreamArray, outputStream, bl, bl2);
                Object var17_18 = null;
                if (inputStream == null) break block27;
                try {
                    inputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            for (int i = 0; i < inputStreamArray.length; ++i) {
                InputStream inputStream3 = inputStreamArray[i];
                if (inputStream3 == null) continue;
                try {
                    inputStream3.close();
                    continue;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
            if (bl3 && (file = new File(string3)).exists()) {
                file.delete();
            }
            break block30;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException4) {
                    bl3 = true;
                    throw iOException4;
                }
            }
            catch (Throwable throwable) {
                File file3;
                IOException iOException52222;
                Object var17_19 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                for (int i = 0; i < inputStreamArray.length; ++i) {
                    InputStream inputStream4 = inputStreamArray[i];
                    if (inputStream4 == null) continue;
                    try {
                        inputStream4.close();
                        continue;
                    }
                    catch (IOException iOException6) {
                        // empty catch block
                    }
                }
                if (bl3 && (file3 = new File(string3)).exists()) {
                    file3.delete();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void signAndEncryptFile(String string, KeyStore keyStore, long l, String string2, long l2, String string3, boolean bl, boolean bl2) throws IOException, PGPException {
        block30: {
            Serializable serializable2222;
            boolean bl3;
            OutputStream outputStream;
            InputStream inputStream;
            InputStream inputStream2;
            InputStream inputStream3;
            block26: {
                inputStream3 = null;
                inputStream2 = null;
                inputStream = null;
                outputStream = null;
                this.Debug("Signing and encrypting file {0}", string);
                this.Debug("Output file is {0}", new File(string3).getAbsolutePath());
                bl3 = false;
                inputStream3 = this.createPublicRingStream(keyStore, l2);
                inputStream2 = this.createPrivateRingStream(keyStore, l);
                File file = new File(string);
                inputStream = new BufferedInputStream(new FileInputStream(string), 65536);
                outputStream = new BufferedOutputStream(new FileOutputStream(string3), 65536);
                this.signAndEncryptStream(inputStream, file.getName(), inputStream2, string2, inputStream3, outputStream, bl, bl2);
                Object var18_17 = null;
                if (inputStream == null) break block26;
                try {
                    inputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (inputStream3 != null) {
                try {
                    inputStream3.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (bl3 && ((File)(serializable2222 = new File(string3))).exists()) {
                ((File)serializable2222).delete();
            }
            break block30;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable32222;
                Object var18_18 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (inputStream3 != null) {
                    try {
                        inputStream3.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (bl3 && ((File)(serializable32222 = new File(string3))).exists()) {
                    ((File)serializable32222).delete();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void signAndEncryptFiles(String[] stringArray, KeyStore keyStore, long l, String string, long l2, String string2, boolean bl) throws IOException, PGPException {
        block30: {
            Serializable serializable2222;
            boolean bl2;
            OutputStream outputStream;
            InputStream inputStream;
            InputStream inputStream2;
            InputStream inputStream3;
            block26: {
                inputStream3 = null;
                inputStream2 = null;
                inputStream = null;
                outputStream = null;
                this.Debug("Output file is {0}", new File(string2).getAbsolutePath());
                bl2 = false;
                File file = null;
                inputStream3 = this.createPublicRingStream(keyStore, l2);
                inputStream2 = this.createPrivateRingStream(keyStore, l);
                file = this.createTarFile(stringArray);
                this.Debug("Signing and encrypting file {0}", file.getAbsolutePath());
                String string3 = file.getAbsolutePath();
                inputStream = new BufferedInputStream(new FileInputStream(string3), 65536);
                outputStream = new BufferedOutputStream(new FileOutputStream(string2), 65536);
                this.signAndEncryptStream(inputStream, file.getName(), inputStream2, string, inputStream3, outputStream, bl, this.integrityProtect);
                Object var18_17 = null;
                if (inputStream == null) break block26;
                try {
                    inputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (inputStream3 != null) {
                try {
                    inputStream3.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (bl2 && ((File)(serializable2222 = new File(string2))).exists()) {
                ((File)serializable2222).delete();
            }
            break block30;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl2 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl2 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable32222;
                Object var18_18 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (inputStream3 != null) {
                    try {
                        inputStream3.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (bl2 && ((File)(serializable32222 = new File(string2))).exists()) {
                    ((File)serializable32222).delete();
                }
                throw throwable;
            }
        }
    }

    public void signAndEncryptStream(InputStream inputStream, String string, KeyStore keyStore, String string2, String string3, String string4, OutputStream outputStream, boolean bl, boolean bl2) throws IOException, PGPException {
        try {
            InputStream inputStream2 = this.createPublicRingStream(keyStore, string4);
            InputStream inputStream3 = this.createPrivateRingStream(keyStore, string2);
            this.signAndEncryptStream(inputStream, string, inputStream3, string3, inputStream2, outputStream, bl, bl2);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
    }

    public void signAndEncryptStream(InputStream inputStream, String string, KeyStore keyStore, String string2, String string3, String[] stringArray, OutputStream outputStream, boolean bl, boolean bl2) throws IOException, PGPException {
        InputStream[] inputStreamArray = new InputStream[stringArray.length];
        InputStream inputStream2 = null;
        try {
            try {
                inputStream2 = this.createPrivateRingStream(keyStore, string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    inputStreamArray[i] = this.createPublicRingStream(keyStore, stringArray[i]);
                }
                this.signAndEncryptStream(inputStream, string, inputStream2, string3, inputStreamArray, outputStream, bl, bl2);
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            inputStream2.close();
            throw throwable;
        }
        inputStream2.close();
    }

    public void signAndEncryptStream(InputStream inputStream, String string, KeyStore keyStore, String string2, String string3, long[] lArray, OutputStream outputStream, boolean bl, boolean bl2) throws IOException, PGPException {
        InputStream[] inputStreamArray = new InputStream[lArray.length];
        InputStream inputStream2 = null;
        try {
            try {
                inputStream2 = this.createPrivateRingStream(keyStore, string2);
                for (int i = 0; i < lArray.length; ++i) {
                    inputStreamArray[i] = this.createPublicRingStream(keyStore, lArray[i]);
                }
                this.signAndEncryptStream(inputStream, string, inputStream2, string3, inputStreamArray, outputStream, bl, bl2);
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            inputStream2.close();
            throw throwable;
        }
        inputStream2.close();
    }

    /*
     * Loose catch block
     */
    public void signAndEncryptFileVersion3(String string, String string2, String string3, String string4, String string5, boolean bl) throws PGPException, IOException {
        block30: {
            Serializable serializable2222;
            boolean bl2;
            OutputStream outputStream;
            InputStream inputStream;
            InputStream inputStream2;
            BufferedInputStream bufferedInputStream;
            block26: {
                bufferedInputStream = null;
                inputStream2 = null;
                inputStream = null;
                outputStream = null;
                bl2 = false;
                this.Debug("Signing and encrypting file {0}", string);
                this.Debug("Output file is {0}", new File(string5).getAbsolutePath());
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string), 65536);
                inputStream2 = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
                outputStream = new BufferedOutputStream(new FileOutputStream(string5), 65536);
                inputStream = PGPLib.readFileOrAsciiString(string4, "publicKeyFile");
                this.signAndEncryptStreamVersion3((InputStream)bufferedInputStream, new File(string).getName(), inputStream2, string3, inputStream, outputStream, bl, this.integrityProtect);
                Object var14_12 = null;
                if (bufferedInputStream == null) break block26;
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (bl2 && ((File)(serializable2222 = new File(string5))).exists()) {
                ((File)serializable2222).delete();
            }
            break block30;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl2 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl2 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable32222;
                Object var14_13 = null;
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (bl2 && ((File)(serializable32222 = new File(string5))).exists()) {
                    ((File)serializable32222).delete();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void signAndEncryptFileVersion3(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) throws PGPException, IOException {
        block30: {
            Serializable serializable2222;
            boolean bl3;
            OutputStream outputStream;
            InputStream inputStream;
            InputStream inputStream2;
            BufferedInputStream bufferedInputStream;
            block26: {
                bufferedInputStream = null;
                inputStream2 = null;
                inputStream = null;
                outputStream = null;
                this.Debug("Signing and encrypting file {0}", string);
                this.Debug("Output file is {0}", new File(string5).getAbsolutePath());
                bl3 = false;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string), 65536);
                inputStream2 = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
                outputStream = new BufferedOutputStream(new FileOutputStream(string5), 65536);
                inputStream = PGPLib.readFileOrAsciiString(string4, "publicKeyFile");
                this.signAndEncryptStreamVersion3((InputStream)bufferedInputStream, new File(string).getName(), inputStream2, string3, inputStream, outputStream, bl, bl2);
                Object var15_13 = null;
                if (bufferedInputStream == null) break block26;
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (bl3 && ((File)(serializable2222 = new File(string5))).exists()) {
                ((File)serializable2222).delete();
            }
            break block30;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable32222;
                Object var15_14 = null;
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (bl3 && ((File)(serializable32222 = new File(string5))).exists()) {
                    ((File)serializable32222).delete();
                }
                throw throwable;
            }
        }
    }

    public void signAndEncryptStreamVersion3(InputStream inputStream, String string, InputStream inputStream2, String string2, InputStream inputStream3, OutputStream outputStream, boolean bl) throws IOException, PGPException, WrongPasswordException {
        this.signAndEncryptStreamVersion3(inputStream, string, inputStream2, string2, inputStream3, outputStream, bl, this.integrityProtect);
    }

    public void signAndEncryptStreamVersion3(InputStream inputStream, String string, KeyStore keyStore, String string2, String string3, String string4, OutputStream outputStream, boolean bl) throws IOException, PGPException, WrongPasswordException {
        InputStream inputStream2 = this.createPublicRingStream(keyStore, string4);
        InputStream inputStream3 = this.createPrivateRingStream(keyStore, string2);
        this.signAndEncryptStreamVersion3(inputStream, string, inputStream3, string3, inputStream2, outputStream, bl);
    }

    public void signAndEncryptStreamVersion3(InputStream inputStream, String string, KeyStore keyStore, long l, String string2, long l2, OutputStream outputStream, boolean bl) throws IOException, PGPException, WrongPasswordException {
        InputStream inputStream2 = this.createPublicRingStream(keyStore, l2);
        InputStream inputStream3 = this.createPrivateRingStream(keyStore, l);
        this.signAndEncryptStreamVersion3(inputStream, string, inputStream3, string2, inputStream2, outputStream, bl);
    }

    public void signAndEncryptStreamVersion3(InputStream inputStream, String string, InputStream inputStream2, String string2, InputStream inputStream3, OutputStream outputStream, boolean bl, boolean bl2) throws IOException, PGPException, WrongPasswordException {
        Object object;
        if (!(outputStream instanceof BufferedOutputStream)) {
            outputStream = new BufferedOutputStream(outputStream, 65536);
        }
        int n = 65536;
        PGPPublicKey pGPPublicKey = this.readPublicKeyForEncryption(inputStream3);
        PGPSecretKey pGPSecretKey = this.readSecretSigningKey(inputStream2);
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
            this.setAsciiVersionHeader(outputStream);
        }
        int n2 = this.selectPreferredCypher(pGPPublicKey);
        this.Debug("Encrypting with cypher {0}", KeyStore.cypherToString(n2));
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(this.bcFactory.CreatePGPDataEncryptorBuilder(n2, bl2, IOUtil.getSecureRandom()));
        OutputStream outputStream2 = null;
        try {
            pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey));
            outputStream2 = pGPEncryptedDataGenerator.open(outputStream, new byte[n]);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        int n3 = this.selectPreferredCompression(pGPPublicKey);
        PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(n3);
        PGPPrivateKey pGPPrivateKey = PGPLib.extractPrivateKey(pGPSecretKey, string2);
        int n4 = this.selectPreferredHash(pGPPublicKey);
        this.Debug("Signing with hash {0}", KeyStore.hashToString(n4));
        PGPSignatureGenerator pGPSignatureGenerator = this.bcFactory.CreatePGPSignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), n4);
        this.bcFactory.initSign(pGPSignatureGenerator, 0, pGPPrivateKey);
        Iterator iterator = pGPSecretKey.getPublicKey().getRawUserIDs();
        if (iterator.hasNext()) {
            object = new PGPSignatureSubpacketGenerator();
            object.setSignerUserID(false, (byte[])iterator.next());
            pGPSignatureGenerator.setHashedSubpackets(object.generate());
        }
        object = null;
        OutputStream outputStream3 = null;
        DirectByteArrayOutputStream directByteArrayOutputStream = new DirectByteArrayOutputStream(65536);
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        try {
            int n5 = 0;
            byte[] byArray = new byte[65536];
            while ((n5 = inputStream.read(byArray)) > 0) {
                directByteArrayOutputStream.write(byArray, 0, n5);
                pGPSignatureGenerator.update(byArray, 0, n5);
            }
            this.Debug("Signing data with OpenPGP version 3 signature; internal file name {0}", string);
            if (n3 == 0) {
                this.Debug("No Compression.");
                pGPSignatureGenerator.generate().encode(outputStream2);
                outputStream3 = pGPLiteralDataGenerator.open(outputStream2, 'b', string, new Date(), new byte[n]);
            } else {
                this.Debug("Compression is {0}", KeyStore.compressionToString(n3));
                object = pGPCompressedDataGenerator.open(outputStream2, new byte[n]);
                pGPSignatureGenerator.generate().encode((OutputStream)object);
                outputStream3 = pGPLiteralDataGenerator.open((OutputStream)object, 'b', string, new Date(), new byte[n]);
            }
            outputStream3.write(directByteArrayOutputStream.getArray(), 0, directByteArrayOutputStream.size());
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        pGPLiteralDataGenerator.close();
        pGPCompressedDataGenerator.close();
        pGPEncryptedDataGenerator.close();
        if (outputStream3 != null) {
            try {
                outputStream3.flush();
                outputStream3.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (object != null) {
            try {
                ((OutputStream)object).flush();
                ((OutputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (outputStream2 != null) {
            try {
                outputStream2.flush();
                outputStream2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (directByteArrayOutputStream != null) {
            try {
                directByteArrayOutputStream.flush();
                directByteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        outputStream3 = null;
        directByteArrayOutputStream = null;
        inputStream = null;
        object = null;
        outputStream2 = null;
        outputStream.flush();
        if (bl && outputStream != null) {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String signAndEncryptString(String string, KeyStore keyStore, String string2, String string3, String string4, String string5) throws PGPException, IOException {
        IOException iOException3;
        String string6;
        DirectByteArrayOutputStream directByteArrayOutputStream;
        InputStream inputStream;
        InputStream inputStream2;
        InputStream inputStream3;
        block16: {
            inputStream3 = null;
            inputStream2 = null;
            inputStream = null;
            directByteArrayOutputStream = null;
            try {
                inputStream2 = this.createPrivateRingStream(keyStore, string2);
                inputStream = this.createPublicRingStream(keyStore, string4);
                directByteArrayOutputStream = new DirectByteArrayOutputStream(65536);
                inputStream3 = new ByteArrayInputStream(string.getBytes(string5));
                char c = this.getContentType();
                this.setContentType('t');
                this.signAndEncryptStream(inputStream3, DEFAULT_MESSAGE_FILE_NAME, inputStream2, string3, inputStream, (OutputStream)directByteArrayOutputStream, true, this.integrityProtect);
                this.setContentType(c);
                string6 = new String(directByteArrayOutputStream.toByteArray(), 0, directByteArrayOutputStream.size(), "UTF-8");
                Object var14_13 = null;
                if (inputStream3 == null) break block16;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var14_14 = null;
                if (inputStream3 != null) {
                    try {
                        inputStream3.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream2 = null;
                inputStream = null;
                inputStream3 = null;
                directByteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream3.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream2 != null) {
            try {
                inputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream2 = null;
        inputStream = null;
        inputStream3 = null;
        directByteArrayOutputStream = null;
        return string6;
    }

    public String signAndEncryptString(String string, KeyStore keyStore, String string2, String string3, String string4) throws PGPException, IOException {
        return this.signAndEncryptString(string, keyStore, string2, string3, string4, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String signAndEncryptString(String string, KeyStore keyStore, long l, String string2, long l2, String string3) throws PGPException, IOException {
        IOException iOException3;
        String string4;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        InputStream inputStream2;
        InputStream inputStream3;
        block16: {
            inputStream3 = null;
            inputStream2 = null;
            inputStream = null;
            byteArrayOutputStream = null;
            try {
                inputStream2 = this.createPrivateRingStream(keyStore, l);
                inputStream = this.createPublicRingStream(keyStore, l2);
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                inputStream3 = new ByteArrayInputStream(string.getBytes(string3));
                char c = this.getContentType();
                this.setContentType('t');
                this.signAndEncryptStream(inputStream3, DEFAULT_MESSAGE_FILE_NAME, inputStream2, string2, inputStream, (OutputStream)byteArrayOutputStream, true, this.integrityProtect);
                this.setContentType(c);
                string4 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), "UTF-8");
                Object var16_13 = null;
                if (inputStream3 == null) break block16;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var16_14 = null;
                if (inputStream3 != null) {
                    try {
                        inputStream3.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream3 = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream3.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream2 != null) {
            try {
                inputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream3 = null;
        byteArrayOutputStream = null;
        return string4;
    }

    public String signAndEncryptString(String string, KeyStore keyStore, long l, String string2, long l2) throws PGPException, IOException {
        return this.signAndEncryptString(string, keyStore, l, string2, l2, "UTF-8");
    }

    public String signAndEncryptString(String string, String string2, String string3, String string4) throws PGPException, IOException {
        return this.signAndEncryptString(string, string2, string3, string4, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String signAndEncryptString(String string, InputStream inputStream, String string2, InputStream inputStream2, String string3) throws PGPException, IOException {
        String string4;
        ByteArrayOutputStream byteArrayOutputStream;
        block6: {
            InputStream inputStream3 = null;
            byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                inputStream3 = new ByteArrayInputStream(string.getBytes(string3));
                this.signAndEncryptStream(inputStream3, DEFAULT_MESSAGE_FILE_NAME, inputStream, string2, inputStream2, (OutputStream)byteArrayOutputStream, true, false);
                string4 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), "UTF-8");
                Object var10_9 = null;
                if (inputStream3 == null) break block6;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (inputStream3 != null) {
                    try {
                        inputStream3.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                byteArrayOutputStream = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream3.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byteArrayOutputStream = null;
        byteArrayOutputStream = null;
        return string4;
    }

    public String signAndEncryptStringVersion3(String string, String string2, String string3, String string4) throws PGPException, IOException {
        return this.signAndEncryptStringVersion3(string, string2, string3, string4, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String signAndEncryptString(String string, String string2, String string3, String string4, String string5) throws PGPException, IOException {
        IOException iOException3;
        String string6;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        InputStream inputStream2;
        InputStream inputStream3;
        block16: {
            inputStream3 = null;
            inputStream2 = null;
            inputStream = null;
            byteArrayOutputStream = null;
            try {
                inputStream2 = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
                inputStream = PGPLib.readFileOrAsciiString(string4, "publicKeyFileName");
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                inputStream3 = new ByteArrayInputStream(string.getBytes(string5));
                this.signAndEncryptStream(inputStream3, DEFAULT_MESSAGE_FILE_NAME, inputStream2, string3, inputStream, (OutputStream)byteArrayOutputStream, true, this.integrityProtect);
                string6 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), "UTF-8");
                Object var12_11 = null;
                if (inputStream3 == null) break block16;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var12_12 = null;
                if (inputStream3 != null) {
                    try {
                        inputStream3.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream3 = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream3.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream2 != null) {
            try {
                inputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream3 = null;
        byteArrayOutputStream = null;
        return string6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String signAndEncryptStringVersion3(String string, String string2, String string3, String string4, String string5) throws PGPException, IOException {
        IOException iOException3;
        String string6;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        InputStream inputStream2;
        InputStream inputStream3;
        block16: {
            inputStream3 = null;
            inputStream2 = null;
            inputStream = null;
            byteArrayOutputStream = null;
            try {
                inputStream2 = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
                inputStream = PGPLib.readFileOrAsciiString(string4, "publicKeyFileName");
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                inputStream3 = new ByteArrayInputStream(string.getBytes(string5));
                this.signAndEncryptStreamVersion3(inputStream3, DEFAULT_MESSAGE_FILE_NAME, inputStream2, string3, inputStream, byteArrayOutputStream, true, false);
                string6 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), "UTF-8");
                Object var12_11 = null;
                if (inputStream3 == null) break block16;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var12_12 = null;
                if (inputStream3 != null) {
                    try {
                        inputStream3.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream3 = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream3.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream2 != null) {
            try {
                inputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream3 = null;
        byteArrayOutputStream = null;
        return string6;
    }

    public String decryptString(String string, String string2, String string3) throws IOException, PGPException {
        return this.decryptString(string, string2, string3, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptString(String string, String string2, String string3, String string4) throws IOException, PGPException {
        String string5;
        block5: {
            InputStream inputStream = null;
            try {
                inputStream = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
                string5 = this.decryptString(string, inputStream, string3, string4);
                Object var8_7 = null;
                if (inputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (inputStream == null) break block6;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string5;
    }

    public String decryptString(String string, InputStream inputStream, String string2) throws IOException, PGPException {
        return this.decryptString(string, inputStream, string2, "UTF-8");
    }

    public String decryptString(String string, KeyStore keyStore, String string2) throws IOException, PGPException {
        return this.decryptString(string, keyStore, string2, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptString(String string, KeyStore keyStore, String string2, String string3) throws IOException, PGPException {
        IOException iOException3;
        String string4;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayInputStream byteArrayInputStream;
        block11: {
            byteArrayInputStream = null;
            byteArrayOutputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                this.decryptStream((InputStream)byteArrayInputStream, keyStore, string2, (OutputStream)byteArrayOutputStream);
                string4 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), string3);
                Object var9_8 = null;
                if (byteArrayInputStream == null) break block11;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var9_9 = null;
                if (byteArrayInputStream != null) {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                byteArrayInputStream = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        byteArrayInputStream = null;
        byteArrayOutputStream = null;
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptString(String string, InputStream inputStream, String string2, String string3) throws IOException, PGPException {
        IOException iOException3;
        String string4;
        ByteArrayOutputStream byteArrayOutputStream;
        block10: {
            InputStream inputStream2 = null;
            byteArrayOutputStream = null;
            try {
                inputStream2 = PGPLib.readFileOrAsciiString(string, "message");
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                this.decryptStream(inputStream2, inputStream, string2, (OutputStream)byteArrayOutputStream);
                string4 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), string3);
                Object var9_8 = null;
                if (inputStream2 == null) break block10;
            }
            catch (Throwable throwable) {
                block12: {
                    IOException iOException22;
                    Object var9_9 = null;
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (byteArrayOutputStream == null) break block12;
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {}
                }
                throw throwable;
            }
            try {
                inputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptStream(InputStream inputStream, InputStream inputStream2, String string, OutputStream outputStream) throws PGPException, IOException {
        Object object;
        block15: {
            InputStream inputStream3 = PGPUtil.getDecoderStream((InputStream)inputStream);
            PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream3);
            Object object2 = null;
            try {
                object2 = pGPObjectFactory.nextObject();
            }
            catch (IOException iOException) {
                inputStream3.close();
                throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
            }
            if (object2 instanceof PGPMarker) {
                this.Debug("Skipping PGP marker.");
                object2 = pGPObjectFactory.nextObject();
            }
            try {
                SignatureCheck signatureCheck = new SignatureCheck();
                String string2 = null;
                if (object2 instanceof PGPEncryptedDataList) {
                    object = (PGPEncryptedDataList)object2;
                    string2 = this.parseEncryptedData((PGPEncryptedDataList)object, false, signatureCheck, null, inputStream2, string, null, outputStream);
                } else if (object2 instanceof PGPCompressedData) {
                    string2 = this.parseCompressedData((PGPCompressedData)object2, false, signatureCheck, null, null, outputStream);
                } else if (object2 instanceof PGPOnePassSignatureList) {
                    string2 = this.parseSignedData((PGPOnePassSignatureList)object2, pGPObjectFactory, null, null, outputStream, signatureCheck);
                } else if (object2 instanceof PGPSignatureList) {
                    string2 = this.parseSignedDataVersion3((PGPSignatureList)object2, pGPObjectFactory, null, null, outputStream, signatureCheck);
                } else if (object2 instanceof PGPLiteralData) {
                    string2 = this.parseLiteralData((PGPLiteralData)object2, null, outputStream);
                } else {
                    throw new NonPGPDataException("Unknown message format: " + object2);
                }
                object = string2;
                Object var12_12 = null;
                if (inputStream3 == null) break block15;
            }
            catch (Throwable throwable) {
                block16: {
                    Object var12_13 = null;
                    if (inputStream3 == null) break block16;
                    inputStream3.close();
                }
                throw throwable;
            }
            inputStream3.close();
        }
        return object;
    }

    public String[] decryptStreamTo(InputStream inputStream, InputStream inputStream2, String string, String string2) throws PGPException, IOException {
        return this.decryptStreamTo(inputStream, inputStream2, string, string2, null);
    }

    private String[] decryptStreamTo(InputStream inputStream, InputStream inputStream2, String string, String string2, String string3) throws PGPException, IOException {
        this.Debug("Decrypting stream to folder {0}", new File(string2).getAbsolutePath());
        InputStream inputStream3 = PGPUtil.getDecoderStream((InputStream)inputStream);
        PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream3);
        Object object = null;
        try {
            object = pGPObjectFactory.nextObject();
        }
        catch (IOException iOException) {
            throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
        }
        if (object instanceof PGPMarker) {
            this.Debug("Skipping PGP marker.");
            object = pGPObjectFactory.nextObject();
        }
        SignatureCheck signatureCheck = new SignatureCheck();
        String[] stringArray = new String[]{};
        if (object instanceof PGPEncryptedDataList) {
            PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
            stringArray = this.parseEncryptedDataTo(pGPEncryptedDataList, false, signatureCheck, null, inputStream2, string, null, string2, string3);
        } else if (object instanceof PGPCompressedData) {
            stringArray = this.parseCompressedDataTo((PGPCompressedData)object, false, signatureCheck, null, null, string2, string3);
        } else if (object instanceof PGPOnePassSignatureList) {
            stringArray = this.parseSignedDataTo((PGPOnePassSignatureList)object, pGPObjectFactory, null, null, string2, string3, signatureCheck);
        } else if (object instanceof PGPSignatureList) {
            stringArray = this.parseSignedDataVersion3To((PGPSignatureList)object, pGPObjectFactory, null, null, string2, string3, signatureCheck);
        } else if (object instanceof PGPLiteralData) {
            stringArray = this.parseLiteralDataTo((PGPLiteralData)object, null, string2, string3);
        } else {
            throw new NonPGPDataException("Unknown message format: " + object);
        }
        return stringArray;
    }

    public String[] decryptStreamTo(InputStream inputStream, KeyStore keyStore, String string, String string2) throws PGPException, IOException {
        return this.decryptStreamTo(inputStream, keyStore, string, string2, null);
    }

    private String[] decryptStreamTo(InputStream inputStream, KeyStore keyStore, String string, String string2, String string3) throws PGPException, IOException {
        this.Debug("Decrypting stream to folder {0}", new File(string2).getAbsolutePath());
        InputStream inputStream2 = PGPUtil.getDecoderStream((InputStream)inputStream);
        PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream2);
        Object object = null;
        try {
            object = pGPObjectFactory.nextObject();
        }
        catch (IOException iOException) {
            throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
        }
        if (object instanceof PGPMarker) {
            this.Debug("Skipping PGP marker.");
            object = pGPObjectFactory.nextObject();
        }
        SignatureCheck signatureCheck = new SignatureCheck();
        String[] stringArray = new String[]{};
        if (object instanceof PGPEncryptedDataList) {
            PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
            stringArray = this.parseEncryptedDataTo(pGPEncryptedDataList, false, signatureCheck, keyStore, null, string, null, string2, string3);
        } else if (object instanceof PGPCompressedData) {
            stringArray = this.parseCompressedDataTo((PGPCompressedData)object, false, signatureCheck, null, null, string2, string3);
        } else if (object instanceof PGPOnePassSignatureList) {
            stringArray = this.parseSignedDataTo((PGPOnePassSignatureList)object, pGPObjectFactory, null, null, string2, string3, signatureCheck);
        } else if (object instanceof PGPSignatureList) {
            stringArray = this.parseSignedDataVersion3To((PGPSignatureList)object, pGPObjectFactory, null, null, string2, string3, signatureCheck);
        } else if (object instanceof PGPLiteralData) {
            stringArray = this.parseLiteralDataTo((PGPLiteralData)object, null, string2, string3);
        } else {
            throw new NonPGPDataException("Unknown message format: " + object);
        }
        return stringArray;
    }

    public String decryptStream(InputStream inputStream, KeyStore keyStore, String string, OutputStream outputStream) throws PGPException, IOException {
        InputStream inputStream2 = PGPUtil.getDecoderStream((InputStream)inputStream);
        PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream2);
        Object object = null;
        try {
            object = pGPObjectFactory.nextObject();
        }
        catch (IOException iOException) {
            throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
        }
        if (object instanceof PGPMarker) {
            this.Debug("Skipping PGP marker.");
            object = pGPObjectFactory.nextObject();
        }
        SignatureCheck signatureCheck = new SignatureCheck();
        String string2 = null;
        if (object instanceof PGPEncryptedDataList) {
            PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
            string2 = this.parseEncryptedData(pGPEncryptedDataList, false, signatureCheck, keyStore, null, string, null, outputStream);
        } else if (object instanceof PGPCompressedData) {
            string2 = this.parseCompressedData((PGPCompressedData)object, false, signatureCheck, null, null, outputStream);
        } else if (object instanceof PGPLiteralData) {
            string2 = this.parseLiteralData((PGPLiteralData)object, null, outputStream);
        } else if (object instanceof PGPOnePassSignatureList) {
            string2 = this.parseSignedData((PGPOnePassSignatureList)object, pGPObjectFactory, null, null, outputStream, signatureCheck);
        } else if (object instanceof PGPSignatureList) {
            string2 = this.parseSignedDataVersion3((PGPSignatureList)object, pGPObjectFactory, null, null, outputStream, signatureCheck);
        } else {
            throw new NonPGPDataException("Unknown message format: " + object);
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String decryptFile(String var1_1, KeyStore var2_2, String var3_3, String var4_4) throws PGPException, IOException {
        block19: {
            block15: {
                var5_5 = null;
                var6_6 = null;
                this.Debug("Decrypting file {0}", var1_1);
                this.Debug("Decrypting to {0}", new File(var4_4).getAbsolutePath());
                var7_7 = false;
                try {
                    try {
                        var5_5 = new FileInputStream(var1_1);
                        var6_6 = new FileOutputStream(var4_4);
                        var8_8 = this.decryptStream((InputStream)var5_5, var2_2, var3_3, (OutputStream)var6_6);
                        var10_11 = null;
                        if (var5_5 == null) break block15;
                    }
                    catch (lw.bouncycastle.openpgp.PGPException var8_9) {
                        var7_7 = true;
                        throw IOUtil.newPGPException(var8_9);
                    }
                    catch (IOException var8_10) {
                        var7_7 = true;
                        throw var8_10;
                    }
                }
                catch (Throwable var9_15) {
                    var10_12 = null;
                    if (var5_5 != null) {
                        try {
                            var5_5.close();
                        }
                        catch (IOException var11_14) {
                            // empty catch block
                        }
                    }
                    if (var6_6 != null) {
                        try {
                            var6_6.flush();
                            var6_6.close();
                        }
                        catch (IOException var11_14) {
                            // empty catch block
                        }
                    }
                    if (var7_7 == false) throw var9_15;
                    var11_14 = new File(var4_4);
                    if (var11_14.exists() == false) throw var9_15;
                    var11_14.delete();
                    throw var9_15;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 109->117)] { 
lbl47:
                // 1 sources

                var5_5.close();
                break block15;
lbl49:
                // 1 sources

                catch (IOException var11_13) {
                    // empty catch block
                }
            }
            if (var6_6 != null) {
                ** try [egrp 3[TRYBLOCK] [5 : 124->137)] { 
lbl54:
                // 1 sources

                var6_6.flush();
                var6_6.close();
                break block19;
lbl57:
                // 1 sources

                catch (IOException var11_13) {
                    // empty catch block
                }
            }
        }
        if (var7_7 == false) return var8_8;
        var11_13 = new File(var4_4);
        if (var11_13.exists() == false) return var8_8;
        var11_13.delete();
        return var8_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptFile(String string, String string2, String string3, String string4) throws PGPException, IOException {
        String string5;
        block5: {
            this.Debug("Decrypting file {0}", string);
            InputStream inputStream = null;
            try {
                inputStream = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
                string5 = this.decryptFile(string, inputStream, string3, string4);
                Object var8_7 = null;
                if (inputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (inputStream == null) break block6;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string5;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String decryptFilePBE(String var1_1, String var2_2, String var3_3) throws PGPException, IOException {
        block19: {
            block15: {
                this.Debug("Decrypting password encrypted file {0}", var1_1);
                this.Debug("Decrypting to {0}", new File(var3_3).getAbsolutePath());
                var4_4 = null;
                var5_5 = null;
                var6_6 = false;
                try {
                    try {
                        var4_4 = new BufferedInputStream(new FileInputStream(var1_1));
                        var5_5 = new BufferedOutputStream(new FileOutputStream(var3_3));
                        var7_7 = this.decryptStreamPBE(var4_4, var2_2, var5_5);
                        var9_10 = null;
                        if (var4_4 == null) break block15;
                    }
                    catch (lw.bouncycastle.openpgp.PGPException var7_8) {
                        var6_6 = true;
                        throw IOUtil.newPGPException(var7_8);
                    }
                    catch (IOException var7_9) {
                        var6_6 = true;
                        throw var7_9;
                    }
                }
                catch (Throwable var8_14) {
                    var9_11 = null;
                    if (var4_4 != null) {
                        try {
                            var4_4.close();
                        }
                        catch (IOException var10_13) {
                            // empty catch block
                        }
                    }
                    if (var5_5 != null) {
                        var5_5.flush();
                        try {
                            var5_5.close();
                        }
                        catch (IOException var10_13) {
                            // empty catch block
                        }
                    }
                    if (var6_6 == false) throw var8_14;
                    var10_13 = new File(var3_3);
                    if (var10_13.exists() == false) throw var8_14;
                    var10_13.delete();
                    throw var8_14;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 120->128)] { 
lbl47:
                // 1 sources

                var4_4.close();
                break block15;
lbl49:
                // 1 sources

                catch (IOException var10_12) {
                    // empty catch block
                }
            }
            if (var5_5 != null) {
                var5_5.flush();
                ** try [egrp 3[TRYBLOCK] [5 : 140->148)] { 
lbl55:
                // 1 sources

                var5_5.close();
                break block19;
lbl57:
                // 1 sources

                catch (IOException var10_12) {
                    // empty catch block
                }
            }
        }
        if (var6_6 == false) return var7_7;
        var10_12 = new File(var3_3);
        if (var10_12.exists() == false) return var7_7;
        var10_12.delete();
        return var7_7;
    }

    public String decryptStringPBE(String string, String string2) throws IOException, PGPException {
        return this.decryptStringPBE(string, string2, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptStringPBE(String string, String string2, String string3) throws IOException, PGPException {
        IOException iOException3;
        String string4;
        ByteArrayOutputStream byteArrayOutputStream;
        block10: {
            ByteArrayInputStream byteArrayInputStream = null;
            byteArrayOutputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes("ASCII"));
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                this.decryptStreamPBE(byteArrayInputStream, string2, byteArrayOutputStream);
                string4 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), string3);
                Object var8_7 = null;
                if (byteArrayInputStream == null) break block10;
            }
            catch (Throwable throwable) {
                block12: {
                    IOException iOException22;
                    Object var8_8 = null;
                    if (byteArrayInputStream != null) {
                        try {
                            ((InputStream)byteArrayInputStream).close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (byteArrayOutputStream == null) break block12;
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptStreamPBE(InputStream inputStream, String string, OutputStream outputStream) throws PGPException, IOException {
        Object object;
        InputStream inputStream2 = PGPUtil.getDecoderStream((InputStream)inputStream);
        try {
            PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream2);
            Object object2 = null;
            try {
                object2 = pGPObjectFactory.nextObject();
            }
            catch (IOException iOException) {
                throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
            }
            if (object2 instanceof PGPMarker) {
                object2 = pGPObjectFactory.nextObject();
            }
            SignatureCheck signatureCheck = new SignatureCheck();
            String string2 = null;
            if (object2 instanceof PGPEncryptedDataList) {
                object = (PGPEncryptedDataList)object2;
                string2 = this.parseEncryptedDataPBE((PGPEncryptedDataList)object, false, signatureCheck, string, null, null, outputStream);
            } else if (object2 instanceof PGPCompressedData) {
                string2 = this.parseCompressedData((PGPCompressedData)object2, false, signatureCheck, null, null, outputStream);
            } else if (object2 instanceof PGPOnePassSignatureList) {
                string2 = this.parseSignedData((PGPOnePassSignatureList)object2, pGPObjectFactory, null, null, outputStream, signatureCheck);
            } else if (object2 instanceof PGPSignatureList) {
                string2 = this.parseSignedDataVersion3((PGPSignatureList)object2, pGPObjectFactory, null, null, outputStream, signatureCheck);
            } else if (object2 instanceof PGPLiteralData) {
                string2 = this.parseLiteralData((PGPLiteralData)object2, null, outputStream);
            } else {
                throw new NonPGPDataException("Unknown message format: " + object2);
            }
            object = string2;
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            inputStream2.close();
            throw throwable;
        }
        inputStream2.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] decryptFileTo(String string, String string2, String string3, String string4) throws PGPException, IOException {
        IOException iOException3;
        String[] stringArray;
        InputStream inputStream;
        block10: {
            this.Debug("Decrypting file {0}", string);
            FileInputStream fileInputStream = null;
            inputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                inputStream = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
                stringArray = this.decryptStreamTo((InputStream)fileInputStream, inputStream, string3, string4, string);
                Object var9_8 = null;
                if (fileInputStream == null) break block10;
            }
            catch (Throwable throwable) {
                block12: {
                    IOException iOException22;
                    Object var9_9 = null;
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (inputStream == null) break block12;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] decryptFileTo(String string, KeyStore keyStore, String string2, String string3) throws PGPException, IOException {
        String[] stringArray;
        block5: {
            this.Debug("Decrypting file {0}", string);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                stringArray = this.decryptStreamTo((InputStream)fileInputStream, keyStore, string2, string3, string);
                Object var8_7 = null;
                if (fileInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (fileInputStream == null) break block6;
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stringArray;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String decryptFile(String var1_1, InputStream var2_2, String var3_3, String var4_4) throws PGPException, IOException {
        block19: {
            block15: {
                var5_5 = null;
                var6_6 = null;
                this.Debug("Decrypting file {0}", var1_1);
                this.Debug("Decrypting to {0}", new File(var4_4).getAbsolutePath());
                var7_7 = false;
                try {
                    try {
                        var5_5 = new BufferedInputStream(new FileInputStream(var1_1), 65536);
                        var6_6 = new BufferedOutputStream(new FileOutputStream(var4_4), 65536);
                        var8_8 = this.decryptStream((InputStream)var5_5, var2_2, var3_3, var6_6);
                        var10_11 = null;
                        if (var5_5 == null) break block15;
                    }
                    catch (PGPException var8_9) {
                        var7_7 = true;
                        throw var8_9;
                    }
                    catch (IOException var8_10) {
                        var7_7 = true;
                        throw var8_10;
                    }
                }
                catch (Throwable var9_15) {
                    var10_12 = null;
                    if (var5_5 != null) {
                        try {
                            var5_5.close();
                        }
                        catch (IOException var11_14) {
                            // empty catch block
                        }
                    }
                    if (var6_6 != null) {
                        var6_6.flush();
                        try {
                            var6_6.close();
                        }
                        catch (IOException var11_14) {
                            // empty catch block
                        }
                    }
                    if (var7_7 == false) throw var9_15;
                    var11_14 = new File(var4_4);
                    if (var11_14.exists() == false) throw var9_15;
                    var11_14.delete();
                    throw var9_15;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 124->132)] { 
lbl47:
                // 1 sources

                var5_5.close();
                break block15;
lbl49:
                // 1 sources

                catch (IOException var11_13) {
                    // empty catch block
                }
            }
            if (var6_6 != null) {
                var6_6.flush();
                ** try [egrp 3[TRYBLOCK] [5 : 144->152)] { 
lbl55:
                // 1 sources

                var6_6.close();
                break block19;
lbl57:
                // 1 sources

                catch (IOException var11_13) {
                    // empty catch block
                }
            }
        }
        if (var7_7 == false) return var8_8;
        var11_13 = new File(var4_4);
        if (var11_13.exists() == false) return var8_8;
        var11_13.delete();
        return var8_8;
    }

    public String encryptString(String string, String string2) throws PGPException, IOException {
        return this.encryptString(string, string2, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptString(String string, String string2, String string3) throws PGPException, IOException {
        String string4;
        block5: {
            InputStream inputStream = null;
            try {
                inputStream = PGPLib.readFileOrAsciiString(string2, "publicKeyFileName");
                string4 = this.encryptString(string, inputStream, string3);
                Object var7_6 = null;
                if (inputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var7_7 = null;
                    if (inputStream == null) break block6;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String encryptString(String string, String[] stringArray, String string2) throws PGPException, IOException {
        IOException iOException2222;
        String string3;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        InputStream[] inputStreamArray;
        block17: {
            LinkedList<InputStream> linkedList = new LinkedList<InputStream>();
            InputStream inputStream2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                inputStream2 = PGPLib.readFileOrAsciiString(stringArray[i], "publicKeyFileNames :" + i);
                linkedList.add(inputStream2);
            }
            inputStreamArray = linkedList.toArray(new InputStream[linkedList.size()]);
            inputStream = null;
            byteArrayOutputStream = null;
            byteArrayOutputStream = new ByteArrayOutputStream(65536);
            inputStream = new ByteArrayInputStream(string.getBytes(string2));
            this.encryptStream(inputStream, DEFAULT_MESSAGE_FILE_NAME, inputStreamArray, (OutputStream)byteArrayOutputStream, true, this.integrityProtect);
            string3 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), "UTF-8");
            Object var11_11 = null;
            if (inputStream == null) break block17;
            try {
                inputStream.close();
            }
            catch (IOException iOException2222) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException2222) {
                // empty catch block
            }
        }
        inputStream = null;
        byteArrayOutputStream = null;
        for (int i = 0; i < inputStreamArray.length; ++i) {
            InputStream inputStream3 = inputStreamArray[i];
            if (inputStream3 == null) continue;
            try {
                inputStream3.close();
                continue;
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        return string3;
        catch (Throwable throwable) {
            IOException iOException42222;
            Object var11_12 = null;
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException42222) {
                    // empty catch block
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.flush();
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException42222) {
                    // empty catch block
                }
            }
            inputStream = null;
            byteArrayOutputStream = null;
            for (int i = 0; i < inputStreamArray.length; ++i) {
                InputStream inputStream4 = inputStreamArray[i];
                if (inputStream4 == null) continue;
                try {
                    inputStream4.close();
                    continue;
                }
                catch (IOException iOException5) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    public String encryptString(String string, KeyStore keyStore, String string2) throws PGPException, IOException {
        return this.encryptString(string, keyStore, string2, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptString(String string, KeyStore keyStore, String string2, String string3) throws PGPException, IOException {
        String string4;
        block5: {
            InputStream inputStream = null;
            try {
                inputStream = this.createPublicRingStream(keyStore, string2);
                string4 = this.encryptString(string, inputStream, string3);
                Object var8_7 = null;
                if (inputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (inputStream == null) break block6;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string4;
    }

    public String encryptString(String string, KeyStore keyStore, long l) throws PGPException, IOException {
        return this.encryptString(string, keyStore, l, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptString(String string, KeyStore keyStore, long l, String string2) throws PGPException, IOException {
        String string3;
        block5: {
            InputStream inputStream = null;
            try {
                inputStream = this.createPublicRingStream(keyStore, l);
                string3 = this.encryptString(string, inputStream, string2);
                Object var9_7 = null;
                if (inputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var9_8 = null;
                    if (inputStream == null) break block6;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptString(String string, KeyStore keyStore, long[] lArray, String string2) throws PGPException, IOException {
        IOException iOException3;
        String string3;
        InputStream inputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        block11: {
            byteArrayOutputStream = null;
            inputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                inputStream = new ByteArrayInputStream(string.getBytes(string2));
                this.encryptStream(inputStream, DEFAULT_MESSAGE_FILE_NAME, keyStore, lArray, (OutputStream)byteArrayOutputStream, true, this.integrityProtect);
                string3 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), "UTF-8");
                Object var9_8 = null;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var9_9 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream = null;
        byteArrayOutputStream = null;
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptString(String string, KeyStore keyStore, String[] stringArray, String string2) throws PGPException, IOException {
        IOException iOException3;
        String string3;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        block11: {
            inputStream = null;
            byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                inputStream = new ByteArrayInputStream(string.getBytes(string2));
                this.encryptStream(inputStream, DEFAULT_MESSAGE_FILE_NAME, keyStore, stringArray, (OutputStream)byteArrayOutputStream, true, this.integrityProtect);
                string3 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), "UTF-8");
                Object var9_8 = null;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var9_9 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream = null;
        byteArrayOutputStream = null;
        return string3;
    }

    public String encryptString(String string, InputStream inputStream) throws PGPException, IOException {
        return this.encryptString(string, inputStream, "UTF-8");
    }

    public String encryptString(String string, InputStream inputStream, String string2) throws PGPException, IOException {
        return this.encryptString(string, DEFAULT_MESSAGE_FILE_NAME, inputStream, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptString(String string, String string2, InputStream inputStream, String string3) throws PGPException, IOException {
        IOException iOException3;
        String string4;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream2;
        block11: {
            inputStream2 = null;
            byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                inputStream2 = new ByteArrayInputStream(string.getBytes(string3));
                this.encryptStream(inputStream2, string2, inputStream, (OutputStream)byteArrayOutputStream, true, this.integrityProtect);
                string4 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), "UTF-8");
                Object var9_8 = null;
                if (inputStream2 == null) break block11;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var9_9 = null;
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.flush();
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream2 = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            byteArrayOutputStream.flush();
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream2 = null;
        byteArrayOutputStream = null;
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String signString(String string, String string2, String string3) throws PGPException, IOException {
        String string4;
        block5: {
            InputStream inputStream = null;
            try {
                inputStream = PGPLib.readFileOrAsciiString(string2, "privateKeyFile");
                string4 = this.signString(string, inputStream, string3, "UTF-8");
                Object var7_6 = null;
                if (inputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var7_7 = null;
                    if (inputStream == null) break block6;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String signString(String string, String string2, String string3, String string4) throws PGPException, IOException {
        String string5;
        block5: {
            InputStream inputStream = null;
            try {
                inputStream = PGPLib.readFileOrAsciiString(string2, "privateKeyFile");
                string5 = this.signString(string, inputStream, string3, string4);
                Object var8_7 = null;
                if (inputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (inputStream == null) break block6;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String signString(String string, InputStream inputStream, String string2, String string3) throws PGPException, IOException {
        IOException iOException3;
        String string4;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream2;
        block11: {
            inputStream2 = null;
            byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                inputStream2 = new ByteArrayInputStream(string.getBytes(string3));
                this.signStream(inputStream2, DEFAULT_MESSAGE_FILE_NAME, inputStream, string2, byteArrayOutputStream, true);
                string4 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), "UTF-8");
                Object var9_8 = null;
                if (inputStream2 == null) break block11;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var9_9 = null;
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream2 = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream2 = null;
        byteArrayOutputStream = null;
        return string4;
    }

    public String signString(String string, InputStream inputStream, String string2) throws PGPException, IOException {
        return this.signString(string, inputStream, string2, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String signString(String string, KeyStore keyStore, String string2, String string3, String string4) throws PGPException, IOException {
        IOException iOException3;
        String string5;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        block11: {
            inputStream = null;
            byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                inputStream = new ByteArrayInputStream(string.getBytes(string4));
                this.signStream(inputStream, DEFAULT_MESSAGE_FILE_NAME, keyStore, string2, string3, (OutputStream)byteArrayOutputStream, true);
                string5 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), "UTF-8");
                Object var10_9 = null;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var10_10 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream = null;
        byteArrayOutputStream = null;
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String signString(String string, KeyStore keyStore, long l, String string2, String string3) throws PGPException, IOException {
        IOException iOException3;
        String string4;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        block11: {
            inputStream = null;
            byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                inputStream = new ByteArrayInputStream(string.getBytes(string3));
                this.signStream(inputStream, DEFAULT_MESSAGE_FILE_NAME, keyStore, l, string2, (OutputStream)byteArrayOutputStream, true);
                string4 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), "UTF-8");
                Object var11_9 = null;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var11_10 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream = null;
        byteArrayOutputStream = null;
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encryptStream(InputStream inputStream, String string, InputStream[] inputStreamArray, OutputStream outputStream, boolean bl, boolean bl2) throws PGPException, IOException {
        try {
            PGPPublicKey[] pGPPublicKeyArray = new PGPPublicKey[inputStreamArray.length];
            for (int i = 0; i < inputStreamArray.length; ++i) {
                pGPPublicKeyArray[i] = this.readPublicKeyForEncryption(inputStreamArray[i]);
            }
            this.inernalEncryptStream(inputStream, string, pGPPublicKeyArray, outputStream, new Date(), bl, bl2, false);
            Object var10_9 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void encryptStream(InputStream inputStream, String string, long l, String string2, OutputStream outputStream, boolean bl) throws PGPException, IOException {
        this.encryptStream(inputStream, string, l, string2, outputStream, bl, this.integrityProtect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encryptStream(InputStream inputStream, String string, long l, String string2, OutputStream outputStream, boolean bl, boolean bl2) throws PGPException, IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(string2));
            this.encryptStream(inputStream, string, l, fileInputStream, outputStream, bl, bl2);
            Object var11_9 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)fileInputStream).close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void encryptStream(InputStream inputStream, String string, KeyStore keyStore, String string2, OutputStream outputStream, boolean bl) throws PGPException, IOException {
        this.encryptStream(inputStream, string, keyStore, string2, outputStream, bl, this.integrityProtect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encryptStream(InputStream inputStream, String string, KeyStore keyStore, String string2, OutputStream outputStream, boolean bl, boolean bl2) throws PGPException, IOException {
        IOException iOException3;
        block11: {
            InputStream inputStream2 = this.createPublicRingStream(keyStore, string2);
            try {
                this.encryptStream(inputStream, string, inputStream2, outputStream, bl, bl2);
                Object var10_9 = null;
                if (inputStream2 == null) break block11;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var10_10 = null;
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                inputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encryptStream(InputStream inputStream, String string, KeyStore keyStore, String[] stringArray, OutputStream outputStream, boolean bl, boolean bl2) throws PGPException, IOException {
        InputStream[] inputStreamArray = new InputStream[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            inputStreamArray[i] = this.createPublicRingStream(keyStore, stringArray[i]);
        }
        try {
            this.encryptStream(inputStream, string, inputStreamArray, outputStream, bl, bl2);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                InputStream inputStream2 = inputStreamArray[i];
                if (inputStream2 == null) continue;
                try {
                    inputStream2.close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            InputStream inputStream3 = inputStreamArray[i];
            if (inputStream3 == null) continue;
            try {
                inputStream3.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encryptStream(InputStream inputStream, String string, KeyStore keyStore, long[] lArray, OutputStream outputStream, boolean bl, boolean bl2) throws PGPException, IOException {
        InputStream[] inputStreamArray = new InputStream[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            PGPPublicKeyRing pGPPublicKeyRing = keyStore.findPublicKeyRing(lArray[i]);
            inputStreamArray[i] = new ByteArrayInputStream(pGPPublicKeyRing.getEncoded());
        }
        try {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            this.encryptStream(inputStream, string, inputStreamArray, outputStream, bl, bl2);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            for (int i = 0; i < lArray.length; ++i) {
                InputStream inputStream2 = inputStreamArray[i];
                if (inputStream2 == null) continue;
                try {
                    inputStream2.close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        for (int i = 0; i < lArray.length; ++i) {
            InputStream inputStream3 = inputStreamArray[i];
            if (inputStream3 == null) continue;
            try {
                inputStream3.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encryptStream(InputStream inputStream, String string, KeyStore keyStore, long l, OutputStream outputStream, boolean bl, boolean bl2) throws PGPException, IOException {
        ByteArrayInputStream byteArrayInputStream;
        block12: {
            IOException iOException3;
            block11: {
                PGPPublicKeyRing pGPPublicKeyRing = keyStore.findPublicKeyRing(l);
                byteArrayInputStream = null;
                try {
                    byteArrayInputStream = new ByteArrayInputStream(pGPPublicKeyRing.getEncoded());
                    this.encryptStream(inputStream, string, byteArrayInputStream, outputStream, bl, bl2);
                    Object var12_10 = null;
                    if (byteArrayInputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    IOException iOException22;
                    Object var12_11 = null;
                    if (byteArrayInputStream != null) {
                        try {
                            ((InputStream)byteArrayInputStream).close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    byteArrayInputStream = null;
                    throw throwable;
                }
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                    break block12;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                {
                }
            }
        }
        byteArrayInputStream = null;
    }

    public void encryptStream(InputStream inputStream, String string, long l, InputStream inputStream2, OutputStream outputStream, boolean bl, boolean bl2) throws PGPException, IOException {
        PGPPublicKey pGPPublicKey = this.readPublicKeyForEncryption(inputStream2);
        this.internalEncryptStream(inputStream, string, l, new PGPPublicKey[]{pGPPublicKey}, outputStream, bl, bl2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encryptStream(InputStream inputStream, String string, InputStream inputStream2, OutputStream outputStream, boolean bl, boolean bl2) throws PGPException, IOException {
        try {
            PGPPublicKey pGPPublicKey = this.readPublicKeyForEncryption(inputStream2);
            this.internalEncryptStream2(inputStream, string, new PGPPublicKey[]{pGPPublicKey}, outputStream, new Date(), bl, bl2, false);
            Object var9_8 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encryptStream(InputStream inputStream, String string, PGPKeyPair pGPKeyPair, OutputStream outputStream, boolean bl, boolean bl2) throws PGPException, IOException {
        try {
            PGPPublicKey pGPPublicKey = this.readPublicKeyForEncryption(pGPKeyPair.getRawPublicKeyRing());
            this.internalEncryptStream2(inputStream, string, new PGPPublicKey[]{pGPPublicKey}, outputStream, new Date(), bl, bl2, false);
            Object var9_8 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public String encryptStringPBE(String string, String string2) throws PGPException, IOException {
        return this.encryptStringPBE(string, string2, "UTF-8");
    }

    public String encryptStringWithPassword(String string, String string2) throws PGPException, IOException {
        return this.encryptStringPBE(string, string2, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptStringPBE(String string, String string2, String string3) throws PGPException, IOException {
        IOException iOException3;
        String string4;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        block11: {
            inputStream = null;
            byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                inputStream = new ByteArrayInputStream(string.getBytes(string3));
                this.encryptStreamPBE(inputStream, DEFAULT_MESSAGE_FILE_NAME, string2, byteArrayOutputStream, true, this.integrityProtect);
                string4 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), "UTF-8");
                Object var8_7 = null;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var8_8 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream = null;
        byteArrayOutputStream = null;
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptStringWithPassword(String string, String string2, String string3) throws PGPException, IOException {
        IOException iOException3;
        String string4;
        DirectByteArrayOutputStream directByteArrayOutputStream;
        InputStream inputStream;
        block11: {
            inputStream = null;
            directByteArrayOutputStream = null;
            try {
                directByteArrayOutputStream = new DirectByteArrayOutputStream(65536);
                inputStream = new ByteArrayInputStream(string.getBytes(string3));
                this.encryptStreamPBE(inputStream, DEFAULT_MESSAGE_FILE_NAME, string2, directByteArrayOutputStream, true, this.integrityProtect);
                string4 = new String(directByteArrayOutputStream.toByteArray(), 0, directByteArrayOutputStream.size(), "UTF-8");
                Object var8_7 = null;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var8_8 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (directByteArrayOutputStream != null) {
                    try {
                        directByteArrayOutputStream.flush();
                        directByteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream = null;
                directByteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (directByteArrayOutputStream != null) {
            try {
                directByteArrayOutputStream.flush();
                directByteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream = null;
        directByteArrayOutputStream = null;
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encryptStreamPBE(InputStream inputStream, String string, String string2, OutputStream outputStream, boolean bl, boolean bl2) throws PGPException, IOException {
        try {
            this.inernalEncryptStreamPBE(inputStream, string, string2, outputStream, bl, bl2);
            Object var8_7 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    /*
     * Loose catch block
     */
    public void encryptFilePBE(String string, String string2, String string3, String string4, boolean bl, boolean bl2) throws PGPException, IOException {
        block24: {
            Serializable serializable2222;
            boolean bl3;
            OutputStream outputStream;
            InputStream inputStream;
            BufferedInputStream bufferedInputStream;
            block21: {
                File file = new File(string);
                bufferedInputStream = null;
                inputStream = null;
                outputStream = null;
                this.Debug("Password encrypting file {0}", string);
                this.Debug("Encrypting to {0}", new File(string4).getAbsolutePath());
                bl3 = false;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string), 65536);
                outputStream = new BufferedOutputStream(new FileOutputStream(string4), 65536);
                inputStream = PGPLib.readFileOrAsciiString(string2, "publicKeyFileName");
                PGPPublicKey pGPPublicKey = this.readPublicKeyForEncryption(inputStream);
                this.inernalEncryptStreamPBE(bufferedInputStream, file.getName(), file.length(), pGPPublicKey, string3, outputStream, bl, bl2);
                Object var14_15 = null;
                if (inputStream == null) break block21;
                try {
                    inputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (bufferedInputStream != null) {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (bl3 && ((File)(serializable2222 = new File(string4))).exists()) {
                ((File)serializable2222).delete();
            }
            break block24;
            {
                catch (PGPException pGPException) {
                    bl3 = true;
                    throw pGPException;
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable32222;
                Object var14_16 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (bl3 && ((File)(serializable32222 = new File(string4))).exists()) {
                    ((File)serializable32222).delete();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void encryptFilePBE(String string, String string2, String string3, boolean bl, boolean bl2) throws PGPException, IOException {
        block24: {
            Serializable serializable2222;
            boolean bl3;
            OutputStream outputStream;
            InputStream inputStream;
            BufferedInputStream bufferedInputStream;
            block21: {
                File file = new File(string);
                bufferedInputStream = null;
                inputStream = null;
                outputStream = null;
                this.Debug("Password encrypting file {0}", string);
                this.Debug("Encrypting to {0}", new File(string3).getAbsolutePath());
                bl3 = false;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string), 65536);
                outputStream = new BufferedOutputStream(new FileOutputStream(string3), 65536);
                this.inernalEncryptStreamPBE(bufferedInputStream, file.getName(), string2, outputStream, bl, bl2);
                Object var13_11 = null;
                if (inputStream == null) break block21;
                try {
                    inputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (bufferedInputStream != null) {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (bl3 && ((File)(serializable2222 = new File(string3))).exists()) {
                ((File)serializable2222).delete();
            }
            break block24;
            {
                catch (PGPException pGPException) {
                    bl3 = true;
                    throw pGPException;
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable32222;
                Object var13_12 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (bl3 && ((File)(serializable32222 = new File(string3))).exists()) {
                    ((File)serializable32222).delete();
                }
                throw throwable;
            }
        }
    }

    public void encryptFile(String string, String string2, String string3, boolean bl) throws PGPException, IOException {
        this.encryptFile(string, string2, string3, bl, this.integrityProtect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encryptFile(String string, String string2, String string3, boolean bl, boolean bl2) throws PGPException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = PGPLib.readFileOrAsciiString(string2, "publicKeyFileName");
            this.encryptFile(string, inputStream, string3, bl, bl2);
            Object var8_7 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void encryptFile(String string, String[] stringArray, String string2, boolean bl, boolean bl2) throws PGPException, IOException {
        block25: {
            Serializable serializable3222;
            boolean bl3;
            OutputStream outputStream;
            Object object;
            block23: {
                Serializable serializable22222;
                this.Debug("Encrypting file {0}", string);
                this.Debug("Encrypting to {0}", new File(string2).getAbsolutePath());
                LinkedList<PGPPublicKey> linkedList = new LinkedList<PGPPublicKey>();
                InputStream inputStream = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    Object var11_11;
                    try {
                        inputStream = PGPLib.readFileOrAsciiString(stringArray[i], "publicKeysFileNames :" + i);
                        object = this.readPublicKeyForEncryption(inputStream);
                        linkedList.add((PGPPublicKey)object);
                        var11_11 = null;
                        if (inputStream == null) continue;
                    }
                    catch (Throwable throwable) {
                        var11_11 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException serializable22222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable22222) {}
                }
                PGPPublicKey[] pGPPublicKeyArray = linkedList.toArray(new PGPPublicKey[linkedList.size()]);
                object = null;
                outputStream = null;
                bl3 = false;
                serializable22222 = new File(string);
                object = new FileInputStream((File)serializable22222);
                outputStream = new FileOutputStream(string2);
                boolean bl4 = false;
                this.internalEncryptStream2((InputStream)object, ((File)serializable22222).getName(), pGPPublicKeyArray, outputStream, new Date(((File)serializable22222).lastModified()), bl, bl2, bl4);
                Object var15_19 = null;
                if (object == null) break block23;
                try {
                    ((FileInputStream)object).close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (bl3 && ((File)(serializable3222 = new File(string2))).exists()) {
                ((File)serializable3222).delete();
            }
            break block25;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable42222;
                Object var15_20 = null;
                if (object != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (IOException serializable42222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        ((FileOutputStream)outputStream).close();
                    }
                    catch (IOException serializable42222) {
                        // empty catch block
                    }
                }
                if (bl3 && ((File)(serializable42222 = new File(string2))).exists()) {
                    ((File)serializable42222).delete();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void encryptFile(String string, KeyStore keyStore, String[] stringArray, String string2, boolean bl, boolean bl2) throws PGPException, IOException {
        block25: {
            Serializable serializable3222;
            boolean bl3;
            OutputStream outputStream;
            Object object;
            block23: {
                Serializable serializable22222;
                this.Debug("Encrypting file {0}", string);
                this.Debug("Encrypting to {0}", new File(string2).getAbsolutePath());
                LinkedList<PGPPublicKey> linkedList = new LinkedList<PGPPublicKey>();
                InputStream inputStream = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    Object var12_12;
                    try {
                        inputStream = this.createPublicRingStream(keyStore, stringArray[i]);
                        object = this.readPublicKeyForEncryption(inputStream);
                        linkedList.add((PGPPublicKey)object);
                        var12_12 = null;
                        if (inputStream == null) continue;
                    }
                    catch (Throwable throwable) {
                        var12_12 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException serializable22222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable22222) {}
                }
                PGPPublicKey[] pGPPublicKeyArray = linkedList.toArray(new PGPPublicKey[linkedList.size()]);
                object = null;
                outputStream = null;
                bl3 = false;
                serializable22222 = new File(string);
                object = new FileInputStream((File)serializable22222);
                outputStream = new FileOutputStream(string2);
                boolean bl4 = false;
                this.internalEncryptStream2((InputStream)object, ((File)serializable22222).getName(), pGPPublicKeyArray, outputStream, new Date(((File)serializable22222).lastModified()), bl, bl2, bl4);
                Object var16_20 = null;
                if (object == null) break block23;
                try {
                    ((FileInputStream)object).close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (bl3 && ((File)(serializable3222 = new File(string2))).exists()) {
                ((File)serializable3222).delete();
            }
            break block25;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable42222;
                Object var16_21 = null;
                if (object != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (IOException serializable42222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        ((FileOutputStream)outputStream).close();
                    }
                    catch (IOException serializable42222) {
                        // empty catch block
                    }
                }
                if (bl3 && ((File)(serializable42222 = new File(string2))).exists()) {
                    ((File)serializable42222).delete();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void encryptFile(String string, KeyStore keyStore, long[] lArray, String string2, boolean bl, boolean bl2) throws PGPException, IOException {
        block25: {
            Serializable serializable3222;
            boolean bl3;
            OutputStream outputStream;
            Object object;
            block23: {
                Serializable serializable22222;
                this.Debug("Encrypting file {0}", string);
                this.Debug("Encrypting to {0}", new File(string2).getAbsolutePath());
                LinkedList<PGPPublicKey> linkedList = new LinkedList<PGPPublicKey>();
                InputStream inputStream = null;
                for (int i = 0; i < lArray.length; ++i) {
                    Object var12_12;
                    try {
                        inputStream = this.createPublicRingStream(keyStore, lArray[i]);
                        object = this.readPublicKeyForEncryption(inputStream);
                        linkedList.add((PGPPublicKey)object);
                        var12_12 = null;
                        if (inputStream == null) continue;
                    }
                    catch (Throwable throwable) {
                        var12_12 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException serializable22222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable22222) {}
                }
                PGPPublicKey[] pGPPublicKeyArray = linkedList.toArray(new PGPPublicKey[linkedList.size()]);
                object = null;
                outputStream = null;
                bl3 = false;
                serializable22222 = new File(string);
                object = new FileInputStream((File)serializable22222);
                outputStream = new FileOutputStream(string2);
                boolean bl4 = false;
                this.internalEncryptStream2((InputStream)object, ((File)serializable22222).getName(), pGPPublicKeyArray, outputStream, new Date(((File)serializable22222).lastModified()), bl, bl2, bl4);
                Object var16_20 = null;
                if (object == null) break block23;
                try {
                    ((FileInputStream)object).close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (bl3 && ((File)(serializable3222 = new File(string2))).exists()) {
                ((File)serializable3222).delete();
            }
            break block25;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable42222;
                Object var16_21 = null;
                if (object != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (IOException serializable42222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        ((FileOutputStream)outputStream).close();
                    }
                    catch (IOException serializable42222) {
                        // empty catch block
                    }
                }
                if (bl3 && ((File)(serializable42222 = new File(string2))).exists()) {
                    ((File)serializable42222).delete();
                }
                throw throwable;
            }
        }
    }

    public void encryptFiles(String[] stringArray, String string, String string2, boolean bl, boolean bl2) throws PGPException, IOException {
        this.encryptFiles(stringArray, new String[]{string}, string2, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void encryptFiles(String[] stringArray, String[] stringArray2, String string, boolean bl, boolean bl2) throws PGPException, IOException {
        block31: {
            Serializable serializable3222;
            boolean bl3;
            OutputStream outputStream;
            Object object3222;
            block28: {
                String string2;
                Object object2;
                this.Debug("Encrypting multiple files");
                this.Debug("Encrypting to {0}", new File(string).getAbsolutePath());
                if (stringArray.length == 0) {
                    throw new IllegalArgumentException("Please specify at least one file to be encrypted.");
                }
                LinkedList<PGPPublicKey> linkedList = new LinkedList<PGPPublicKey>();
                InputStream inputStream = null;
                for (int i = 0; i < stringArray2.length; ++i) {
                    try {
                        inputStream = PGPLib.readFileOrAsciiString(stringArray2[i], "publicKeysFileNames :" + i);
                        object2 = this.readPublicKeyForEncryption(inputStream);
                        linkedList.add((PGPPublicKey)object2);
                        string2 = null;
                        if (inputStream == null) continue;
                    }
                    catch (Throwable throwable) {
                        string2 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException object3222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException object3222) {}
                }
                PGPPublicKey[] pGPPublicKeyArray = linkedList.toArray(new PGPPublicKey[linkedList.size()]);
                object2 = null;
                boolean bl4 = false;
                string2 = stringArray[0];
                if (stringArray.length > 1) {
                    object2 = this.createTarFile(stringArray);
                    bl4 = true;
                    string2 = ((File)object2).getAbsolutePath();
                }
                object3222 = null;
                outputStream = null;
                File file = null;
                bl3 = false;
                char c = this.contentType;
                try {
                    file = new File(string2);
                    object3222 = new BufferedInputStream(new FileInputStream(file), 65536);
                    outputStream = new BufferedOutputStream(new FileOutputStream(string), 65536);
                    if (bl4) {
                        this.contentType = (char)98;
                    }
                    this.internalEncryptStream2((InputStream)object3222, file.getName(), pGPPublicKeyArray, outputStream, new Date(file.lastModified()), bl, bl2, bl4);
                    Object var19_19 = null;
                    this.contentType = c;
                    if (object2 == null) break block28;
                    ((File)object2).delete();
                }
                catch (Throwable throwable) {
                    Serializable serializable22222;
                    Object var19_20 = null;
                    this.contentType = c;
                    if (object2 != null) {
                        ((File)object2).delete();
                    }
                    if (object3222 != null) {
                        try {
                            ((InputStream)object3222).close();
                        }
                        catch (IOException serializable22222) {
                            // empty catch block
                        }
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (IOException serializable22222) {
                            // empty catch block
                        }
                    }
                    if (bl3 && ((File)(serializable22222 = new File(string))).exists()) {
                        ((File)serializable22222).delete();
                    }
                    throw throwable;
                }
            }
            if (object3222 != null) {
                try {
                    ((InputStream)object3222).close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException serializable3222) {
                    // empty catch block
                }
            }
            if (bl3 && ((File)(serializable3222 = new File(string))).exists()) {
                ((File)serializable3222).delete();
            }
            break block31;
            {
                catch (PGPException pGPException) {
                    bl3 = true;
                    throw pGPException;
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void encryptFiles(String[] stringArray, KeyStore keyStore, String[] stringArray2, String string, boolean bl, boolean bl2) throws PGPException, IOException {
        block30: {
            Serializable serializable2222;
            char c;
            boolean bl3;
            OutputStream outputStream;
            Object object3222;
            Object object2;
            block28: {
                String string2;
                this.Debug("Encrypting multiple files");
                this.Debug("Encrypting to {0}", new File(string).getAbsolutePath());
                if (stringArray.length == 0) {
                    throw new IllegalArgumentException("please specify at least one file name to be encrypted.");
                }
                LinkedList<PGPPublicKey> linkedList = new LinkedList<PGPPublicKey>();
                InputStream inputStream = null;
                for (int i = 0; i < stringArray2.length; ++i) {
                    try {
                        inputStream = this.createPublicRingStream(keyStore, stringArray2[i]);
                        object2 = this.readPublicKeyForEncryption(inputStream);
                        linkedList.add((PGPPublicKey)object2);
                        string2 = null;
                        if (inputStream == null) continue;
                    }
                    catch (Throwable throwable) {
                        string2 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException object3222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException object3222) {}
                }
                PGPPublicKey[] pGPPublicKeyArray = linkedList.toArray(new PGPPublicKey[linkedList.size()]);
                object2 = null;
                boolean bl4 = false;
                string2 = stringArray[0];
                if (stringArray.length > 1) {
                    object2 = this.createTarFile(stringArray);
                    bl4 = true;
                    string2 = ((File)object2).getAbsolutePath();
                }
                object3222 = null;
                outputStream = null;
                File file = null;
                bl3 = false;
                c = this.contentType;
                file = new File(string2);
                object3222 = new BufferedInputStream(new FileInputStream(file), 65536);
                outputStream = new BufferedOutputStream(new FileOutputStream(string), 65536);
                if (bl4) {
                    this.contentType = (char)98;
                }
                this.internalEncryptStream2((InputStream)object3222, file.getName(), pGPPublicKeyArray, outputStream, new Date(file.lastModified()), bl, bl2, bl4);
                Object var20_20 = null;
                this.contentType = c;
                if (object3222 == null) break block28;
                try {
                    ((InputStream)object3222).close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (object2 != null) {
                ((File)object2).delete();
            }
            if (bl3 && ((File)(serializable2222 = new File(string))).exists()) {
                ((File)serializable2222).delete();
            }
            break block30;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable32222;
                Object var20_21 = null;
                this.contentType = c;
                if (object3222 != null) {
                    try {
                        ((InputStream)object3222).close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (object2 != null) {
                    ((File)object2).delete();
                }
                if (bl3 && ((File)(serializable32222 = new File(string))).exists()) {
                    ((File)serializable32222).delete();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void encryptFiles(String[] stringArray, KeyStore keyStore, long[] lArray, String string, boolean bl, boolean bl2) throws PGPException, IOException {
        block30: {
            Serializable serializable2222;
            char c;
            boolean bl3;
            OutputStream outputStream;
            Object object3222;
            Object object2;
            block28: {
                String string2;
                this.Debug("Encrypting multiple files");
                this.Debug("Encrypting to {0}", new File(string).getAbsolutePath());
                if (stringArray.length == 0) {
                    throw new IllegalArgumentException("please specify at least one file name to be encrypted.");
                }
                LinkedList<PGPPublicKey> linkedList = new LinkedList<PGPPublicKey>();
                InputStream inputStream = null;
                for (int i = 0; i < lArray.length; ++i) {
                    try {
                        inputStream = this.createPublicRingStream(keyStore, lArray[i]);
                        object2 = this.readPublicKeyForEncryption(inputStream);
                        linkedList.add((PGPPublicKey)object2);
                        string2 = null;
                        if (inputStream == null) continue;
                    }
                    catch (Throwable throwable) {
                        string2 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException object3222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException object3222) {}
                }
                PGPPublicKey[] pGPPublicKeyArray = linkedList.toArray(new PGPPublicKey[linkedList.size()]);
                object2 = null;
                boolean bl4 = false;
                string2 = stringArray[0];
                if (stringArray.length > 1) {
                    object2 = this.createTarFile(stringArray);
                    bl4 = true;
                    string2 = ((File)object2).getAbsolutePath();
                }
                object3222 = null;
                outputStream = null;
                File file = null;
                bl3 = false;
                c = this.contentType;
                file = new File(string2);
                object3222 = new BufferedInputStream(new FileInputStream(file), 65536);
                outputStream = new BufferedOutputStream(new FileOutputStream(string), 65536);
                if (bl4) {
                    this.contentType = (char)98;
                }
                this.internalEncryptStream2((InputStream)object3222, file.getName(), pGPPublicKeyArray, outputStream, new Date(file.lastModified()), bl, bl2, bl4);
                Object var20_20 = null;
                this.contentType = c;
                if (object3222 == null) break block28;
                try {
                    ((InputStream)object3222).close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (object2 != null) {
                ((File)object2).delete();
            }
            if (bl3 && ((File)(serializable2222 = new File(string))).exists()) {
                ((File)serializable2222).delete();
            }
            break block30;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable32222;
                Object var20_21 = null;
                this.contentType = c;
                if (object3222 != null) {
                    try {
                        ((InputStream)object3222).close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (object2 != null) {
                    ((File)object2).delete();
                }
                if (bl3 && ((File)(serializable32222 = new File(string))).exists()) {
                    ((File)serializable32222).delete();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void encryptFile(String string, InputStream inputStream, String string2, boolean bl, boolean bl2) throws PGPException, IOException {
        block18: {
            Serializable serializable2222;
            boolean bl3;
            OutputStream outputStream;
            InputStream inputStream2;
            block16: {
                this.Debug("Encrypting file {0}", string);
                this.Debug("Encrypting to {0}", new File(string2).getAbsolutePath());
                inputStream2 = null;
                outputStream = null;
                File file = null;
                bl3 = false;
                file = new File(string);
                inputStream2 = new BufferedInputStream(new FileInputStream(file), 65536);
                outputStream = new BufferedOutputStream(new FileOutputStream(string2), 65536);
                PGPPublicKey pGPPublicKey = this.readPublicKeyForEncryption(inputStream);
                this.internalEncryptStream2(inputStream2, file.getName(), new PGPPublicKey[]{pGPPublicKey}, outputStream, new Date(file.lastModified()), bl, bl2, false);
                Object var12_13 = null;
                if (inputStream2 == null) break block16;
                try {
                    inputStream2.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (bl3 && ((File)(serializable2222 = new File(string2))).exists()) {
                ((File)serializable2222).delete();
            }
            break block18;
            {
                catch (PGPException pGPException) {
                    bl3 = true;
                    throw pGPException;
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable32222;
                Object var12_14 = null;
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (bl3 && ((File)(serializable32222 = new File(string2))).exists()) {
                    ((File)serializable32222).delete();
                }
                throw throwable;
            }
        }
    }

    public int encryptFileByUserId(KeyStore keyStore, String string, String string2, String string3) {
        try {
            this.encryptFile(string, keyStore, string2, string3);
        }
        catch (Exception exception) {
            return 1;
        }
        return 0;
    }

    /*
     * Loose catch block
     */
    public void encryptFile(String string, KeyStore keyStore, String string2, String string3, boolean bl, boolean bl2) throws PGPException, IOException {
        block18: {
            Serializable serializable2222;
            boolean bl3;
            OutputStream outputStream;
            InputStream inputStream;
            block16: {
                this.Debug("Encrypting file {0}", string);
                this.Debug("Encrypting to {0}", new File(string3).getAbsolutePath());
                InputStream inputStream2 = this.createPublicRingStream(keyStore, string2);
                inputStream = null;
                outputStream = null;
                bl3 = false;
                File file = new File(string);
                inputStream = new FileInputStream(string);
                outputStream = new FileOutputStream(string3);
                this.encryptStream(inputStream, file.getName(), inputStream2, outputStream, bl, bl2);
                Object var13_14 = null;
                if (inputStream == null) break block16;
                try {
                    inputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (bl3 && ((File)(serializable2222 = new File(string3))).exists()) {
                ((File)serializable2222).delete();
            }
            break block18;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable32222;
                Object var13_15 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (bl3 && ((File)(serializable32222 = new File(string3))).exists()) {
                    ((File)serializable32222).delete();
                }
                throw throwable;
            }
        }
    }

    public void encryptFile(String string, KeyStore keyStore, String string2, String string3) throws PGPException, IOException {
        boolean bl = false;
        boolean bl2 = this.integrityProtect;
        this.encryptFile(string, keyStore, string2, string3, bl, bl2);
    }

    public int encryptFileByKeyId(KeyStore keyStore, String string, String string2, String string3) {
        try {
            this.encryptFile(string, keyStore, Long.decode(string2), string3);
        }
        catch (Exception exception) {
            return 0;
        }
        return 1;
    }

    /*
     * Loose catch block
     */
    public void encryptFile(String string, KeyStore keyStore, long l, String string2, boolean bl, boolean bl2) throws PGPException, IOException {
        block24: {
            Serializable serializable2222;
            boolean bl3;
            InputStream inputStream;
            OutputStream outputStream;
            InputStream inputStream2;
            block21: {
                inputStream2 = null;
                outputStream = null;
                inputStream = null;
                this.Debug("Encrypting file {0}", new File(string).getAbsolutePath());
                this.Debug("Encrypting to {0}", new File(string2).getAbsolutePath());
                bl3 = false;
                File file = new File(string);
                inputStream2 = new BufferedInputStream(new FileInputStream(string), 65536);
                outputStream = new BufferedOutputStream(new FileOutputStream(string2), 65536);
                inputStream = this.createPublicRingStream(keyStore, l);
                PGPPublicKey pGPPublicKey = this.readPublicKeyForEncryption(inputStream);
                this.internalEncryptStream2(inputStream2, file.getName(), new PGPPublicKey[]{pGPPublicKey}, outputStream, new Date(file.lastModified()), bl, bl2, false);
                Object var15_15 = null;
                if (inputStream2 == null) break block21;
                try {
                    inputStream2.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            if (bl3 && ((File)(serializable2222 = new File(string2))).exists()) {
                ((File)serializable2222).delete();
            }
            break block24;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    bl3 = true;
                    throw IOUtil.newPGPException(pGPException);
                }
                catch (IOException iOException) {
                    bl3 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Serializable serializable32222;
                Object var15_16 = null;
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable32222) {
                        // empty catch block
                    }
                }
                if (bl3 && ((File)(serializable32222 = new File(string2))).exists()) {
                    ((File)serializable32222).delete();
                }
                throw throwable;
            }
        }
    }

    public void encryptFile(String string, KeyStore keyStore, long l, String string2) throws PGPException, IOException {
        boolean bl = false;
        boolean bl2 = this.integrityProtect;
        this.encryptFile(string, keyStore, l, string2, bl, bl2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyFile(String var1_1, String var2_2, String var3_3) throws PGPException, FileIsEncryptedException, IOException {
        block26: {
            block25: {
                block20: {
                    var4_4 = null;
                    var5_5 = null;
                    var6_6 = null;
                    this.Debug("Signature verification of file {0}", var1_1);
                    this.Debug("Extracting to {0}", new File(var3_3).getAbsolutePath());
                    var7_7 = false;
                    try {
                        try {
                            var4_4 = new BufferedInputStream(new FileInputStream(var1_1), 65536);
                            var5_5 = PGPLib.readFileOrAsciiString(var2_2, "publicKeyFileName");
                            var6_6 = new BufferedOutputStream(new FileOutputStream(var3_3), 65536);
                            var8_8 = this.verifyStream((InputStream)var4_4, var5_5, var6_6);
                            var10_11 = null;
                            if (var4_4 == null) break block20;
                        }
                        catch (PGPException var8_9) {
                            var7_7 = true;
                            throw var8_9;
                        }
                        catch (IOException var8_10) {
                            var7_7 = true;
                            throw var8_10;
                        }
                    }
                    catch (Throwable var9_15) {
                        var10_12 = null;
                        if (var4_4 != null) {
                            try {
                                var4_4.close();
                            }
                            catch (IOException var11_14) {
                                // empty catch block
                            }
                        }
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                            }
                            catch (IOException var11_14) {
                                // empty catch block
                            }
                        }
                        if (var6_6 != null) {
                            try {
                                var6_6.flush();
                                var6_6.close();
                            }
                            catch (IOException var11_14) {
                                // empty catch block
                            }
                        }
                        if (var7_7 == false) throw var9_15;
                        var11_14 = new File(var3_3);
                        if (var11_14.exists() == false) throw var9_15;
                        var11_14.delete();
                        throw var9_15;
                    }
                    ** try [egrp 2[TRYBLOCK] [4 : 133->141)] { 
lbl56:
                    // 1 sources

                    var4_4.close();
                    break block20;
lbl58:
                    // 1 sources

                    catch (IOException var11_13) {
                        // empty catch block
                    }
                }
                if (var5_5 != null) {
                    ** try [egrp 3[TRYBLOCK] [5 : 148->156)] { 
lbl63:
                    // 1 sources

                    var5_5.close();
                    break block25;
lbl65:
                    // 1 sources

                    catch (IOException var11_13) {
                        // empty catch block
                    }
                }
            }
            if (var6_6 != null) {
                ** try [egrp 4[TRYBLOCK] [6 : 163->176)] { 
lbl70:
                // 1 sources

                var6_6.flush();
                var6_6.close();
                break block26;
lbl73:
                // 1 sources

                catch (IOException var11_13) {
                    // empty catch block
                }
            }
        }
        if (var7_7 == false) return var8_8;
        var11_13 = new File(var3_3);
        if (var11_13.exists() == false) return var8_8;
        var11_13.delete();
        return var8_8;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyFile(String var1_1, KeyStore var2_2, String var3_3) throws PGPException, FileIsEncryptedException, IOException {
        block19: {
            block15: {
                var4_4 = null;
                var5_5 = null;
                this.Debug("Signature verification of file {0}", var1_1);
                this.Debug("Extracting to {0}", new File(var3_3).getAbsolutePath());
                var6_6 = false;
                try {
                    try {
                        var4_4 = new BufferedInputStream(new FileInputStream(var1_1));
                        var5_5 = new FileOutputStream(var3_3);
                        var7_7 = this.verifyStream((InputStream)var4_4, var2_2, var5_5);
                        var9_10 = null;
                        if (var4_4 == null) break block15;
                    }
                    catch (PGPException var7_8) {
                        var6_6 = true;
                        throw var7_8;
                    }
                    catch (IOException var7_9) {
                        var6_6 = true;
                        throw var7_9;
                    }
                }
                catch (Throwable var8_14) {
                    var9_11 = null;
                    if (var4_4 != null) {
                        try {
                            var4_4.close();
                        }
                        catch (IOException var10_13) {
                            // empty catch block
                        }
                    }
                    if (var5_5 != null) {
                        try {
                            var5_5.flush();
                            var5_5.close();
                        }
                        catch (IOException var10_13) {
                            // empty catch block
                        }
                    }
                    if (var6_6 == false) throw var8_14;
                    var10_13 = new File(var3_3);
                    if (var10_13.exists() == false) throw var8_14;
                    var10_13.delete();
                    throw var8_14;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 110->118)] { 
lbl47:
                // 1 sources

                var4_4.close();
                break block15;
lbl49:
                // 1 sources

                catch (IOException var10_12) {
                    // empty catch block
                }
            }
            if (var5_5 != null) {
                ** try [egrp 3[TRYBLOCK] [5 : 125->138)] { 
lbl54:
                // 1 sources

                var5_5.flush();
                var5_5.close();
                break block19;
lbl57:
                // 1 sources

                catch (IOException var10_12) {
                    // empty catch block
                }
            }
        }
        if (var6_6 == false) return var7_7;
        var10_12 = new File(var3_3);
        if (var10_12.exists() == false) return var7_7;
        var10_12.delete();
        return var7_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyFile(String string, String string2) throws PGPException, FileIsEncryptedException, IOException {
        IOException iOException3;
        boolean bl;
        InputStream inputStream;
        block10: {
            this.Debug("Signature verification of file {0}", string);
            FileInputStream fileInputStream = null;
            inputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                inputStream = PGPLib.readFileOrAsciiString(string2, "publicKeyFileName");
                bl = this.verifyStream(fileInputStream, inputStream);
                Object var7_6 = null;
                if (fileInputStream == null) break block10;
            }
            catch (Throwable throwable) {
                block12: {
                    IOException iOException22;
                    Object var7_7 = null;
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (inputStream == null) break block12;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean verifyFile(InputStream inputStream, InputStream inputStream2) throws PGPException, IOException {
        return this.verifyStream(inputStream, inputStream2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignatureCheckResult verifyWithoutExtracting(InputStream inputStream, InputStream inputStream2) throws PGPException, FileIsEncryptedException, IOException {
        SignatureCheckResult signatureCheckResult;
        DummyStream dummyStream;
        InputStream inputStream3;
        block17: {
            SignatureCheckResult signatureCheckResult2;
            block16: {
                inputStream3 = PGPUtil.getDecoderStream((InputStream)inputStream);
                dummyStream = new DummyStream();
                try {
                    ArmoredInputStream armoredInputStream;
                    if (inputStream3 instanceof ArmoredInputStream && (armoredInputStream = (ArmoredInputStream)inputStream3).isClearText()) {
                        ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
                        DummyStream dummyStream2 = new DummyStream();
                        try {
                            signatureCheckResult2 = clearSignedHelper.verify2(armoredInputStream, null, inputStream2, dummyStream2);
                            Object var10_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_14 = null;
                            dummyStream2.close();
                            throw throwable;
                        }
                        dummyStream2.close();
                        Object var12_15 = null;
                        break block16;
                    }
                    armoredInputStream = PGPObjectFactory2.create(inputStream3);
                    Object object = null;
                    try {
                        object = armoredInputStream.nextObject();
                    }
                    catch (IOException iOException) {
                        throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
                    }
                    if (object instanceof PGPMarker) {
                        object = armoredInputStream.nextObject();
                    }
                    SignatureCheck signatureCheck = new SignatureCheck();
                    if (object instanceof PGPEncryptedDataList) {
                        throw new FileIsEncryptedException("This file is encrypted. Use the methods <decryptAndVerifySignature> or <decrypt> to open it.");
                    }
                    if (object instanceof PGPCompressedData) {
                        this.parseCompressedData((PGPCompressedData)object, true, signatureCheck, null, inputStream2, dummyStream);
                    } else if (object instanceof PGPOnePassSignatureList) {
                        this.parseSignedData((PGPOnePassSignatureList)object, (PGPObjectFactory)armoredInputStream, null, inputStream2, dummyStream, signatureCheck);
                    } else if (object instanceof PGPSignatureList) {
                        this.parseSignedDataVersion3((PGPSignatureList)object, (PGPObjectFactory)armoredInputStream, null, inputStream2, dummyStream, signatureCheck);
                    } else {
                        if (!(object instanceof PGPLiteralData)) throw new NonPGPDataException("Unknown message format: " + object);
                        this.parseLiteralData((PGPLiteralData)object, null, dummyStream);
                    }
                    signatureCheckResult = signatureCheck.result;
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    inputStream3.close();
                    dummyStream.close();
                    throw throwable;
                }
            }
            inputStream3.close();
            dummyStream.close();
            return signatureCheckResult2;
        }
        Object var12_16 = null;
        inputStream3.close();
        dummyStream.close();
        return signatureCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult verifyWithoutExtracting(InputStream inputStream, InputStream inputStream2, String string, InputStream inputStream3) throws PGPException, FileIsEncryptedException, IOException {
        SignatureCheckResult signatureCheckResult;
        ArmoredInputStream armoredInputStream;
        InputStream inputStream4 = PGPUtil.getDecoderStream((InputStream)inputStream);
        DummyStream dummyStream = new DummyStream();
        if (inputStream4 instanceof ArmoredInputStream && (armoredInputStream = (ArmoredInputStream)inputStream4).isClearText()) {
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            return clearSignedHelper.verify2(armoredInputStream, null, inputStream3, new DummyStream());
        }
        try {
            armoredInputStream = PGPObjectFactory2.create(inputStream4);
            Object object = null;
            try {
                object = armoredInputStream.nextObject();
            }
            catch (IOException iOException) {
                throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
            }
            if (object instanceof PGPMarker) {
                object = armoredInputStream.nextObject();
            }
            SignatureCheck signatureCheck = new SignatureCheck();
            if (object instanceof PGPEncryptedDataList) {
                this.parseEncryptedData((PGPEncryptedDataList)object, true, signatureCheck, null, inputStream2, string, inputStream3, dummyStream);
            } else if (object instanceof PGPCompressedData) {
                this.parseCompressedData((PGPCompressedData)object, true, signatureCheck, null, inputStream3, dummyStream);
            } else if (object instanceof PGPOnePassSignatureList) {
                this.parseSignedData((PGPOnePassSignatureList)object, (PGPObjectFactory)armoredInputStream, null, inputStream3, dummyStream, signatureCheck);
            } else if (object instanceof PGPSignatureList) {
                this.parseSignedDataVersion3((PGPSignatureList)object, (PGPObjectFactory)armoredInputStream, null, inputStream3, dummyStream, signatureCheck);
            } else if (object instanceof PGPLiteralData) {
                this.parseLiteralData((PGPLiteralData)object, null, dummyStream);
            } else {
                throw new NonPGPDataException("Unknown message format: " + object);
            }
            signatureCheckResult = signatureCheck.result;
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            dummyStream.close();
            throw throwable;
        }
        dummyStream.close();
        return signatureCheckResult;
    }

    public SignatureCheckResult verifyWithoutExtracting(InputStream inputStream, KeyStore keyStore, String string) throws PGPException, FileIsEncryptedException, IOException {
        ArmoredInputStream armoredInputStream;
        inputStream = PGPUtil.getDecoderStream((InputStream)inputStream);
        DummyStream dummyStream = new DummyStream();
        if (inputStream instanceof ArmoredInputStream && (armoredInputStream = (ArmoredInputStream)inputStream).isClearText()) {
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            return clearSignedHelper.verify2(armoredInputStream, keyStore, null, dummyStream);
        }
        armoredInputStream = PGPObjectFactory2.create(inputStream);
        Object object = null;
        try {
            object = armoredInputStream.nextObject();
        }
        catch (IOException iOException) {
            throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
        }
        if (object instanceof PGPMarker) {
            object = armoredInputStream.nextObject();
        }
        SignatureCheck signatureCheck = new SignatureCheck();
        if (object instanceof PGPEncryptedDataList) {
            this.parseEncryptedData((PGPEncryptedDataList)object, true, signatureCheck, keyStore, null, string, null, dummyStream);
        } else if (object instanceof PGPCompressedData) {
            this.parseCompressedData((PGPCompressedData)object, true, signatureCheck, keyStore, null, dummyStream);
        } else if (object instanceof PGPOnePassSignatureList) {
            this.parseSignedData((PGPOnePassSignatureList)object, (PGPObjectFactory)armoredInputStream, keyStore, null, dummyStream, signatureCheck);
        } else if (object instanceof PGPSignatureList) {
            this.parseSignedDataVersion3((PGPSignatureList)object, (PGPObjectFactory)armoredInputStream, keyStore, null, dummyStream, signatureCheck);
        } else if (object instanceof PGPLiteralData) {
            this.parseLiteralData((PGPLiteralData)object, null, dummyStream);
        } else {
            throw new NonPGPDataException("Unknown message format: " + object);
        }
        return signatureCheck.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult verifyWithoutExtracting(InputStream inputStream, KeyStore keyStore) throws PGPException, FileIsEncryptedException, IOException {
        ArmoredInputStream armoredInputStream;
        DummyStream dummyStream;
        block15: {
            SignatureCheckResult signatureCheckResult;
            inputStream = PGPUtil.getDecoderStream((InputStream)inputStream);
            dummyStream = new DummyStream();
            try {
                if (!(inputStream instanceof ArmoredInputStream) || !(armoredInputStream = (ArmoredInputStream)inputStream).isClearText()) break block15;
                ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
                signatureCheckResult = clearSignedHelper.verify2(armoredInputStream, keyStore, null, dummyStream);
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                dummyStream.close();
                throw throwable;
            }
            dummyStream.close();
            return signatureCheckResult;
        }
        armoredInputStream = PGPObjectFactory2.create(inputStream);
        Object object = null;
        try {
            object = armoredInputStream.nextObject();
        }
        catch (IOException iOException) {
            throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
        }
        if (object instanceof PGPMarker) {
            object = armoredInputStream.nextObject();
        }
        SignatureCheck signatureCheck = new SignatureCheck();
        if (object instanceof PGPEncryptedDataList) {
            throw new FileIsEncryptedException("This file is encrypted. Use <decryptAndVerify> or <decrypt> to open it.");
        }
        if (object instanceof PGPCompressedData) {
            this.parseCompressedData((PGPCompressedData)object, true, signatureCheck, keyStore, null, dummyStream);
        } else if (object instanceof PGPOnePassSignatureList) {
            this.parseSignedData((PGPOnePassSignatureList)object, (PGPObjectFactory)armoredInputStream, keyStore, null, dummyStream, signatureCheck);
        } else if (object instanceof PGPSignatureList) {
            this.parseSignedDataVersion3((PGPSignatureList)object, (PGPObjectFactory)armoredInputStream, keyStore, null, dummyStream, signatureCheck);
        } else if (object instanceof PGPLiteralData) {
            this.parseLiteralData((PGPLiteralData)object, null, dummyStream);
        } else {
            throw new NonPGPDataException("Unknown message format: " + object);
        }
        SignatureCheckResult signatureCheckResult = signatureCheck.result;
        Object var9_11 = null;
        dummyStream.close();
        return signatureCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult verifyWithoutExtracting(String string, String string2, String string3, String string4) throws IOException, PGPException, FileIsEncryptedException {
        IOException iOException3;
        SignatureCheckResult signatureCheckResult;
        DummyStream dummyStream;
        InputStream inputStream;
        block15: {
            InputStream inputStream2 = null;
            inputStream = null;
            InputStream inputStream3 = null;
            dummyStream = new DummyStream();
            try {
                SignatureCheckResult signatureCheckResult2;
                inputStream2 = PGPLib.readFileOrAsciiString(string, "message");
                inputStream = PGPLib.readFileOrAsciiString(string4, "publicKeyFile");
                inputStream3 = PGPLib.readFileOrAsciiString(string2, "privateKeyFile");
                signatureCheckResult = signatureCheckResult2 = this.verifyWithoutExtracting(inputStream2, inputStream3, string3, inputStream);
                Object var12_11 = null;
                if (inputStream2 == null) break block15;
            }
            catch (Throwable throwable) {
                block18: {
                    IOException iOException22;
                    Object var12_12 = null;
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (dummyStream == null) break block18;
                    try {
                        dummyStream.flush();
                        dummyStream.close();
                    }
                    catch (IOException iOException22) {}
                }
                throw throwable;
            }
            try {
                inputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (dummyStream != null) {
            try {
                dummyStream.flush();
                dummyStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        return signatureCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult verifyWithoutExtracting(String string, String string2) throws IOException, PGPException, FileIsEncryptedException {
        IOException iOException3;
        SignatureCheckResult signatureCheckResult;
        DummyStream dummyStream;
        InputStream inputStream;
        block15: {
            InputStream inputStream2 = null;
            inputStream = null;
            dummyStream = new DummyStream();
            try {
                SignatureCheckResult signatureCheckResult2;
                inputStream2 = PGPLib.readFileOrAsciiString(string, "message");
                inputStream = PGPLib.readFileOrAsciiString(string2, "publicKeyFile");
                signatureCheckResult = signatureCheckResult2 = this.verifyAndExtract(inputStream2, inputStream, (OutputStream)dummyStream);
                Object var9_8 = null;
                if (inputStream2 == null) break block15;
            }
            catch (Throwable throwable) {
                block18: {
                    IOException iOException22;
                    Object var9_9 = null;
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (dummyStream == null) break block18;
                    try {
                        dummyStream.flush();
                        dummyStream.close();
                    }
                    catch (IOException iOException22) {}
                }
                throw throwable;
            }
            try {
                inputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (dummyStream != null) {
            try {
                dummyStream.flush();
                dummyStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        return signatureCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult verifyWithoutExtracting(String string, KeyStore keyStore) throws IOException, PGPException, FileIsEncryptedException {
        IOException iOException3;
        SignatureCheckResult signatureCheckResult;
        DummyStream dummyStream;
        block10: {
            InputStream inputStream = null;
            dummyStream = new DummyStream();
            try {
                SignatureCheckResult signatureCheckResult2;
                inputStream = PGPLib.readFileOrAsciiString(string, "message");
                signatureCheckResult = signatureCheckResult2 = this.verifyAndExtract(inputStream, keyStore, (OutputStream)dummyStream);
                Object var8_7 = null;
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                block12: {
                    IOException iOException22;
                    Object var8_8 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (dummyStream == null) break block12;
                    try {
                        dummyStream.flush();
                        dummyStream.close();
                    }
                    catch (IOException iOException22) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (dummyStream != null) {
            try {
                dummyStream.flush();
                dummyStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        return signatureCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult verifyWithoutExtracting(String string, KeyStore keyStore, String string2) throws IOException, PGPException, FileIsEncryptedException {
        SignatureCheckResult signatureCheckResult;
        block5: {
            InputStream inputStream = null;
            try {
                SignatureCheckResult signatureCheckResult2;
                inputStream = PGPLib.readFileOrAsciiString(string, "message");
                signatureCheckResult = signatureCheckResult2 = this.verifyWithoutExtracting(inputStream, keyStore, string2);
                Object var8_7 = null;
                if (inputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (inputStream == null) break block6;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return signatureCheckResult;
    }

    public SignatureCheckResult verifyWithoutExtracting(File file, File file2) throws PGPException, FileIsEncryptedException, IOException {
        return this.verifyWithoutExtracting(file.getAbsolutePath(), file2.getAbsolutePath());
    }

    public SignatureCheckResult verifyWithoutExtracting(File file, File file2, String string, File file3) throws PGPException, FileIsEncryptedException, IOException {
        return this.verifyWithoutExtracting(file.getAbsolutePath(), file2.getAbsolutePath(), string, file3.getAbsolutePath());
    }

    public SignatureCheckResult verifyWithoutExtracting(File file, KeyStore keyStore) throws PGPException, FileIsEncryptedException, IOException {
        return this.verifyWithoutExtracting(file.getAbsolutePath(), keyStore);
    }

    public SignatureCheckResult verifyWithoutExtracting(File file, KeyStore keyStore, String string) throws PGPException, FileIsEncryptedException, IOException {
        return this.verifyWithoutExtracting(file.getAbsolutePath(), keyStore, string);
    }

    public SignatureCheckResult verifyAndExtract(InputStream inputStream, InputStream inputStream2, OutputStream outputStream) throws PGPException, FileIsEncryptedException, IOException {
        ArmoredInputStream armoredInputStream;
        if ((inputStream = PGPUtil.getDecoderStream((InputStream)inputStream)) instanceof ArmoredInputStream && (armoredInputStream = (ArmoredInputStream)inputStream).isClearText()) {
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            return clearSignedHelper.verify2(armoredInputStream, null, inputStream2, outputStream);
        }
        armoredInputStream = PGPObjectFactory2.create(inputStream);
        Object object = null;
        try {
            object = armoredInputStream.nextObject();
        }
        catch (IOException iOException) {
            throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
        }
        if (object instanceof PGPMarker) {
            object = armoredInputStream.nextObject();
        }
        SignatureCheck signatureCheck = new SignatureCheck();
        if (object instanceof PGPEncryptedDataList) {
            throw new FileIsEncryptedException("This file is encrypted. Use the methods <decryptAndVerifySignature> or <decrypt> to open it.");
        }
        if (object instanceof PGPCompressedData) {
            this.parseCompressedData((PGPCompressedData)object, true, signatureCheck, null, inputStream2, outputStream);
        } else if (object instanceof PGPOnePassSignatureList) {
            this.parseSignedData((PGPOnePassSignatureList)object, (PGPObjectFactory)armoredInputStream, null, inputStream2, outputStream, signatureCheck);
        } else if (object instanceof PGPSignatureList) {
            this.parseSignedDataVersion3((PGPSignatureList)object, (PGPObjectFactory)armoredInputStream, null, inputStream2, outputStream, signatureCheck);
        } else if (object instanceof PGPLiteralData) {
            this.parseLiteralData((PGPLiteralData)object, null, outputStream);
        } else {
            throw new NonPGPDataException("Unknown message format: " + object);
        }
        return signatureCheck.result;
    }

    public SignatureCheckResult verifyAndExtract(InputStream inputStream, KeyStore keyStore, OutputStream outputStream) throws PGPException, FileIsEncryptedException, IOException {
        ArmoredInputStream armoredInputStream;
        if ((inputStream = PGPUtil.getDecoderStream((InputStream)inputStream)) instanceof ArmoredInputStream && (armoredInputStream = (ArmoredInputStream)inputStream).isClearText()) {
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            return clearSignedHelper.verify2(armoredInputStream, keyStore, null, outputStream);
        }
        armoredInputStream = PGPObjectFactory2.create(inputStream);
        Object object = null;
        try {
            object = armoredInputStream.nextObject();
        }
        catch (IOException iOException) {
            throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
        }
        if (object instanceof PGPMarker) {
            object = armoredInputStream.nextObject();
        }
        SignatureCheck signatureCheck = new SignatureCheck();
        if (object instanceof PGPEncryptedDataList) {
            throw new FileIsEncryptedException("This file is encrypted. Use <decryptAndVerify> or <decrypt> to open it.");
        }
        if (object instanceof PGPCompressedData) {
            this.parseCompressedData((PGPCompressedData)object, true, signatureCheck, keyStore, null, outputStream);
        } else if (object instanceof PGPOnePassSignatureList) {
            this.parseSignedData((PGPOnePassSignatureList)object, (PGPObjectFactory)armoredInputStream, keyStore, null, outputStream, signatureCheck);
        } else if (object instanceof PGPSignatureList) {
            this.parseSignedDataVersion3((PGPSignatureList)object, (PGPObjectFactory)armoredInputStream, keyStore, null, outputStream, signatureCheck);
        } else if (object instanceof PGPLiteralData) {
            this.parseLiteralData((PGPLiteralData)object, null, outputStream);
        } else {
            throw new NonPGPDataException("Unknown message format: " + object);
        }
        return signatureCheck.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult verifyAndExtract(String string, String string2, StringBuffer stringBuffer, String string3) throws IOException, PGPException, FileIsEncryptedException {
        IOException iOException3;
        SignatureCheckResult signatureCheckResult;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        InputStream inputStream2;
        block17: {
            if (stringBuffer == null) {
                throw new IllegalArgumentException("The decryptedString parameter cannot be null");
            }
            inputStream2 = null;
            inputStream = null;
            byteArrayOutputStream = null;
            try {
                inputStream2 = PGPLib.readFileOrAsciiString(string, "message");
                inputStream = PGPLib.readFileOrAsciiString(string2, "publicKeyFile");
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                SignatureCheckResult signatureCheckResult2 = this.verifyAndExtract(inputStream2, inputStream, (OutputStream)byteArrayOutputStream);
                stringBuffer.setLength(0);
                stringBuffer.append(new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), string3));
                signatureCheckResult = signatureCheckResult2;
                Object var11_10 = null;
                if (inputStream2 == null) break block17;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var11_11 = null;
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream2 = null;
                inputStream = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream2 = null;
        inputStream = null;
        byteArrayOutputStream = null;
        return signatureCheckResult;
    }

    public SignatureCheckResult verifyAndExtract(String string, String string2, StringBuffer stringBuffer) throws IOException, PGPException, FileIsEncryptedException {
        return this.verifyAndExtract(string, string2, stringBuffer, "ASCII");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult verifyAndExtract(String string, KeyStore keyStore, StringBuffer stringBuffer, String string2) throws IOException, PGPException, FileIsEncryptedException {
        IOException iOException3;
        SignatureCheckResult signatureCheckResult;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        block12: {
            if (stringBuffer == null) {
                throw new IllegalArgumentException("The decryptedString parameter cannot be null");
            }
            inputStream = null;
            byteArrayOutputStream = null;
            try {
                inputStream = PGPLib.readFileOrAsciiString(string, "message");
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                SignatureCheckResult signatureCheckResult2 = this.verifyAndExtract(inputStream, keyStore, (OutputStream)byteArrayOutputStream);
                stringBuffer.setLength(0);
                stringBuffer.append(new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), string2));
                signatureCheckResult = signatureCheckResult2;
                Object var10_9 = null;
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var10_10 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                inputStream = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        inputStream = null;
        byteArrayOutputStream = null;
        return signatureCheckResult;
    }

    public SignatureCheckResult verifyAndExtract(String string, KeyStore keyStore, StringBuffer stringBuffer) throws IOException, PGPException, FileIsEncryptedException {
        return this.verifyAndExtract(string, keyStore, stringBuffer);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignatureCheckResult verifyAndExtract(String var1_1, String var2_2, String var3_3) throws PGPException, FileIsEncryptedException, IOException {
        block26: {
            block25: {
                block20: {
                    var4_4 = null;
                    var5_5 = null;
                    var6_6 = null;
                    this.Debug("Signature verification of file {0}", var1_1);
                    this.Debug("Extracting to {0}", new File(var3_3).getAbsolutePath());
                    var7_7 = false;
                    try {
                        try {
                            var4_4 = new BufferedInputStream(new FileInputStream(var1_1), 65536);
                            var5_5 = PGPLib.readFileOrAsciiString(var2_2, "publicKeyFileName");
                            var6_6 = new BufferedOutputStream(new FileOutputStream(var3_3), 65536);
                            var8_8 = this.verifyAndExtract((InputStream)var4_4, var5_5, var6_6);
                            var10_11 = null;
                            if (var4_4 == null) break block20;
                        }
                        catch (PGPException var8_9) {
                            var7_7 = true;
                            throw var8_9;
                        }
                        catch (IOException var8_10) {
                            var7_7 = true;
                            throw var8_10;
                        }
                    }
                    catch (Throwable var9_15) {
                        var10_12 = null;
                        if (var4_4 != null) {
                            try {
                                var4_4.close();
                            }
                            catch (IOException var11_14) {
                                // empty catch block
                            }
                        }
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                            }
                            catch (IOException var11_14) {
                                // empty catch block
                            }
                        }
                        if (var6_6 != null) {
                            try {
                                var6_6.flush();
                                var6_6.close();
                            }
                            catch (IOException var11_14) {
                                // empty catch block
                            }
                        }
                        if (var7_7 == false) throw var9_15;
                        var11_14 = new File(var3_3);
                        if (var11_14.exists() == false) throw var9_15;
                        var11_14.delete();
                        throw var9_15;
                    }
                    ** try [egrp 2[TRYBLOCK] [4 : 133->141)] { 
lbl56:
                    // 1 sources

                    var4_4.close();
                    break block20;
lbl58:
                    // 1 sources

                    catch (IOException var11_13) {
                        // empty catch block
                    }
                }
                if (var5_5 != null) {
                    ** try [egrp 3[TRYBLOCK] [5 : 148->156)] { 
lbl63:
                    // 1 sources

                    var5_5.close();
                    break block25;
lbl65:
                    // 1 sources

                    catch (IOException var11_13) {
                        // empty catch block
                    }
                }
            }
            if (var6_6 != null) {
                ** try [egrp 4[TRYBLOCK] [6 : 163->176)] { 
lbl70:
                // 1 sources

                var6_6.flush();
                var6_6.close();
                break block26;
lbl73:
                // 1 sources

                catch (IOException var11_13) {
                    // empty catch block
                }
            }
        }
        if (var7_7 == false) return var8_8;
        var11_13 = new File(var3_3);
        if (var11_13.exists() == false) return var8_8;
        var11_13.delete();
        return var8_8;
    }

    public SignatureCheckResult verifyAndExtract(File file, File file2, File file3) throws PGPException, FileIsEncryptedException, IOException {
        return this.verifyAndExtract(file.getAbsolutePath(), file2.getAbsolutePath(), file3.getAbsolutePath());
    }

    public SignatureCheckResult verifyAndExtract(File file, KeyStore keyStore, File file2) throws PGPException, FileIsEncryptedException, IOException {
        return this.verifyAndExtract(file.getAbsolutePath(), keyStore, file2.getAbsolutePath());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignatureCheckResult verifyAndExtract(String var1_1, KeyStore var2_2, String var3_3) throws PGPException, FileIsEncryptedException, IOException {
        block19: {
            block15: {
                var4_4 = null;
                var5_5 = null;
                this.Debug("Signature verification of file {0}", var1_1);
                this.Debug("Extracting to {0}", new File(var3_3).getAbsolutePath());
                var6_6 = false;
                try {
                    try {
                        var4_4 = new BufferedInputStream(new FileInputStream(var1_1));
                        var5_5 = new FileOutputStream(var3_3);
                        var7_7 = this.verifyAndExtract((InputStream)var4_4, var2_2, var5_5);
                        var9_10 = null;
                        if (var4_4 == null) break block15;
                    }
                    catch (PGPException var7_8) {
                        var6_6 = true;
                        throw var7_8;
                    }
                    catch (IOException var7_9) {
                        var6_6 = true;
                        throw var7_9;
                    }
                }
                catch (Throwable var8_14) {
                    var9_11 = null;
                    if (var4_4 != null) {
                        try {
                            var4_4.close();
                        }
                        catch (IOException var10_13) {
                            // empty catch block
                        }
                    }
                    if (var5_5 != null) {
                        var5_5.flush();
                        try {
                            var5_5.close();
                        }
                        catch (IOException var10_13) {
                            // empty catch block
                        }
                    }
                    if (var6_6 == false) throw var8_14;
                    var10_13 = new File(var3_3);
                    if (var10_13.exists() == false) throw var8_14;
                    var10_13.delete();
                    throw var8_14;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 110->118)] { 
lbl47:
                // 1 sources

                var4_4.close();
                break block15;
lbl49:
                // 1 sources

                catch (IOException var10_12) {
                    // empty catch block
                }
            }
            if (var5_5 != null) {
                var5_5.flush();
                ** try [egrp 3[TRYBLOCK] [5 : 130->138)] { 
lbl55:
                // 1 sources

                var5_5.close();
                break block19;
lbl57:
                // 1 sources

                catch (IOException var10_12) {
                    // empty catch block
                }
            }
        }
        if (var6_6 == false) return var7_7;
        var10_12 = new File(var3_3);
        if (var10_12.exists() == false) return var7_7;
        var10_12.delete();
        return var7_7;
    }

    public boolean verifyStream(InputStream inputStream, InputStream inputStream2) throws PGPException, FileIsEncryptedException, IOException {
        inputStream = PGPUtil.getDecoderStream((InputStream)inputStream);
        return this.verifyStream(inputStream, inputStream2, (OutputStream)new DummyStream());
    }

    public boolean verifyStream(InputStream inputStream, InputStream inputStream2, OutputStream outputStream) throws PGPException, FileIsEncryptedException, IOException {
        ArmoredInputStream armoredInputStream;
        if ((inputStream = PGPUtil.getDecoderStream((InputStream)inputStream)) instanceof ArmoredInputStream && (armoredInputStream = (ArmoredInputStream)inputStream).isClearText()) {
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            return clearSignedHelper.verify2(armoredInputStream, null, inputStream2, outputStream) == SignatureCheckResult.SignatureVerified;
        }
        armoredInputStream = PGPObjectFactory2.create(inputStream);
        Object object = null;
        try {
            object = armoredInputStream.nextObject();
        }
        catch (IOException iOException) {
            throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
        }
        if (object instanceof PGPMarker) {
            object = armoredInputStream.nextObject();
        }
        SignatureCheck signatureCheck = new SignatureCheck();
        if (object instanceof PGPEncryptedDataList) {
            throw new FileIsEncryptedException("This file is encrypted. Use <decryptAndVerify> or <decrypt> to open it.");
        }
        if (object instanceof PGPCompressedData) {
            this.parseCompressedData((PGPCompressedData)object, true, signatureCheck, null, inputStream2, outputStream);
        } else if (object instanceof PGPOnePassSignatureList) {
            this.parseSignedData((PGPOnePassSignatureList)object, (PGPObjectFactory)armoredInputStream, null, inputStream2, outputStream, signatureCheck);
        } else if (object instanceof PGPSignatureList) {
            this.parseSignedDataVersion3((PGPSignatureList)object, (PGPObjectFactory)armoredInputStream, null, inputStream2, outputStream, signatureCheck);
        } else if (object instanceof PGPLiteralData) {
            this.parseLiteralData((PGPLiteralData)object, null, outputStream);
        } else {
            throw new PGPException("Unknown message format: " + object);
        }
        return signatureCheck.result == SignatureCheckResult.SignatureVerified;
    }

    public boolean verifyStream(InputStream inputStream, KeyStore keyStore, OutputStream outputStream) throws PGPException, FileIsEncryptedException, IOException {
        ArmoredInputStream armoredInputStream;
        if ((inputStream = PGPUtil.getDecoderStream((InputStream)inputStream)) instanceof ArmoredInputStream && (armoredInputStream = (ArmoredInputStream)inputStream).isClearText()) {
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            try {
                return clearSignedHelper.verify(armoredInputStream, keyStore, null, outputStream);
            }
            catch (SignatureException signatureException) {
                return false;
            }
        }
        armoredInputStream = PGPObjectFactory2.create(inputStream);
        Object object = armoredInputStream.nextObject();
        if (object instanceof PGPMarker) {
            object = armoredInputStream.nextObject();
        }
        SignatureCheck signatureCheck = new SignatureCheck();
        if (object instanceof PGPEncryptedDataList) {
            throw new FileIsEncryptedException("This file is encrypted. Use <decryptAndVerify> or <decrypt> to open it.");
        }
        if (object instanceof PGPCompressedData) {
            this.parseCompressedData((PGPCompressedData)object, true, signatureCheck, keyStore, null, outputStream);
        } else if (object instanceof PGPOnePassSignatureList) {
            this.parseSignedData((PGPOnePassSignatureList)object, (PGPObjectFactory)armoredInputStream, keyStore, null, outputStream, signatureCheck);
        } else if (object instanceof PGPSignatureList) {
            this.parseSignedDataVersion3((PGPSignatureList)object, (PGPObjectFactory)armoredInputStream, keyStore, null, outputStream, signatureCheck);
        } else if (object instanceof PGPLiteralData) {
            this.parseLiteralData((PGPLiteralData)object, null, outputStream);
        } else {
            throw new NonPGPDataException("Unknown message format: " + object);
        }
        return signatureCheck.result == SignatureCheckResult.SignatureVerified;
    }

    public boolean verifyString(String string, String string2, StringBuffer stringBuffer) throws IOException, PGPException, FileIsEncryptedException {
        return this.verifyString(string, string2, stringBuffer, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyString(String string, String string2, StringBuffer stringBuffer, String string3) throws IOException, PGPException, FileIsEncryptedException {
        IOException iOException3;
        boolean bl;
        OutputStream outputStream;
        InputStream inputStream;
        ByteArrayInputStream byteArrayInputStream;
        block17: {
            if (stringBuffer == null) {
                throw new IllegalArgumentException("The decryptedString parameter cannot be null");
            }
            byteArrayInputStream = null;
            inputStream = null;
            outputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes(string3));
                inputStream = PGPLib.readFileOrAsciiString(string2, "publicKeyFileName");
                outputStream = new ByteArrayOutputStream(65536);
                boolean bl2 = this.verifyStream((InputStream)byteArrayInputStream, inputStream, outputStream);
                stringBuffer.setLength(0);
                stringBuffer.append(new String(((ByteArrayOutputStream)outputStream).toByteArray(), 0, ((ByteArrayOutputStream)outputStream).size(), string3));
                bl = bl2;
                Object var11_10 = null;
                if (byteArrayInputStream == null) break block17;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var11_11 = null;
                if (byteArrayInputStream != null) {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        ((ByteArrayOutputStream)outputStream).close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                byteArrayInputStream = null;
                inputStream = null;
                outputStream = null;
                throw throwable;
            }
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (outputStream != null) {
            try {
                outputStream.flush();
                ((ByteArrayOutputStream)outputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        byteArrayInputStream = null;
        inputStream = null;
        outputStream = null;
        return bl;
    }

    public boolean decryptAndVerifyString(String string, String string2, String string3, String string4, StringBuffer stringBuffer) throws IOException, PGPException, FileIsEncryptedException {
        return this.decryptAndVerifyString(string, string2, string3, string4, stringBuffer, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decryptAndVerifyString(String string, InputStream inputStream, String string2, InputStream inputStream2, StringBuffer stringBuffer, String string3) throws IOException, PGPException {
        IOException iOException3;
        boolean bl;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayInputStream byteArrayInputStream;
        block12: {
            if (stringBuffer == null) {
                throw new IllegalArgumentException("The decryptedString parameter cannot be null");
            }
            byteArrayInputStream = null;
            byteArrayOutputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes("ASCII"));
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                boolean bl2 = this.decryptAndVerifyStream(byteArrayInputStream, inputStream, string2, inputStream2, byteArrayOutputStream);
                stringBuffer.setLength(0);
                stringBuffer.append(new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), string3));
                bl = bl2;
                Object var12_11 = null;
                if (byteArrayInputStream == null) break block12;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var12_12 = null;
                if (byteArrayInputStream != null) {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                byteArrayInputStream = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        byteArrayInputStream = null;
        byteArrayOutputStream = null;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decryptAndVerifyString(String string, String string2, String string3, String string4, StringBuffer stringBuffer, String string5) throws IOException, PGPException {
        IOException iOException3;
        boolean bl;
        OutputStream outputStream;
        InputStream inputStream;
        InputStream inputStream2;
        block21: {
            if (stringBuffer == null) {
                throw new IllegalArgumentException("The decryptedString parameter cannot be null");
            }
            ByteArrayInputStream byteArrayInputStream = null;
            inputStream2 = null;
            inputStream = null;
            outputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes("ASCII"));
                inputStream2 = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
                inputStream = PGPLib.readFileOrAsciiString(string4, "publicKeyFileName");
                outputStream = new ByteArrayOutputStream(65536);
                boolean bl2 = this.decryptAndVerifyStream(byteArrayInputStream, inputStream2, string3, inputStream, outputStream);
                stringBuffer.setLength(0);
                stringBuffer.append(new String(((ByteArrayOutputStream)outputStream).toByteArray(), 0, ((ByteArrayOutputStream)outputStream).size(), string5));
                bl = bl2;
                Object var14_13 = null;
                if (byteArrayInputStream == null) break block21;
            }
            catch (Throwable throwable) {
                block25: {
                    IOException iOException22;
                    Object var14_14 = null;
                    if (byteArrayInputStream != null) {
                        try {
                            ((InputStream)byteArrayInputStream).close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (outputStream == null) break block25;
                    try {
                        outputStream.flush();
                        ((ByteArrayOutputStream)outputStream).close();
                    }
                    catch (IOException iOException22) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream2 != null) {
            try {
                inputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (outputStream != null) {
            try {
                outputStream.flush();
                ((ByteArrayOutputStream)outputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        return bl;
    }

    public SignatureCheckResult decryptAndVerify(String string, String string2, String string3, String string4, StringBuffer stringBuffer) throws IOException, PGPException, FileIsEncryptedException {
        return this.decryptAndVerify(string, string2, string3, string4, stringBuffer, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult decryptAndVerify(String string, InputStream inputStream, String string2, InputStream inputStream2, StringBuffer stringBuffer, String string3) throws IOException, PGPException {
        IOException iOException3;
        SignatureCheckResult signatureCheckResult;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayInputStream byteArrayInputStream;
        block12: {
            if (stringBuffer == null) {
                throw new IllegalArgumentException("The decryptedString parameter cannot be null");
            }
            byteArrayInputStream = null;
            byteArrayOutputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes("ASCII"));
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                SignatureCheckResult signatureCheckResult2 = this.decryptAndVerify(byteArrayInputStream, inputStream, string2, inputStream2, byteArrayOutputStream);
                stringBuffer.setLength(0);
                stringBuffer.append(new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), string3));
                signatureCheckResult = signatureCheckResult2;
                Object var12_11 = null;
                if (byteArrayInputStream == null) break block12;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var12_12 = null;
                if (byteArrayInputStream != null) {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                byteArrayInputStream = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        byteArrayInputStream = null;
        byteArrayOutputStream = null;
        return signatureCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult decryptAndVerify(String string, String string2, String string3, String string4, StringBuffer stringBuffer, String string5) throws IOException, PGPException {
        IOException iOException3;
        SignatureCheckResult signatureCheckResult;
        OutputStream outputStream;
        InputStream inputStream;
        InputStream inputStream2;
        ByteArrayInputStream byteArrayInputStream;
        block22: {
            if (stringBuffer == null) {
                throw new IllegalArgumentException("The decryptedString parameter cannot be null");
            }
            byteArrayInputStream = null;
            inputStream2 = null;
            inputStream = null;
            outputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                inputStream2 = PGPLib.readFileOrAsciiString(string2, "privateKeyFileName");
                inputStream = PGPLib.readFileOrAsciiString(string4, "publicKeyFileName");
                outputStream = new ByteArrayOutputStream(65536);
                SignatureCheckResult signatureCheckResult2 = this.decryptAndVerify(byteArrayInputStream, inputStream2, string3, inputStream, outputStream);
                stringBuffer.setLength(0);
                stringBuffer.append(new String(((ByteArrayOutputStream)outputStream).toByteArray(), 0, ((ByteArrayOutputStream)outputStream).size(), string5));
                signatureCheckResult = signatureCheckResult2;
                Object var14_13 = null;
                if (byteArrayInputStream == null) break block22;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var14_14 = null;
                if (byteArrayInputStream != null) {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        ((ByteArrayOutputStream)outputStream).close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                byteArrayInputStream = null;
                outputStream = null;
                throw throwable;
            }
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream2 != null) {
            try {
                inputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (outputStream != null) {
            try {
                outputStream.flush();
                ((ByteArrayOutputStream)outputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        byteArrayInputStream = null;
        outputStream = null;
        return signatureCheckResult;
    }

    public SignatureCheckResult decryptAndVerifyString(String string, KeyStore keyStore, String string2, StringBuffer stringBuffer) throws PGPException, IOException {
        return this.decryptAndVerifyString(string, keyStore, string2, stringBuffer, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult decryptAndVerifyString(String string, KeyStore keyStore, String string2, StringBuffer stringBuffer, String string3) throws PGPException, IOException {
        IOException iOException3;
        SignatureCheckResult signatureCheckResult;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayInputStream byteArrayInputStream;
        block11: {
            byteArrayInputStream = null;
            byteArrayOutputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                byteArrayOutputStream = new ByteArrayOutputStream(65536);
                SignatureCheckResult signatureCheckResult2 = this.decryptAndVerify(byteArrayInputStream, keyStore, string2, byteArrayOutputStream);
                stringBuffer.setLength(0);
                stringBuffer.append(new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), string3));
                signatureCheckResult = signatureCheckResult2;
                Object var11_10 = null;
                if (byteArrayInputStream == null) break block11;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var11_11 = null;
                if (byteArrayInputStream != null) {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                byteArrayInputStream = null;
                byteArrayOutputStream = null;
                throw throwable;
            }
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        byteArrayInputStream = null;
        byteArrayOutputStream = null;
        return signatureCheckResult;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean decryptAndVerifyFile(String var1_1, KeyStore var2_2, String var3_3, String var4_4) throws PGPException, IOException {
        block30: {
            block29: {
                block24: {
                    this.Debug("Decrypting and verifying file {0}", new File(var1_1).getAbsolutePath());
                    this.Debug("Extracting to {0}", new File(var4_4).getAbsolutePath());
                    var5_5 = null;
                    var6_6 = null;
                    var7_7 = null;
                    var8_8 = false;
                    try {
                        try {
                            var5_5 = new FileInputStream(var1_1);
                            var6_6 = new FileOutputStream(var4_4);
                            var7_7 = PGPUtil.getDecoderStream((InputStream)var5_5);
                            var9_9 = PGPObjectFactory2.create(var7_7);
                            var11_12 = var9_9.nextObject();
                            if (var11_12 instanceof PGPMarker) {
                                var11_12 = var9_9.nextObject();
                            }
                            var12_13 = new SignatureCheck();
                            if (var11_12 instanceof PGPEncryptedDataList) {
                                var10_14 = (PGPEncryptedDataList)var11_12;
                                this.parseEncryptedData(var10_14, true, var12_13, var2_2, null, var3_3, null, var6_6);
                            } else {
                                if (!(var11_12 instanceof PGPCompressedData)) {
                                    if (var11_12 != null) throw new PGPException("Unknown message format: " + var11_12);
                                    throw new NonPGPDataException("The supplied data is not a valid OpenPGP message");
                                }
                                this.parseCompressedData((PGPCompressedData)var11_12, true, var12_13, var2_2, null, var6_6);
                            }
                            var13_15 = var12_13.result == SignatureCheckResult.SignatureVerified;
                            var15_16 = null;
                            if (var5_5 == null) break block24;
                        }
                        catch (PGPException var9_10) {
                            var8_8 = true;
                            throw var9_10;
                        }
                        catch (IOException var9_11) {
                            var8_8 = true;
                            throw var9_11;
                        }
                    }
                    catch (Throwable var14_20) {
                        var15_17 = null;
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                            }
                            catch (IOException var16_19) {
                                // empty catch block
                            }
                        }
                        if (var7_7 != null) {
                            try {
                                var7_7.close();
                            }
                            catch (IOException var16_19) {
                                // empty catch block
                            }
                        }
                        if (var6_6 != null) {
                            try {
                                var6_6.flush();
                                var6_6.close();
                            }
                            catch (IOException var16_19) {
                                // empty catch block
                            }
                        }
                        if (var8_8 == false) throw var14_20;
                        var16_19 = new File(var4_4);
                        if (var16_19.exists() == false) throw var14_20;
                        var16_19.delete();
                        throw var14_20;
                    }
                    ** try [egrp 2[TRYBLOCK] [4 : 277->285)] { 
lbl71:
                    // 1 sources

                    var5_5.close();
                    break block24;
lbl73:
                    // 1 sources

                    catch (IOException var16_18) {
                        // empty catch block
                    }
                }
                if (var7_7 != null) {
                    ** try [egrp 3[TRYBLOCK] [5 : 292->300)] { 
lbl78:
                    // 1 sources

                    var7_7.close();
                    break block29;
lbl80:
                    // 1 sources

                    catch (IOException var16_18) {
                        // empty catch block
                    }
                }
            }
            if (var6_6 != null) {
                ** try [egrp 4[TRYBLOCK] [6 : 307->320)] { 
lbl85:
                // 1 sources

                var6_6.flush();
                var6_6.close();
                break block30;
lbl88:
                // 1 sources

                catch (IOException var16_18) {
                    // empty catch block
                }
            }
        }
        if (var8_8 == false) return var13_15;
        var16_18 = new File(var4_4);
        if (var16_18.exists() == false) return var13_15;
        var16_18.delete();
        return var13_15;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignatureCheckResult decryptAndVerify(String var1_1, String var2_2, String var3_3, String var4_4, String var5_5) throws PGPException, IOException {
        block33: {
            block32: {
                block31: {
                    block25: {
                        this.Debug("Decrypting and signature verifying file {0}", var1_1);
                        this.Debug("Extracting to {0}", new File(var5_5).getAbsolutePath());
                        var6_6 = null;
                        var7_7 = null;
                        var8_8 = null;
                        var9_9 = null;
                        var10_10 = false;
                        try {
                            try {
                                var6_6 = new FileInputStream(var1_1);
                                var7_7 = PGPLib.readFileOrAsciiString(var2_2, "privateKeyFileName");
                                var8_8 = PGPLib.readFileOrAsciiString(var4_4, "publicKeyFile");
                                var9_9 = new FileOutputStream(var5_5);
                                var11_11 = this.decryptAndVerify(var6_6, var7_7, var3_3, var8_8, var9_9);
                                var13_14 = null;
                                if (var6_6 == null) break block25;
                            }
                            catch (PGPException var11_12) {
                                var10_10 = true;
                                throw var11_12;
                            }
                            catch (IOException var11_13) {
                                var10_10 = true;
                                throw var11_13;
                            }
                        }
                        catch (Throwable var12_18) {
                            var13_15 = null;
                            if (var6_6 != null) {
                                try {
                                    var6_6.close();
                                }
                                catch (IOException var14_17) {
                                    // empty catch block
                                }
                            }
                            if (var7_7 != null) {
                                try {
                                    var7_7.close();
                                }
                                catch (IOException var14_17) {
                                    // empty catch block
                                }
                            }
                            if (var8_8 != null) {
                                try {
                                    var8_8.close();
                                }
                                catch (IOException var14_17) {
                                    // empty catch block
                                }
                            }
                            if (var9_9 != null) {
                                try {
                                    var9_9.flush();
                                    var9_9.close();
                                }
                                catch (IOException var14_17) {
                                    // empty catch block
                                }
                            }
                            if (var10_10 == false) throw var12_18;
                            var14_17 = new File(var5_5);
                            if (var14_17.exists() == false) throw var12_18;
                            var14_17.delete();
                            throw var12_18;
                        }
                        ** try [egrp 2[TRYBLOCK] [4 : 132->140)] { 
lbl65:
                        // 1 sources

                        var6_6.close();
                        break block25;
lbl67:
                        // 1 sources

                        catch (IOException var14_16) {
                            // empty catch block
                        }
                    }
                    if (var7_7 != null) {
                        ** try [egrp 3[TRYBLOCK] [5 : 147->155)] { 
lbl72:
                        // 1 sources

                        var7_7.close();
                        break block31;
lbl74:
                        // 1 sources

                        catch (IOException var14_16) {
                            // empty catch block
                        }
                    }
                }
                if (var8_8 != null) {
                    ** try [egrp 4[TRYBLOCK] [6 : 162->170)] { 
lbl79:
                    // 1 sources

                    var8_8.close();
                    break block32;
lbl81:
                    // 1 sources

                    catch (IOException var14_16) {
                        // empty catch block
                    }
                }
            }
            if (var9_9 != null) {
                ** try [egrp 5[TRYBLOCK] [7 : 177->190)] { 
lbl86:
                // 1 sources

                var9_9.flush();
                var9_9.close();
                break block33;
lbl89:
                // 1 sources

                catch (IOException var14_16) {
                    // empty catch block
                }
            }
        }
        if (var10_10 == false) return var11_11;
        var14_16 = new File(var5_5);
        if (var14_16.exists() == false) return var11_11;
        var14_16.delete();
        return var11_11;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignatureCheckResult decryptAndVerify(String var1_1, KeyStore var2_2, String var3_3, String var4_4) throws PGPException, IOException {
        block26: {
            block25: {
                block20: {
                    this.Debug("Decrypting and verifying file {0}", new File(var1_1).getAbsolutePath());
                    this.Debug("Extracting to {0}", new File(var4_4).getAbsolutePath());
                    var5_5 = null;
                    var6_6 = null;
                    var7_7 = null;
                    var8_8 = false;
                    try {
                        try {
                            var5_5 = new FileInputStream(var1_1);
                            var6_6 = new FileOutputStream(var4_4);
                            var9_9 = this.decryptAndVerify(var5_5, var2_2, var3_3, var6_6);
                            var11_12 = null;
                            if (var5_5 == null) break block20;
                        }
                        catch (PGPException var9_10) {
                            var8_8 = true;
                            throw var9_10;
                        }
                        catch (IOException var9_11) {
                            var8_8 = true;
                            throw var9_11;
                        }
                    }
                    catch (Throwable var10_16) {
                        var11_13 = null;
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                            }
                            catch (IOException var12_15) {
                                // empty catch block
                            }
                        }
                        if (var7_7 != null) {
                            try {
                                var7_7.close();
                            }
                            catch (IOException var12_15) {
                                // empty catch block
                            }
                        }
                        if (var6_6 != null) {
                            try {
                                var6_6.flush();
                                var6_6.close();
                            }
                            catch (IOException var12_15) {
                                // empty catch block
                            }
                        }
                        if (var8_8 == false) throw var10_16;
                        var12_15 = new File(var4_4);
                        if (var12_15.exists() == false) throw var10_16;
                        var12_15.delete();
                        throw var10_16;
                    }
                    ** try [egrp 2[TRYBLOCK] [4 : 119->127)] { 
lbl55:
                    // 1 sources

                    var5_5.close();
                    break block20;
lbl57:
                    // 1 sources

                    catch (IOException var12_14) {
                        // empty catch block
                    }
                }
                if (var7_7 != null) {
                    ** try [egrp 3[TRYBLOCK] [5 : 134->142)] { 
lbl62:
                    // 1 sources

                    var7_7.close();
                    break block25;
lbl64:
                    // 1 sources

                    catch (IOException var12_14) {
                        // empty catch block
                    }
                }
            }
            if (var6_6 != null) {
                ** try [egrp 4[TRYBLOCK] [6 : 149->162)] { 
lbl69:
                // 1 sources

                var6_6.flush();
                var6_6.close();
                break block26;
lbl72:
                // 1 sources

                catch (IOException var12_14) {
                    // empty catch block
                }
            }
        }
        if (var8_8 == false) return var9_9;
        var12_14 = new File(var4_4);
        if (var12_14.exists() == false) return var9_9;
        var12_14.delete();
        return var9_9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decryptAndVerifyFileTo(String string, KeyStore keyStore, String string2, String string3) throws PGPException, IOException {
        IOException iOException3;
        boolean bl;
        InputStream inputStream;
        block21: {
            FileInputStream fileInputStream = null;
            inputStream = null;
            this.Debug("Decrypting and verifying file {0}", new File(string).getAbsolutePath());
            this.Debug("Extracting to {0}", new File(string3).getAbsolutePath());
            try {
                fileInputStream = new FileInputStream(string);
                inputStream = PGPUtil.getDecoderStream((InputStream)fileInputStream);
                PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream);
                Object object = pGPObjectFactory.nextObject();
                if (object instanceof PGPMarker) {
                    object = pGPObjectFactory.nextObject();
                }
                SignatureCheck signatureCheck = new SignatureCheck();
                if (object instanceof PGPEncryptedDataList) {
                    PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
                    this.parseEncryptedDataTo(pGPEncryptedDataList, true, signatureCheck, keyStore, null, string2, null, string3, string);
                } else if (object instanceof PGPCompressedData) {
                    this.parseCompressedDataTo((PGPCompressedData)object, true, signatureCheck, keyStore, null, string3, string);
                } else if (object instanceof PGPOnePassSignatureList) {
                    this.parseSignedDataTo((PGPOnePassSignatureList)object, pGPObjectFactory, keyStore, null, string3, string, signatureCheck);
                } else if (object instanceof PGPSignatureList) {
                    this.parseSignedDataVersion3To((PGPSignatureList)object, pGPObjectFactory, keyStore, null, string3, string, signatureCheck);
                } else if (object instanceof PGPLiteralData) {
                    this.parseLiteralDataTo((PGPLiteralData)object, null, string3, string);
                } else {
                    throw new NonPGPDataException("The supplied data is not a valid OpenPGP message");
                }
                bl = signatureCheck.result == SignatureCheckResult.SignatureVerified;
                Object var13_12 = null;
                if (fileInputStream == null) break block21;
            }
            catch (Throwable throwable) {
                block23: {
                    IOException iOException22;
                    Object var13_13 = null;
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (inputStream == null) break block23;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult decryptAndVerifyTo(String string, KeyStore keyStore, String string2, String string3) throws PGPException, IOException {
        SignatureCheckResult signatureCheckResult;
        block5: {
            BufferedInputStream bufferedInputStream = null;
            this.Debug("Decrypting and verifying file {0}", new File(string).getAbsolutePath());
            this.Debug("Extracting to {0}", new File(string3).getAbsolutePath());
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                signatureCheckResult = this.decryptAndVerifyTo(bufferedInputStream, keyStore, string2, string3);
                Object var8_7 = null;
                if (bufferedInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (bufferedInputStream == null) break block6;
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return signatureCheckResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean decryptAndVerifyStream(InputStream inputStream, KeyStore keyStore, String string, OutputStream outputStream) throws PGPException, IOException {
        boolean bl;
        InputStream inputStream2;
        block26: {
            boolean bl2;
            block25: {
                inputStream2 = null;
                try {
                    try {
                        ArmoredInputStream armoredInputStream;
                        inputStream2 = PGPUtil.getDecoderStream((InputStream)inputStream);
                        if (inputStream2 instanceof ArmoredInputStream && (armoredInputStream = (ArmoredInputStream)inputStream2).isClearText()) {
                            this.Debug("Clear text signed data found");
                            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
                            try {
                                bl2 = clearSignedHelper.verify(armoredInputStream, keyStore, null, outputStream);
                            }
                            catch (SignatureException signatureException) {
                                this.Debug("Signature exception: " + signatureException);
                                boolean bl3 = false;
                                Object var12_14 = null;
                                if (inputStream2 == null) return bl3;
                                try {
                                    inputStream2.close();
                                    return bl3;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                return bl3;
                            }
                            Object var12_13 = null;
                            if (inputStream2 == null) return bl2;
                            break block25;
                        }
                        armoredInputStream = PGPObjectFactory2.create(inputStream2);
                        Object object = null;
                        try {
                            object = armoredInputStream.nextObject();
                        }
                        catch (IOException iOException) {
                            throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
                        }
                        if (object instanceof PGPMarker) {
                            this.Debug("Skipping PGP marker.");
                            object = armoredInputStream.nextObject();
                        }
                        SignatureCheck signatureCheck = new SignatureCheck();
                        if (object instanceof PGPEncryptedDataList) {
                            PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
                            this.parseEncryptedData(pGPEncryptedDataList, true, signatureCheck, keyStore, null, string, null, outputStream);
                        } else if (object instanceof PGPCompressedData) {
                            this.parseCompressedData((PGPCompressedData)object, true, signatureCheck, keyStore, null, outputStream);
                        } else if (object instanceof PGPOnePassSignatureList) {
                            this.parseSignedData((PGPOnePassSignatureList)object, (PGPObjectFactory)armoredInputStream, keyStore, null, outputStream, signatureCheck);
                        } else if (object instanceof PGPSignatureList) {
                            this.parseSignedDataVersion3((PGPSignatureList)object, (PGPObjectFactory)armoredInputStream, keyStore, null, outputStream, signatureCheck);
                        } else {
                            if (!(object instanceof PGPLiteralData)) throw new NonPGPDataException("Unknown message format: " + object);
                            this.parseLiteralData((PGPLiteralData)object, null, outputStream);
                        }
                        bl = signatureCheck.result == SignatureCheckResult.SignatureVerified;
                        break block26;
                    }
                    catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                        throw IOUtil.newPGPException(pGPException);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    if (inputStream2 == null) throw throwable;
                    try {}
                    catch (IOException iOException) {
                        throw throwable;
                    }
                    inputStream2.close();
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {
                // empty catch block
                return bl2;
            }
            inputStream2.close();
            return bl2;
        }
        Object var12_15 = null;
        if (inputStream2 == null) return bl;
        try {}
        catch (IOException iOException) {
            // empty catch block
            return bl;
        }
        inputStream2.close();
        return bl;
    }

    /*
     * Loose catch block
     */
    public SignatureCheckResult decryptAndVerify(InputStream inputStream, KeyStore keyStore, String string, OutputStream outputStream) throws PGPException, IOException {
        SignatureCheckResult signatureCheckResult;
        InputStream inputStream2;
        block24: {
            ArmoredInputStream armoredInputStream;
            block22: {
                SignatureCheckResult signatureCheckResult2;
                block23: {
                    inputStream2 = null;
                    inputStream2 = PGPUtil.getDecoderStream((InputStream)inputStream);
                    if (!(inputStream2 instanceof ArmoredInputStream) || !(armoredInputStream = (ArmoredInputStream)inputStream2).isClearText()) break block22;
                    this.Debug("Clear text signed data found");
                    ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
                    signatureCheckResult2 = clearSignedHelper.verify2(armoredInputStream, keyStore, null, outputStream);
                    Object var12_12 = null;
                    if (inputStream2 == null) break block23;
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return signatureCheckResult2;
            }
            armoredInputStream = PGPObjectFactory2.create(inputStream2);
            Object object = null;
            try {
                object = armoredInputStream.nextObject();
            }
            catch (IOException iOException) {
                throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
            }
            if (object instanceof PGPMarker) {
                this.Debug("Skipping PGP marker.");
                object = armoredInputStream.nextObject();
            }
            SignatureCheck signatureCheck = new SignatureCheck();
            if (object instanceof PGPEncryptedDataList) {
                PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
                this.parseEncryptedData(pGPEncryptedDataList, true, signatureCheck, keyStore, null, string, null, outputStream);
            } else if (object instanceof PGPCompressedData) {
                this.parseCompressedData((PGPCompressedData)object, true, signatureCheck, keyStore, null, outputStream);
            } else if (object instanceof PGPOnePassSignatureList) {
                this.parseSignedData((PGPOnePassSignatureList)object, (PGPObjectFactory)armoredInputStream, keyStore, null, outputStream, signatureCheck);
            } else if (object instanceof PGPSignatureList) {
                this.parseSignedDataVersion3((PGPSignatureList)object, (PGPObjectFactory)armoredInputStream, keyStore, null, outputStream, signatureCheck);
            } else if (object instanceof PGPLiteralData) {
                this.parseLiteralData((PGPLiteralData)object, null, outputStream);
            } else {
                throw new NonPGPDataException("Unknown message format: " + object);
            }
            signatureCheckResult = signatureCheck.result;
            Object var12_13 = null;
            if (inputStream2 == null) break block24;
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return signatureCheckResult;
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            try {
                throw IOUtil.newPGPException(pGPException);
            }
            catch (Throwable throwable) {
                block25: {
                    Object var12_14 = null;
                    if (inputStream2 == null) break block25;
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean decryptAndVerifyFile(String var1_1, String var2_2, String var3_3, String var4_4, String var5_5) throws PGPException, IOException {
        block33: {
            block32: {
                block31: {
                    block25: {
                        this.Debug("Decrypting and signature verifying file {0}", var1_1);
                        this.Debug("Extracting to {0}", new File(var5_5).getAbsolutePath());
                        var6_6 = null;
                        var7_7 = null;
                        var8_8 = null;
                        var9_9 = null;
                        var10_10 = false;
                        try {
                            try {
                                var6_6 = new FileInputStream(var1_1);
                                var7_7 = PGPLib.readFileOrAsciiString(var2_2, "privateKeyFileName");
                                var8_8 = PGPLib.readFileOrAsciiString(var4_4, "publicKeyFile");
                                var9_9 = new FileOutputStream(var5_5);
                                var11_11 = this.decryptAndVerifyStream(var6_6, var7_7, var3_3, var8_8, var9_9);
                                var13_14 = null;
                                if (var6_6 == null) break block25;
                            }
                            catch (PGPException var11_12) {
                                var10_10 = true;
                                throw var11_12;
                            }
                            catch (IOException var11_13) {
                                var10_10 = true;
                                throw var11_13;
                            }
                        }
                        catch (Throwable var12_18) {
                            var13_15 = null;
                            if (var6_6 != null) {
                                try {
                                    var6_6.close();
                                }
                                catch (IOException var14_17) {
                                    // empty catch block
                                }
                            }
                            if (var7_7 != null) {
                                try {
                                    var7_7.close();
                                }
                                catch (IOException var14_17) {
                                    // empty catch block
                                }
                            }
                            if (var8_8 != null) {
                                try {
                                    var8_8.close();
                                }
                                catch (IOException var14_17) {
                                    // empty catch block
                                }
                            }
                            if (var9_9 != null) {
                                try {
                                    var9_9.flush();
                                    var9_9.close();
                                }
                                catch (IOException var14_17) {
                                    // empty catch block
                                }
                            }
                            if (var10_10 == false) throw var12_18;
                            var14_17 = new File(var5_5);
                            if (var14_17.exists() == false) throw var12_18;
                            var14_17.delete();
                            throw var12_18;
                        }
                        ** try [egrp 2[TRYBLOCK] [4 : 132->140)] { 
lbl65:
                        // 1 sources

                        var6_6.close();
                        break block25;
lbl67:
                        // 1 sources

                        catch (IOException var14_16) {
                            // empty catch block
                        }
                    }
                    if (var7_7 != null) {
                        ** try [egrp 3[TRYBLOCK] [5 : 147->155)] { 
lbl72:
                        // 1 sources

                        var7_7.close();
                        break block31;
lbl74:
                        // 1 sources

                        catch (IOException var14_16) {
                            // empty catch block
                        }
                    }
                }
                if (var8_8 != null) {
                    ** try [egrp 4[TRYBLOCK] [6 : 162->170)] { 
lbl79:
                    // 1 sources

                    var8_8.close();
                    break block32;
lbl81:
                    // 1 sources

                    catch (IOException var14_16) {
                        // empty catch block
                    }
                }
            }
            if (var9_9 != null) {
                ** try [egrp 5[TRYBLOCK] [7 : 177->190)] { 
lbl86:
                // 1 sources

                var9_9.flush();
                var9_9.close();
                break block33;
lbl89:
                // 1 sources

                catch (IOException var14_16) {
                    // empty catch block
                }
            }
        }
        if (var10_10 == false) return var11_11;
        var14_16 = new File(var5_5);
        if (var14_16.exists() == false) return var11_11;
        var14_16.delete();
        return var11_11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decryptAndVerifyFileTo(String string, String string2, String string3, String string4, String string5) throws PGPException, IOException {
        IOException iOException3;
        boolean bl;
        InputStream inputStream;
        FileInputStream fileInputStream;
        block15: {
            this.Debug("Decrypting and signature verifying file {0}", string);
            this.Debug("Extracting to {0}", new File(string5).getAbsolutePath());
            FileInputStream fileInputStream2 = null;
            fileInputStream = null;
            inputStream = null;
            try {
                fileInputStream2 = new FileInputStream(string);
                fileInputStream = new FileInputStream(string2);
                inputStream = new FileInputStream(string4);
                bl = this.decryptAndVerifyStreamTo(fileInputStream2, fileInputStream, string3, inputStream, string5);
                Object var11_10 = null;
                if (fileInputStream2 == null) break block15;
            }
            catch (Throwable throwable) {
                block18: {
                    IOException iOException22;
                    Object var11_11 = null;
                    if (fileInputStream2 != null) {
                        try {
                            ((InputStream)fileInputStream2).close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (inputStream == null) break block18;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream2).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (fileInputStream != null) {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCheckResult decryptAndVerifyTo(String string, String string2, String string3, String string4, String string5) throws PGPException, IOException {
        IOException iOException3;
        SignatureCheckResult signatureCheckResult;
        InputStream inputStream;
        FileInputStream fileInputStream;
        block15: {
            this.Debug("Decrypting and signature verifying file {0}", string);
            this.Debug("Extracting to {0}", new File(string5).getAbsolutePath());
            FileInputStream fileInputStream2 = null;
            fileInputStream = null;
            inputStream = null;
            try {
                fileInputStream2 = new FileInputStream(string);
                fileInputStream = new FileInputStream(string2);
                inputStream = new FileInputStream(string4);
                signatureCheckResult = this.decryptAndVerifyTo(fileInputStream2, fileInputStream, string3, inputStream, string5);
                Object var11_10 = null;
                if (fileInputStream2 == null) break block15;
            }
            catch (Throwable throwable) {
                block18: {
                    IOException iOException22;
                    Object var11_11 = null;
                    if (fileInputStream2 != null) {
                        try {
                            ((InputStream)fileInputStream2).close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (inputStream == null) break block18;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream2).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (fileInputStream != null) {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        return signatureCheckResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean decryptAndVerifyStream(InputStream inputStream, InputStream inputStream2, String string, InputStream inputStream3, OutputStream outputStream) throws PGPException, IOException {
        boolean bl;
        ArmoredInputStream armoredInputStream;
        InputStream inputStream4 = PGPUtil.getDecoderStream((InputStream)inputStream);
        if (inputStream4 instanceof ArmoredInputStream && (armoredInputStream = (ArmoredInputStream)inputStream4).isClearText()) {
            this.Debug("Clear text signed data found");
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            try {
                return clearSignedHelper.verify(armoredInputStream, null, inputStream3, outputStream);
            }
            catch (SignatureException signatureException) {
                this.Debug("Signature exception: " + signatureException);
                return false;
            }
        }
        try {
            try {
                armoredInputStream = PGPObjectFactory2.create(inputStream4);
                Object object = null;
                try {
                    object = armoredInputStream.nextObject();
                }
                catch (IOException iOException) {
                    throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
                }
                if (object instanceof PGPMarker) {
                    this.Debug("Skipping marker packet.");
                    object = armoredInputStream.nextObject();
                }
                SignatureCheck signatureCheck = new SignatureCheck();
                if (object instanceof PGPEncryptedDataList) {
                    PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
                    this.parseEncryptedData(pGPEncryptedDataList, true, signatureCheck, null, inputStream2, string, inputStream3, outputStream);
                } else if (object instanceof PGPCompressedData) {
                    this.parseCompressedData((PGPCompressedData)object, true, signatureCheck, null, inputStream3, outputStream);
                } else if (object instanceof PGPOnePassSignatureList) {
                    this.parseSignedData((PGPOnePassSignatureList)object, (PGPObjectFactory)armoredInputStream, null, inputStream3, outputStream, signatureCheck);
                } else if (object instanceof PGPSignatureList) {
                    this.parseSignedDataVersion3((PGPSignatureList)object, (PGPObjectFactory)armoredInputStream, null, inputStream3, outputStream, signatureCheck);
                } else {
                    if (!(object instanceof PGPLiteralData)) throw new NonPGPDataException("Unknown message format: " + object);
                    this.parseLiteralData((PGPLiteralData)object, null, outputStream);
                }
                bl = signatureCheck.result == SignatureCheckResult.SignatureVerified;
                Object var13_16 = null;
                if (inputStream4 == null) return bl;
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                this.Debug("PGPException " + (Object)((Object)pGPException));
                throw IOUtil.newPGPException(pGPException);
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (inputStream4 == null) throw throwable;
            try {
                inputStream4.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return bl;
        }
        inputStream4.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignatureCheckResult decryptAndVerify(InputStream inputStream, InputStream inputStream2, String string, InputStream inputStream3, OutputStream outputStream) throws PGPException, IOException {
        SignatureCheckResult signatureCheckResult;
        ArmoredInputStream armoredInputStream;
        InputStream inputStream4 = PGPUtil.getDecoderStream((InputStream)inputStream);
        if (inputStream4 instanceof ArmoredInputStream && (armoredInputStream = (ArmoredInputStream)inputStream4).isClearText()) {
            this.Debug("Clear text signed data found");
            ClearSignedHelper clearSignedHelper = new ClearSignedHelper();
            return clearSignedHelper.verify2(armoredInputStream, null, inputStream3, outputStream);
        }
        try {
            try {
                armoredInputStream = PGPObjectFactory2.create(inputStream4);
                Object object = null;
                try {
                    object = armoredInputStream.nextObject();
                }
                catch (IOException iOException) {
                    throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
                }
                if (object instanceof PGPMarker) {
                    this.Debug("Skipping marker packet.");
                    object = armoredInputStream.nextObject();
                }
                SignatureCheck signatureCheck = new SignatureCheck();
                if (object instanceof PGPEncryptedDataList) {
                    PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
                    this.parseEncryptedData(pGPEncryptedDataList, true, signatureCheck, null, inputStream2, string, inputStream3, outputStream);
                } else if (object instanceof PGPCompressedData) {
                    this.parseCompressedData((PGPCompressedData)object, true, signatureCheck, null, inputStream3, outputStream);
                } else if (object instanceof PGPOnePassSignatureList) {
                    this.parseSignedData((PGPOnePassSignatureList)object, (PGPObjectFactory)armoredInputStream, null, inputStream3, outputStream, signatureCheck);
                } else if (object instanceof PGPSignatureList) {
                    this.parseSignedDataVersion3((PGPSignatureList)object, (PGPObjectFactory)armoredInputStream, null, inputStream3, outputStream, signatureCheck);
                } else {
                    if (!(object instanceof PGPLiteralData)) throw new NonPGPDataException("Unknown message format: " + object);
                    this.parseLiteralData((PGPLiteralData)object, null, outputStream);
                }
                signatureCheckResult = signatureCheck.result;
                Object var13_15 = null;
                if (inputStream4 == null) return signatureCheckResult;
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                this.Debug("PGPException " + (Object)((Object)pGPException));
                throw IOUtil.newPGPException(pGPException);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (inputStream4 == null) throw throwable;
            try {
                inputStream4.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return signatureCheckResult;
        }
        inputStream4.close();
        return signatureCheckResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean decryptAndVerifyStreamTo(InputStream inputStream, InputStream inputStream2, String string, InputStream inputStream3, String string2) throws PGPException, IOException {
        boolean bl;
        this.Debug("Decrypting and signature verifying of stream data to {0}", new File(string2).getAbsolutePath());
        InputStream inputStream4 = null;
        try {
            try {
                inputStream4 = PGPUtil.getDecoderStream((InputStream)inputStream);
                PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream4);
                Object object = null;
                try {
                    object = pGPObjectFactory.nextObject();
                }
                catch (IOException iOException) {
                    throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
                }
                if (object instanceof PGPMarker) {
                    this.Debug("Skipping marker packet.");
                    object = pGPObjectFactory.nextObject();
                }
                SignatureCheck signatureCheck = new SignatureCheck();
                if (object instanceof PGPEncryptedDataList) {
                    PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
                    this.parseEncryptedDataTo(pGPEncryptedDataList, true, signatureCheck, null, inputStream2, string, inputStream3, string2, null);
                } else if (object instanceof PGPCompressedData) {
                    this.parseCompressedDataTo((PGPCompressedData)object, true, signatureCheck, null, inputStream3, string2, null);
                } else if (object instanceof PGPOnePassSignatureList) {
                    this.parseSignedDataTo((PGPOnePassSignatureList)object, pGPObjectFactory, null, inputStream3, string2, null, signatureCheck);
                } else if (object instanceof PGPSignatureList) {
                    this.parseSignedDataVersion3To((PGPSignatureList)object, pGPObjectFactory, null, inputStream3, string2, null, signatureCheck);
                } else {
                    if (!(object instanceof PGPLiteralData)) throw new NonPGPDataException("Unknown message format: " + object);
                    this.parseLiteralDataTo((PGPLiteralData)object, null, string2, null);
                }
                bl = signatureCheck.result == SignatureCheckResult.SignatureVerified;
                Object var13_14 = null;
                if (inputStream4 == null) return bl;
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (inputStream4 == null) throw throwable;
            try {
                inputStream4.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return bl;
        }
        inputStream4.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignatureCheckResult decryptAndVerifyTo(InputStream inputStream, InputStream inputStream2, String string, InputStream inputStream3, String string2) throws PGPException, IOException {
        SignatureCheckResult signatureCheckResult;
        this.Debug("Decrypting and signature verifying of stream data to {0}", new File(string2).getAbsolutePath());
        InputStream inputStream4 = null;
        try {
            try {
                inputStream4 = PGPUtil.getDecoderStream((InputStream)inputStream);
                PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream4);
                Object object = null;
                try {
                    object = pGPObjectFactory.nextObject();
                }
                catch (IOException iOException) {
                    throw new NonPGPDataException("The supplied data is not a valid OpenPGP message", iOException);
                }
                if (object instanceof PGPMarker) {
                    this.Debug("Skipping marker packet.");
                    object = pGPObjectFactory.nextObject();
                }
                SignatureCheck signatureCheck = new SignatureCheck();
                if (object instanceof PGPEncryptedDataList) {
                    PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
                    this.parseEncryptedDataTo(pGPEncryptedDataList, true, signatureCheck, null, inputStream2, string, inputStream3, string2, null);
                } else if (object instanceof PGPCompressedData) {
                    this.parseCompressedDataTo((PGPCompressedData)object, true, signatureCheck, null, inputStream3, string2, null);
                } else if (object instanceof PGPOnePassSignatureList) {
                    this.parseSignedDataTo((PGPOnePassSignatureList)object, pGPObjectFactory, null, inputStream3, string2, null, signatureCheck);
                } else if (object instanceof PGPSignatureList) {
                    this.parseSignedDataVersion3To((PGPSignatureList)object, pGPObjectFactory, null, inputStream3, string2, null, signatureCheck);
                } else {
                    if (!(object instanceof PGPLiteralData)) throw new NonPGPDataException("Unknown message format: " + object);
                    this.parseLiteralDataTo((PGPLiteralData)object, null, string2, null);
                }
                signatureCheckResult = signatureCheck.result;
                Object var13_14 = null;
                if (inputStream4 == null) return signatureCheckResult;
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (inputStream4 == null) throw throwable;
            try {
                inputStream4.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return signatureCheckResult;
        }
        inputStream4.close();
        return signatureCheckResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean decryptAndVerifyStreamTo(InputStream inputStream, KeyStore keyStore, String string, String string2) throws PGPException, IOException {
        boolean bl;
        this.Debug("Decrypting and signature verifying of stream data to {0}", new File(string2).getAbsolutePath());
        InputStream inputStream2 = null;
        try {
            try {
                inputStream2 = PGPUtil.getDecoderStream((InputStream)inputStream);
                PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream2);
                Object object = pGPObjectFactory.nextObject();
                if (object instanceof PGPMarker) {
                    object = pGPObjectFactory.nextObject();
                }
                SignatureCheck signatureCheck = new SignatureCheck();
                if (object instanceof PGPEncryptedDataList) {
                    PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
                    this.parseEncryptedDataTo(pGPEncryptedDataList, true, signatureCheck, keyStore, null, string, null, string2, null);
                } else {
                    if (!(object instanceof PGPCompressedData)) {
                        if (object != null) throw new lw.bouncycastle.openpgp.PGPException("Unknown message format: " + object);
                        throw new NonPGPDataException("The supplied data is not a valid OpenPGP message");
                    }
                    this.parseCompressedDataTo((PGPCompressedData)object, true, signatureCheck, keyStore, null, string2, null);
                }
                bl = signatureCheck.result == SignatureCheckResult.SignatureVerified;
                Object var12_12 = null;
                if (inputStream2 == null) return bl;
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (inputStream2 == null) throw throwable;
            try {
                inputStream2.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return bl;
        }
        inputStream2.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignatureCheckResult decryptAndVerifyTo(InputStream inputStream, KeyStore keyStore, String string, String string2) throws PGPException, IOException {
        SignatureCheckResult signatureCheckResult;
        this.Debug("Decrypting and signature verifying of stream data to {0}", new File(string2).getAbsolutePath());
        InputStream inputStream2 = null;
        try {
            try {
                inputStream2 = PGPUtil.getDecoderStream((InputStream)inputStream);
                PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream2);
                Object object = pGPObjectFactory.nextObject();
                if (object instanceof PGPMarker) {
                    object = pGPObjectFactory.nextObject();
                }
                SignatureCheck signatureCheck = new SignatureCheck();
                if (object instanceof PGPEncryptedDataList) {
                    PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
                    this.parseEncryptedDataTo(pGPEncryptedDataList, true, signatureCheck, keyStore, null, string, null, string2, null);
                } else {
                    if (!(object instanceof PGPCompressedData)) {
                        if (object != null) throw new lw.bouncycastle.openpgp.PGPException("Unknown message format: " + object);
                        throw new NonPGPDataException("The supplied data is not a valid OpenPGP message");
                    }
                    this.parseCompressedDataTo((PGPCompressedData)object, true, signatureCheck, keyStore, null, string2, null);
                }
                signatureCheckResult = signatureCheck.result;
                Object var12_12 = null;
                if (inputStream2 == null) return signatureCheckResult;
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (inputStream2 == null) throw throwable;
            try {
                inputStream2.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return signatureCheckResult;
        }
        inputStream2.close();
        return signatureCheckResult;
    }

    /*
     * Loose catch block
     */
    private void internalEncryptStream(InputStream inputStream, String string, long l, PGPPublicKey[] pGPPublicKeyArray, OutputStream outputStream, boolean bl, boolean bl2, boolean bl3) throws PGPException, IOException {
        block32: {
            IOException iOException2222;
            OutputStream outputStream2;
            OutputStream outputStream3;
            File file;
            block29: {
                int n;
                if (this.pgp2Compatible) {
                    this.internalEncryptStreamPgp2x(inputStream, string, pGPPublicKeyArray, outputStream, bl);
                    return;
                }
                if (!(outputStream instanceof BufferedOutputStream)) {
                    outputStream = new BufferedOutputStream(outputStream, 65536);
                }
                OutputStream outputStream4 = null;
                if (bl) {
                    this.Debug("Output in ASCII armored format.");
                    outputStream4 = outputStream;
                    outputStream = new ArmoredOutputStream(outputStream4);
                    this.setAsciiVersionHeader(outputStream);
                }
                int n2 = this.compression.get(0);
                int n3 = this.cypher.get(0);
                if (pGPPublicKeyArray.length == 1) {
                    n2 = this.selectPreferredCompression(pGPPublicKeyArray[0]);
                    n3 = this.selectPreferredCypher(pGPPublicKeyArray[0]);
                    this.Debug("Encrypting with cypher {0}", KeyStore.cypherToString(n3));
                    this.Debug("Compression is {0}", KeyStore.compressionToString(n2));
                }
                file = null;
                outputStream3 = null;
                outputStream2 = null;
                PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(this.bcFactory.CreatePGPDataEncryptorBuilder(n3, bl2, IOUtil.getSecureRandom()));
                for (n = 0; n < pGPPublicKeyArray.length; ++n) {
                    this.Debug("Encrypting with key {0} ", KeyPairInformation.keyId2Hex(pGPPublicKeyArray[n].getKeyID()));
                    pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator(pGPPublicKeyArray[n]));
                }
                for (n = 0; n < this.getMasterKeysCount(); ++n) {
                    KeyPairInformation keyPairInformation = (KeyPairInformation)this.masterKeysList.get(n);
                    PGPPublicKey pGPPublicKey = this.readPublicKeyForEncryption(keyPairInformation.getPublicKeyRing());
                    pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey));
                    this.Debug("Encrypting with master key Id {0}", KeyPairInformation.keyId2Hex(pGPPublicKey.getKeyID()));
                }
                if (bl3) {
                    BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(outputStream);
                    this.writeMarker(bCPGOutputStream);
                    bCPGOutputStream.flush();
                }
                outputStream2 = pGPEncryptedDataGenerator.open(outputStream, new byte[65536]);
                PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(n2);
                if (n2 == 0) {
                    this.writeFileToLiteralData(outputStream2, this.getContentType(), inputStream, string, l, new Date());
                } else {
                    outputStream3 = pGPCompressedDataGenerator.open(outputStream2);
                    this.writeFileToLiteralData(outputStream3, this.getContentType(), inputStream, string, l, new Date());
                }
                pGPCompressedDataGenerator.close();
                pGPEncryptedDataGenerator.close();
                Object var21_22 = null;
                if (outputStream3 == null) break block29;
                try {
                    outputStream3.flush();
                    outputStream3.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (outputStream2 != null) {
                try {
                    outputStream2.flush();
                    outputStream2.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            outputStream.flush();
            if (bl && outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (file != null) {
                file.delete();
            }
            break block32;
            {
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    throw IOUtil.newPGPException(pGPException);
                }
            }
            catch (Throwable throwable) {
                IOException iOException32222;
                Object var21_23 = null;
                if (outputStream3 != null) {
                    try {
                        outputStream3.flush();
                        outputStream3.close();
                    }
                    catch (IOException iOException32222) {
                        // empty catch block
                    }
                }
                if (outputStream2 != null) {
                    try {
                        outputStream2.flush();
                        outputStream2.close();
                    }
                    catch (IOException iOException32222) {
                        // empty catch block
                    }
                }
                outputStream.flush();
                if (bl && outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException iOException32222) {
                        // empty catch block
                    }
                }
                if (file != null) {
                    file.delete();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalEncryptStream2(InputStream inputStream, String string, PGPPublicKey[] pGPPublicKeyArray, OutputStream outputStream, Date date, boolean bl, boolean bl2, boolean bl3) throws PGPException, IOException {
        IOException iOException3;
        block23: {
            Object object;
            KeyPairInformation keyPairInformation;
            BCPGOutputStream bCPGOutputStream;
            if (this.pgp2Compatible) {
                this.internalEncryptStreamPgp2x(inputStream, string, pGPPublicKeyArray, outputStream, bl);
                return;
            }
            if (!(outputStream instanceof BufferedOutputStream)) {
                outputStream = new BufferedOutputStream(outputStream, 65536);
            }
            OutputStream outputStream2 = null;
            if (bl) {
                outputStream2 = outputStream;
                outputStream = new ArmoredOutputStream(outputStream2);
                this.setAsciiVersionHeader(outputStream);
            }
            int n = this.compression.get(0);
            int n2 = this.cypher.get(0);
            if (pGPPublicKeyArray.length == 1) {
                n = this.selectPreferredCompression(pGPPublicKeyArray[0]);
                n2 = this.selectPreferredCypher(pGPPublicKeyArray[0]);
            }
            this.Debug("Encrypting with cypher {0}", KeyStore.cypherToString(n2));
            this.Debug("Compression is {0}", KeyStore.compressionToString(n));
            if (bl3) {
                bCPGOutputStream = new BCPGOutputStream(outputStream);
                this.writeMarker(bCPGOutputStream);
                bCPGOutputStream.flush();
            }
            bCPGOutputStream = new PGPEncryptedDataGenerator(this.bcFactory.CreatePGPDataEncryptorBuilder(n2, bl2, IOUtil.getSecureRandom()));
            OutputStream outputStream3 = null;
            try {
                int n3;
                for (n3 = 0; n3 < pGPPublicKeyArray.length; ++n3) {
                    this.Debug("Encrypting with key {0} ", KeyPairInformation.keyId2Hex(pGPPublicKeyArray[n3].getKeyID()));
                    bCPGOutputStream.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator(pGPPublicKeyArray[n3]));
                }
                for (n3 = 0; n3 < this.getMasterKeysCount(); ++n3) {
                    keyPairInformation = (KeyPairInformation)this.masterKeysList.get(n3);
                    object = this.readPublicKeyForEncryption(keyPairInformation.getPublicKeyRing());
                    bCPGOutputStream.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator((PGPPublicKey)object));
                    this.Debug("Encrypting with master key Id {0}", KeyPairInformation.keyId2Hex(object.getKeyID()));
                }
                outputStream3 = bCPGOutputStream.open(outputStream, new byte[65536]);
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
            try {
                PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(n);
                keyPairInformation = new PGPLiteralDataGenerator();
                object = null;
                if (n == 0) {
                    object = keyPairInformation.open(outputStream3, this.getContentType(), string, date, new byte[65536]);
                    PGPLib.pipeAll(inputStream, (OutputStream)object);
                } else {
                    object = keyPairInformation.open(pGPCompressedDataGenerator.open(outputStream3), this.getContentType(), string, date, new byte[65536]);
                    PGPLib.pipeAll(inputStream, (OutputStream)object);
                }
                if (keyPairInformation != null) {
                    keyPairInformation.close();
                }
                pGPCompressedDataGenerator.close();
                bCPGOutputStream.close();
                Object var18_19 = null;
                if (outputStream3 == null) break block23;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var18_20 = null;
                if (outputStream3 != null) {
                    try {
                        outputStream3.flush();
                        outputStream3.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                outputStream.flush();
                if (bl && outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                outputStream3.flush();
                outputStream3.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        outputStream.flush();
        if (bl && outputStream != null) {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException3) {}
        }
    }

    private void internalEncryptStreamPgp2x(InputStream inputStream, String string, PGPPublicKey[] pGPPublicKeyArray, OutputStream outputStream, boolean bl) throws PGPException, IOException {
        Object object;
        Object object2;
        this.Debug("Encrypting in PGP 2.x compatibility mode");
        if (string == null || "".equals(string.trim())) {
            this.Debug("No internal file name label was specified. Using {0} instead.", "_CONSOLE");
            string = "_CONSOLE";
        }
        OutputStream outputStream2 = null;
        OutputStream outputStream3 = outputStream;
        if (bl) {
            this.Debug("Output is ASCII armored");
            outputStream2 = outputStream3;
            outputStream3 = new ArmoredOutputStream(outputStream2);
            this.setAsciiVersionHeader(outputStream3);
        }
        int n = 1;
        boolean bl2 = true;
        this.Debug("Cipher used is {0}", KeyStore.cypherToString(n));
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = this.bcFactory.CreatePGPEncryptedDataGenerator(n, false, IOUtil.getSecureRandom(), bl2);
        for (int i = 0; i < pGPPublicKeyArray.length; ++i) {
            pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator(pGPPublicKeyArray[i]));
            for (int j = 0; j < this.getMasterKeysCount(); ++j) {
                object2 = (KeyPairInformation)this.masterKeysList.get(j);
                object = this.readPublicKeyForEncryption(((KeyPairInformation)object2).getPublicKeyRing());
                pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator((PGPPublicKey)object));
                this.Debug("Encrypting with master key Id {0}", KeyPairInformation.keyId2Hex(object.getKeyID()));
            }
            this.Debug("Encrypting for key Id {0}", String.valueOf(pGPPublicKeyArray[i].getKeyID()));
        }
        DirectByteArrayOutputStream directByteArrayOutputStream = new DirectByteArrayOutputStream(65536);
        BaseLib.pipeAll(inputStream, directByteArrayOutputStream);
        DirectByteArrayOutputStream directByteArrayOutputStream2 = new DirectByteArrayOutputStream(65536);
        object2 = new PGPLiteralDataGenerator(bl2);
        object = object2.open((OutputStream)directByteArrayOutputStream2, this.contentType, string, (long)directByteArrayOutputStream.size(), new Date());
        directByteArrayOutputStream.writeTo((OutputStream)object);
        object2.close();
        ((OutputStream)object).close();
        OutputStream outputStream4 = null;
        try {
            outputStream4 = pGPEncryptedDataGenerator.open(outputStream3, (long)directByteArrayOutputStream2.size());
            directByteArrayOutputStream2.writeTo(outputStream4);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        if (outputStream4 != null) {
            try {
                outputStream4.flush();
                outputStream4.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        directByteArrayOutputStream = null;
        directByteArrayOutputStream2 = null;
        outputStream3.flush();
        if (bl && outputStream3 != null) {
            try {
                outputStream3.flush();
                outputStream3.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inernalEncryptStream(InputStream inputStream, String string, PGPPublicKey[] pGPPublicKeyArray, OutputStream outputStream, Date date, boolean bl, boolean bl2, boolean bl3) throws PGPException, IOException {
        IOException iOException5;
        block34: {
            Object object;
            KeyPairInformation keyPairInformation;
            BCPGOutputStream bCPGOutputStream;
            OutputStream outputStream2 = null;
            if (bl) {
                outputStream2 = outputStream;
                outputStream = new ArmoredOutputStream(outputStream2);
                this.setAsciiVersionHeader(outputStream);
            }
            int n = this.compression.get(0);
            int n2 = this.cypher.get(0);
            if (pGPPublicKeyArray.length == 1) {
                n = this.selectPreferredCompression(pGPPublicKeyArray[0]);
                n2 = this.selectPreferredCypher(pGPPublicKeyArray[0]);
                this.Debug("Encrypting with cypher {0}", KeyStore.cypherToString(n2));
                this.Debug("Compression is {0}", KeyStore.compressionToString(n));
            }
            if (bl3) {
                bCPGOutputStream = new BCPGOutputStream(outputStream);
                this.writeMarker(bCPGOutputStream);
                bCPGOutputStream.flush();
            }
            bCPGOutputStream = new PGPEncryptedDataGenerator(this.bcFactory.CreatePGPDataEncryptorBuilder(n2, bl2, IOUtil.getSecureRandom()));
            OutputStream outputStream3 = null;
            try {
                int n3;
                for (n3 = 0; n3 < pGPPublicKeyArray.length; ++n3) {
                    this.Debug("Encrypting with key {0} ", KeyPairInformation.keyId2Hex(pGPPublicKeyArray[n3].getKeyID()));
                    bCPGOutputStream.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator(pGPPublicKeyArray[n3]));
                }
                for (n3 = 0; n3 < this.getMasterKeysCount(); ++n3) {
                    keyPairInformation = (KeyPairInformation)this.masterKeysList.get(n3);
                    object = this.readPublicKeyForEncryption(keyPairInformation.getPublicKeyRing());
                    bCPGOutputStream.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator((PGPPublicKey)object));
                    this.Debug("Encrypting with master key Id {0}", KeyPairInformation.keyId2Hex(object.getKeyID()));
                }
                outputStream3 = bCPGOutputStream.open(outputStream, new byte[65536]);
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
            try {
                PGPCompressedDataGenerator pGPCompressedDataGenerator;
                block33: {
                    pGPCompressedDataGenerator = new PGPCompressedDataGenerator(n);
                    keyPairInformation = new PGPLiteralDataGenerator();
                    object = null;
                    try {
                        if (n == 0) {
                            object = keyPairInformation.open(outputStream3, 'b', string, date, new byte[65536]);
                            PGPLib.pipeAll(inputStream, (OutputStream)object);
                        } else {
                            object = keyPairInformation.open(pGPCompressedDataGenerator.open(outputStream3), 'b', string, date, new byte[65536]);
                            PGPLib.pipeAll(inputStream, (OutputStream)object);
                        }
                        Object var18_19 = null;
                        if (keyPairInformation == null) break block33;
                    }
                    catch (Throwable throwable) {
                        Object var18_20 = null;
                        if (keyPairInformation != null) {
                            keyPairInformation.close();
                        }
                        pGPCompressedDataGenerator.close();
                        bCPGOutputStream.close();
                        if (object != null) {
                            try {
                                ((OutputStream)object).flush();
                                ((OutputStream)object).close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    keyPairInformation.close();
                }
                pGPCompressedDataGenerator.close();
                bCPGOutputStream.close();
                if (object != null) {
                    try {
                        ((OutputStream)object).flush();
                        ((OutputStream)object).close();
                    }
                    catch (IOException iOException3) {}
                }
                Object var21_24 = null;
                if (outputStream3 == null) break block34;
            }
            catch (Throwable throwable) {
                IOException iOException42;
                Object var21_25 = null;
                if (outputStream3 != null) {
                    try {
                        outputStream3.flush();
                        outputStream3.close();
                    }
                    catch (IOException iOException42) {
                        // empty catch block
                    }
                }
                if (bl && outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException iOException42) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException42) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                outputStream3.flush();
                outputStream3.close();
            }
            catch (IOException iOException5) {
                // empty catch block
            }
        }
        if (bl && outputStream != null) {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException5) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException5) {}
        }
    }

    /*
     * Loose catch block
     */
    private void inernalEncryptStreamPBE(InputStream inputStream, String string, long l, PGPPublicKey pGPPublicKey, String string2, OutputStream outputStream, boolean bl, boolean bl2) throws PGPException {
        block27: {
            if (!(outputStream instanceof BufferedOutputStream)) {
                outputStream = new BufferedOutputStream(outputStream, 65536);
            }
            try {
                IOException iOException2222;
                OutputStream outputStream2;
                OutputStream outputStream3;
                block25: {
                    OutputStream outputStream4 = null;
                    if (bl) {
                        outputStream4 = outputStream;
                        outputStream = new ArmoredOutputStream(outputStream4);
                        this.setAsciiVersionHeader(outputStream);
                    }
                    Object var11_11 = null;
                    outputStream3 = null;
                    outputStream2 = null;
                    int n = this.selectPreferredCompression(pGPPublicKey);
                    int n2 = this.selectPreferredCypher(pGPPublicKey);
                    PGPEncryptedDataGenerator pGPEncryptedDataGenerator = this.bcFactory.CreatePGPEncryptedDataGenerator(n2, bl2, IOUtil.getSecureRandom());
                    pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey));
                    this.Debug("Encrypting with key {0} ", KeyPairInformation.keyId2Hex(pGPPublicKey.getKeyID()));
                    pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePBEKeyEncryptionMethodGenerator(string2));
                    this.Debug("Encrypting with password");
                    for (int i = 0; i < this.getMasterKeysCount(); ++i) {
                        KeyPairInformation keyPairInformation = (KeyPairInformation)this.masterKeysList.get(i);
                        PGPPublicKey pGPPublicKey2 = this.readPublicKeyForEncryption(keyPairInformation.getPublicKeyRing());
                        pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey2));
                        this.Debug("Encrypting with master key Id {0}", KeyPairInformation.keyId2Hex(pGPPublicKey2.getKeyID()));
                    }
                    outputStream2 = pGPEncryptedDataGenerator.open(outputStream, new byte[65536]);
                    PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(n);
                    if (n == 0) {
                        this.writeFileToLiteralData(outputStream2, this.getContentType(), inputStream, string, l, new Date());
                    } else {
                        this.writeFileToLiteralData(pGPCompressedDataGenerator.open(outputStream2), this.getContentType(), inputStream, string, l, new Date());
                    }
                    pGPCompressedDataGenerator.close();
                    pGPEncryptedDataGenerator.close();
                    Object var21_22 = null;
                    if (outputStream3 == null) break block25;
                    try {
                        outputStream3.flush();
                        outputStream3.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (outputStream2 != null) {
                    try {
                        outputStream2.flush();
                        outputStream2.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                outputStream.flush();
                if (bl && outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException iOException2222) {}
                }
                break block27;
                {
                    catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                        throw IOUtil.newPGPException(pGPException);
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException32222;
                    Object var21_23 = null;
                    if (outputStream3 != null) {
                        try {
                            outputStream3.flush();
                            outputStream3.close();
                        }
                        catch (IOException iOException32222) {
                            // empty catch block
                        }
                    }
                    if (outputStream2 != null) {
                        try {
                            outputStream2.flush();
                            outputStream2.close();
                        }
                        catch (IOException iOException32222) {
                            // empty catch block
                        }
                    }
                    outputStream.flush();
                    if (bl && outputStream != null) {
                        try {
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (IOException iOException32222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                throw new PGPException(iOException.getMessage(), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inernalEncryptStreamPBE(InputStream inputStream, String string, String string2, OutputStream outputStream, boolean bl, boolean bl2) throws PGPException {
        try {
            IOException iOException4;
            OutputStream outputStream2;
            block27: {
                Object object;
                KeyPairInformation keyPairInformation;
                OutputStream outputStream3 = null;
                if (bl) {
                    outputStream3 = outputStream;
                    outputStream = new ArmoredOutputStream(outputStream3);
                    this.setAsciiVersionHeader(outputStream);
                }
                outputStream2 = null;
                int n = this.compression.get(0);
                int n2 = this.cypher.get(0);
                PGPEncryptedDataGenerator pGPEncryptedDataGenerator = this.bcFactory.CreatePGPEncryptedDataGenerator(n2, bl2, IOUtil.getSecureRandom());
                try {
                    pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePBEKeyEncryptionMethodGenerator(string2));
                    this.Debug("Encrypting with password");
                    for (int i = 0; i < this.getMasterKeysCount(); ++i) {
                        keyPairInformation = (KeyPairInformation)this.masterKeysList.get(i);
                        object = this.readPublicKeyForEncryption(keyPairInformation.getPublicKeyRing());
                        pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator((PGPPublicKey)object));
                        this.Debug("Encrypting with master key Id {0}", KeyPairInformation.keyId2Hex(object.getKeyID()));
                    }
                    outputStream2 = pGPEncryptedDataGenerator.open(outputStream, new byte[65536]);
                }
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    throw IOUtil.newPGPException(pGPException);
                }
                try {
                    PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(n);
                    keyPairInformation = new PGPLiteralDataGenerator();
                    object = null;
                    if (n == 0) {
                        object = keyPairInformation.open(outputStream2, this.getContentType(), string, new Date(), new byte[65536]);
                        PGPLib.pipeAll(inputStream, (OutputStream)object);
                    } else {
                        object = keyPairInformation.open(pGPCompressedDataGenerator.open(outputStream2), this.getContentType(), string, new Date(), new byte[65536]);
                        PGPLib.pipeAll(inputStream, (OutputStream)object);
                    }
                    if (object != null) {
                        try {
                            ((OutputStream)object).flush();
                            ((OutputStream)object).close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    pGPCompressedDataGenerator.close();
                    Object var17_19 = null;
                    if (inputStream == null) break block27;
                }
                catch (Throwable throwable) {
                    IOException iOException32;
                    Object var17_20 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException32) {
                            // empty catch block
                        }
                    }
                    if (outputStream2 != null) {
                        try {
                            outputStream2.flush();
                            outputStream2.close();
                        }
                        catch (IOException iOException32) {
                            // empty catch block
                        }
                    }
                    outputStream.flush();
                    if (bl && outputStream != null) {
                        try {
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (IOException iOException32) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException4) {
                    // empty catch block
                }
            }
            if (outputStream2 != null) {
                try {
                    outputStream2.flush();
                    outputStream2.close();
                }
                catch (IOException iOException4) {
                    // empty catch block
                }
            }
            outputStream.flush();
            if (bl && outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException4) {}
            }
        }
        catch (IOException iOException) {
            throw new PGPException(iOException.getMessage(), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseLiteralDataVersion3(PGPLiteralData pGPLiteralData, PGPSignature pGPSignature, OutputStream outputStream) throws IOException {
        String string = pGPLiteralData.getFileName();
        this.Debug("Found literal data packet");
        this.Debug("Decrypted file original name is {0}", string);
        InputStream inputStream = null;
        try {
            int n;
            inputStream = pGPLiteralData.getInputStream();
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                if (pGPSignature != null) {
                    pGPSignature.update(byArray, 0, n);
                }
                if (outputStream == null) continue;
                outputStream.write(byArray, 0, n);
            }
            Object var9_8 = null;
            if (inputStream == null) return string;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] parseLiteralDataVersion3To(PGPLiteralData pGPLiteralData, PGPSignature pGPSignature, String string, String string2) throws IOException {
        this.Debug("Found literal data packet");
        String string3 = pGPLiteralData.getFileName();
        if (string3.toUpperCase().endsWith(".TAR") && this.extractEmbeddedTar) {
            String[] stringArray;
            this.Debug("Found multiple file archive");
            TarInputStream tarInputStream = new TarInputStream(pGPLiteralData.getInputStream());
            try {
                stringArray = tarInputStream.extractAll(string);
                Object var9_10 = null;
                if (tarInputStream == null) return stringArray;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (tarInputStream == null) throw throwable;
                tarInputStream.close();
                throw throwable;
            }
            tarInputStream.close();
            return stringArray;
        }
        OutputStream outputStream = null;
        try {
            int n;
            if (string3 == null || "".equals(string3)) {
                if (string2 != null && !"".equals(string2)) {
                    string3 = new File(string2).getName();
                    if (string3.lastIndexOf(".") > 0) {
                        string3 = string3.substring(0, string3.lastIndexOf("."));
                    }
                } else {
                    string3 = "output";
                }
            }
            outputStream = new FileOutputStream(string + File.separator + string3);
            this.Debug("Extracting to {0}", string + File.separator + string3);
            InputStream inputStream = pGPLiteralData.getInputStream();
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                if (pGPSignature != null) {
                    pGPSignature.update(byArray, 0, n);
                }
                ((FileOutputStream)outputStream).write(byArray, 0, n);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                }
            }
            Object var12_16 = null;
            if (outputStream == null) return new String[]{string3};
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.flush();
                ((FileOutputStream)outputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            outputStream.flush();
            ((FileOutputStream)outputStream).close();
            return new String[]{string3};
        }
        catch (IOException iOException) {}
        return new String[]{string3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseLiteralData(PGPLiteralData pGPLiteralData, PGPOnePassSignature pGPOnePassSignature, OutputStream outputStream) throws IOException {
        String string = pGPLiteralData.getFileName();
        InputStream inputStream = pGPLiteralData.getInputStream();
        this.Debug("Found literal data packet");
        this.Debug("Decrypted file original name is {0}", string);
        byte[] byArray = new byte[65536];
        try {
            int n;
            while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                if (pGPOnePassSignature != null) {
                    pGPOnePassSignature.update(byArray, 0, n);
                }
                if (outputStream == null) continue;
                outputStream.write(byArray, 0, n);
            }
            Object var9_8 = null;
            if (inputStream == null) return string;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] parseLiteralDataTo(PGPLiteralData pGPLiteralData, PGPOnePassSignature pGPOnePassSignature, String string, String string2) throws IOException {
        this.Debug("Found literal data packet");
        String string3 = pGPLiteralData.getFileName();
        if (string3.toUpperCase().endsWith(".TAR") && this.extractEmbeddedTar) {
            String[] stringArray;
            this.Debug("Found multiple file archive");
            TarInputStream tarInputStream = null;
            try {
                tarInputStream = new TarInputStream(pGPLiteralData.getInputStream());
                stringArray = tarInputStream.extractAll(string);
                Object var9_10 = null;
                if (tarInputStream == null) return stringArray;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (tarInputStream == null) throw throwable;
                tarInputStream.close();
                throw throwable;
            }
            tarInputStream.close();
            return stringArray;
        }
        InputStream inputStream = pGPLiteralData.getInputStream();
        this.Debug("Decrypted file original name is {0}", pGPLiteralData.getFileName());
        if (string3 == null || "".equals(string3)) {
            if (string2 != null && !"".equals(string2)) {
                string3 = new File(string2).getName();
                if (string3.lastIndexOf(".") > 0) {
                    string3 = string3.substring(0, string3.lastIndexOf("."));
                }
            } else {
                string3 = "output";
            }
        }
        this.Debug("Extracting to {0}", string + File.separator + string3);
        FileOutputStream fileOutputStream = new FileOutputStream(string + File.separator + string3);
        byte[] byArray = new byte[65536];
        try {
            int n;
            while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                if (pGPOnePassSignature != null) {
                    pGPOnePassSignature.update(byArray, 0, n);
                }
                fileOutputStream.write(byArray, 0, n);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                }
            }
            Object var12_16 = null;
            if (fileOutputStream == null) return new String[]{string3};
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.flush();
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileOutputStream.flush();
            fileOutputStream.close();
            return new String[]{string3};
        }
        catch (IOException iOException) {}
        return new String[]{string3};
    }

    private String parseCompressedData(PGPCompressedData pGPCompressedData, boolean bl, SignatureCheck signatureCheck, KeyStore keyStore, InputStream inputStream, OutputStream outputStream) throws PGPException, IOException {
        Object object;
        block22: {
            String string;
            block25: {
                PGPObjectFactory pGPObjectFactory;
                BufferedInputStream bufferedInputStream;
                block23: {
                    String string2;
                    block24: {
                        block18: {
                            String string3;
                            block21: {
                                block19: {
                                    String string4;
                                    block20: {
                                        block16: {
                                            String string5;
                                            block17: {
                                                this.Debug("Decrypted data compression algorithm is {0}", KeyStore.compressionToString(pGPCompressedData.getAlgorithm()));
                                                bufferedInputStream = null;
                                                try {
                                                    bufferedInputStream = new BufferedInputStream(pGPCompressedData.getDataStream());
                                                }
                                                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                                                    throw IOUtil.newPGPException(pGPException);
                                                }
                                                try {
                                                    pGPObjectFactory = PGPObjectFactory2.create(bufferedInputStream);
                                                    object = pGPObjectFactory.nextObject();
                                                    if (!(object instanceof PGPLiteralData)) break block16;
                                                    string5 = this.parseLiteralData((PGPLiteralData)object, null, outputStream);
                                                    Object var12_16 = null;
                                                    if (bufferedInputStream == null) break block17;
                                                }
                                                catch (Throwable throwable) {
                                                    block26: {
                                                        Object var12_21 = null;
                                                        if (bufferedInputStream == null) break block26;
                                                        try {
                                                            ((InputStream)bufferedInputStream).close();
                                                        }
                                                        catch (IOException iOException) {}
                                                    }
                                                    throw throwable;
                                                }
                                                try {
                                                    ((InputStream)bufferedInputStream).close();
                                                }
                                                catch (IOException iOException) {
                                                    // empty catch block
                                                }
                                            }
                                            return string5;
                                        }
                                        if (!(object instanceof PGPOnePassSignatureList)) break block18;
                                        if (!bl) break block19;
                                        string4 = this.parseSignedData((PGPOnePassSignatureList)object, pGPObjectFactory, keyStore, inputStream, outputStream, signatureCheck);
                                        Object var12_17 = null;
                                        if (bufferedInputStream == null) break block20;
                                        try {
                                            ((InputStream)bufferedInputStream).close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    return string4;
                                }
                                string3 = this.parseSignedData((PGPOnePassSignatureList)object, pGPObjectFactory, null, null, outputStream, signatureCheck);
                                Object var12_18 = null;
                                if (bufferedInputStream == null) break block21;
                                try {
                                    ((InputStream)bufferedInputStream).close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return string3;
                        }
                        if (!(object instanceof PGPSignatureList)) break block22;
                        if (!bl) break block23;
                        string2 = this.parseSignedDataVersion3((PGPSignatureList)object, pGPObjectFactory, keyStore, inputStream, outputStream, signatureCheck);
                        Object var12_19 = null;
                        if (bufferedInputStream == null) break block24;
                        try {
                            ((InputStream)bufferedInputStream).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return string2;
                }
                string = this.parseSignedDataVersion3((PGPSignatureList)object, pGPObjectFactory, null, null, outputStream, signatureCheck);
                Object var12_20 = null;
                if (bufferedInputStream == null) break block25;
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return string;
        }
        throw new PGPException("Unknown message format: " + object);
    }

    private String[] parseCompressedDataTo(PGPCompressedData pGPCompressedData, boolean bl, SignatureCheck signatureCheck, KeyStore keyStore, InputStream inputStream, String string, String string2) throws PGPException, IOException {
        Object object;
        block22: {
            String[] stringArray;
            block25: {
                PGPObjectFactory pGPObjectFactory;
                BufferedInputStream bufferedInputStream;
                block23: {
                    String[] stringArray2;
                    block24: {
                        block18: {
                            String[] stringArray3;
                            block21: {
                                block19: {
                                    String[] stringArray4;
                                    block20: {
                                        block16: {
                                            String[] stringArray5;
                                            block17: {
                                                this.Debug("Decrypted data compression algorithm is {0}", KeyStore.compressionToString(pGPCompressedData.getAlgorithm()));
                                                bufferedInputStream = null;
                                                try {
                                                    bufferedInputStream = new BufferedInputStream(pGPCompressedData.getDataStream());
                                                }
                                                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                                                    throw IOUtil.newPGPException(pGPException);
                                                }
                                                try {
                                                    pGPObjectFactory = PGPObjectFactory2.create(bufferedInputStream);
                                                    object = pGPObjectFactory.nextObject();
                                                    if (!(object instanceof PGPLiteralData)) break block16;
                                                    stringArray5 = this.parseLiteralDataTo((PGPLiteralData)object, null, string, string2);
                                                    Object var13_17 = null;
                                                    if (bufferedInputStream == null) break block17;
                                                }
                                                catch (Throwable throwable) {
                                                    block26: {
                                                        Object var13_22 = null;
                                                        if (bufferedInputStream == null) break block26;
                                                        try {
                                                            ((InputStream)bufferedInputStream).close();
                                                        }
                                                        catch (IOException iOException) {}
                                                    }
                                                    throw throwable;
                                                }
                                                try {
                                                    ((InputStream)bufferedInputStream).close();
                                                }
                                                catch (IOException iOException) {
                                                    // empty catch block
                                                }
                                            }
                                            return stringArray5;
                                        }
                                        if (!(object instanceof PGPOnePassSignatureList)) break block18;
                                        if (!bl) break block19;
                                        stringArray4 = this.parseSignedDataTo((PGPOnePassSignatureList)object, pGPObjectFactory, keyStore, inputStream, string, string2, signatureCheck);
                                        Object var13_18 = null;
                                        if (bufferedInputStream == null) break block20;
                                        try {
                                            ((InputStream)bufferedInputStream).close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    return stringArray4;
                                }
                                stringArray3 = this.parseSignedDataTo((PGPOnePassSignatureList)object, pGPObjectFactory, null, null, string, string2, signatureCheck);
                                Object var13_19 = null;
                                if (bufferedInputStream == null) break block21;
                                try {
                                    ((InputStream)bufferedInputStream).close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return stringArray3;
                        }
                        if (!(object instanceof PGPSignatureList)) break block22;
                        if (!bl) break block23;
                        stringArray2 = this.parseSignedDataVersion3To((PGPSignatureList)object, pGPObjectFactory, keyStore, inputStream, string, string2, signatureCheck);
                        Object var13_20 = null;
                        if (bufferedInputStream == null) break block24;
                        try {
                            ((InputStream)bufferedInputStream).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return stringArray2;
                }
                stringArray = this.parseSignedDataVersion3To((PGPSignatureList)object, pGPObjectFactory, null, null, string, string2, signatureCheck);
                Object var13_21 = null;
                if (bufferedInputStream == null) break block25;
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return stringArray;
        }
        throw new PGPException("Unknown message format: " + object);
    }

    private String parseSignedData(PGPOnePassSignatureList pGPOnePassSignatureList, PGPObjectFactory pGPObjectFactory, KeyStore keyStore, InputStream inputStream, OutputStream outputStream, SignatureCheck signatureCheck) throws PGPException, IOException {
        this.Debug("Found signature");
        PGPOnePassSignature pGPOnePassSignature = null;
        PGPPublicKey pGPPublicKey = null;
        if (inputStream != null || keyStore != null) {
            for (int i = 0; i != pGPOnePassSignatureList.size(); ++i) {
                pGPOnePassSignature = pGPOnePassSignatureList.get(i);
                pGPPublicKey = inputStream != null ? this.readPublicVerificationKey(inputStream, pGPOnePassSignature.getKeyID()) : PGPLib.readPublicVerificationKey(keyStore, pGPOnePassSignature.getKeyID());
                if (pGPPublicKey != null) {
                    this.Debug("Message signed with Key Id {0}", KeyPairInformation.keyId2Hex(pGPPublicKey.getKeyID()));
                    break;
                }
                this.Debug("Message signed with Unknown Key Id {0}", KeyPairInformation.keyId2Hex(pGPOnePassSignature.getKeyID()));
            }
            if (pGPPublicKey != null) {
                this.bcFactory.initVerify(pGPOnePassSignature, pGPPublicKey);
            }
        }
        Object object = pGPObjectFactory.nextObject();
        String string = "";
        if (!(object instanceof PGPLiteralData)) {
            throw new PGPException("Unknown message format: " + object);
        }
        string = this.parseLiteralData((PGPLiteralData)object, (PGPOnePassSignature)(pGPPublicKey != null ? pGPOnePassSignature : null), outputStream);
        if (inputStream != null || keyStore != null) {
            if (pGPPublicKey == null) {
                this.Debug("The signature of the message does not correspond to the provided public key.");
                signatureCheck.result = SignatureCheckResult.PublicKeyNotMatching;
            } else {
                Object object2 = pGPObjectFactory.nextObject();
                if (object2 != null && pGPOnePassSignature != null) {
                    PGPSignatureList pGPSignatureList = (PGPSignatureList)object2;
                    try {
                        if (!pGPOnePassSignature.verify(pGPSignatureList.get(0))) {
                            this.Debug("The signature of the message did not passed verification.");
                            signatureCheck.result = SignatureCheckResult.SignatureBroken;
                        } else {
                            signatureCheck.result = SignatureCheckResult.SignatureVerified;
                        }
                    }
                    catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                        throw IOUtil.newPGPException(pGPException);
                    }
                }
            }
        }
        return string;
    }

    private String[] parseSignedDataTo(PGPOnePassSignatureList pGPOnePassSignatureList, PGPObjectFactory pGPObjectFactory, KeyStore keyStore, InputStream inputStream, String string, String string2, SignatureCheck signatureCheck) throws PGPException, IOException {
        this.Debug("Found signature");
        PGPOnePassSignature pGPOnePassSignature = null;
        PGPPublicKey pGPPublicKey = null;
        if (inputStream != null || keyStore != null) {
            for (int i = 0; i != pGPOnePassSignatureList.size(); ++i) {
                pGPOnePassSignature = pGPOnePassSignatureList.get(i);
                pGPPublicKey = inputStream != null ? this.readPublicVerificationKey(inputStream, pGPOnePassSignature.getKeyID()) : PGPLib.readPublicVerificationKey(keyStore, pGPOnePassSignature.getKeyID());
                if (pGPPublicKey != null) {
                    this.Debug("The message is signed with Key Id {0}", KeyPairInformation.keyId2Hex(pGPPublicKey.getKeyID()));
                    break;
                }
                this.Debug("The message is signed with Unknown Key Id {0}", KeyPairInformation.keyId2Hex(pGPOnePassSignature.getKeyID()));
            }
            if (pGPPublicKey != null) {
                this.bcFactory.initVerify(pGPOnePassSignature, pGPPublicKey);
            }
        }
        Object object = pGPObjectFactory.nextObject();
        String[] stringArray = new String[]{};
        if (!(object instanceof PGPLiteralData)) {
            throw new PGPException("Unknown message format: " + object);
        }
        stringArray = this.parseLiteralDataTo((PGPLiteralData)object, (PGPOnePassSignature)(pGPPublicKey != null ? pGPOnePassSignature : null), string, string2);
        if (inputStream != null || keyStore != null) {
            if (pGPPublicKey == null) {
                this.Debug("The signature of the message does not correspond to the provided public key.");
                signatureCheck.result = SignatureCheckResult.PublicKeyNotMatching;
            } else {
                Object object2 = pGPObjectFactory.nextObject();
                if (object2 != null && pGPOnePassSignature != null) {
                    PGPSignatureList pGPSignatureList = (PGPSignatureList)object2;
                    try {
                        if (!pGPOnePassSignature.verify(pGPSignatureList.get(0))) {
                            this.Debug("The signature of the message did not passed verification.");
                            signatureCheck.result = SignatureCheckResult.SignatureBroken;
                        } else {
                            this.Debug("The signature of the message passed verification.");
                            signatureCheck.result = SignatureCheckResult.SignatureVerified;
                        }
                    }
                    catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                        throw IOUtil.newPGPException(pGPException);
                    }
                }
            }
        }
        return stringArray;
    }

    private String parseSignedDataVersion3(PGPSignatureList pGPSignatureList, PGPObjectFactory pGPObjectFactory, KeyStore keyStore, InputStream inputStream, OutputStream outputStream, SignatureCheck signatureCheck) throws PGPException, IOException {
        this.Debug("Found signature version 3");
        PGPSignature pGPSignature = null;
        PGPPublicKey pGPPublicKey = null;
        if (inputStream != null || keyStore != null) {
            for (int i = 0; i < pGPSignatureList.size(); ++i) {
                pGPSignature = pGPSignatureList.get(i);
                if (pGPSignature.getSignatureType() != 0 && pGPSignature.getSignatureType() != 1 && pGPSignature.getSignatureType() != 16) continue;
                pGPPublicKey = inputStream != null ? this.readPublicVerificationKey(inputStream, pGPSignature.getKeyID()) : PGPLib.readPublicVerificationKey(keyStore, pGPSignature.getKeyID());
                if (pGPPublicKey != null) {
                    this.Debug("The message is signed with Key Id {0}", KeyPairInformation.keyId2Hex(pGPPublicKey.getKeyID()));
                    break;
                }
                this.Debug("The message is signed with Unknown Key Id {0}", KeyPairInformation.keyId2Hex(pGPSignature.getKeyID()));
            }
            if (pGPPublicKey != null) {
                this.bcFactory.initVerify(pGPSignature, pGPPublicKey);
            }
        }
        Object object = pGPObjectFactory.nextObject();
        String string = "";
        if (!(object instanceof PGPLiteralData)) {
            if (object == null) {
                throw new DetachedSignatureException("This is a detached signature file");
            }
            throw new PGPException("Unknown message format: " + object);
        }
        string = this.parseLiteralDataVersion3((PGPLiteralData)object, (PGPSignature)(pGPPublicKey != null ? pGPSignature : null), outputStream);
        if (inputStream != null || keyStore != null) {
            if (pGPPublicKey == null) {
                this.Debug("The signature of the message does not correspond to the provided public key.");
                signatureCheck.result = SignatureCheckResult.PublicKeyNotMatching;
            } else {
                try {
                    if (!pGPSignature.verify()) {
                        this.Debug("The signature of the message did not passed verification.");
                        signatureCheck.result = SignatureCheckResult.SignatureBroken;
                    } else {
                        signatureCheck.result = SignatureCheckResult.SignatureVerified;
                    }
                }
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    throw IOUtil.newPGPException(pGPException);
                }
            }
        }
        return string;
    }

    private String[] parseSignedDataVersion3To(PGPSignatureList pGPSignatureList, PGPObjectFactory pGPObjectFactory, KeyStore keyStore, InputStream inputStream, String string, String string2, SignatureCheck signatureCheck) throws PGPException, IOException {
        PGPSignature pGPSignature = null;
        PGPPublicKey pGPPublicKey = null;
        if (inputStream != null || keyStore != null) {
            for (int i = 0; i < pGPSignatureList.size(); ++i) {
                pGPSignature = pGPSignatureList.get(i);
                if (pGPSignature.getSignatureType() != 0 && pGPSignature.getSignatureType() != 1 && pGPSignature.getSignatureType() != 16) continue;
                pGPPublicKey = inputStream != null ? this.readPublicVerificationKey(inputStream, pGPSignature.getKeyID()) : PGPLib.readPublicVerificationKey(keyStore, pGPSignature.getKeyID());
                if (pGPPublicKey != null) {
                    this.Debug("Message signed with Key Id {0}", KeyPairInformation.keyId2Hex(pGPPublicKey.getKeyID()));
                    break;
                }
                this.Debug("Message signed with Unknown Key Id {0}", KeyPairInformation.keyId2Hex(pGPSignature.getKeyID()));
            }
            if (pGPPublicKey != null) {
                this.bcFactory.initVerify(pGPSignature, pGPPublicKey);
            }
        }
        Object object = pGPObjectFactory.nextObject();
        String[] stringArray = new String[]{};
        if (!(object instanceof PGPLiteralData)) {
            if (object == null) {
                throw new DetachedSignatureException("This is a detached signature file");
            }
            throw new PGPException("Unknown message format: " + object);
        }
        stringArray = this.parseLiteralDataVersion3To((PGPLiteralData)object, (PGPSignature)(pGPPublicKey != null ? pGPSignature : null), string, string2);
        if (inputStream != null || keyStore != null) {
            if (pGPPublicKey == null) {
                this.Debug("The signature of the message does not correspond to the provided public key.");
                signatureCheck.result = SignatureCheckResult.PublicKeyNotMatching;
            }
            try {
                if (!pGPSignature.verify()) {
                    this.Debug("The signature of the message did not passed verification.");
                    signatureCheck.result = SignatureCheckResult.SignatureBroken;
                } else {
                    this.Debug("The signature of the message passed verification.");
                    signatureCheck.result = SignatureCheckResult.SignatureVerified;
                }
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
        }
        return stringArray;
    }

    private String parseEncryptedDataPBE(PGPEncryptedDataList pGPEncryptedDataList, boolean bl, SignatureCheck signatureCheck, String string, KeyStore keyStore, InputStream inputStream, OutputStream outputStream) throws IOException, WrongPasswordException, PGPException {
        Object object;
        Object object2;
        WrongPasswordException wrongPasswordException = null;
        InputStream inputStream2 = null;
        PGPPBEEncryptedData pGPPBEEncryptedData = null;
        if (pGPEncryptedDataList instanceof PGP2xPBEEncryptedData) {
            try {
                this.Debug("Password encrypted data packet found");
                inputStream2 = ((PGP2xPBEEncryptedData)pGPEncryptedDataList).getDataStream(string.toCharArray());
            }
            catch (PGPDataValidationException pGPDataValidationException) {
                throw new WrongPasswordException("The supplied password is incorrect.", pGPDataValidationException.getUnderlyingException());
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
        } else {
            object2 = pGPEncryptedDataList.getEncryptedDataObjects();
            while (inputStream2 == null && object2.hasNext()) {
                object = object2.next();
                if (!(object instanceof PGPPBEEncryptedData)) continue;
                this.Debug("Password encrypted data packet found");
                pGPPBEEncryptedData = (PGPPBEEncryptedData)object;
                try {
                    inputStream2 = pGPPBEEncryptedData.getDataStream(this.bcFactory.CreatePBEDataDecryptorFactory(string));
                    break;
                }
                catch (PGPDataValidationException pGPDataValidationException) {
                    wrongPasswordException = new WrongPasswordException("The supplied password is incorrect.", pGPDataValidationException.getUnderlyingException());
                }
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    throw IOUtil.newPGPException(pGPException);
                }
            }
        }
        if (inputStream2 == null && wrongPasswordException != null) {
            throw wrongPasswordException;
        }
        if (inputStream2 == null) {
            throw new FileIsEncryptedException("The file is encrypted with an OpenPGP key.");
        }
        object2 = "";
        object = PGPObjectFactory2.create(inputStream2);
        Object object3 = object.nextObject();
        if (object3 instanceof PGPCompressedData) {
            object2 = this.parseCompressedData((PGPCompressedData)object3, bl, signatureCheck, keyStore, inputStream, outputStream);
        } else if (object3 instanceof PGPOnePassSignatureList) {
            object2 = bl ? this.parseSignedData((PGPOnePassSignatureList)object3, (PGPObjectFactory)object, keyStore, inputStream, outputStream, signatureCheck) : this.parseSignedData((PGPOnePassSignatureList)object3, (PGPObjectFactory)object, null, null, outputStream, signatureCheck);
        } else if (object3 instanceof PGPSignatureList) {
            object2 = bl ? this.parseSignedDataVersion3((PGPSignatureList)object3, (PGPObjectFactory)object, keyStore, inputStream, outputStream, signatureCheck) : this.parseSignedDataVersion3((PGPSignatureList)object3, (PGPObjectFactory)object, null, null, outputStream, signatureCheck);
        } else if (object3 instanceof PGPLiteralData) {
            object2 = this.parseLiteralData((PGPLiteralData)object3, null, outputStream);
        } else {
            throw new PGPException("Unknown message format: " + object3);
        }
        if (pGPPBEEncryptedData != null && pGPPBEEncryptedData.isIntegrityProtected()) {
            try {
                if (!pGPPBEEncryptedData.verify()) {
                    this.Debug("Integrity check failed!");
                    throw new IntegrityCheckException("The encrypted data is corrupted!");
                }
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                // empty catch block
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseEncryptedData(PGPEncryptedDataList pGPEncryptedDataList, boolean bl, SignatureCheck signatureCheck, KeyStore keyStore, InputStream inputStream, String string, InputStream inputStream2, OutputStream outputStream) throws IOException, PGPException, WrongPrivateKeyException, WrongPasswordException, FileIsPBEEncryptedException, IntegrityCheckException, DetachedSignatureException {
        Object object;
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection = null;
        pGPSecretKeyRingCollection = inputStream != null ? this.createPGPSecretKeyRingCollection(inputStream) : keyStore.secCollection;
        WrongPasswordException wrongPasswordException = null;
        PGPPrivateKey pGPPrivateKey = null;
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = null;
        String[] stringArray = new String[pGPEncryptedDataList.size()];
        this.fill(stringArray, "Password encrypted");
        for (int i = 0; i < pGPEncryptedDataList.size(); ++i) {
            object = pGPEncryptedDataList.get(i);
            if (!(object instanceof PGPPublicKeyEncryptedData)) continue;
            pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)object;
            stringArray[i] = KeyPairInformation.keyId2Hex(pGPPublicKeyEncryptedData.getKeyID());
            this.Debug("Public key encrypted data packet found");
            this.Debug("Encrypted with key {0}", "0".equals(stringArray[i]) ? "wildcard" : stringArray[i]);
            try {
                pGPPrivateKey = this.getPrivateKey(pGPSecretKeyRingCollection, pGPPublicKeyEncryptedData.getKeyID(), string);
                if (pGPPrivateKey != null && keyStore != null) {
                    keyStore.triggetPrivateKeyNotFound(pGPPublicKeyEncryptedData.getKeyID());
                    pGPPrivateKey = this.getPrivateKey(pGPSecretKeyRingCollection, pGPPublicKeyEncryptedData.getKeyID(), string);
                }
            }
            catch (WrongPasswordException wrongPasswordException2) {
                pGPPrivateKey = null;
                wrongPasswordException = wrongPasswordException2;
            }
            if (pGPPrivateKey != null) break;
        }
        if (pGPPrivateKey == null && wrongPasswordException != null) {
            throw wrongPasswordException;
        }
        if (pGPPublicKeyEncryptedData == null) {
            this.Debug("This file is encrypted with a password.");
            throw new FileIsPBEEncryptedException("This file is encrypted with a password.");
        }
        if (pGPPrivateKey == null) {
            if (inputStream == null) throw new WrongPrivateKeyException("Decryption of data encrypted using KEY-ID(s) : " + this.join(stringArray, ",") + " failed, no matching key was found in the KeyStore.");
            if (pGPSecretKeyRingCollection != null && pGPSecretKeyRingCollection.size() == 0) {
                throw new WrongPrivateKeyException("Decryption of data encrypted using KEY-ID(s) : " + this.join(stringArray, ",") + " failed, The provided key is not a valid OpenPGP private key.");
            }
            String string2 = "";
            object = pGPSecretKeyRingCollection.getKeyRings();
            if (!object.hasNext()) throw new WrongPrivateKeyException("Decryption of data encrypted using KEY-ID(s) : " + this.join(stringArray, ",") + " failed, using incorrect private KEY-ID :" + string2);
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)object.next();
            string2 = KeyPairInformation.keyId2Hex(pGPSecretKeyRing.getSecretKey().getKeyID());
            throw new WrongPrivateKeyException("Decryption of data encrypted using KEY-ID(s) : " + this.join(stringArray, ",") + " failed, using incorrect private KEY-ID :" + string2);
        }
        InputStream inputStream3 = null;
        try {
            inputStream3 = pGPPublicKeyEncryptedData.getDataStream(this.bcFactory.CreatePublicKeyDataDecryptorFactory(pGPPrivateKey));
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        stringArray = null;
        object = "";
        try {
            PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream3);
            Object object2 = pGPObjectFactory.nextObject();
            if (object2 instanceof PGPCompressedData) {
                object = this.parseCompressedData((PGPCompressedData)object2, bl, signatureCheck, keyStore, inputStream2, outputStream);
            } else if (object2 instanceof PGPOnePassSignatureList) {
                this.Debug("Signature found!");
                object = bl ? this.parseSignedData((PGPOnePassSignatureList)object2, pGPObjectFactory, keyStore, inputStream2, outputStream, signatureCheck) : this.parseSignedData((PGPOnePassSignatureList)object2, pGPObjectFactory, null, null, outputStream, signatureCheck);
            } else if (object2 instanceof PGPSignatureList) {
                this.Debug("Signature found (version 3, old style)");
                object = bl ? this.parseSignedDataVersion3((PGPSignatureList)object2, pGPObjectFactory, keyStore, inputStream2, outputStream, signatureCheck) : this.parseSignedDataVersion3((PGPSignatureList)object2, pGPObjectFactory, null, null, outputStream, signatureCheck);
            } else {
                if (!(object2 instanceof PGPLiteralData)) throw new NonPGPDataException("Unknown message format: " + object2);
                object = this.parseLiteralData((PGPLiteralData)object2, null, outputStream);
            }
            if (pGPPublicKeyEncryptedData.isIntegrityProtected()) {
                try {
                    if (!pGPPublicKeyEncryptedData.verify()) {
                        this.Debug("Integrity check failed!");
                        throw new IntegrityCheckException("The encrypted data is corrupted!");
                    }
                }
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                }
            }
            Object var20_24 = null;
            if (inputStream3 == null) return object;
        }
        catch (Throwable throwable) {
            Object var20_25 = null;
            if (inputStream3 == null) throw throwable;
            try {
                inputStream3.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream3.close();
            return object;
        }
        catch (IOException iOException) {}
        return object;
    }

    private String[] parseEncryptedDataTo(PGPEncryptedDataList pGPEncryptedDataList, boolean bl, SignatureCheck signatureCheck, KeyStore keyStore, InputStream inputStream, String string, InputStream inputStream2, String string2, String string3) throws IOException, WrongPasswordException, WrongPrivateKeyException, PGPException {
        Object object;
        PGPPrivateKey pGPPrivateKey = null;
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection = null;
        pGPSecretKeyRingCollection = inputStream != null ? this.createPGPSecretKeyRingCollection(inputStream) : keyStore.secCollection;
        WrongPasswordException wrongPasswordException = null;
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = null;
        String[] stringArray = new String[pGPEncryptedDataList.size()];
        this.fill(stringArray, "Password encrypted");
        for (int i = 0; i < pGPEncryptedDataList.size(); ++i) {
            object = pGPEncryptedDataList.get(i);
            if (!(object instanceof PGPPublicKeyEncryptedData)) continue;
            pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)object;
            stringArray[i] = KeyPairInformation.keyId2Hex(pGPPublicKeyEncryptedData.getKeyID());
            this.Debug("Encrypted with key ID {0}", "0".equals(stringArray[i]) ? "wildcard" : stringArray[i]);
            try {
                pGPPrivateKey = this.getPrivateKey(pGPSecretKeyRingCollection, pGPPublicKeyEncryptedData.getKeyID(), string);
                if (pGPPrivateKey != null && keyStore != null) {
                    keyStore.triggetPrivateKeyNotFound(pGPPublicKeyEncryptedData.getKeyID());
                    pGPPrivateKey = this.getPrivateKey(pGPSecretKeyRingCollection, pGPPublicKeyEncryptedData.getKeyID(), string);
                }
            }
            catch (WrongPasswordException wrongPasswordException2) {
                pGPPrivateKey = null;
                wrongPasswordException = wrongPasswordException2;
            }
            if (pGPPrivateKey != null) break;
        }
        if (pGPPrivateKey == null && wrongPasswordException != null) {
            throw wrongPasswordException;
        }
        if (pGPPublicKeyEncryptedData == null) {
            this.Debug("This file is encrypted with a password.");
            throw new FileIsPBEEncryptedException("This file is encrypted with a password.");
        }
        if (pGPPrivateKey == null) {
            if (inputStream != null) {
                if (pGPSecretKeyRingCollection != null && pGPSecretKeyRingCollection.size() == 0) {
                    throw new WrongPrivateKeyException("Decryption of data encrypted using KEY-ID(s) : " + this.join(stringArray, ",") + " failed, The provided key is not a valid OpenPGP private key.");
                }
                String string4 = "";
                object = pGPSecretKeyRingCollection.getKeyRings();
                if (object.hasNext()) {
                    PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)object.next();
                    string4 = KeyPairInformation.keyId2Hex(pGPSecretKeyRing.getSecretKey().getKeyID());
                }
                throw new WrongPrivateKeyException("Decryption of data encrypted using KEY-ID(s) : " + this.join(stringArray, ",") + " failed, using incorrect private KEY-ID :" + string4);
            }
            throw new WrongPrivateKeyException("Decryption of data encrypted using KEY-ID(s) : " + this.join(stringArray, ",") + " failed, no matching key was found in the KeyStore.");
        }
        InputStream inputStream3 = null;
        try {
            inputStream3 = pGPPublicKeyEncryptedData.getDataStream(this.bcFactory.CreatePublicKeyDataDecryptorFactory(pGPPrivateKey));
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        object = new String[]{};
        PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create(inputStream3);
        Object object2 = pGPObjectFactory.nextObject();
        if (object2 instanceof PGPCompressedData) {
            object = this.parseCompressedDataTo((PGPCompressedData)object2, bl, signatureCheck, keyStore, inputStream2, string2, string3);
        } else if (object2 instanceof PGPOnePassSignatureList) {
            object = bl ? this.parseSignedDataTo((PGPOnePassSignatureList)object2, pGPObjectFactory, keyStore, inputStream2, string2, string3, signatureCheck) : this.parseSignedDataTo((PGPOnePassSignatureList)object2, pGPObjectFactory, null, null, string2, string3, signatureCheck);
        } else if (object2 instanceof PGPSignatureList) {
            object = bl ? this.parseSignedDataVersion3To((PGPSignatureList)object2, pGPObjectFactory, keyStore, inputStream2, string2, string3, signatureCheck) : this.parseSignedDataVersion3To((PGPSignatureList)object2, pGPObjectFactory, null, null, string2, string3, signatureCheck);
        } else if (object2 instanceof PGPLiteralData) {
            object = this.parseLiteralDataTo((PGPLiteralData)object2, null, string2, string3);
        } else {
            throw new PGPException("Unknown message format: " + object2);
        }
        if (pGPPublicKeyEncryptedData.isIntegrityProtected()) {
            try {
                if (!pGPPublicKeyEncryptedData.verify()) {
                    this.Debug("Integrity check failed!");
                    throw new IntegrityCheckException("The encrypted data is corrupted!");
                }
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                // empty catch block
            }
        }
        return object;
    }

    private String getKeyUserId(PGPPublicKey pGPPublicKey) {
        Iterator iterator = pGPPublicKey.getRawUserIDs();
        if (iterator.hasNext()) {
            return BaseLib.toUserID((byte[])iterator.next());
        }
        return "";
    }

    private PGPPublicKey readPublicKeyForEncryption(InputStream inputStream) throws IOException, NoPublicKeyFoundException, PGPException {
        PGPPublicKeyRingCollection pGPPublicKeyRingCollection = this.createPGPPublicKeyRingCollection(inputStream);
        PGPException pGPException = null;
        PGPPublicKey pGPPublicKey = null;
        Iterator iterator = pGPPublicKeyRingCollection.getKeyRings();
        while (pGPPublicKey == null && iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)iterator.next();
            try {
                pGPPublicKey = this.readPublicKeyForEncryption(pGPPublicKeyRing);
            }
            catch (PGPException pGPException2) {
                pGPException = pGPException2;
            }
            if (pGPPublicKey == null) continue;
            break;
        }
        if (pGPPublicKey == null) {
            if (pGPException != null) {
                throw pGPException;
            }
            throw new NoPublicKeyFoundException("Can't find encryption key in key ring.");
        }
        return pGPPublicKey;
    }

    private PGPPublicKey readPublicKeyForEncryption(PGPPublicKeyRing pGPPublicKeyRing) throws IOException, NoPublicKeyFoundException, PGPException {
        PGPPublicKey pGPPublicKey;
        PGPPublicKey pGPPublicKey2 = null;
        PGPException pGPException = null;
        LinkedList<Integer> linkedList = new LinkedList();
        List<Integer> list = new LinkedList<Integer>();
        List<Integer> list2 = new LinkedList<Integer>();
        Iterator iterator = pGPPublicKeyRing.getPublicKeys();
        while (iterator.hasNext()) {
            pGPPublicKey = (PGPPublicKey)iterator.next();
            if (pGPPublicKey.isMasterKey()) {
                linkedList = this.listPreferredCompressions(pGPPublicKey);
                list = this.listPreferredCyphers(pGPPublicKey);
                list2 = this.preferredHashes(pGPPublicKey);
            }
            if (!pGPPublicKey.isEncryptionKey()) continue;
            if (pGPPublicKey.isRevoked() && !this.useRevokedKeys) {
                this.Debug("The key {0} is revoked", KeyPairInformation.keyIdToHex(pGPPublicKey.getKeyID()));
                pGPException = new KeyIsRevokedException("The key with Key Id:" + KeyPairInformation.keyIdToHex(pGPPublicKey.getKeyID()) + " [" + this.getKeyUserId(pGPPublicKey) + "] is revoked. See PGPLib.setUseRevokedKeys for more information.");
                continue;
            }
            if (this.isKeyExpired(pGPPublicKey) && !this.useExpiredKeys) {
                this.Debug("The key {0} is expired", KeyPairInformation.keyIdToHex(pGPPublicKey.getKeyID()));
                pGPException = new KeyIsExpiredException("The key with Key Id:" + KeyPairInformation.keyIdToHex(pGPPublicKey.getKeyID()) + " [" + this.getKeyUserId(pGPPublicKey) + "] has expired. See PGPLib.setUseExpiredKeys for more information.");
                continue;
            }
            Iterator iterator2 = pGPPublicKey.getSignatures();
            while (iterator2.hasNext()) {
                PGPSignature pGPSignature = (PGPSignature)iterator2.next();
                if (pGPSignature.getKeyID() != pGPPublicKeyRing.getPublicKey().getKeyID() || pGPSignature.getHashedSubPackets() == null || !pGPSignature.getHashedSubPackets().hasSubpacket(27) || (pGPSignature.getHashedSubPackets().getKeyFlags() & 4) != 4 && (pGPSignature.getHashedSubPackets().getKeyFlags() & 8) != 8) continue;
                pGPPublicKey2 = pGPPublicKey;
                break;
            }
            if (pGPPublicKey2 != null && pGPPublicKey.getBitStrength() <= pGPPublicKey2.getBitStrength() && (!pGPPublicKey2.isMasterKey() || pGPPublicKey.getBitStrength() != pGPPublicKey2.getBitStrength())) continue;
            pGPPublicKey2 = pGPPublicKey;
        }
        if (pGPPublicKey2 == null) {
            if (pGPException != null) {
                throw pGPException;
            }
            throw new NoPublicKeyFoundException("Can't find encryption key in key ring.");
        }
        try {
            pGPPublicKey = new PGPPublicKeyExt(pGPPublicKey2.getPublicKeyPacket());
            pGPPublicKey.setPreferredCyphers(list);
            pGPPublicKey.setPreferredCompressions(linkedList);
            pGPPublicKey.setPreferredHashes(list2);
            return pGPPublicKey;
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException2) {
            throw IOUtil.newPGPException(pGPException2);
        }
    }

    private boolean isKeyExpired(PGPPublicKey pGPPublicKey) throws KeyIsExpiredException {
        if (pGPPublicKey == null) {
            return false;
        }
        if (this.useExpiredKeys) {
            return false;
        }
        if (pGPPublicKey.getValidSeconds() <= 0L) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(pGPPublicKey.getCreationTime());
        calendar.add(5, pGPPublicKey.getValidDays());
        return calendar.getTime().before(new Date());
    }

    private void checkKeyIsExpired(PGPPublicKey pGPPublicKey) throws KeyIsExpiredException {
        if (this.isKeyExpired(pGPPublicKey)) {
            String string = "";
            Iterator iterator = pGPPublicKey.getRawUserIDs();
            if (iterator.hasNext()) {
                string = BaseLib.toUserID((byte[])iterator.next());
            }
            this.Debug("The key {0} is expired", KeyPairInformation.keyId2Hex(pGPPublicKey.getKeyID()));
            throw new KeyIsExpiredException("The key with Id:" + KeyPairInformation.keyId2Hex(pGPPublicKey.getKeyID()) + " [" + string + "] has expired. See PGPLib.setUseExpiredKeys for more information.");
        }
    }

    private boolean isKeyRevoked(PGPPublicKey pGPPublicKey) throws KeyIsRevokedException {
        if (pGPPublicKey == null) {
            return false;
        }
        if (this.useRevokedKeys) {
            return false;
        }
        return pGPPublicKey.hasRevocation();
    }

    private void checkKeyIsRevoked(PGPPublicKey pGPPublicKey) throws KeyIsRevokedException {
        if (this.isKeyRevoked(pGPPublicKey)) {
            String string = "";
            Iterator iterator = pGPPublicKey.getRawUserIDs();
            if (iterator.hasNext()) {
                string = BaseLib.toUserID((byte[])iterator.next());
            }
            this.Debug("The key {0} is revoked", KeyPairInformation.keyId2Hex(pGPPublicKey.getKeyID()));
            throw new KeyIsRevokedException("The key with Id:" + pGPPublicKey.getKeyID() + " [" + string + "] is revoked. See PGPLib.setUseRevokedKeys for more information.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileToLiteralData(OutputStream outputStream, char c, InputStream inputStream, String string, long l, Date date) throws IOException {
        IOException iOException3;
        OutputStream outputStream2;
        block14: {
            PGPLiteralDataGenerator pGPLiteralDataGenerator = null;
            outputStream2 = null;
            try {
                int n;
                pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
                outputStream2 = pGPLiteralDataGenerator.open(outputStream, c, string, l, date);
                byte[] byArray = new byte[65536];
                while ((n = inputStream.read(byArray)) > 0) {
                    outputStream2.write(byArray, 0, n);
                }
                Object var13_11 = null;
                if (pGPLiteralDataGenerator == null) break block14;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var13_12 = null;
                if (pGPLiteralDataGenerator != null) {
                    pGPLiteralDataGenerator.close();
                }
                if (outputStream2 != null) {
                    try {
                        outputStream2.flush();
                        outputStream2.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            pGPLiteralDataGenerator.close();
        }
        if (outputStream2 != null) {
            try {
                outputStream2.flush();
                outputStream2.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {}
        }
    }

    private PGPSecretKey readSecretSigningKey(InputStream inputStream) throws NoPrivateKeyFoundException, IOException, PGPException {
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection = this.createPGPSecretKeyRingCollection(inputStream);
        PGPSecretKey pGPSecretKey = null;
        Iterator iterator = pGPSecretKeyRingCollection.getKeyRings();
        while (pGPSecretKey == null && iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            Iterator iterator2 = pGPSecretKeyRing.getSecretKeys();
            while (pGPSecretKey == null && iterator2.hasNext()) {
                PGPSecretKey pGPSecretKey2 = (PGPSecretKey)iterator2.next();
                if (!pGPSecretKey2.isSigningKey() || pGPSecretKey2.isPrivateKeyEmpty()) continue;
                pGPSecretKey = pGPSecretKey2;
            }
        }
        if (pGPSecretKey == null) {
            throw new NoPrivateKeyFoundException("Can't find signing key in key ring.");
        }
        this.checkKeyIsExpired(pGPSecretKey.getPublicKey());
        this.checkKeyIsRevoked(pGPSecretKey.getPublicKey());
        return pGPSecretKey;
    }

    private PGPSecretKey readSecretSigningKey(KeyStore keyStore, long l) throws NoPrivateKeyFoundException, PGPException {
        KeyPairInformation keyPairInformation = keyStore.getKey(l);
        if (keyPairInformation == null || !keyPairInformation.hasPrivateKey()) {
            throw new NoPrivateKeyFoundException("No private key pair was found with Key Id: " + KeyPairInformation.keyId2Hex(l));
        }
        PGPSecretKeyRing pGPSecretKeyRing = keyPairInformation.getRawPrivateKeyRing();
        Iterator iterator = pGPSecretKeyRing.getSecretKeys();
        PGPSecretKey pGPSecretKey = null;
        PGPSecretKey pGPSecretKey2 = null;
        while (pGPSecretKey == null && iterator.hasNext()) {
            PGPSecretKey pGPSecretKey3 = (PGPSecretKey)iterator.next();
            if (!pGPSecretKey3.isSigningKey() || pGPSecretKey3.isPrivateKeyEmpty()) continue;
            pGPSecretKey2 = pGPSecretKey3;
            try {
                PGPPublicKey pGPPublicKey = keyStore.pubCollection.getPublicKey(pGPSecretKey3.getKeyID());
                if (!PGPLib.hasKeyFlags(pGPPublicKey, 2) || this.isKeyExpired(pGPPublicKey) || this.isKeyRevoked(pGPPublicKey)) continue;
                pGPSecretKey = pGPSecretKey3;
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
        }
        if (pGPSecretKey == null && pGPSecretKey2 == null) {
            throw new NoPrivateKeyFoundException("Can't find signing key in key ring.");
        }
        pGPSecretKey = pGPSecretKey2;
        this.checkKeyIsExpired(pGPSecretKey.getPublicKey());
        this.checkKeyIsRevoked(pGPSecretKey.getPublicKey());
        return pGPSecretKey;
    }

    private void internalSignStream(InputStream inputStream, String string, PGPSecretKey pGPSecretKey, String string2, OutputStream outputStream, boolean bl) throws PGPException, WrongPasswordException, IOException {
        Object object;
        if (!(outputStream instanceof BufferedOutputStream)) {
            outputStream = new BufferedOutputStream(outputStream, 65536);
        }
        if (pGPSecretKey.getPublicKey() != null && pGPSecretKey.getPublicKey().getVersion() == 3) {
            this.Debug("Switching to version 3 signatures");
            this.signStreamVersion3(inputStream, string, new ByteArrayInputStream(pGPSecretKey.getEncoded()), string2, outputStream, bl);
        }
        OutputStream outputStream2 = null;
        if (bl) {
            this.Debug("Output is ASCII armored");
            outputStream2 = outputStream;
            outputStream = new ArmoredOutputStream(outputStream2);
            this.setAsciiVersionHeader(outputStream);
        }
        PGPPrivateKey pGPPrivateKey = PGPLib.extractPrivateKey(pGPSecretKey, string2);
        int n = this.selectPreferredHash();
        this.Debug("Signature with hash algorithm {0}", KeyStore.hashToString(n));
        PGPSignatureGenerator pGPSignatureGenerator = this.bcFactory.CreatePGPSignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), n);
        this.bcFactory.initSign(pGPSignatureGenerator, 0, pGPPrivateKey);
        Iterator iterator = pGPSecretKey.getPublicKey().getRawUserIDs();
        if (iterator.hasNext()) {
            PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            object = (byte[])iterator.next();
            this.Debug("Signing for user Id {0}", BaseLib.toUserID(object));
            pGPSignatureSubpacketGenerator.setSignerUserID(false, object);
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
        }
        int n2 = this.selectPreferredCompression(pGPSecretKey.getPublicKey());
        object = new PGPCompressedDataGenerator(n2);
        BCPGOutputStream bCPGOutputStream = null;
        if (n2 == 0) {
            this.Debug("No Compression");
            bCPGOutputStream = new BCPGOutputStream(outputStream);
        } else {
            this.Debug("Compression algorithm is {0}", KeyStore.compressionToString(n2));
            bCPGOutputStream = new BCPGOutputStream(object.open(outputStream));
        }
        try {
            pGPSignatureGenerator.generateOnePassVersion(false).encode((OutputStream)bCPGOutputStream);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            if (bCPGOutputStream != null) {
                try {
                    bCPGOutputStream.flush();
                    bCPGOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw IOUtil.newPGPException(pGPException);
        }
        DirectByteArrayOutputStream directByteArrayOutputStream = new DirectByteArrayOutputStream(65536);
        int n3 = 0;
        byte[] byArray = new byte[65536];
        while ((n3 = inputStream.read(byArray)) > 0) {
            directByteArrayOutputStream.write(byArray, 0, n3);
            pGPSignatureGenerator.update(byArray, 0, n3);
        }
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream3 = pGPLiteralDataGenerator.open((OutputStream)bCPGOutputStream, this.getContentType(), string, (long)directByteArrayOutputStream.size(), new Date());
        outputStream3.write(directByteArrayOutputStream.getArray(), 0, directByteArrayOutputStream.size());
        try {
            pGPSignatureGenerator.generate().encode((OutputStream)bCPGOutputStream);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        outputStream.flush();
        pGPLiteralDataGenerator.close();
        object.close();
        if (outputStream3 != null) {
            try {
                outputStream3.flush();
                outputStream3.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bCPGOutputStream != null) {
            try {
                bCPGOutputStream.flush();
                bCPGOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (directByteArrayOutputStream != null) {
            try {
                directByteArrayOutputStream.flush();
                directByteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        outputStream3 = null;
        bCPGOutputStream = null;
        directByteArrayOutputStream = null;
        if (bl && outputStream != null) {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void internalSignAndEncryptStreamPgp2x(InputStream inputStream, String string, InputStream inputStream2, String string2, InputStream[] inputStreamArray, OutputStream outputStream, Date date, boolean bl) throws PGPException, IOException {
        Object object;
        Object object2;
        int n;
        OutputStream outputStream2 = null;
        if (bl) {
            this.Debug("Output is ASCII armored");
            outputStream2 = outputStream;
            outputStream = new ArmoredOutputStream(outputStream2);
            this.setAsciiVersionHeader(outputStream);
        }
        DirectByteArrayOutputStream directByteArrayOutputStream = new DirectByteArrayOutputStream(65536);
        BaseLib.pipeAll(inputStream, directByteArrayOutputStream);
        boolean bl2 = true;
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = this.bcFactory.CreatePGPEncryptedDataGenerator(1, false, IOUtil.getSecureRandom());
        PGPPublicKey[] pGPPublicKeyArray = new PGPPublicKey[inputStreamArray.length];
        for (n = 0; n < inputStreamArray.length; ++n) {
            pGPPublicKeyArray[n] = this.readPublicKeyForEncryption(inputStreamArray[n]);
            pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator(pGPPublicKeyArray[n]));
            this.Debug("Ecrypting for key Id {0}", String.valueOf(pGPPublicKeyArray[n].getKeyID()));
        }
        for (n = 0; n < this.getMasterKeysCount(); ++n) {
            object2 = (KeyPairInformation)this.masterKeysList.get(n);
            object = this.readPublicKeyForEncryption(((KeyPairInformation)object2).getPublicKeyRing());
            pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)this.bcFactory.CreatePublicKeyKeyEncryptionMethodGenerator((PGPPublicKey)object));
            this.Debug("Encrypting with master key Id {0}", KeyPairInformation.keyId2Hex(object.getKeyID()));
        }
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator(bl2);
        object2 = new DirectByteArrayOutputStream(65536);
        object = pGPLiteralDataGenerator.open((OutputStream)object2, this.contentType, string, (long)directByteArrayOutputStream.size(), new Date());
        directByteArrayOutputStream.writeTo((OutputStream)object);
        DirectByteArrayOutputStream directByteArrayOutputStream2 = new DirectByteArrayOutputStream(65536);
        this.detachedSignStream(new ByteArrayInputStream(directByteArrayOutputStream.getArray(), 0, directByteArrayOutputStream.size()), inputStream2, string2, directByteArrayOutputStream2, false);
        byte[] byArray = directByteArrayOutputStream2.toByteArray();
        directByteArrayOutputStream2 = new DirectByteArrayOutputStream(65536);
        directByteArrayOutputStream2.write((byte)(byArray[0] | 1));
        directByteArrayOutputStream2.write(0);
        directByteArrayOutputStream2.write(byArray[1]);
        directByteArrayOutputStream2.write(byArray, 2, byArray.length - 2);
        try {
            OutputStream outputStream3 = pGPEncryptedDataGenerator.open(outputStream, (long)(directByteArrayOutputStream2.size() + ((ByteArrayOutputStream)object2).size()));
            directByteArrayOutputStream2.writeTo(outputStream3);
            ((ByteArrayOutputStream)object2).writeTo(outputStream3);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw IOUtil.newPGPException(pGPException);
        }
        outputStream.flush();
        if (bl && outputStream != null) {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private InputStream createPublicRingStream(KeyStore keyStore, String string) throws PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = keyStore.findPublicKeyRing(string);
        try {
            return new ByteArrayInputStream(pGPPublicKeyRing.getEncoded());
        }
        catch (IOException iOException) {
            throw new PGPException(iOException.getMessage(), iOException);
        }
    }

    private InputStream createPublicRingStream(KeyStore keyStore, long l) throws IOException, NoPublicKeyFoundException {
        PGPPublicKeyRing pGPPublicKeyRing = keyStore.findPublicKeyRing(l);
        return new ByteArrayInputStream(pGPPublicKeyRing.getEncoded());
    }

    private InputStream createPrivateRingStream(KeyStore keyStore, String string) throws IOException, PGPException {
        PGPSecretKeyRing pGPSecretKeyRing = keyStore.findSecretKeyRing(string);
        return new ByteArrayInputStream(pGPSecretKeyRing.getEncoded());
    }

    private InputStream createPrivateRingStream(KeyStore keyStore, long l) throws IOException, PGPException {
        try {
            PGPSecretKey pGPSecretKey = keyStore.secCollection.getSecretKey(l);
            if (pGPSecretKey != null) {
                return new ByteArrayInputStream(pGPSecretKey.getEncoded());
            }
            throw new NoPrivateKeyFoundException("No private key was found with KeyId : " + l);
        }
        catch (lw.bouncycastle.openpgp.PGPException pGPException) {
            throw new PGPException(pGPException.getMessage());
        }
    }

    private List<Integer> listPreferredCyphers(PGPPublicKey pGPPublicKey) {
        if (pGPPublicKey instanceof PGPPublicKeyExt) {
            return ((PGPPublicKeyExt)pGPPublicKey).getPreferredCyphers();
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Iterator iterator = pGPPublicKey.getSignatures();
        PGPSignature pGPSignature = (PGPSignature)iterator.next();
        if (pGPSignature.getHashedSubPackets() != null && pGPSignature.getHashedSubPackets().getPreferredSymmetricAlgorithms() != null) {
            int[] nArray = pGPSignature.getHashedSubPackets().getPreferredSymmetricAlgorithms();
            for (int i = 0; i < nArray.length; ++i) {
                linkedList.add(nArray[i]);
            }
        }
        return linkedList;
    }

    private List<Integer> listPreferredHashes(PGPPublicKey pGPPublicKey) {
        if (pGPPublicKey instanceof PGPPublicKeyExt) {
            return ((PGPPublicKeyExt)pGPPublicKey).getPreferredHashes();
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Iterator iterator = pGPPublicKey.getSignatures();
        PGPSignature pGPSignature = (PGPSignature)iterator.next();
        if (pGPSignature.getHashedSubPackets() != null && pGPSignature.getHashedSubPackets().getPreferredHashAlgorithms() != null) {
            int[] nArray = pGPSignature.getHashedSubPackets().getPreferredHashAlgorithms();
            for (int i = 0; i < nArray.length; ++i) {
                linkedList.add(nArray[i]);
            }
        }
        return linkedList;
    }

    private int selectPreferredCypher(PGPPublicKey pGPPublicKey) {
        List<Integer> list = this.listPreferredCyphers(pGPPublicKey);
        int n = this.selectPreferredCypher(list);
        if (pGPPublicKey.getAlgorithm() == 18 && n != 8 && n != 9) {
            n = 9;
        }
        return n;
    }

    private int selectPreferredCypher(List<Integer> list) {
        int n = 0;
        if (this.overrideKeyAlgorithmPreferences) {
            for (int i = 0; i < this.cypher.size(); ++i) {
                Integer n2 = this.cypher.get(i);
                if (!list.contains(n2)) continue;
                n = n2;
                break;
            }
            if (n == 0 && this.cypher.size() > 0) {
                return this.cypher.get(0);
            }
        } else {
            for (int i = 0; n == 0 && i < list.size(); ++i) {
                Integer n3 = list.get(i);
                if (!this.cypher.contains(n3)) continue;
                n = n3;
                break;
            }
            if (n == 0 && list.size() > 0) {
                n = list.get(0);
            }
        }
        if (n == 0) {
            if (this.cypher.size() > 0) {
                return this.cypher.get(0);
            }
            n = 9;
        }
        this.Debug("Cypher: {0}", KeyStore.cypherToString(n));
        return n;
    }

    private List<Integer> preferredHashes(PGPPublicKey pGPPublicKey) {
        if (pGPPublicKey instanceof PGPPublicKeyExt) {
            return ((PGPPublicKeyExt)pGPPublicKey).getPreferredHashes();
        }
        Iterator iterator = pGPPublicKey.getSignatures();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        while (iterator.hasNext()) {
            PGPSignature pGPSignature = (PGPSignature)iterator.next();
            if (pGPSignature.getHashedSubPackets() == null || pGPSignature.getHashedSubPackets().getPreferredHashAlgorithms() == null) continue;
            int[] nArray = pGPSignature.getHashedSubPackets().getPreferredHashAlgorithms();
            for (int i = 0; i < nArray.length; ++i) {
                linkedList.add(nArray[i]);
            }
        }
        return linkedList;
    }

    private int selectPreferredHash() {
        if (this.hash.size() > 0) {
            return this.hash.get(0);
        }
        return 8;
    }

    private int selectPreferredHash(PGPPublicKey pGPPublicKey) {
        List<Integer> list = this.listPreferredHashes(pGPPublicKey);
        return this.selectPreferredHash(list);
    }

    private int selectPreferredHash(List<Integer> list) {
        int n = -1;
        if (this.overrideKeyAlgorithmPreferences) {
            for (int i = 0; i < this.hash.size(); ++i) {
                Integer n2 = this.hash.get(i);
                if (!list.contains(n2)) continue;
                n = n2;
                break;
            }
            if (n == -1 && this.hash.size() > 0) {
                return this.hash.get(0);
            }
        } else {
            for (int i = 0; n == -1 && i < list.size(); ++i) {
                Integer n3 = list.get(i);
                if (!this.hash.contains(n3)) continue;
                n = n3;
                break;
            }
            if (n == -1 && list.size() > 0) {
                return list.get(0);
            }
        }
        if (n == -1) {
            n = 8;
        }
        this.Debug("Hash: {0}", KeyStore.hashToString(n));
        return n;
    }

    private List<Integer> intersectList(List<Integer> list, List<Integer> list2) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        if (list != null && list2 != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!list2.contains(list.get(i))) continue;
                linkedList.add(list.get(i));
            }
        }
        return linkedList;
    }

    private int selectPreferredCompression(PGPPublicKey pGPPublicKey) {
        List<Integer> list = this.listPreferredCompressions(pGPPublicKey);
        return this.selectPreferredCompression(list);
    }

    private int selectPreferredCompression(List<Integer> list) {
        int n = -1;
        if (this.overrideKeyAlgorithmPreferences) {
            for (int i = 0; i < this.compression.size(); ++i) {
                Integer n2 = this.compression.get(i);
                if (!list.contains(n2)) continue;
                n = n2;
                break;
            }
            if (n == -1 && this.compression.size() > 0) {
                return this.compression.get(0);
            }
        } else {
            for (int i = 0; n == -1 && i < list.size(); ++i) {
                Integer n3 = list.get(i);
                if (!this.compression.contains(n3)) continue;
                n = n3;
                break;
            }
            if (n == -1 && list.size() > 0) {
                return list.get(0);
            }
        }
        if (n == -1) {
            n = 0;
        }
        this.Debug("Compression: {0}", KeyStore.compressionToString(n));
        return n;
    }

    private List<Integer> listPreferredCompressions(PGPPublicKey pGPPublicKey) {
        if (pGPPublicKey instanceof PGPPublicKeyExt) {
            return ((PGPPublicKeyExt)pGPPublicKey).getPreferredCompressions();
        }
        Iterator iterator = pGPPublicKey.getSignatures();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        while (iterator.hasNext()) {
            PGPSignature pGPSignature = (PGPSignature)iterator.next();
            if (pGPSignature.getHashedSubPackets() == null || pGPSignature.getHashedSubPackets().getPreferredCompressionAlgorithms() == null) continue;
            int[] nArray = pGPSignature.getHashedSubPackets().getPreferredCompressionAlgorithms();
            for (int i = 0; i < nArray.length; ++i) {
                linkedList.add(nArray[i]);
            }
        }
        return linkedList;
    }

    private void writeMarker(BCPGOutputStream bCPGOutputStream) {
        Class<BCPGOutputStream> clazz = BCPGOutputStream.class;
        byte[] byArray = new byte[]{80, 71, 80};
        Method method = null;
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray;
            if (!methodArray[i].getName().endsWith("writePacket") || (classArray = methodArray[i].getParameterTypes()).length != 3) continue;
            method = methodArray[i];
            method.setAccessible(true);
            try {
                method.invoke((Object)bCPGOutputStream, new Integer(10), byArray, new Boolean(true));
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return;
        }
        if (method == null) {
            throw new Error("No such method: writeMarkerPacket");
        }
    }

    private File createTarFile(String[] stringArray) throws PGPException {
        File file = null;
        try {
            file = File.createTempFile("tmpTarBCPG", ".tar");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            TarOutputStream tarOutputStream = new TarOutputStream(fileOutputStream);
            for (int i = 0; i < stringArray.length; ++i) {
                tarOutputStream.writeFileEntry(new TarEntry(new File(stringArray[i]), ""));
            }
            tarOutputStream.close();
        }
        catch (IOException iOException) {
            throw new PGPException(iOException.getMessage(), iOException);
        }
        return file;
    }

    protected void Debug(String string) {
        if (log.isLoggable(this.debugLevel)) {
            log.log(this.debugLevel, string);
        }
    }

    protected void Debug(String string, String string2) {
        if (log.isLoggable(this.debugLevel)) {
            log.log(this.debugLevel, MessageFormat.format(string, string2));
        }
    }

    private void fill(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string;
        }
    }

    private String join(String[] stringArray, String string) {
        int n = stringArray.length;
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(string).append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public boolean isTrialVersion() {
        return false;
    }

    public boolean isPgp2Compatible() {
        return this.pgp2Compatible;
    }

    public void setPgp2Compatible(boolean bl) {
        this.pgp2Compatible = bl;
    }

    public boolean isExtractTarFiles() {
        return this.extractEmbeddedTar;
    }

    public void setExtractTarFiles(boolean bl) {
        this.extractEmbeddedTar = bl;
    }

    public boolean isIntegrityProtectArchives() {
        return this.integrityProtect;
    }

    public void setIntegrityProtectArchives(boolean bl) {
        this.integrityProtect = bl;
    }

    public boolean isOverrideKeyAlgorithmPreferences() {
        return this.overrideKeyAlgorithmPreferences;
    }

    public void setOverrideKeyAlgorithmPreferences(boolean bl) {
        this.overrideKeyAlgorithmPreferences = bl;
    }

    private class SignatureCheck {
        public SignatureCheckResult result = SignatureCheckResult.NoSignatureFound;

        private SignatureCheck() {
        }
    }

    class ClearSignedHelper {
        public boolean verify(ArmoredInputStream armoredInputStream, KeyStore keyStore, InputStream inputStream, OutputStream outputStream) throws PGPException, IOException, SignatureException {
            DirectByteArrayOutputStream directByteArrayOutputStream = new DirectByteArrayOutputStream(65536);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = this.readInputLine(byteArrayOutputStream, (InputStream)armoredInputStream);
            byte[] byArray = this.getLineSeparator();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            directByteArrayOutputStream.write(byArray2, 0, this.getLengthWithoutSeparator(byArray2));
            directByteArrayOutputStream.write(byArray);
            if (n != -1 && armoredInputStream.isClearText()) {
                while (n != -1 && armoredInputStream.isClearText()) {
                    n = this.readInputLine(byteArrayOutputStream, n, (InputStream)armoredInputStream);
                    byArray2 = byteArrayOutputStream.toByteArray();
                    directByteArrayOutputStream.write(byArray2, 0, this.getLengthWithoutSeparator(byArray2));
                    directByteArrayOutputStream.write(byArray);
                }
            }
            directByteArrayOutputStream.close();
            PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create((InputStream)armoredInputStream);
            PGPSignatureList pGPSignatureList = (PGPSignatureList)pGPObjectFactory.nextObject();
            PGPSignature pGPSignature = null;
            PGPPublicKey pGPPublicKey = null;
            for (int i = 0; i != pGPSignatureList.size(); ++i) {
                pGPSignature = pGPSignatureList.get(i);
                pGPPublicKey = inputStream != null ? PGPLib.this.readPublicVerificationKey(inputStream, pGPSignature.getKeyID()) : PGPLib.readPublicVerificationKey(keyStore, pGPSignature.getKeyID());
                if (pGPPublicKey != null) {
                    PGPLib.this.Debug("Signed with key {0}", KeyPairInformation.keyId2Hex(pGPSignature.getKeyID()));
                    break;
                }
                PGPLib.this.Debug("Signed with unknown key {0}", KeyPairInformation.keyId2Hex(pGPSignature.getKeyID()));
            }
            if (pGPPublicKey == null) {
                throw new NoPublicKeyFoundException("No public key could be found for signature.");
            }
            PGPLib.this.bcFactory.initVerify(pGPSignature, pGPPublicKey);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(directByteArrayOutputStream.getArray(), 0, directByteArrayOutputStream.size());
            n = this.readInputLine(byteArrayOutputStream, byteArrayInputStream);
            this.processLine(pGPSignature, byteArrayOutputStream.toByteArray());
            if (n != -1) {
                do {
                    n = this.readInputLine(byteArrayOutputStream, n, byteArrayInputStream);
                    pGPSignature.update((byte)13);
                    pGPSignature.update((byte)10);
                    this.processLine(pGPSignature, byteArrayOutputStream.toByteArray());
                } while (n != -1);
            }
            boolean bl = false;
            try {
                if (pGPSignature.verify()) {
                    bl = true;
                }
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(directByteArrayOutputStream.getArray(), 0, directByteArrayOutputStream.size());
            int n2 = 0;
            byte[] byArray3 = new byte[65536];
            while ((n2 = byteArrayInputStream2.read(byArray3)) > 0) {
                outputStream.write(byArray3, 0, n2);
            }
            directByteArrayOutputStream = null;
            byteArrayInputStream = null;
            byteArrayInputStream2 = null;
            outputStream.flush();
            return bl;
        }

        public SignatureCheckResult verify2(ArmoredInputStream armoredInputStream, KeyStore keyStore, InputStream inputStream, OutputStream outputStream) throws PGPException, IOException {
            SignatureCheckResult signatureCheckResult = SignatureCheckResult.NoSignatureFound;
            DirectByteArrayOutputStream directByteArrayOutputStream = new DirectByteArrayOutputStream(65536);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = this.readInputLine(byteArrayOutputStream, (InputStream)armoredInputStream);
            byte[] byArray = this.getLineSeparator();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            directByteArrayOutputStream.write(byArray2, 0, this.getLengthWithoutSeparator(byArray2));
            directByteArrayOutputStream.write(byArray);
            if (n != -1 && armoredInputStream.isClearText()) {
                while (n != -1 && armoredInputStream.isClearText()) {
                    n = this.readInputLine(byteArrayOutputStream, n, (InputStream)armoredInputStream);
                    byArray2 = byteArrayOutputStream.toByteArray();
                    directByteArrayOutputStream.write(byArray2, 0, this.getLengthWithoutSeparator(byArray2));
                    directByteArrayOutputStream.write(byArray);
                }
            }
            directByteArrayOutputStream.close();
            PGPObjectFactory pGPObjectFactory = PGPObjectFactory2.create((InputStream)armoredInputStream);
            PGPSignatureList pGPSignatureList = (PGPSignatureList)pGPObjectFactory.nextObject();
            PGPSignature pGPSignature = null;
            PGPPublicKey pGPPublicKey = null;
            for (int i = 0; i != pGPSignatureList.size(); ++i) {
                pGPSignature = pGPSignatureList.get(i);
                pGPPublicKey = inputStream != null ? PGPLib.this.readPublicVerificationKey(inputStream, pGPSignature.getKeyID()) : PGPLib.readPublicVerificationKey(keyStore, pGPSignature.getKeyID());
                if (pGPPublicKey != null) {
                    PGPLib.this.Debug("Signed with key {0}", KeyPairInformation.keyId2Hex(pGPSignature.getKeyID()));
                    break;
                }
                PGPLib.this.Debug("Signed with unknown key {0}", KeyPairInformation.keyId2Hex(pGPSignature.getKeyID()));
            }
            if (pGPPublicKey == null) {
                signatureCheckResult = SignatureCheckResult.PublicKeyNotMatching;
            } else {
                PGPLib.this.bcFactory.initVerify(pGPSignature, pGPPublicKey);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(directByteArrayOutputStream.getArray(), 0, directByteArrayOutputStream.size());
                n = this.readInputLine(byteArrayOutputStream, byteArrayInputStream);
                this.processLine(pGPSignature, byteArrayOutputStream.toByteArray());
                if (n != -1) {
                    do {
                        n = this.readInputLine(byteArrayOutputStream, n, byteArrayInputStream);
                        pGPSignature.update((byte)13);
                        pGPSignature.update((byte)10);
                        this.processLine(pGPSignature, byteArrayOutputStream.toByteArray());
                    } while (n != -1);
                }
                try {
                    signatureCheckResult = pGPSignature.verify() ? SignatureCheckResult.SignatureVerified : SignatureCheckResult.SignatureBroken;
                }
                catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                    throw IOUtil.newPGPException(pGPException);
                }
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(directByteArrayOutputStream.getArray(), 0, directByteArrayOutputStream.size());
            int n2 = 0;
            byte[] byArray3 = new byte[65536];
            while ((n2 = byteArrayInputStream.read(byArray3)) > 0) {
                outputStream.write(byArray3, 0, n2);
            }
            directByteArrayOutputStream = null;
            byteArrayInputStream = null;
            outputStream.flush();
            return signatureCheckResult;
        }

        public String sign(String string, PGPSecretKey pGPSecretKey, String string2, int n) throws IOException, lw.bouncycastle.openpgp.PGPException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(65536);
            this.sign(byteArrayInputStream, pGPSecretKey, string2, n, byteArrayOutputStream);
            return new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
        }

        public String signV3(String string, PGPSecretKey pGPSecretKey, String string2, int n) throws IOException, lw.bouncycastle.openpgp.PGPException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(65536);
            this.signV3(byteArrayInputStream, pGPSecretKey, string2, n, byteArrayOutputStream);
            return new String(byteArrayOutputStream.toByteArray());
        }

        public void sign(InputStream inputStream, PGPSecretKey pGPSecretKey, String string, int n, OutputStream outputStream) throws IOException, lw.bouncycastle.openpgp.PGPException, WrongPasswordException {
            Object object;
            PGPLib.this.Debug("Clear text signing with hash {0}", KeyStore.hashToString(n));
            PGPPrivateKey pGPPrivateKey = BaseLib.extractPrivateKey(pGPSecretKey, string);
            PGPSignatureGenerator pGPSignatureGenerator = PGPLib.this.bcFactory.CreatePGPSignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), n);
            PGPLib.this.bcFactory.initSign(pGPSignatureGenerator, 1, pGPPrivateKey);
            PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            Iterator iterator = pGPSecretKey.getPublicKey().getRawUserIDs();
            if (iterator.hasNext()) {
                object = (byte[])iterator.next();
                PGPLib.this.Debug("Signing for User Id {0}", BaseLib.toUserID(object));
                pGPSignatureSubpacketGenerator.setSignerUserID(false, object);
                pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
            }
            object = new ArmoredOutputStream(outputStream);
            PGPLib.this.setAsciiVersionHeader((OutputStream)object);
            object.beginClearText(n);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = this.readInputLine(byteArrayOutputStream, inputStream);
            int n3 = 1;
            this.processLine((OutputStream)object, pGPSignatureGenerator, byteArrayOutputStream.toByteArray());
            if (n2 != -1) {
                do {
                    ++n3;
                    n2 = this.readInputLine(byteArrayOutputStream, n2, inputStream);
                    pGPSignatureGenerator.update((byte)13);
                    pGPSignatureGenerator.update((byte)10);
                    this.processLine((OutputStream)object, pGPSignatureGenerator, byteArrayOutputStream.toByteArray());
                } while (n2 != -1);
            }
            if (n3 >= 1 && !this.isLineEnding(byteArrayOutputStream.toByteArray()[byteArrayOutputStream.toByteArray().length - 1])) {
                object.write(13);
                object.write(10);
            }
            object.endClearText();
            BCPGOutputStream bCPGOutputStream = new BCPGOutputStream((OutputStream)object);
            try {
                pGPSignatureGenerator.generate().encode((OutputStream)bCPGOutputStream);
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
            finally {
                bCPGOutputStream.close();
                object.close();
            }
        }

        public void signV3(InputStream inputStream, PGPSecretKey pGPSecretKey, String string, int n, OutputStream outputStream) throws IOException, lw.bouncycastle.openpgp.PGPException {
            Object object;
            PGPPrivateKey pGPPrivateKey = BaseLib.extractPrivateKey(pGPSecretKey, string);
            PGPV3SignatureGenerator pGPV3SignatureGenerator = PGPLib.this.bcFactory.CreatePGPV3SignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), n);
            PGPLib.this.bcFactory.initSign(pGPV3SignatureGenerator, 1, pGPPrivateKey);
            PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            Iterator iterator = pGPSecretKey.getPublicKey().getRawUserIDs();
            if (iterator.hasNext()) {
                object = (byte[])iterator.next();
                PGPLib.this.Debug("Signing for User Id {0}", BaseLib.toUserID(object));
                pGPSignatureSubpacketGenerator.setSignerUserID(false, object);
            }
            object = new ArmoredOutputStream(outputStream);
            PGPLib.this.setAsciiVersionHeader((OutputStream)object);
            object.beginClearText(n);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = this.readInputLine(byteArrayOutputStream, inputStream);
            this.processLineV3((OutputStream)object, pGPV3SignatureGenerator, byteArrayOutputStream.toByteArray());
            if (n2 != -1) {
                do {
                    n2 = this.readInputLine(byteArrayOutputStream, n2, inputStream);
                    pGPV3SignatureGenerator.update((byte)13);
                    pGPV3SignatureGenerator.update((byte)10);
                    this.processLineV3((OutputStream)object, pGPV3SignatureGenerator, byteArrayOutputStream.toByteArray());
                } while (n2 != -1);
            }
            object.endClearText();
            BCPGOutputStream bCPGOutputStream = new BCPGOutputStream((OutputStream)object);
            try {
                pGPV3SignatureGenerator.generate().encode((OutputStream)bCPGOutputStream);
            }
            catch (lw.bouncycastle.openpgp.PGPException pGPException) {
                throw IOUtil.newPGPException(pGPException);
            }
            finally {
                bCPGOutputStream.close();
                object.close();
            }
        }

        private byte[] getLineSeparator() {
            String string = System.getProperty("line.separator");
            byte[] byArray = new byte[string.length()];
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = (byte)string.charAt(i);
            }
            return byArray;
        }

        private int getLengthWithoutSeparator(byte[] byArray) {
            int n;
            for (n = byArray.length - 1; n >= 0 && this.isLineEnding(byArray[n]); --n) {
            }
            return n + 1;
        }

        private void processLine(OutputStream outputStream, PGPSignatureGenerator pGPSignatureGenerator, byte[] byArray) throws lw.bouncycastle.openpgp.PGPException, IOException {
            int n = this.getLengthWithoutWhiteSpace(byArray);
            if (n > 0) {
                pGPSignatureGenerator.update(byArray, 0, n);
            }
            outputStream.write(byArray, 0, byArray.length);
        }

        private void processLineV3(OutputStream outputStream, PGPV3SignatureGenerator pGPV3SignatureGenerator, byte[] byArray) throws lw.bouncycastle.openpgp.PGPException, IOException {
            int n = this.getLengthWithoutWhiteSpace(byArray);
            if (n > 0) {
                pGPV3SignatureGenerator.update(byArray, 0, n);
            }
            outputStream.write(byArray, 0, byArray.length);
        }

        private void processLine(PGPSignature pGPSignature, byte[] byArray) throws IOException {
            int n = this.getLengthWithoutWhiteSpace(byArray);
            if (n > 0) {
                pGPSignature.update(byArray, 0, n);
            }
        }

        private int getLengthWithoutWhiteSpace(byte[] byArray) {
            int n;
            for (n = byArray.length - 1; n >= 0 && this.isWhiteSpace(byArray[n]); --n) {
            }
            return n + 1;
        }

        private boolean isWhiteSpace(byte by) {
            return by == 13 || by == 10 || by == 9 || by == 32;
        }

        private boolean isLineEnding(byte by) {
            return by == 13 || by == 10;
        }

        private int readInputLine(ByteArrayOutputStream byteArrayOutputStream, InputStream inputStream) throws IOException {
            int n;
            byteArrayOutputStream.reset();
            int n2 = -1;
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
                if (n != 13 && n != 10) continue;
                n2 = this.readPassedEOL(byteArrayOutputStream, n, inputStream);
                break;
            }
            return n2;
        }

        private int readInputLine(ByteArrayOutputStream byteArrayOutputStream, int n, InputStream inputStream) throws IOException {
            byteArrayOutputStream.reset();
            int n2 = n;
            do {
                byteArrayOutputStream.write(n2);
                if (n2 != 13 && n2 != 10) continue;
                n = this.readPassedEOL(byteArrayOutputStream, n2, inputStream);
                break;
            } while ((n2 = inputStream.read()) >= 0);
            if (n2 < 0) {
                n = -1;
            }
            return n;
        }

        private int readPassedEOL(ByteArrayOutputStream byteArrayOutputStream, int n, InputStream inputStream) throws IOException {
            int n2 = inputStream.read();
            if (n == 13 && n2 == 10) {
                byteArrayOutputStream.write(n2);
                n2 = inputStream.read();
            }
            return n2;
        }
    }
}

