/*
 * Decompiled with CFR 0.152.
 */
package com.crushftp.client;

import com.crushftp.client.Common;
import com.crushftp.client.File_U;
import com.crushftp.client.GenericClient;
import com.crushftp.client.VRL;
import com.crushftp.client.Worker;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;

public class FindMatcher
implements FileVisitor<Path>,
BiPredicate<Path, BasicFileAttributes> {
    Properties config = null;
    Vector list = null;
    String path = "";
    long index = 0L;
    int maxItems = 1000;
    String keyword = "";
    String[] keywords = null;
    boolean exact = false;
    boolean all_keywords = false;
    boolean date1 = false;
    String date1_action = "";
    String date1_value = "";
    boolean date2 = false;
    String date2_action = "";
    String date2_value = "";
    boolean size1 = false;
    String size1_action = "";
    String size1_value = "";
    boolean size2 = false;
    String size2_action = "";
    String size2_value = "";
    boolean type1 = false;
    String type1_action = "";
    boolean or_type = false;
    boolean keywords_only = false;
    AtomicInteger counter = new AtomicInteger(0);

    public FindMatcher(String path, Vector list, Properties config) {
        this.config = config;
        this.list = list;
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        this.path = path;
        this.keyword = Common.url_decode(config.getProperty("keyword", "").replace('+', ' ')).trim();
        this.keywords = this.keyword.split(" ");
        this.exact = config.getProperty("exact", "").equalsIgnoreCase("true");
        this.all_keywords = config.getProperty("all_keywords", "false").equalsIgnoreCase("true");
        this.date1 = config.getProperty("date1", "").equalsIgnoreCase("true");
        this.date1_action = Common.url_decode(config.getProperty("date1_action", "").replace('+', ' '));
        this.date1_value = config.getProperty("date1_value", "");
        this.date2 = config.getProperty("date2", "").equalsIgnoreCase("true");
        this.date2_action = Common.url_decode(config.getProperty("date2_action", "").replace('+', ' '));
        this.date2_value = config.getProperty("date2_value", "");
        this.size1 = config.getProperty("size1", "").equalsIgnoreCase("true");
        this.size1_action = Common.url_decode(config.getProperty("size1_action", "").replace('+', ' '));
        this.size1_value = config.getProperty("size1_value", "");
        this.size2 = config.getProperty("size2", "").equalsIgnoreCase("true");
        this.size2_action = Common.url_decode(config.getProperty("size2_action", "").replace('+', ' '));
        this.size2_value = config.getProperty("size2_value", "");
        this.type1 = config.getProperty("type1", "").equalsIgnoreCase("true");
        this.type1_action = Common.url_decode(config.getProperty("type1_action", "").replace('+', ' '));
        this.or_type = config.getProperty("include_type", "or").equalsIgnoreCase("or");
        this.keywords_only = config.getProperty("keywords_only", "false").equals("true");
        this.maxItems = Integer.parseInt(config.getProperty("max_item", "1000"));
    }

    public void walkParallel(int depth) throws IOException {
        Files.walkFileTree(new File_U(this.path).toPath(), EnumSet.noneOf(FileVisitOption.class), depth, this);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        this.test(dir, attrs);
        if (this.list.size() >= this.maxItems) {
            return FileVisitResult.TERMINATE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        this.test(file, attrs);
        if (this.list.size() >= this.maxItems) {
            return FileVisitResult.TERMINATE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public boolean test(final Path p, final BasicFileAttributes attrs) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        boolean ok = false;
                        ok = FindMatcher.this.searchItemMatcher(p, attrs);
                        if (ok) {
                            Properties item = FindMatcher.this.getItem(p);
                            if (FindMatcher.this.list.size() < FindMatcher.this.maxItems) {
                                FindMatcher.this.list.add(item);
                            }
                        }
                    }
                    catch (Exception e) {
                        Common.log("FILE_CLIENT", 1, e);
                        FindMatcher.this.counter.getAndDecrement();
                    }
                }
                finally {
                    FindMatcher.this.counter.getAndDecrement();
                }
            }
        };
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 180000L) {
            if (this.counter.get() < 8) break;
        }
        try {
            Worker.startWorker(r);
            this.counter.getAndIncrement();
        }
        catch (IOException e) {
            Common.log("FILE_CLIENT", 1, e);
        }
        return false;
    }

    private Properties getItem(Path p) {
        Properties item = new Properties();
        try {
            String vfsPath;
            String name = p.getFileName().toString();
            if (name.equals("") && (Common.machine_is_x() || Common.machine_is_unix() || Common.machine_is_linux())) {
                name = "localhost";
            } else if (name.equals("") && Common.machine_is_windows()) {
                name = p.toFile().getPath().substring(0, 2);
            }
            item.put("name", name.replaceAll("\r", "%0A").replaceAll("\n", "%0D"));
            item.put("size", "0");
            item.put("type", "FILE");
            if (p.toFile().isDirectory()) {
                item.put("type", "DIR");
                item.put("permissions", "drwxrwxrwx");
                item.put("size", "1");
                item.put("search_ignore_recursive_list", "true");
            } else {
                item.put("permissions", "-rwxrwxrwx");
                item.put("size", String.valueOf(p.toFile().length()));
            }
            String temp_url = Common.url_decode(p.toUri().toURL().toExternalForm()).replaceAll("\r", "%0A").replaceAll("\n", "%0D");
            if (temp_url.toLowerCase().startsWith("file:/") && !temp_url.toLowerCase().startsWith("file://")) {
                temp_url = Common.replace_str(temp_url, "file:/", "file://");
            }
            item.put("url", temp_url);
            item.put("link", "false");
            item.put("num_items", "1");
            item.put("owner", "user");
            item.put("group", "group");
            item.put("protocol", "file");
            String file_path = p.toFile().getPath();
            String root_dir = file_path.substring(this.config.getProperty("urlPath", "").length());
            if (root_dir.endsWith("/")) {
                root_dir = root_dir.substring(0, root_dir.length() - 1);
            }
            if ((vfsPath = this.config.getProperty("rootPath", "")).equals("/")) {
                vfsPath = "";
            }
            root_dir = Common.all_but_last(root_dir);
            item.put("root_dir", String.valueOf(vfsPath) + root_dir);
            Date itemDate = new Date(p.toFile().lastModified());
            item.put("modified", String.valueOf(itemDate.getTime()));
            SimpleDateFormat mm = new SimpleDateFormat("MM", Locale.US);
            item.put("month", GenericClient.months[Integer.parseInt(mm.format(itemDate))]);
            SimpleDateFormat dd = new SimpleDateFormat("dd", Locale.US);
            item.put("day", dd.format(itemDate));
            SimpleDateFormat hhmm = new SimpleDateFormat("HH:mm", Locale.US);
            String time_or_year = hhmm.format(itemDate);
            SimpleDateFormat yyyy = new SimpleDateFormat("yyyy", Locale.US);
            if (!yyyy.format(itemDate).equals(yyyy.format(new Date())) || System.getProperty("crushftp.ls.year", "false").equals("true")) {
                time_or_year = yyyy.format(itemDate);
            }
            item.put("time_or_year", time_or_year);
            item.put("path", root_dir);
            item.put("owner", "user");
            item.put("group", "group");
            item.put("protocol", "file");
            item.put("search_filter_match", "true");
        }
        catch (Exception e) {
            Common.log("FILE_CLIENT", 1, e);
            return null;
        }
        return item;
    }

    public boolean searchItemMatcher(Path p, BasicFileAttributes u) throws Exception {
        long file_size2;
        long file_size1;
        long modified2;
        long modified1;
        boolean date_ok = true;
        boolean size_ok = true;
        boolean type_ok = true;
        int name_count = 0;
        SimpleDateFormat mmddyyyy = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
        if (this.date1) {
            modified1 = u.lastModifiedTime().toMillis();
            modified2 = mmddyyyy.parse(this.date1_value).getTime();
            if (this.date1_action.equalsIgnoreCase("before") && modified2 <= modified1) {
                date_ok = false;
            } else if (this.date1_action.equalsIgnoreCase("after") && modified2 >= modified1) {
                date_ok = false;
            }
        }
        if (this.date2) {
            modified1 = u.lastModifiedTime().toMillis();
            modified2 = mmddyyyy.parse(this.date2_value).getTime();
            if (this.date2_action.equalsIgnoreCase("before") && modified2 <= modified1) {
                date_ok = false;
            } else if (this.date2_action.equalsIgnoreCase("after") && modified2 >= modified1) {
                date_ok = false;
            }
        }
        if (this.size1) {
            file_size1 = u.size();
            file_size2 = Long.parseLong(this.size1_value) * 1024L;
            if (this.size1_action.equalsIgnoreCase("bigger than") && file_size2 >= file_size1) {
                size_ok = false;
            } else if (this.size1_action.equalsIgnoreCase("smaller than") && file_size2 <= file_size1) {
                size_ok = false;
            }
        }
        if (this.size2) {
            file_size1 = u.size();
            file_size2 = Long.parseLong(this.size2_value) * 1024L;
            if (this.size2_action.equalsIgnoreCase("bigger than") && file_size2 >= file_size1) {
                size_ok = false;
            } else if (this.size2_action.equalsIgnoreCase("smaller than") && file_size2 <= file_size1) {
                size_ok = false;
            }
        }
        if (this.type1) {
            String item_type1;
            String string = item_type1 = u.isDirectory() ? "dir" : "file";
            if (this.type1_action.equalsIgnoreCase("file") && !item_type1.equalsIgnoreCase("file")) {
                type_ok = false;
            } else if (this.type1_action.equalsIgnoreCase("folder") && !item_type1.equalsIgnoreCase("dir")) {
                type_ok = false;
            }
        }
        if (date_ok && size_ok && type_ok && this.keywords.length > 0) {
            String name = p.getFileName().toString();
            String name_upper = name.toUpperCase();
            if (!this.keywords_only) {
                name_count = this.checkItemName(name);
            }
            if (name_count == 0 && (this.config.getProperty("search_keywords_also", "false").equals("true") || this.config.getProperty("search_file_contents_also", "false").equals("true"))) {
                Common.log("FILE_CLIENT", 1, "name still not found, trying more...");
                String indexText = "";
                String temp_url = Common.url_decode(p.toUri().toURL().toExternalForm()).replaceAll("\r", "%0A").replaceAll("\n", "%0D");
                if (this.config.getProperty("search_file_contents_also", "false").equals("true")) {
                    File_U temp_item;
                    VRL vrl;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (temp_url.toLowerCase().startsWith("file:/") && !temp_url.toLowerCase().startsWith("file://")) {
                        temp_url = Common.replace_str(temp_url, "file:/", "file://");
                    }
                    if ((vrl = new VRL(temp_url)).getProtocol().equalsIgnoreCase("FILE") && (temp_item = new File_U(vrl.getPath())).exists() && temp_item.isFile()) {
                        Common.log("FILE_CLIENT", 1, "Getting file contents to search..." + vrl.safe() + ":" + temp_item.length());
                        if (temp_item.length() < 0x500000L) {
                            Common.streamCopier(new FileInputStream(temp_item), baos, false, true, true);
                        } else {
                            Common.log("FILE_CLIENT", 2, "Skipping file contents (too big) to search..." + vrl.safe() + ":" + temp_item.length());
                        }
                    }
                    indexText = new String(baos.toByteArray(), "UTF8");
                } else if (!this.config.getProperty("search_keywords_also", "false").equals("true")) {
                    indexText = "";
                } else {
                    String the_dir = Common.getPreviewPath(this.config.getProperty("previews_path", ""), temp_url, "1", 1);
                    if (the_dir == null) {
                        indexText = "";
                    } else {
                        String index = String.valueOf(this.config.getProperty("previews_path", "")) + the_dir.substring(1);
                        StringBuffer resultData = new StringBuffer();
                        indexText = Common.getKeywordsContent(Common.all_but_last(index));
                    }
                }
                int x = 0;
                while (x < this.keywords.length) {
                    if (name_count > 0 && this.or_type) break;
                    Common.log("FILE_CLIENT", 2, "search item indexText:" + indexText + " vs. " + this.keywords[x]);
                    if (!this.exact && indexText.toUpperCase().indexOf(this.keywords[x].toUpperCase().trim()) >= 0) {
                        ++name_count;
                    }
                    if (this.exact && indexText.toUpperCase().indexOf("\r\n" + this.keywords[x].toUpperCase().trim() + "\r\n") >= 0) {
                        ++name_count;
                    }
                    ++x;
                }
                if (this.exact && this.keywords_only && this.keywords.length > 1 && indexText.toUpperCase().indexOf(this.keyword) >= 0) {
                    name_count = this.keywords.length;
                    Common.log("FILE_CLIENT", 2, "Search:Found full text exact match.");
                }
            }
            if (!this.or_type && name_count < this.keywords.length) {
                Common.log("FILE_CLIENT", 2, "search item or_type:" + this.or_type + " name_count:" + name_count + " versus keyword count:" + this.keywords.length);
                name_count = 0;
            }
        } else {
            ++name_count;
        }
        return name_count > 0 && date_ok && size_ok && type_ok;
    }

    public int checkItemName(String name) {
        int name_count = 0;
        String name_upper = name.toUpperCase();
        int loop = 0;
        int last_loc = 0;
        while (loop < this.keywords.length) {
            if (name_count > 0 && !this.all_keywords && this.or_type) break;
            Common.log("SEARCH", 2, "search item name:" + name + " vs. " + this.keywords[loop]);
            if (!this.exact && !this.all_keywords && name_upper.indexOf(this.keywords[loop].toUpperCase().trim()) >= 0) {
                ++name_count;
            }
            if (this.exact && name_upper.equals(this.keyword.toUpperCase())) {
                ++name_count;
            }
            if (this.all_keywords && name_upper.indexOf(this.keywords[loop].toUpperCase().trim(), last_loc) >= 0) {
                last_loc = name_upper.indexOf(this.keywords[loop].toUpperCase().trim(), last_loc);
                ++name_count;
            }
            ++loop;
        }
        if (this.all_keywords && name_count < this.keywords.length) {
            name_count = 0;
        }
        return name_count;
    }

    public void filter_items() throws Exception {
        SimpleDateFormat mmddyyyy = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
        int x = this.list.size() - 1;
        while (x >= 0) {
            Properties p = (Properties)this.list.get(x);
            if (!p.getProperty("path").startsWith(this.path) && !this.config.getProperty("ignore_path_check", "false").equals("true")) {
                this.list.remove(x);
            } else {
                long file_size2;
                long file_size1;
                long modified2;
                long modified1;
                p.put("search_filter_match", "true");
                String parentPath = this.config.getProperty("rootPath", "");
                if (parentPath.equals("/")) {
                    parentPath = "";
                }
                p.put("root_dir", String.valueOf(parentPath) + p.getProperty("path", this.path));
                boolean date_ok = true;
                boolean size_ok = true;
                boolean type_ok = true;
                int name_count = 0;
                if (this.date1) {
                    modified1 = Long.parseLong(p.getProperty("modified", "0"));
                    modified2 = mmddyyyy.parse(this.date1_value).getTime();
                    if (this.date1_action.equalsIgnoreCase("before") && modified2 <= modified1) {
                        date_ok = false;
                    } else if (this.date1_action.equalsIgnoreCase("after") && modified2 >= modified1) {
                        date_ok = false;
                    }
                }
                if (this.date2) {
                    modified1 = Long.parseLong(p.getProperty("modified", "0"));
                    modified2 = mmddyyyy.parse(this.date2_value).getTime();
                    if (this.date2_action.equalsIgnoreCase("before") && modified2 <= modified1) {
                        date_ok = false;
                    } else if (this.date2_action.equalsIgnoreCase("after") && modified2 >= modified1) {
                        date_ok = false;
                    }
                }
                if (this.size1) {
                    file_size1 = Long.parseLong(p.getProperty("size", ""));
                    file_size2 = Long.parseLong(this.size1_value) * 1024L;
                    if (this.size1_action.equalsIgnoreCase("bigger than") && file_size2 >= file_size1) {
                        size_ok = false;
                    } else if (this.size1_action.equalsIgnoreCase("smaller than") && file_size2 <= file_size1) {
                        size_ok = false;
                    }
                }
                if (this.size2) {
                    file_size1 = Long.parseLong(p.getProperty("size", ""));
                    file_size2 = Long.parseLong(this.size2_value) * 1024L;
                    if (this.size2_action.equalsIgnoreCase("bigger than") && file_size2 >= file_size1) {
                        size_ok = false;
                    } else if (this.size2_action.equalsIgnoreCase("smaller than") && file_size2 <= file_size1) {
                        size_ok = false;
                    }
                }
                if (this.type1) {
                    String item_type1;
                    String string = item_type1 = p.getProperty("type", "FILE").equalsIgnoreCase("DIR") ? "dir" : "file";
                    if (this.type1_action.equalsIgnoreCase("file") && !item_type1.equalsIgnoreCase("file")) {
                        type_ok = false;
                    } else if (this.type1_action.equalsIgnoreCase("folder") && !item_type1.equalsIgnoreCase("dir")) {
                        type_ok = false;
                    }
                }
                if (date_ok && size_ok && type_ok && this.keywords.length > 0) {
                    String name = p.getProperty("name", "");
                    String name_upper = name.toUpperCase();
                    if (!this.keywords_only) {
                        name_count = this.checkItemName(name);
                    }
                    if (!this.or_type && name_count < this.keywords.length) {
                        name_count = 0;
                    }
                } else {
                    ++name_count;
                }
                if (!(name_count > 0 && date_ok && size_ok && type_ok)) {
                    this.list.remove(x);
                }
            }
            --x;
        }
    }
}

