/*
 * Decompiled with CFR 0.152.
 */
package com.crushftp.client;

import com.crushftp.client.Common;
import com.crushftp.client.GenericClient;
import com.crushftp.client.Mailer;
import com.crushftp.client.VRL;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataSource;

public class ClientDataSource
implements DataSource,
Serializable {
    private static final long serialVersionUID = 1L;
    Vector fileMimeTypes = new Vector();
    Properties prefs = new Properties();
    VRL vrl = null;

    public ClientDataSource(VRL vrl, Properties prefs) {
        this.vrl = vrl;
        this.prefs = prefs;
    }

    public String getContentType() {
        return Mailer.getCustomMimetypesFileTypeMap(this.fileMimeTypes).getContentType(this.getName());
    }

    public InputStream getInputStream() throws IOException {
        try {
            GenericClient c = Common.getClientReplication(this.vrl.toString(), "ClientDataSource", new Vector());
            c.setupConfig(this.prefs, null);
            c.login(this.vrl.getUsername(), this.vrl.getPassword(), "ClientDataSource");
            InputStream is = c.download(this.vrl.getPath(), -1L, -1L, true);
            class InputWrapper
            extends InputStream {
                GenericClient c = null;
                InputStream is = null;
                boolean closed = false;

                public InputWrapper(GenericClient c, InputStream in3) {
                    this.is = in3;
                }

                @Override
                public int read() throws IOException {
                    return this.is.read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return this.read(b, 0, b.length);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return this.is.read(b, off, len);
                }

                @Override
                public void close() throws IOException {
                    if (!this.closed) {
                        this.closed = true;
                        try {
                            if (this.is != null) {
                                this.is.close();
                            }
                        }
                        catch (Exception e) {
                            Common.log("SMTP", 1, e);
                        }
                        try {
                            if (this.c != null) {
                                this.c.close();
                            }
                        }
                        catch (Exception e) {
                            Common.log("SMTP", 1, e);
                        }
                    }
                }
            }
            return new InputWrapper(c, is);
        }
        catch (IOException e) {
            Common.log("SMTP", 1, e);
            throw e;
        }
        catch (Exception e) {
            Common.log("SMTP", 1, e);
            return null;
        }
    }

    public String getName() {
        return this.vrl.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public void setFileTypeMap(Vector mimeTypes) {
        this.fileMimeTypes.addAll(mimeTypes);
    }

    public void logout() throws Exception {
    }
}

