/*
 * Decompiled with CFR 0.152.
 */
package com.crushftp.client;

import com.crushftp.client.Base64;
import com.crushftp.client.Common;
import com.crushftp.client.FindMatcher;
import com.crushftp.client.GenericClient;
import com.crushftp.client.URLConnection;
import com.crushftp.client.VRL;
import com.crushftp.client.Worker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class B2Client
extends GenericClient {
    String token = "";
    String downloadUrl = "";
    String account_id = "";
    String api_url = "";
    static Properties resourceIdCache = new Properties();
    static Properties bucketIdCache = new Properties();

    public B2Client(String url, String header, Vector log) {
        super(header, log);
        this.fields = new String[]{"username", "password", "uploaded_by", "uploaded_md5"};
        this.url = url;
    }

    @Override
    public String login2(String username, String password, String clientid) throws Exception {
        JSONObject allowed;
        this.config.put("username", username.trim());
        this.config.put("password", VRL.vrlDecode(password.trim()));
        URLConnection urlc = URLConnection.openConnection(new VRL("https://api.backblazeb2.com/b2api/v2/b2_authorize_account"), this.config);
        urlc.setRequestMethod("GET");
        urlc.setDoInput(true);
        urlc.setDoOutput(true);
        urlc.setUseCaches(false);
        urlc.setRequestProperty("Authorization", "Basic  " + Base64.encodeBytes((String.valueOf(this.config.getProperty("username")) + ":" + this.config.getProperty("password")).getBytes()));
        String result = URLConnection.consumeResponse(urlc.getInputStream());
        if (urlc.getResponseCode() < 200 || urlc.getResponseCode() > 299) {
            this.log(String.valueOf(urlc.getResponseCode()) + result + "\r\n");
            throw new IOException(result);
        }
        JSONObject obj = (JSONObject)JSONValue.parse((String)result);
        this.token = (String)obj.get((Object)"authorizationToken");
        this.account_id = (String)obj.get((Object)"accountId");
        this.api_url = (String)obj.get((Object)"apiUrl");
        this.downloadUrl = (String)obj.get((Object)"downloadUrl");
        if (obj.containsKey((Object)"allowed") && obj.get((Object)"allowed") != null && (allowed = (JSONObject)obj.get((Object)"allowed")).containsKey((Object)"bucketName") && allowed.containsKey((Object)"bucketId")) {
            String bucketName = (String)allowed.get((Object)"bucketName");
            String bucketId = (String)allowed.get((Object)"bucketId");
            if (bucketName != null && bucketId != null && !bucketName.equals("") && !bucketId.equals("")) {
                bucketIdCache.put(String.valueOf(this.config.getProperty("password")) + bucketName, bucketId);
            }
        }
        this.config.put("logged_out", "false");
        return "Success!";
    }

    @Override
    public Vector list(String path, Vector list) throws Exception {
        if (path.equals("/")) {
            return this.listBuckets(list);
        }
        return this.listFiles("b2_list_file_names", path, list, true, 1000);
    }

    public Vector listBuckets(Vector list) throws Exception {
        URLConnection urlc = URLConnection.openConnection(new VRL(String.valueOf(this.api_url) + "/b2api/v2/b2_list_buckets"), this.config);
        urlc.setRequestMethod("POST");
        urlc.setDoInput(true);
        urlc.setDoOutput(true);
        urlc.setUseCaches(false);
        urlc.setRequestProperty("Authorization", this.token);
        JSONObject postData = new JSONObject();
        postData.put((Object)"accountId", (Object)this.config.getProperty("username"));
        JSONArray bucketTypes = new JSONArray();
        bucketTypes.add((Object)"allPrivate");
        bucketTypes.add((Object)"allPublic");
        postData.put((Object)"bucketTypes", (Object)bucketTypes);
        OutputStream out = urlc.getOutputStream();
        out.write(postData.toString().getBytes("UTF8"));
        out.close();
        int code = urlc.getResponseCode();
        String result = URLConnection.consumeResponse(urlc.getInputStream());
        urlc.disconnect();
        if (code < 200 || code > 299) {
            this.log(String.valueOf(urlc.getResponseCode()) + result + "\r\n");
            throw new IOException(result);
        }
        Vector<Properties> list2 = new Vector<Properties>();
        SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
        Object obj = ((JSONObject)JSONValue.parse((String)result)).get((Object)"buckets");
        if (obj instanceof JSONArray) {
            JSONArray ja = (JSONArray)obj;
            int xxx = 0;
            while (xxx < ja.size()) {
                Object obj2 = ja.get(xxx);
                if (obj2 instanceof JSONObject) {
                    JSONObject jo = (JSONObject)obj2;
                    Date d = new Date();
                    String line = "drwxrwxrwx   1    owner   group   0   " + yyyyMMddHHmmss.format(d) + "   " + this.dd.format(d) + " " + this.yyyy.format(d) + " /" + jo.get((Object)"bucketName");
                    Properties stat = B2Client.parseStat(line);
                    stat.put("url", "b2://" + this.config.getProperty("username") + ":" + VRL.vrlEncode(this.config.getProperty("password")) + "@api.backblaze.com/" + stat.getProperty("name") + "/");
                    stat.put("bucketId", jo.get((Object)"bucketId"));
                    bucketIdCache.put(String.valueOf(this.config.getProperty("password")) + stat.getProperty("name"), jo.get((Object)"bucketId"));
                    list2.addElement(stat);
                }
                ++xxx;
            }
        }
        list.addAll(list2);
        return list;
    }

    public Vector listFiles(String command, String path, Vector list, boolean ignore_bzEmpty, int max) throws Exception {
        return this.listFiles("b2_list_file_names", path, list, ignore_bzEmpty, max, false);
    }

    public Vector listFiles(String command, String path, Vector list, boolean ignore_bzEmpty, int max, boolean search) throws Exception {
        String bucketName = path.substring(1, path.indexOf("/", 1));
        if ((path = path.substring(bucketName.length() + 1)).startsWith("/")) {
            path = path.substring(1);
        }
        String startFileName = "";
        int x = 0;
        while (x < 1000) {
            if (this.config.getProperty("logged_out", "false").equals("true")) {
                throw new Exception("Error: Cancel dir listing. The client is already closed.");
            }
            URLConnection urlc = URLConnection.openConnection(new VRL(String.valueOf(this.api_url) + "/b2api/v2/" + command), this.config);
            urlc.setRequestMethod("POST");
            urlc.setDoInput(true);
            urlc.setDoOutput(true);
            urlc.setUseCaches(false);
            urlc.setRequestProperty("Authorization", this.token);
            JSONObject postData = new JSONObject();
            if (!bucketIdCache.containsKey(String.valueOf(this.config.getProperty("password")) + bucketName)) {
                Vector buckets = new Vector();
                this.listBuckets(buckets);
            }
            postData.put((Object)"bucketId", (Object)bucketIdCache.getProperty(String.valueOf(this.config.getProperty("password")) + bucketName));
            postData.put((Object)"maxFileCount", (Object)new Integer(max));
            if (!startFileName.equals("")) {
                postData.put((Object)"startFileName", (Object)startFileName);
            }
            postData.put((Object)"prefix", (Object)path);
            if (ignore_bzEmpty) {
                postData.put((Object)"delimiter", (Object)"/");
            }
            OutputStream out = urlc.getOutputStream();
            out.write(postData.toString().getBytes("UTF8"));
            out.close();
            String result = URLConnection.consumeResponse(urlc.getInputStream());
            int code = urlc.getResponseCode();
            if (code < 200 || code > 299) {
                this.log(String.valueOf(urlc.getResponseCode()) + result + "\r\n");
                throw new IOException(result);
            }
            urlc.disconnect();
            this.parseListItems(list, path, ignore_bzEmpty, bucketName, result, search);
            if (max <= 1 || ((JSONObject)JSONValue.parse((String)result)).get((Object)"nextFileName") == null) break;
            startFileName = (String)((JSONObject)JSONValue.parse((String)result)).get((Object)"nextFileName");
            ++x;
        }
        return list;
    }

    private void parseListItems(Vector list, String path, boolean ignore_bzEmpty, String bucketName, String result, boolean search) throws ParseException, Exception {
        SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
        Object obj = ((JSONObject)JSONValue.parse((String)result)).get((Object)"files");
        if (obj instanceof JSONArray) {
            JSONArray ja = (JSONArray)obj;
            int xxx = 0;
            while (xxx < ja.size()) {
                Object obj2 = ja.get(xxx);
                if (obj2 instanceof JSONObject) {
                    JSONObject jo = (JSONObject)obj2;
                    boolean folder = false;
                    String name = (String)jo.get((Object)"fileName");
                    if (!ignore_bzEmpty || !name.endsWith("/.bzEmpty")) {
                        if (search && name.endsWith("/.bzEmpty")) {
                            name = Common.replace_str(name, "/.bzEmpty", "/");
                        }
                        long mdtm = -1L;
                        JSONObject file_info = (JSONObject)jo.get((Object)"fileInfo");
                        if (((String)jo.get((Object)"action")).endsWith("folder")) {
                            folder = true;
                            if (!search) {
                                name = name.substring(path.length(), name.indexOf("/", path.length()));
                            }
                        } else {
                            if (!search) {
                                name = name.substring(path.length());
                            }
                            if (file_info.get((Object)"modified_date_time") != null) {
                                SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                                mdtm = sdf.parse((String)file_info.get((Object)"modified_date_time")).getTime();
                            } else if (file_info.get((Object)"src_last_modified_millis") != null) {
                                mdtm = Long.parseLong((String)file_info.get((Object)"src_last_modified_millis"));
                            }
                        }
                        Date d = new Date();
                        if (mdtm > 0L) {
                            d.setTime(mdtm);
                        }
                        String line = String.valueOf(folder ? "d" : "-") + "rwxrwxrwx   1    owner   group   " + jo.get((Object)"contentLength") + "   " + yyyyMMddHHmmss.format(d) + "   " + this.dd.format(d) + " " + this.yyyy.format(d) + " /" + name;
                        Properties stat = B2Client.parseStat(line);
                        stat.put("b2_file_name", (String)jo.get((Object)"fileName"));
                        if (jo.get((Object)"fileId") != null) {
                            stat.put("fileId", (String)jo.get((Object)"fileId"));
                        }
                        String url_path = String.valueOf(path) + stat.getProperty("name") + (folder ? "/" : "");
                        if (search) {
                            String file_path = Common.replace_str((String)jo.get((Object)"fileName"), "/.bzEmpty", "/");
                            url_path = String.valueOf(file_path) + (folder ? "/" : "");
                        }
                        stat.put("url", "b2://" + this.config.getProperty("username") + ":" + VRL.vrlEncode(this.config.getProperty("password")) + "@api.backblaze.com/" + bucketName + "/" + url_path);
                        if (file_info.get((Object)"uploaded_by") != null) {
                            stat.put("uploaded_by", (String)file_info.get((Object)"uploaded_by"));
                        }
                        list.addElement(stat);
                    }
                }
                ++xxx;
            }
        }
    }

    @Override
    public Properties stat(String path) throws Exception {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Vector v = new Vector();
        this.list(Common.all_but_last(path), v);
        int x = 0;
        while (x < v.size()) {
            Properties p = (Properties)v.elementAt(x);
            if (p.getProperty("name").equals(Common.last(path))) {
                return p;
            }
            ++x;
        }
        return null;
    }

    @Override
    protected InputStream download3(String path, long startPos, long endPos, boolean binary) throws Exception {
        URLConnection urlc = URLConnection.openConnection(new VRL(String.valueOf(this.downloadUrl) + "/file" + path), this.config);
        urlc.setRequestMethod("GET");
        urlc.setDoInput(true);
        urlc.setDoOutput(true);
        urlc.setUseCaches(false);
        urlc.setRequestProperty("Content-Type", "application/json");
        urlc.setRequestProperty("Authorization", this.token);
        this.in = urlc.getInputStream();
        return this.in;
    }

    @Override
    protected OutputStream upload3(String path, long startPos, boolean truncate, boolean binary) throws Exception {
        if (!path.substring(1).contains("/")) {
            throw new Exception("Cannot upload on Bucket level!!!");
        }
        String file_name = path.substring(("/" + Common.first(path.substring(1)) + "/").length());
        URLConnection urlc = URLConnection.openConnection(new VRL(String.valueOf(this.api_url) + "/b2api/v2/b2_start_large_file"), this.config);
        urlc.setRequestMethod("POST");
        urlc.setDoInput(true);
        urlc.setDoOutput(true);
        urlc.setUseCaches(false);
        urlc.setRequestProperty("Content-Type", "application/json");
        urlc.setRequestProperty("Authorization", this.token);
        JSONObject postData = new JSONObject();
        postData.put((Object)"fileName", (Object)Common.url_encode(file_name, "/.#@&?!\\=+~"));
        postData.put((Object)"contentType", (Object)"application/octet-stream");
        String bucket_id = bucketIdCache.getProperty(String.valueOf(this.config.getProperty("password")) + Common.first(path.substring(1)), "");
        if (bucket_id.equals("")) {
            this.list("/", new Vector());
            bucket_id = bucketIdCache.getProperty(String.valueOf(this.config.getProperty("password")) + Common.first(path.substring(1)), "");
        }
        postData.put((Object)"bucketId", (Object)bucket_id);
        OutputStream out = urlc.getOutputStream();
        out.write(postData.toString().getBytes("UTF8"));
        out.close();
        int code = urlc.getResponseCode();
        String result = URLConnection.consumeResponse(urlc.getInputStream());
        if (code < 200 || code > 299) {
            this.log(String.valueOf(urlc.getResponseCode()) + result + "\r\n");
            throw new IOException(result);
        }
        urlc.disconnect();
        JSONObject obj = (JSONObject)JSONValue.parse((String)result);
        String file_id = (String)obj.get((Object)"fileId");
        URLConnection urlc2 = URLConnection.openConnection(new VRL(String.valueOf(this.api_url) + "/b2api/v2/b2_get_upload_part_url"), this.config);
        urlc2.setRequestMethod("POST");
        urlc2.setDoInput(true);
        urlc2.setDoOutput(true);
        urlc2.setUseCaches(false);
        urlc2.setRequestProperty("Authorization", this.token);
        urlc2.setRequestProperty("Content-Type", "application/json");
        JSONObject postData2 = new JSONObject();
        postData2.put((Object)"fileId", (Object)file_id);
        OutputStream out2 = urlc2.getOutputStream();
        out2.write(postData2.toString().getBytes("UTF8"));
        out2.close();
        int code2 = urlc2.getResponseCode();
        String result2 = URLConnection.consumeResponse(urlc2.getInputStream());
        if (code2 < 200 || code2 > 299) {
            this.log(String.valueOf(urlc2.getResponseCode()) + result2 + "\r\n");
            throw new IOException(result2);
        }
        urlc2.disconnect();
        JSONObject obj2 = (JSONObject)JSONValue.parse((String)result2);
        String upload_auth_token = (String)obj2.get((Object)"authorizationToken");
        String upload_url = (String)obj2.get((Object)"uploadUrl");
        String upload_bucket_id = bucket_id;
        class OutputWrapper
        extends OutputStream {
            boolean closed = false;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0x500000);
            long pos = 0L;
            long final_size = 0L;
            boolean first_flush = true;
            final Properties status = new Properties();
            int part_number = 0;
            JSONArray all_hexSha1 = new JSONArray();
            boolean is_not_small_file = false;
            private final /* synthetic */ String val$file_id;
            private final /* synthetic */ String val$upload_bucket_id;
            private final /* synthetic */ String val$file_name;
            private final /* synthetic */ String val$path;
            private final /* synthetic */ String val$upload_url;
            private final /* synthetic */ String val$upload_auth_token;

            OutputWrapper(String string, String string2, String string3, String string4, String string5, String string6) {
                this.val$file_id = string;
                this.val$upload_bucket_id = string2;
                this.val$file_name = string3;
                this.val$path = string4;
                this.val$upload_url = string5;
                this.val$upload_auth_token = string6;
            }

            @Override
            public void write(int i) throws IOException {
                this.write(new byte[]{(byte)i}, 0, 1);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (this.baos.size() + len > 0x500000) {
                    int chunks = (this.baos.size() + len) / 0x500000;
                    int diff = this.baos.size() + len - chunks * 0x500000;
                    int offset_len = len - diff;
                    this.baos.write(b, off, offset_len);
                    long tmp_pos = this.baos.size();
                    this.flushNow();
                    this.pos += tmp_pos;
                    this.baos.write(b, offset_len, len - offset_len);
                } else {
                    this.baos.write(b, off, len);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                if (!this.is_not_small_file && this.baos.size() <= 0x500000) {
                    try {
                        URLConnection urlc = URLConnection.openConnection(new VRL(String.valueOf(B2Client.this.api_url) + "/b2api/v2/b2_cancel_large_file"), B2Client.this.config);
                        urlc.setRequestMethod("POST");
                        urlc.setDoInput(true);
                        urlc.setDoOutput(true);
                        urlc.setUseCaches(false);
                        urlc.setRequestProperty("Authorization", B2Client.this.token);
                        urlc.setRequestProperty("Content-Type", "application/json");
                        JSONObject postData2 = new JSONObject();
                        postData2.put((Object)"fileId", (Object)this.val$file_id);
                        OutputStream out = urlc.getOutputStream();
                        out.write(postData2.toString().getBytes("UTF8"));
                        out.close();
                        int code = urlc.getResponseCode();
                        String result = URLConnection.consumeResponse(urlc.getInputStream());
                        if (code < 200 || code > 299) {
                            B2Client.this.log(String.valueOf(urlc.getResponseCode()) + result + "\r\n");
                        }
                        urlc.disconnect();
                    }
                    catch (Exception e) {
                        B2Client.this.log(e);
                    }
                    byte[] b_flush = this.baos.toByteArray();
                    Exception e = null;
                    boolean succeeded = false;
                    int i = 0;
                    while (i < 5 && !succeeded) {
                        block21: {
                            try {
                                URLConnection urlc3 = URLConnection.openConnection(new VRL(String.valueOf(B2Client.this.api_url) + "/b2api/v2/b2_get_upload_url"), B2Client.this.config);
                                urlc3.setRequestMethod("POST");
                                urlc3.setDoInput(true);
                                urlc3.setDoOutput(true);
                                urlc3.setUseCaches(false);
                                urlc3.setRequestProperty("Authorization", B2Client.this.token);
                                urlc3.setRequestProperty("Content-Type", "application/json");
                                JSONObject postData3 = new JSONObject();
                                postData3.put((Object)"bucketId", (Object)this.val$upload_bucket_id);
                                OutputStream out3 = urlc3.getOutputStream();
                                out3.write(postData3.toString().getBytes("UTF8"));
                                out3.close();
                                int code3 = urlc3.getResponseCode();
                                String result3 = URLConnection.consumeResponse(urlc3.getInputStream());
                                if (code3 < 200 || code3 > 299) {
                                    B2Client.this.log(String.valueOf(urlc3.getResponseCode()) + result3 + "\r\n");
                                }
                                urlc3.disconnect();
                                JSONObject obj3 = (JSONObject)JSONValue.parse((String)result3);
                                String small_upload_auth_token = (String)obj3.get((Object)"authorizationToken");
                                String small_upload_url = (String)obj3.get((Object)"uploadUrl");
                                URL url_java = new URL(small_upload_url);
                                HttpURLConnection urlc2 = (HttpURLConnection)url_java.openConnection();
                                urlc2.setRequestMethod("POST");
                                urlc2.setReadTimeout(30000);
                                urlc2.setConnectTimeout(6000);
                                urlc2.setDoOutput(true);
                                urlc2.setUseCaches(false);
                                urlc2.setRequestProperty("Authorization", small_upload_auth_token);
                                MessageDigest sha1Digest = MessageDigest.getInstance("SHA-1");
                                sha1Digest.update(b_flush, 0, b_flush.length);
                                byte[] sha1Buf = sha1Digest.digest();
                                String hexSha1 = String.format("%040x", new BigInteger(1, sha1Buf));
                                urlc2.setRequestProperty("X-Bz-File-Name", Common.url_encode(this.val$file_name, "/.#@&?!\\=+~"));
                                urlc2.setRequestProperty("X-Bz-Content-Sha1", hexSha1);
                                urlc2.setRequestProperty("Content-Type", "application/octet-stream");
                                urlc2.connect();
                                urlc2.getOutputStream().write(b_flush);
                                urlc2.getOutputStream().close();
                                int code2 = urlc2.getResponseCode();
                                String result2 = URLConnection.consumeResponse(urlc2.getInputStream());
                                if (code2 < 200 || code2 > 299) {
                                    B2Client.this.log("Upload path :" + this.val$path + "Error : code :" + code2 + " " + urlc2.getResponseMessage());
                                }
                                urlc2.disconnect();
                            }
                            catch (Exception e1) {
                                B2Client.this.log(e1);
                                if (e == null) {
                                    e = e1;
                                }
                                break block21;
                            }
                            e = null;
                            succeeded = true;
                        }
                        ++i;
                    }
                    if (e != null) {
                        throw new IOException(e);
                    }
                    this.closed = true;
                    return;
                }
                this.flushNow();
                try {
                    int loops = 0;
                    while (this.status.getProperty("status", "").equals("") && loops++ < 1000) {
                        Thread.sleep(100L);
                    }
                    if (loops >= 998) {
                        throw new IOException("100 second timeout while waiting for prior b2 chunk to complete..." + loops + ":" + this.pos + ":" + this.pos);
                    }
                    if (this.status.getProperty("status", "").equals("error")) {
                        throw new IOException(this.status.getProperty("error_message", ""));
                    }
                    if (this.status.containsKey("size")) {
                        this.final_size += Long.parseLong(this.status.getProperty("size"));
                        this.status.remove("size");
                        this.all_hexSha1.add(this.status.remove("hexSha1"));
                    }
                }
                catch (InterruptedException e) {
                    B2Client.this.log(e);
                }
                try {
                    URLConnection urlc = URLConnection.openConnection(new VRL(String.valueOf(B2Client.this.api_url) + "/b2api/v2/b2_finish_large_file"), B2Client.this.config);
                    urlc.setDoOutput(true);
                    urlc.setDoInput(true);
                    urlc.setRequestMethod("POST");
                    urlc.setRequestProperty("Authorization", B2Client.this.token);
                    urlc.setRequestProperty("Content-Type", "application/json");
                    JSONObject postData = new JSONObject();
                    postData.put((Object)"fileId", (Object)this.val$file_id);
                    postData.put((Object)"partSha1Array", (Object)this.all_hexSha1);
                    OutputStream out = urlc.getOutputStream();
                    out.write(postData.toString().getBytes("UTF8"));
                    out.close();
                    int code = urlc.getResponseCode();
                    String result = URLConnection.consumeResponse(urlc.getInputStream());
                    if (code < 200 || code > 299) {
                        B2Client.this.log(String.valueOf(urlc.getResponseCode()) + result + "\r\n");
                        throw new IOException(result);
                    }
                    urlc.disconnect();
                }
                catch (Exception e) {
                    B2Client.this.log(e);
                    throw new IOException("Upload error : " + e.getMessage());
                }
                this.closed = true;
            }

            public void flushNow() throws IOException {
                if (this.baos.size() > 0) {
                    this.is_not_small_file = true;
                    int loops = 0;
                    while (this.status.getProperty("status", "").equals("") && loops++ < 1500 && !this.first_flush) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            B2Client.this.log(e);
                        }
                    }
                    if (loops >= 1495) {
                        throw new IOException("100 second timeout while waiting for prior b2 chunk to complete..." + loops + ":" + this.pos + ":" + this.pos);
                    }
                    if (this.status.getProperty("status", "").equals("error")) {
                        throw new IOException(this.status.getProperty("error_message", ""));
                    }
                    if (this.status.containsKey("size")) {
                        this.final_size += Long.parseLong(this.status.getProperty("size"));
                        this.status.remove("size");
                        this.all_hexSha1.add(this.status.remove("hexSha1"));
                    }
                    this.first_flush = false;
                    this.status.put("status", "");
                    long pos_now = this.pos;
                    final byte[] b_flush = this.baos.toByteArray();
                    final int current_part_number = ++this.part_number;
                    Worker.startWorker(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                URL url_java = new URL(val$upload_url);
                                HttpURLConnection urlc = (HttpURLConnection)url_java.openConnection();
                                urlc.setRequestMethod("POST");
                                urlc.setDoInput(true);
                                urlc.setDoOutput(true);
                                urlc.setUseCaches(false);
                                urlc.setRequestProperty("Authorization", val$upload_auth_token);
                                urlc.setRequestProperty("X-Bz-Part-Number", String.valueOf(current_part_number));
                                urlc.setRequestProperty("Content-Length", String.valueOf(b_flush.length));
                                MessageDigest sha1Digest = MessageDigest.getInstance("SHA-1");
                                sha1Digest.update(b_flush, 0, b_flush.length);
                                byte[] sha1Buf = sha1Digest.digest();
                                String hexSha1 = String.format("%040x", new BigInteger(1, sha1Buf));
                                urlc.setRequestProperty("X-Bz-Content-Sha1", hexSha1);
                                urlc.connect();
                                urlc.getOutputStream().write(b_flush);
                                urlc.getOutputStream().close();
                                int code = urlc.getResponseCode();
                                String result = URLConnection.consumeResponse(urlc.getInputStream());
                                if (code < 200 || code > 299) {
                                    B2Client.this.log("Upload path :" + val$path + "Error : code :" + code + " " + urlc.getResponseMessage());
                                    throw new Exception("Upload error : Upload path :" + val$path + "Error : code :" + code + " " + urlc.getResponseMessage());
                                }
                                urlc.disconnect();
                                status.put("size", String.valueOf(b_flush.length));
                                status.put("hexSha1", hexSha1);
                                status.put("status", "ok");
                            }
                            catch (Exception e) {
                                B2Client.this.log(e);
                                status.put("status", "error");
                                status.put("error_message", e.getMessage());
                            }
                        }
                    });
                    this.baos.reset();
                }
            }
        }
        out = new OutputWrapper(file_id, upload_bucket_id, file_name, path, upload_url, upload_auth_token);
        return out;
    }

    @Override
    public boolean delete(String path) throws Exception {
        if (!path.substring(1).contains("/")) {
            throw new Exception("Cannot delete on Bucket level!");
        }
        Properties p = this.stat(path);
        Vector<Properties> files = new Vector<Properties>();
        if (!p.containsKey("fileId")) {
            String folder_path = path;
            this.listFiles("b2_list_file_names", folder_path, files, false, 1000);
            if (files.size() == 0) {
                throw new Exception("Could not found file id of the given path :" + path);
            }
        } else {
            files.add(p);
        }
        IOException e = null;
        int x = 0;
        while (x < files.size()) {
            block8: {
                try {
                    Properties pp = (Properties)files.get(x);
                    this.delete_version(pp.getProperty("fileId"), pp.getProperty("b2_file_name", ""));
                }
                catch (Exception de) {
                    this.log(de);
                    if (e != null) break block8;
                    e = new IOException(de.getMessage());
                }
            }
            ++x;
        }
        if (e != null) {
            throw e;
        }
        return true;
    }

    private void delete_version(String file_id, String b2_file_name) throws Exception {
        URLConnection urlc = URLConnection.openConnection(new VRL(String.valueOf(this.api_url) + "/b2api/v1/b2_delete_file_version"), this.config);
        urlc.setRequestMethod("POST");
        urlc.setDoInput(true);
        urlc.setDoOutput(true);
        urlc.setUseCaches(false);
        urlc.setRequestProperty("Authorization", this.token);
        JSONObject postData = new JSONObject();
        postData.put((Object)"fileId", (Object)file_id);
        postData.put((Object)"fileName", (Object)b2_file_name);
        OutputStream out = urlc.getOutputStream();
        out.write(postData.toString().getBytes("UTF8"));
        out.close();
        int code = urlc.getResponseCode();
        String result = URLConnection.consumeResponse(urlc.getInputStream());
        urlc.disconnect();
        if (code < 200 || code > 299) {
            this.log(String.valueOf(urlc.getResponseCode()) + result + "\r\n");
            throw new IOException(result);
        }
    }

    @Override
    public boolean makedir(String path) throws Exception {
        if (!path.substring(1).contains("/")) {
            throw new Exception("Cannot create folder on Bucket level!");
        }
        String bucket_id = bucketIdCache.getProperty(String.valueOf(this.config.getProperty("password")) + Common.first(path.substring(1)), "");
        if (bucket_id.equals("")) {
            this.list("/", new Vector());
            bucket_id = bucketIdCache.getProperty(String.valueOf(this.config.getProperty("password")) + Common.first(path.substring(1)), "");
        }
        String b2_path = path.substring(("/" + Common.first(path.substring(1)) + "/").length());
        URLConnection urlc = URLConnection.openConnection(new VRL(String.valueOf(this.api_url) + "/b2api/v2/b2_get_upload_url"), this.config);
        urlc.setRequestMethod("POST");
        urlc.setDoInput(true);
        urlc.setDoOutput(true);
        urlc.setUseCaches(false);
        urlc.setRequestProperty("Authorization", this.token);
        urlc.setRequestProperty("Content-Type", "application/json");
        JSONObject postData3 = new JSONObject();
        postData3.put((Object)"bucketId", (Object)bucket_id);
        OutputStream out = urlc.getOutputStream();
        out.write(postData3.toString().getBytes("UTF8"));
        out.close();
        int code = urlc.getResponseCode();
        String result = URLConnection.consumeResponse(urlc.getInputStream());
        if (code < 200 || code > 299) {
            this.log(String.valueOf(urlc.getResponseCode()) + result + "\r\n");
            urlc.disconnect();
            return false;
        }
        urlc.disconnect();
        JSONObject obj = (JSONObject)JSONValue.parse((String)result);
        String folder_upload_auth_token = (String)obj.get((Object)"authorizationToken");
        String folder_upload_url = (String)obj.get((Object)"uploadUrl");
        URLConnection urlc2 = URLConnection.openConnection(new VRL(folder_upload_url), this.config);
        urlc2.setRequestMethod("POST");
        urlc2.setDoInput(true);
        urlc2.setDoOutput(true);
        urlc2.setUseCaches(false);
        urlc2.setRequestProperty("Authorization", folder_upload_auth_token);
        urlc2.setRequestProperty("X-Bz-File-Name", Common.url_encode(String.valueOf(b2_path) + ".bzEmpty", "/.#@&?!\\=+~"));
        urlc2.setRequestProperty("X-Bz-Content-Sha1", "da39a3ee5e6b4b0d3255bfef95601890afd80709");
        urlc2.setRequestProperty("Content-Length", "0");
        urlc2.setRequestProperty("Content-Type", "text/plain");
        urlc2.getOutputStream().close();
        int code2 = urlc2.getResponseCode();
        if (code2 < 200 || code2 > 299) {
            this.log("Create directory path :" + path + "Error : code :" + code2 + " " + urlc2.getResponseMessage());
            this.log("Response" + URLConnection.consumeResponse(urlc2.getInputStream()));
            urlc2.disconnect();
            return false;
        }
        urlc2.disconnect();
        return true;
    }

    @Override
    public boolean makedirs(String path) throws Exception {
        boolean ok = true;
        String[] parts = path.split("/");
        String path2 = "";
        int x = 0;
        while (x < parts.length && ok) {
            path2 = String.valueOf(path2) + parts[x] + "/";
            if (x >= 1 && this.stat(path2) == null) {
                ok = this.makedir(path2);
            }
            ++x;
        }
        return ok;
    }

    @Override
    public boolean rename(String rnfr, String rnto, boolean overwrite) throws Exception {
        Properties p = this.stat(rnfr);
        if (!rnfr.substring(1).contains("/")) {
            this.log("Cannot rename folder! Bucket rename not allowed.");
            throw new Exception("FAILURE: Renaming of Cloud (sub)Directories is not supported, aborting rename operation.");
        }
        if (!p.containsKey("fileId")) {
            this.log("Cannot rename folder! B2 REST API does not support renaming folders.");
            throw new Exception("FAILURE: Renaming of Cloud (sub)Directories is not supported, aborting rename operation.");
        }
        String b2_rnto_path = rnto.substring(("/" + Common.first(rnto.substring(1)) + "/").length());
        URLConnection urlc = URLConnection.openConnection(new VRL(String.valueOf(this.api_url) + "/b2api/v2/b2_copy_file"), this.config);
        urlc.setRequestMethod("POST");
        urlc.setDoInput(true);
        urlc.setDoOutput(true);
        urlc.setUseCaches(false);
        urlc.setRequestProperty("Authorization", this.token);
        JSONObject postData = new JSONObject();
        postData.put((Object)"sourceFileId", (Object)p.getProperty("fileId"));
        postData.put((Object)"fileName", (Object)b2_rnto_path);
        OutputStream out = urlc.getOutputStream();
        out.write(postData.toString().getBytes("UTF8"));
        out.close();
        int code = urlc.getResponseCode();
        if (code < 200 || code > 299) {
            this.log("Rename from path :" + rnfr + " to " + rnto + " Error : code :" + code + " " + urlc.getResponseMessage());
            this.log("Result : " + URLConnection.consumeResponse(urlc.getInputStream()));
            urlc.disconnect();
            return false;
        }
        urlc.disconnect();
        return this.delete(rnfr);
    }

    @Override
    public boolean mdtm(String path, long modified) throws Exception {
        return this.update_file_info(path, modified);
    }

    private boolean update_file_info(final String path, long modified) throws Exception {
        Properties p = this.stat(path);
        URLConnection urlc = URLConnection.openConnection(new VRL(String.valueOf(this.api_url) + "/b2api/v2/b2_copy_file"), this.config);
        urlc.setRequestMethod("POST");
        urlc.setDoInput(true);
        urlc.setDoOutput(true);
        urlc.setUseCaches(false);
        urlc.setRequestProperty("Authorization", this.token);
        JSONObject postData = new JSONObject();
        postData.put((Object)"sourceFileId", (Object)p.getProperty("fileId"));
        String file_name = path.substring(("/" + Common.first(path.substring(1)) + "/").length());
        postData.put((Object)"fileName", (Object)Common.url_encode(file_name, "/.#@&?!\\=+~"));
        postData.put((Object)"metadataDirective", (Object)"REPLACE");
        postData.put((Object)"contentType", (Object)"application/octet-stream");
        JSONObject fileInfo = new JSONObject();
        if (modified > 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            fileInfo.put((Object)"modified_date_time", (Object)sdf.format(new Date(modified)));
        }
        fileInfo.put((Object)"uploaded_by", (Object)this.config.getProperty("uploaded_by", ""));
        fileInfo.put((Object)"md5", (Object)this.config.getProperty("uploaded_md5", ""));
        postData.put((Object)"fileInfo", (Object)fileInfo);
        OutputStream out = urlc.getOutputStream();
        out.write(postData.toString().getBytes("UTF8"));
        out.close();
        int code = urlc.getResponseCode();
        String result = URLConnection.consumeResponse(urlc.getInputStream());
        if (code < 200 || code > 299) {
            this.log("Result : " + result);
            urlc.disconnect();
            return false;
        }
        urlc.disconnect();
        JSONObject jo = (JSONObject)JSONValue.parse((String)result);
        final String file_id = (String)jo.get((Object)"fileId");
        Worker.startWorker(new Runnable(){

            @Override
            public void run() {
                try {
                    Vector file_versions = new Vector();
                    B2Client.this.listFiles("b2_list_file_versions", path, file_versions, false, 1000);
                    if (file_versions.size() == 0) {
                        throw new Exception("Could not found file id of the given path :" + path);
                    }
                    int x = 0;
                    while (x < file_versions.size()) {
                        Properties pp = (Properties)file_versions.get(x);
                        if (!pp.getProperty("fileId").equals(file_id)) {
                            B2Client.this.delete_version(pp.getProperty("fileId"), pp.getProperty("b2_file_name", ""));
                        }
                        ++x;
                    }
                }
                catch (Exception e) {
                    B2Client.this.log(e);
                }
            }
        });
        return true;
    }

    @Override
    public String getUploadedByMetadata(String path) {
        String user_name = "";
        try {
            Properties p = this.stat(path);
            if (p != null) {
                JSONObject postData = new JSONObject();
                postData.put((Object)"fileId", (Object)p.getProperty("fileId"));
                if (p.containsKey("uploaded_by") && !p.getProperty("uploaded_by").equals("")) {
                    return p.getProperty("uploaded_by", "");
                }
                URLConnection urlc = URLConnection.openConnection(new VRL(String.valueOf(this.api_url) + "/b2api/v2/b2_get_file_info"), this.config);
                urlc.setRequestMethod("POST");
                urlc.setDoInput(true);
                urlc.setDoOutput(true);
                urlc.setUseCaches(false);
                urlc.setRequestProperty("Authorization", this.token);
                urlc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                OutputStream out = urlc.getOutputStream();
                out.write(postData.toString().getBytes("UTF8"));
                out.close();
                int code = urlc.getResponseCode();
                String result = URLConnection.consumeResponse(urlc.getInputStream());
                if (code < 200 || code > 299) {
                    this.log(String.valueOf(urlc.getResponseCode()) + result + "\r\n");
                    urlc.disconnect();
                }
                urlc.disconnect();
                JSONObject jo = (JSONObject)JSONValue.parse((String)result);
                JSONObject file_info = (JSONObject)jo.get((Object)"fileInfo");
                if (file_info.containsKey((Object)"uploaded_by")) {
                    user_name = (String)file_info.get((Object)"uploaded_by");
                }
            }
        }
        catch (Exception e) {
            this.log(e);
        }
        return user_name;
    }

    @Override
    public void set_MD5_and_upload_id(String path) throws Exception {
        if (this.config.getProperty("uploaded_by", "").equals("") || this.config.getProperty("uploaded_md5", "").equals("")) {
            return;
        }
        this.update_file_info(path, 0L);
    }

    @Override
    public boolean isSearchSupported(Properties config) {
        return true;
    }

    @Override
    public Vector search(String path, Vector list, Properties config) throws Exception {
        try {
            String bucketName = path.substring(1, path.indexOf("/", 1));
            String search_path = path.substring(bucketName.length() + 1);
            Vector search_list = new Vector();
            config.put("ignore_path_check", "true");
            this.listFiles("b2_list_file_names", path, search_list, false, 10000, true);
            FindMatcher fm = new FindMatcher(path, search_list, config);
            fm.filter_items();
            list.addAll(search_list);
        }
        catch (Exception e) {
            Common.log("SEARCH", 1, e);
        }
        return list;
    }
}

