/*
 * Decompiled with CFR 0.152.
 */
package com.crushftp.client;

import com.crushftp.client.Common;
import com.crushftp.client.File_S;
import com.crushftp.client.File_U;
import com.crushftp.client.VRL;
import com.crushftp.client.Worker;
import com.sun.mail.dsn.DispositionNotification;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.ZlibCompressor;
import org.bouncycastle.cms.jcajce.ZlibExpanderProvider;
import org.bouncycastle.mail.smime.SMIMECompressed;
import org.bouncycastle.mail.smime.SMIMECompressedGenerator;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.operator.InputExpanderProvider;
import org.bouncycastle.operator.OutputCompressor;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;

public class As2Msg {
    public static final String A_RC2 = "rc2";
    public static final String A_RC4 = "rc4";
    public static final String A_AES_128 = "aes128";
    public static final String A_AES_192 = "aes192";
    public static final String A_AES_256 = "aes256";
    public static final String A_3DES = "3des";
    public static final String A_DES = "des";
    public static final String A_SHA1 = "sha1";
    public static final String A_SHA_256 = "sha-256";
    public static final String A_SHA256 = "sha256";
    public static final String A_MD5 = "md5";
    public static final String A_IDEA = "idea";
    public static final String A_CAST5 = "cast5";
    public static final int E_NONE = 1;
    public static final int E_3DES = 2;
    public static final int E_RC2_40 = 3;
    public static final int E_RC2_64 = 4;
    public static final int E_RC2_128 = 5;
    public static final int E_RC2_192 = 6;
    public static final int E_AES_128 = 8;
    public static final int E_AES_192 = 9;
    public static final int E_AES_256 = 10;
    public static final int E_RC4_40 = 11;
    public static final int E_RC4_56 = 12;
    public static final int E_RC4_128 = 13;
    public static final int E_DES = 15;
    public static final int SIG_NONE = 1;
    public static final int SIG_SHA1 = 2;
    public static final int SIG_MD5 = 3;
    public static final int SIG_SHA256 = 4;
    public static Properties algorithmLookup = new Properties();
    public static Properties mdnResponses;

    static {
        algorithmLookup.put("none", "1");
        algorithmLookup.put(A_SHA1, "2");
        algorithmLookup.put(A_MD5, "3");
        algorithmLookup.put(A_SHA_256, "4");
        algorithmLookup.put(A_SHA256, "4");
        algorithmLookup.put(A_3DES, "2");
        algorithmLookup.put("rc2_40", "3");
        algorithmLookup.put("rc2_64", "4");
        algorithmLookup.put("rc2_128", "5");
        algorithmLookup.put("rc2_192", "6");
        algorithmLookup.put("rc2_unknown", "7");
        algorithmLookup.put("aes_128", "8");
        algorithmLookup.put("aes_192", "9");
        algorithmLookup.put("aes_256", "10");
        algorithmLookup.put("rc4_40", "11");
        algorithmLookup.put("rc4_56", "12");
        algorithmLookup.put("rc4_128", "13");
        algorithmLookup.put("rc4_unknown", "14");
        algorithmLookup.put(A_DES, "15");
        mdnResponses = new Properties();
    }

    public As2Msg() {
        try {
            Common.configureBC();
        }
        catch (Exception e) {
            Common.log("SERVER", 0, e);
        }
    }

    public Object createMessage(Properties info, Object inData, boolean compress, int as2SignType, String as2SignKeystoreFormat, String as2SignKeystorePath, String as2SignKeystorePassword, String as2SignKeyPassword, String as2SignKeyAlias, int as2EncryptType, String as2EncryptKeystoreFormat, String as2EncryptKeystorePath, String as2EncryptKeystorePassword, String as2EncryptKeyAlias, String preservedFilename, Properties otherParams) throws Exception {
        MimeBodyPart bodyPart = new MimeBodyPart();
        if (inData instanceof File_U) {
            bodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource((File)((File_U)inData))));
        } else {
            bodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource((byte[])inData, "application/binary")));
        }
        bodyPart.addHeader("Content-Type", otherParams.getProperty("CONTENT-TYPE", "text/plain"));
        bodyPart.addHeader("Content-Transfer-Encoding", otherParams.getProperty("CONTENT-TRANSFER-ENCODING", "binary"));
        Enumeration<Object> keys = otherParams.keys();
        while (keys.hasMoreElements()) {
            String key = "" + keys.nextElement();
            if (!key.toUpperCase().startsWith("X-")) continue;
            bodyPart.addHeader(key, otherParams.getProperty(key));
        }
        String newFilename = "";
        newFilename = inData instanceof File_U ? ((File_U)inData).getName().replace(' ', '_').replace('@', '_').replace(':', '_').replace(';', '_').replace('(', '_').replace(')', '_') : (preservedFilename == null || preservedFilename.equals("") ? "as2_" + Common.makeBoundary(11) + ".temp" : preservedFilename);
        if (otherParams.containsKey("Content-Disposition")) {
            bodyPart.addHeader("Content-Disposition", otherParams.getProperty("Content-Disposition", ""));
        } else {
            bodyPart.addHeader("Content-Disposition", "attachment; filename=" + newFilename);
        }
        String digestOID = null;
        if (as2SignType == 3) {
            digestOID = this.getAlgNameToId(A_MD5);
        } else if (as2SignType == 4) {
            digestOID = this.getAlgNameToId(A_SHA256);
        } else if (as2SignType == 2 || digestOID == null) {
            digestOID = this.getAlgNameToId(A_SHA1);
        }
        if (compress) {
            bodyPart = this.compressData(bodyPart);
        }
        if (digestOID != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            bodyPart.writeTo((OutputStream)bOut);
            bOut.close();
            String mic = this.calculateMIC(new ByteArrayInputStream(bOut.toByteArray()), digestOID);
            String signtype = A_SHA1;
            if (as2SignType == 3) {
                signtype = A_MD5;
            }
            if (as2SignType == 4) {
                signtype = System.getProperty("crushftp.as2.sha256", A_SHA_256);
            }
            info.put("mic", String.valueOf(mic) + ", " + signtype);
        }
        MimeMessage messagePart = new MimeMessage(Session.getInstance((Properties)System.getProperties(), null));
        if (as2SignType != 1) {
            MimeMultipart signedPart = this.signMessage(as2SignKeystoreFormat, as2SignKeystorePath, as2SignKeystorePassword, as2SignKeyPassword, as2SignKeyAlias, bodyPart, as2SignType);
            messagePart.setContent((Multipart)signedPart);
            messagePart.saveChanges();
        } else {
            MimeMultipart unsignedPart = new MimeMultipart();
            unsignedPart.addBodyPart((BodyPart)bodyPart);
            messagePart.setContent((Multipart)unsignedPart);
            messagePart.saveChanges();
        }
        ByteArrayOutputStream signedOut = new ByteArrayOutputStream();
        ByteArrayOutputStream completedOut = null;
        try {
            if (as2EncryptType != 1) {
                Enumeration hdrLines = messagePart.getMatchingHeaderLines(new String[]{"Content-Type"});
                while (hdrLines.hasMoreElements()) {
                    signedOut.write((String.valueOf(MimeUtility.unfold((String)((String)hdrLines.nextElement()))) + "\r\n").getBytes());
                }
            }
            messagePart.writeTo((OutputStream)signedOut, new String[]{"Message-ID", "Mime-Version", "Content-Type"});
        }
        catch (Exception e) {
            Common.log("AS2_SERVER", 1, e);
        }
        String tmpFilename = String.valueOf(System.currentTimeMillis()) + ".as2dump_signed";
        if (Common.log("AS2_SERVER", 4, "Raw File Data Dumped to disk:" + tmpFilename)) {
            RandomAccessFile tmpOut = new RandomAccessFile(new File_U(tmpFilename), "rw");
            tmpOut.write(signedOut.toByteArray());
            tmpOut.close();
        }
        if (as2EncryptType != 1) {
            completedOut = new ByteArrayOutputStream();
            OutputStream converter = this.encryptData(as2EncryptKeystoreFormat, as2EncryptKeystorePath, as2EncryptKeystorePassword, as2EncryptKeyAlias, as2EncryptType, completedOut);
            converter.write(signedOut.toByteArray());
            converter.close();
        } else {
            completedOut = signedOut;
        }
        if (inData instanceof File_U) {
            File_U f = new File_U(String.valueOf(Common.all_but_last(((File_U)inData).getPath())) + "/as2_" + Common.makeBoundary(11) + ".encrypted");
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(completedOut.toByteArray());
            fos.close();
            return f;
        }
        return completedOut.toByteArray();
    }

    public OutputStream encryptData(String keystoreType, String keystorePath, String keystorePassword, String alias, int encryptionType, OutputStream encryptedFile) throws Exception {
        keystorePassword = Common.encryptDecrypt(keystorePassword, false);
        if (keystorePath.toUpperCase().endsWith(".PFX")) {
            keystoreType = "pkcs12";
        }
        KeyStore keystore = KeyStore.getInstance(keystoreType);
        if (Common.System2.containsKey("crushftp.keystores." + keystorePath.toUpperCase().replace('\\', '/'))) {
            Properties p = (Properties)Common.System2.get("crushftp.keystores." + keystorePath.toUpperCase().replace('\\', '/'));
            keystore.load(new ByteArrayInputStream((byte[])p.get("bytes")), keystorePassword.toCharArray());
        } else {
            keystore.load(new FileInputStream(keystorePath), keystorePassword.toCharArray());
        }
        X509Certificate certificate = (X509Certificate)keystore.getCertificate(alias);
        if (certificate == null) {
            throw new Exception("Could not load key alias " + alias + " from specified keystore:" + keystorePath);
        }
        CMSEnvelopedDataStreamGenerator dataGenerator = new CMSEnvelopedDataStreamGenerator();
        dataGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(certificate));
        OutputEncryptor oe = null;
        if (encryptionType == 2) {
            oe = new JceCMSContentEncryptorBuilder(CMSAlgorithm.DES_EDE3_CBC).setProvider("BC").build();
        } else if (encryptionType == 15) {
            oe = new JceCMSContentEncryptorBuilder(CMSAlgorithm.DES_CBC, 56).setProvider("BC").build();
        } else if (encryptionType == 3) {
            oe = new JceCMSContentEncryptorBuilder(CMSAlgorithm.RC2_CBC, 40).setProvider("BC").build();
        } else if (encryptionType == 4) {
            oe = new JceCMSContentEncryptorBuilder(CMSAlgorithm.RC2_CBC, 64).setProvider("BC").build();
        } else if (encryptionType == 5) {
            oe = new JceCMSContentEncryptorBuilder(CMSAlgorithm.RC2_CBC, 128).setProvider("BC").build();
        } else if (encryptionType == 6) {
            oe = new JceCMSContentEncryptorBuilder(CMSAlgorithm.RC2_CBC, 192).setProvider("BC").build();
        } else if (encryptionType == 8) {
            oe = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider("BC").build();
        } else if (encryptionType == 9) {
            oe = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES192_CBC).setProvider("BC").build();
        } else if (encryptionType == 10) {
            oe = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).setProvider("BC").build();
        } else if (encryptionType == 11) {
            oe = new JceCMSContentEncryptorBuilder(PKCSObjectIdentifiers.rc4, 40).setProvider("BC").build();
        } else if (encryptionType == 12) {
            oe = new JceCMSContentEncryptorBuilder(PKCSObjectIdentifiers.rc4, 56).setProvider("BC").build();
        } else if (encryptionType == 13) {
            oe = new JceCMSContentEncryptorBuilder(PKCSObjectIdentifiers.rc4, 128).setProvider("BC").build();
        }
        if (oe == null) {
            throw new Exception("Unsupported encryption type " + encryptionType);
        }
        OutputStream envelopedData = dataGenerator.open(encryptedFile, oe);
        return envelopedData;
    }

    public MimeMultipart signMessage(String keystoreType, String keystorePath, String keystorePassword, String keyPassword, String alias, MimeBodyPart body, int signType) throws Exception {
        keystorePassword = Common.encryptDecrypt(keystorePassword, false);
        keyPassword = Common.encryptDecrypt(keyPassword, false);
        if (keystorePath.toUpperCase().endsWith(".PFX")) {
            keystoreType = "pkcs12";
        }
        KeyStore keystore = KeyStore.getInstance(keystoreType);
        if (Common.System2.containsKey("crushftp.keystores." + keystorePath.toUpperCase().replace('\\', '/'))) {
            Properties p = (Properties)Common.System2.get("crushftp.keystores." + keystorePath.toUpperCase().replace('\\', '/'));
            keystore.load(new ByteArrayInputStream((byte[])p.get("bytes")), keystorePassword.toCharArray());
        } else {
            keystore.load(new FileInputStream(new File_S(keystorePath)), keystorePassword.toCharArray());
        }
        PrivateKey senderKey = (PrivateKey)keystore.getKey(alias, keyPassword.toCharArray());
        Certificate[] chain = keystore.getCertificateChain(alias);
        if (chain == null) {
            throw new Exception("Could not load key alias " + alias + " from specified keystore:" + keystorePath);
        }
        String digest = null;
        if (signType == 2) {
            digest = A_SHA1;
        } else if (signType == 3) {
            digest = A_MD5;
        } else if (signType == 4) {
            digest = System.getProperty("crushftp.as2.sha256", A_SHA_256);
        } else {
            throw new Exception("Unsupported sign type " + signType);
        }
        return this.sign(body, chain, senderKey, digest);
    }

    public String getAlgNameToId(String a) throws NoSuchAlgorithmException {
        String aid = "";
        if (a.equalsIgnoreCase(A_MD5)) {
            aid = "1.2.840.113549.2.5";
        } else if (a.equalsIgnoreCase(A_SHA1)) {
            aid = "1.3.14.3.2.26";
        } else if (a.equalsIgnoreCase(A_SHA256)) {
            aid = "2.16.840.1.101.3.4.2.1";
        } else if (a.equalsIgnoreCase(A_SHA_256)) {
            aid = "2.16.840.1.101.3.4.2.1";
        } else if (a.equalsIgnoreCase(A_AES_128)) {
            aid = CMSEnvelopedDataGenerator.AES128_CBC;
        } else if (a.equalsIgnoreCase(A_AES_192)) {
            aid = CMSEnvelopedDataGenerator.AES192_CBC;
        } else if (a.equalsIgnoreCase(A_AES_256)) {
            aid = CMSEnvelopedDataGenerator.AES256_CBC;
        } else if (a.equalsIgnoreCase(A_3DES)) {
            aid = "1.2.840.113549.3.7";
        } else if (a.equalsIgnoreCase(A_DES)) {
            aid = "1.3.14.3.2.7";
        } else if (a.equalsIgnoreCase(A_CAST5)) {
            aid = CMSEnvelopedDataGenerator.CAST5_CBC;
        } else if (a.equalsIgnoreCase(A_IDEA)) {
            aid = CMSEnvelopedDataGenerator.IDEA_CBC;
        } else if (a.equalsIgnoreCase(A_RC2)) {
            aid = CMSEnvelopedDataGenerator.RC2_CBC;
        } else if (a.equalsIgnoreCase(A_RC4)) {
            aid = "1.2.840.113549.3.4";
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm: " + a);
        }
        return aid;
    }

    public String getAlgIdToName(String id) throws NoSuchAlgorithmException {
        String aname = "";
        if (id.equalsIgnoreCase("1.2.840.113549.2.5")) {
            aname = A_MD5;
        } else if (id.equalsIgnoreCase("1.3.14.3.2.26")) {
            aname = A_SHA1;
        } else if (id.equalsIgnoreCase("2.16.840.1.101.3.4.2.1")) {
            aname = A_SHA_256;
        } else if (id.equalsIgnoreCase(CMSEnvelopedDataGenerator.AES128_CBC)) {
            aname = A_AES_128;
        } else if (id.equalsIgnoreCase(CMSEnvelopedDataGenerator.AES192_CBC)) {
            aname = A_AES_192;
        } else if (id.equalsIgnoreCase(CMSEnvelopedDataGenerator.AES256_CBC)) {
            aname = A_AES_256;
        } else if (id.equalsIgnoreCase(CMSEnvelopedDataGenerator.CAST5_CBC)) {
            aname = A_CAST5;
        } else if (id.equalsIgnoreCase(CMSEnvelopedDataGenerator.DES_EDE3_CBC)) {
            aname = A_3DES;
        } else if (id.equalsIgnoreCase("1.3.14.3.2.7")) {
            aname = A_DES;
        } else if (id.equalsIgnoreCase(CMSEnvelopedDataGenerator.IDEA_CBC)) {
            aname = A_IDEA;
        } else if (id.equalsIgnoreCase(CMSEnvelopedDataGenerator.RC2_CBC)) {
            aname = A_RC2;
        } else if (id.equalsIgnoreCase("1.2.840.113549.3.4")) {
            aname = A_RC4;
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm: " + id);
        }
        return aname;
    }

    public MimeMultipart sign(Object body, Certificate[] chain, Key key, String digest) throws Exception {
        SMIMECapabilityVector allowedSigns = new SMIMECapabilityVector();
        allowedSigns.addCapability(SMIMECapability.rC2_CBC, 128);
        allowedSigns.addCapability(SMIMECapability.dES_CBC);
        allowedSigns.addCapability(SMIMECapability.dES_EDE3_CBC);
        ASN1EncodableVector attrs = new ASN1EncodableVector();
        attrs.add((ASN1Encodable)new SMIMECapabilitiesAttribute(allowedSigns));
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        if (digest.equalsIgnoreCase(A_SHA1)) {
            gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").build("SHA1withRSA", (PrivateKey)key, (X509Certificate)chain[0]));
        } else if (digest.equalsIgnoreCase(A_MD5)) {
            gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").build("MD5withRSA", (PrivateKey)key, (X509Certificate)chain[0]));
        } else if (digest.equalsIgnoreCase(A_SHA256)) {
            gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").build("SHA256withRSA", (PrivateKey)key, (X509Certificate)chain[0]));
        } else if (digest.equalsIgnoreCase(A_SHA_256)) {
            gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").build("SHA256withRSA", (PrivateKey)key, (X509Certificate)chain[0]));
        } else {
            throw new Exception("Signing digest " + digest + " not supported.");
        }
        JcaCertStore store = new JcaCertStore(new ArrayList<Certificate>(Arrays.asList(chain)));
        gen.addCertificates((Store)store);
        gen.addCRLs((Store)store);
        if (body instanceof MimeBodyPart) {
            return gen.generate((MimeBodyPart)body);
        }
        if (body instanceof MimeMessage) {
            return gen.generate((MimeMessage)body);
        }
        return null;
    }

    public String calculateMIC(InputStream data, String digestAlgOID) throws GeneralSecurityException, MessagingException, IOException {
        DigestInputStream digestInputStream = new DigestInputStream(data, MessageDigest.getInstance(digestAlgOID, "BC"));
        byte[] b = new byte[32768];
        while (digestInputStream.read(b) >= 0) {
        }
        digestInputStream.close();
        return new String(Base64.encode((byte[])digestInputStream.getMessageDigest().digest()));
    }

    public String calculateMIC(Part part, String digestAlgOID) throws GeneralSecurityException, MessagingException, IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        part.writeTo((OutputStream)bOut);
        bOut.close();
        return this.calculateMIC(new ByteArrayInputStream(bOut.toByteArray()), digestAlgOID);
    }

    public Object decryptData(Properties info, Object inData, String contentType, String keystoreType, String keystorePath, String keystorePassword, String keyPassword, String alias) throws Exception {
        Common.log("AS2_SERVER", 2, "decryptData:info:" + info);
        Common.log("AS2_SERVER", 2, "decryptData:inData:" + inData);
        Common.log("AS2_SERVER", 2, "decryptData:contentType:" + contentType);
        Common.log("AS2_SERVER", 2, "decryptData:keystoreType:" + keystoreType);
        Common.log("AS2_SERVER", 2, "decryptData:keystorePath:" + keystorePath);
        Common.log("AS2_SERVER", 2, "decryptData:alias:" + alias);
        Common.log("AS2_SERVER", 3, "decryptData:keystorePassword:" + keystorePassword);
        Common.log("AS2_SERVER", 3, "decryptData:keyPassword:" + keyPassword);
        info.put("encryptType", "1");
        info.put("contentType", String.valueOf(contentType));
        if (contentType.toLowerCase().indexOf("application/pkcs7-mime") < 0) {
            if (inData instanceof File_U) {
                File_U file2 = new File_U(String.valueOf(((File_U)inData).getPath()) + ".decrypted");
                ((File_U)inData).renameTo(file2);
                return file2;
            }
            return inData;
        }
        keystorePassword = Common.encryptDecrypt(keystorePassword, false);
        keyPassword = Common.encryptDecrypt(keyPassword, false);
        if (keystorePath.toUpperCase().endsWith(".PFX")) {
            keystoreType = "pkcs12";
        }
        KeyStore keystore = KeyStore.getInstance(keystoreType);
        if (Common.System2.containsKey("crushftp.keystores." + keystorePath.toUpperCase().replace('\\', '/'))) {
            Properties p = (Properties)Common.System2.get("crushftp.keystores." + keystorePath.toUpperCase().replace('\\', '/'));
            keystore.load(new ByteArrayInputStream((byte[])p.get("bytes")), keystorePassword.toCharArray());
        } else {
            keystore.load(new FileInputStream(new File_S(keystorePath)), keystorePassword.toCharArray());
        }
        X509Certificate certificate = (X509Certificate)keystore.getCertificate(alias);
        PrivateKey privateKey = (PrivateKey)keystore.getKey(alias, keyPassword.toCharArray());
        if (privateKey == null) {
            throw new Exception("Could not load private key alias " + alias + " from specified keystore:" + keystorePath);
        }
        MimeBodyPart encryptedBody = new MimeBodyPart();
        encryptedBody.setHeader("content-type", contentType);
        if (inData instanceof File_U) {
            encryptedBody.setDataHandler(new DataHandler((DataSource)new FileDataSource((File)((File_U)inData))));
        } else {
            if (((byte[])inData).length == 0) {
                throw new Exception("No data was received!");
            }
            encryptedBody.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource((byte[])inData, "application/binary")));
        }
        KeyTransRecipientId recipientId = new KeyTransRecipientId(new X500Name(certificate.getIssuerX500Principal().getName()), certificate.getSerialNumber());
        SMIMEEnveloped enveloped = new SMIMEEnveloped(encryptedBody);
        int encryptType = 0;
        String algorithm = this.getAlgIdToName(enveloped.getEncryptionAlgOID());
        encryptType = algorithm.equals(A_AES_128) ? 8 : (algorithm.equals(A_AES_192) ? 9 : (algorithm.equals(A_AES_256) ? 10 : (algorithm.equals(A_3DES) ? 2 : (algorithm.equals(A_DES) ? 15 : (algorithm.equals(A_RC2) ? 7 : (algorithm.equals(A_RC4) ? 14 : 99))))));
        Common.log("AS2_SERVER", 2, "decryptData:algorithm:" + algorithm);
        RecipientInformationStore recipients = enveloped.getRecipientInfos();
        RecipientInformation recipient = recipients.get((RecipientId)recipientId);
        if (recipient == null) {
            throw new Exception("It seems an invalid cert was used, so we can't continue.");
        }
        info.put("encryptType", String.valueOf(encryptType));
        info.put("contentType", String.valueOf(contentType));
        if (inData instanceof File_U) {
            Common.copyStreams(recipient.getContentStream((Recipient)new JceKeyTransEnvelopedRecipient(privateKey)).getContentStream(), new FileOutputStream(String.valueOf(((File_U)inData).getPath()) + ".decrypted"), true, true);
            return new File_U(String.valueOf(((File_U)inData).getPath()) + ".decrypted");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Common.copyStreams(recipient.getContentStream((Recipient)new JceKeyTransEnvelopedRecipient(privateKey)).getContentStream(), baos, true, true);
        return baos.toByteArray();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Vector getPayloadsAndMic(Properties info, Object inData, String keystoreType, String keystorePath, String keystorePassword, String alias, String mic_alg) throws Exception {
        block49: {
            block50: {
                attachments = new Vector<Object>();
                multipart = null;
                multipart = inData instanceof File_U != false ? new MimeMultipart((DataSource)new FileDataSource((File)((File_U)inData))) : new MimeMultipart((DataSource)new ByteArrayDataSource((byte[])inData, "application/binary"));
                contentType = info.getProperty("contentType", "");
                try {
                    if (info.getProperty("signType", "").equals("1")) {
                        throw new Exception("NO SIGNATURE");
                    }
                    try {
                        multipart.getCount();
                    }
                    catch (Exception e) {
                        baos = new ByteArrayOutputStream();
                        compressed = new SMIMECompressed(new MimeBodyPart((InputStream)new ByteArrayInputStream((byte[])inData)));
                        baos.write(compressed.getContent((InputExpanderProvider)new ZlibExpanderProvider()));
                        inData = baos.toByteArray();
                        multipart = new MimeMultipart((DataSource)new ByteArrayDataSource((byte[])inData, "application/binary"));
                        multipart.getCount();
                    }
                    break block49;
                }
                catch (Exception e) {
                    newData = inData;
                    in /* !! */  = null;
                    mb = null;
                    try {
                        in /* !! */  = inData instanceof File_U != false ? new FileInputStream((File_U)inData) : new ByteArrayInputStream((byte[])inData);
                        mb = new MimeBodyPart((InputStream)in /* !! */ );
                    }
                    catch (Exception ee) {
                        Common.log("AS2_SERVER", 2, ee);
                    }
                    if (info.getProperty("user-agent", "").toUpperCase().indexOf("mendelson") >= 0 || mb.getHeader("Content-Disposition") == null) {
                        newFilename = info.getProperty("content-disposition", "");
                        if (newFilename.endsWith(".as2") && info.containsKey("as2Filename")) {
                            newFilename = info.getProperty("as2Filename");
                        }
                        if (!newFilename.equals("") && newFilename.indexOf("filename=\"") > 0) {
                            newFilename = newFilename.substring(newFilename.indexOf("filename=\""));
                            newFilename = newFilename.substring(newFilename.indexOf("\"") + 1, newFilename.lastIndexOf("\""));
                            if (inData instanceof File_U) {
                                newData = new File_U(String.valueOf(((File_U)inData).getParent()) + "/" + newFilename);
                                ((File_U)inData).renameTo((File_U)newData);
                            } else {
                                p = new Properties();
                                p.put("name", newFilename);
                                p.put("data", inData);
                                newData = p;
                            }
                        } else if (inData instanceof File_U) {
                            newData = new File_U(String.valueOf(((File_U)inData).getParent()) + "/" + ((File_U)inData).getName() + ".as2");
                            ((File_U)inData).renameTo((File_U)newData);
                        } else {
                            p = new Properties();
                            p.put("name", String.valueOf(Common.makeBoundary(11)) + ".as2");
                            p.put("data", inData);
                            newData = p;
                        }
                        break block50;
                    }
                    heads = mb.getAllHeaderLines();
                    ** while (heads.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    Common.log("AS2_SERVER", 2, "HEADER:" + heads.nextElement().toString());
                    continue;
                }
lbl68:
                // 1 sources

                newFilename = mb.getHeader("Content-Disposition")[0];
                if (newFilename.endsWith(".as2") && info.containsKey("as2Filename")) {
                    newFilename = info.getProperty("as2Filename");
                }
                if (newFilename.indexOf("filename=\"") >= 0) {
                    newFilename = newFilename.substring(newFilename.indexOf("filename=\""));
                    newFilename = newFilename.substring(newFilename.indexOf("\"") + 1, newFilename.lastIndexOf("\""));
                } else if (newFilename.indexOf("filename=") >= 0) {
                    newFilename = newFilename.substring(newFilename.indexOf("filename="));
                    newFilename = newFilename.substring(newFilename.indexOf("=") + 1).trim();
                }
                if (inData instanceof File_U) {
                    newData = new File_U(String.valueOf(((File_U)newData).getParent()) + "/" + newFilename);
                    Common.copyStreams((InputStream)mb.getContent(), new FileOutputStream((File_U)newData), true, true);
                } else {
                    baos = new ByteArrayOutputStream();
                    if (mb.getHeader("Content-Type")[0].toLowerCase().indexOf("compressed-data") >= 0) {
                        compressed = new SMIMECompressed(mb);
                        baos.write(compressed.getContent((InputExpanderProvider)new ZlibExpanderProvider()));
                    } else {
                        Common.copyStreams((InputStream)mb.getContent(), baos, true, true);
                    }
                    p = new Properties();
                    p.put("name", newFilename);
                    p.put("data", baos.toByteArray());
                    newData = p;
                }
            }
            attachments.addElement(newData);
            if (inData instanceof File_U) {
                fin = new FileInputStream((File_U)newData);
                info.put("mic", String.valueOf(this.calculateMIC(fin, this.getAlgNameToId(mic_alg))) + ", " + mic_alg);
                fin.close();
            } else {
                p = (Properties)newData;
                info.put("mic", String.valueOf(this.calculateMIC(new ByteArrayInputStream((byte[])p.get("data")), this.getAlgNameToId(mic_alg))) + ", " + mic_alg);
            }
            return attachments;
        }
        keystorePassword = Common.encryptDecrypt(keystorePassword, false);
        if (!keystorePath.trim().equals("")) {
            if (keystorePath.toUpperCase().endsWith(".PFX")) {
                keystoreType = "pkcs12";
            }
            keystore = KeyStore.getInstance(keystoreType);
            if (Common.System2.containsKey("crushftp.keystores." + keystorePath.toUpperCase().replace('\\', '/'))) {
                p = (Properties)Common.System2.get("crushftp.keystores." + keystorePath.toUpperCase().replace('\\', '/'));
                keystore.load(new ByteArrayInputStream((byte[])p.get("bytes")), keystorePassword.toCharArray());
            } else {
                keystore.load(new FileInputStream(new File_S(keystorePath)), keystorePassword.toCharArray());
            }
            ok = false;
            try {
                signer = (SignerInformation)new SMIMESigned(multipart).getSignerInfos().getSigners().iterator().next();
                ok = signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(((X509Certificate)keystore.getCertificate(alias)).getPublicKey()));
            }
            catch (Exception e) {
                Common.log("AS2_SERVER", 1, e);
            }
            if (!ok && keystorePath.indexOf("no_validate") < 0) {
                Common.log("AS2_SERVER", 2, "Response failed signature validation, aborting.");
                throw new Exception("Signature valdiation failed.");
            }
        }
        x = 0;
        while (x < multipart.getCount()) {
            Common.log("AS2_SERVER", 2, "BodyPart ContentType1:" + multipart.getBodyPart(x).getContentType());
            if (multipart.getBodyPart(x).getContentType().toLowerCase().indexOf("pkcs7-signature") < 0) {
                contentType = multipart.getBodyPart(x).getContentType();
                Common.log("AS2_SERVER", 2, "BodyPart ContentType2:" + multipart.getBodyPart(x).getContentType());
                bp = multipart.getBodyPart(x);
                decompressedPayload = null;
                Common.log("AS2_SERVER", 2, "BodyPart ContentType3:" + bp.getContentType());
                bpOriginal = bp;
                if (bp.getContentType().toLowerCase().indexOf("compressed-data") >= 0) {
                    compressedPart = (MimeBodyPart)multipart.getBodyPart(x);
                    compressed = new SMIMECompressed(compressedPart);
                    if (inData instanceof File_U) {
                        decompressedPayload = new File_U(String.valueOf(((File_U)inData).getPath()) + ".decompressed");
                        Common.copyStreams(new ByteArrayInputStream(compressed.getContent((InputExpanderProvider)new ZlibExpanderProvider())), new FileOutputStream(decompressedPayload), true, true);
                        bp = new MimeBodyPart((InputStream)new FileInputStream(decompressedPayload));
                    } else {
                        bp = new MimeBodyPart((InputStream)new ByteArrayInputStream(compressed.getContent((InputExpanderProvider)new ZlibExpanderProvider())));
                    }
                }
                if (inData instanceof File_U) {
                    f = new File_U(String.valueOf(((File_U)inData).getParentFile().getPath()) + Common.dots("/" + bp.getFileName()));
                    attachments.addElement(f);
                    Common.copyStreams(bp.getInputStream(), new FileOutputStream(f), true, true);
                    if (decompressedPayload != null) {
                        decompressedPayload.delete();
                    }
                    info.put("mic", this.calculateContentMIC((File_U)inData, Integer.parseInt(info.getProperty("encryptType", "0")), Integer.parseInt(info.getProperty("signType", "0")), (Part)bpOriginal, contentType));
                    loops = 0;
                    while (!((File_U)inData).delete() && loops++ < 100) {
                        Thread.sleep(10L);
                    }
                } else {
                    baos2 = new ByteArrayOutputStream();
                    multipart.writeTo((OutputStream)baos2);
                    info.put("mic", this.calculateContentMIC(baos2.toByteArray(), Integer.parseInt(info.getProperty("encryptType", "0")), Integer.parseInt(info.getProperty("signType", "0")), (Part)bpOriginal, contentType));
                    baos2.close();
                    baos2 = null;
                    baos = new ByteArrayOutputStream();
                    Common.copyStreams(bp.getInputStream(), baos, true, true);
                    p = new Properties();
                    if (contentType.toLowerCase().indexOf("disposition-notification") >= 0) {
                        p.put("name", "response.mdn");
                        info.put("contentType", contentType);
                        mdn = new String(baos.toByteArray());
                        oid = mdn.substring(mdn.toUpperCase().indexOf("Original-Message-ID:".toUpperCase()));
                        oid = oid.substring(oid.indexOf(":") + 1, oid.indexOf("\r")).trim();
                        mdnInfo = this.parseMDN(baos.toByteArray(), contentType);
                        if (!Common.System2.containsKey("crushftp.as2_async_mdn")) {
                            Common.System2.put("crushftp.as2_async_mdn", new Properties());
                        }
                        ((Properties)Common.System2.get("crushftp.as2_async_mdn")).put(oid, mdnInfo);
                    } else {
                        filename = bp.getFileName();
                        if (filename != null) {
                            info.put("as2_real_filename", Common.dots(filename));
                            p.put("as2_real_filename", info.getProperty("as2_real_filename"));
                        } else {
                            if (filename == null) {
                                filename = "data_" + Common.makeBoundary(11) + ".as2";
                            }
                            if (info.containsKey("as2Filename")) {
                                filename = info.getProperty("as2Filename");
                            }
                        }
                        p.put("name", Common.dots(filename));
                    }
                    p.put("data", baos.toByteArray());
                    attachments.addElement(p);
                }
            }
            ++x;
        }
        return attachments;
    }

    public String calculateContentMIC(Object inData, int encryptType, int signType, Part partWithHeader, String contentType) throws Exception {
        MimeBodyPart signedPart = new MimeBodyPart();
        InputStream in = null;
        if (inData instanceof File_U) {
            signedPart.setDataHandler(new DataHandler((DataSource)new FileDataSource((File)((File_U)inData))));
            in = new FileInputStream((File_U)inData);
        } else {
            signedPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource((byte[])inData, contentType)));
            in = new ByteArrayInputStream((byte[])inData);
        }
        if (encryptType == 1) {
            signedPart.setHeader("Content-Type", contentType);
        } else {
            signedPart.setHeader("Content-Type", new MimeBodyPart(in).getContentType());
        }
        try {
            if (signType == 1) {
                String string = String.valueOf(this.calculateMIC(in, this.getAlgNameToId(A_SHA1))) + ", sha1";
                return string;
            }
            String daoid = this.getDigestAlgOIDFromSignature((Part)signedPart);
            String string = String.valueOf(this.calculateMIC(partWithHeader, daoid)) + ", " + this.getAlgIdToName(daoid);
            return string;
        }
        finally {
            in.close();
        }
    }

    public String getDigestAlgOIDFromSignature(Part part) throws Exception {
        MimeMultipart signedMultiPart = null;
        signedMultiPart = part.getContent() instanceof MimeMultipart ? (MimeMultipart)part.getContent() : new MimeMultipart(part.getDataHandler().getDataSource());
        SMIMESigned signed = new SMIMESigned(signedMultiPart);
        SignerInformationStore signerStore = signed.getSignerInfos();
        Iterator iterator = signerStore.getSigners().iterator();
        if (iterator.hasNext()) {
            return ((SignerInformation)iterator.next()).getDigestAlgOID();
        }
        throw new GeneralSecurityException("Can't understand signature algorithm.");
    }

    public String createMDN(String receivedMIC, String mic_alg, boolean signMDN, String receiverId, String messageId, String dispositionState, String additionalText, String keystoreType, String keystorePath, String keystorePassword, String keyPassword, String alias) throws Exception {
        MimeMultipart multiPart = new MimeMultipart();
        MimeBodyPart body = new MimeBodyPart();
        body.setText(additionalText);
        body.setHeader("Content-Type", "text/plain");
        body.setHeader("Content-Transfer-Encoding", "7bit");
        multiPart.addBodyPart((BodyPart)body);
        MimeBodyPart bodyDisposition = new MimeBodyPart();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Reporting-UA: test\r\n");
        buffer.append("Original-Recipient: rfc822; " + receiverId + "\r\n");
        buffer.append("Final-Recipient: rfc822; " + receiverId + "\r\n");
        buffer.append("Original-Message-ID: <" + messageId + ">\r\n");
        buffer.append("Disposition: " + dispositionState + "\r\n");
        if (receivedMIC != null) {
            buffer.append("Received-Content-MIC: " + receivedMIC + "\r\n");
        }
        bodyDisposition.setText(buffer.toString());
        bodyDisposition.setHeader("Content-Type", "message/disposition-notification");
        bodyDisposition.setHeader("Content-Transfer-Encoding", "7bit");
        multiPart.addBodyPart((BodyPart)bodyDisposition);
        multiPart.setSubType("report; report-type=disposition-notification");
        MimeMessage messagePart = new MimeMessage(Session.getInstance((Properties)System.getProperties(), null));
        messagePart.setContent((Object)multiPart, MimeUtility.unfold((String)multiPart.getContentType()));
        messagePart.saveChanges();
        if (signMDN || System.getProperty("crushftp.as2.alwayssign", "true").equals("true")) {
            if (!signMDN) {
                Common.log("AS2_SERVER", 0, "Signed MDN not requested, but we are signing anyway.");
            }
            MimeMessage signedMessage = this.signMDN(mic_alg, messagePart, keystoreType, keystorePath, keystorePassword, keyPassword, alias);
            ByteArrayOutputStream memOutSigned = new ByteArrayOutputStream();
            signedMessage.writeTo((OutputStream)memOutSigned, new String[]{"Message-ID", "Mime-Version", "Content-Type"});
            memOutSigned.flush();
            memOutSigned.close();
            String s = new String(memOutSigned.toByteArray());
            if (s.startsWith("\r\n")) {
                s = s.substring(2);
            }
            if (s.toUpperCase().startsWith("DATE:")) {
                s = s.substring(s.indexOf("\r\n") + 2);
            }
            if (s.startsWith("\r\n")) {
                s = s.substring(2);
            }
            return s;
        }
        ByteArrayOutputStream memOut = new ByteArrayOutputStream();
        messagePart.writeTo((OutputStream)memOut, new String[]{"Message-ID", "Mime-Version", "Content-Type"});
        memOut.flush();
        memOut.close();
        String s = new String(memOut.toByteArray());
        if (s.startsWith("\r\n")) {
            s = s.substring(2);
        }
        return s;
    }

    public MimeMessage signMDN(String mic_alg, MimeMessage mimeMessage, String keystoreType, String keystorePath, String keystorePassword, String keyPassword, String alias) throws Exception {
        if (mic_alg == null) {
            return mimeMessage;
        }
        keystorePassword = Common.encryptDecrypt(keystorePassword, false);
        keyPassword = Common.encryptDecrypt(keyPassword, false);
        if (keystorePath.toUpperCase().endsWith(".PFX")) {
            keystoreType = "pkcs12";
        }
        KeyStore keystore = KeyStore.getInstance(keystoreType);
        if (Common.System2.containsKey("crushftp.keystores." + keystorePath.toUpperCase().replace('\\', '/'))) {
            Properties p = (Properties)Common.System2.get("crushftp.keystores." + keystorePath.toUpperCase().replace('\\', '/'));
            keystore.load(new ByteArrayInputStream((byte[])p.get("bytes")), keystorePassword.toCharArray());
        } else {
            keystore.load(new FileInputStream(new File_S(keystorePath)), keystorePassword.toCharArray());
        }
        PrivateKey senderKey = (PrivateKey)keystore.getKey(alias, keyPassword.toCharArray());
        Certificate[] chain = keystore.getCertificateChain(alias);
        MimeMultipart signedPart = this.sign(mimeMessage, chain, senderKey, mic_alg.toUpperCase());
        MimeMessage signedMessage = new MimeMessage(Session.getInstance((Properties)System.getProperties(), null));
        signedMessage.setContent((Object)signedPart, MimeUtility.unfold((String)signedPart.getContentType()));
        signedMessage.saveChanges();
        return signedMessage;
    }

    public String doAsyncMDNPost(Socket sock, String username, String password, Properties as2Info, boolean expect100, String mdn, String boundary, String destUrl, String keystore_path, String keystore_pass, String cert_pass, boolean acceptAnyCert, String use_dmz) {
        SimpleDateFormat sdf_rfc1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        StringBuffer data_log = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("POST " + new VRL(destUrl).getPath() + " HTTP/1.1\r\n");
            if (!(username.equals("") || username.equalsIgnoreCase("anonymous") || username.equalsIgnoreCase("template"))) {
                sb.append("Authorization: Basic " + Common.encode64(String.valueOf(username) + ":" + password).trim() + "\r\n");
            }
            sb.append("AS2-Version: 1.1\r\n");
            sb.append("Mime-Version: 1.0\r\n");
            sb.append("Message-ID: <AS2-" + new Date().getTime() + "-" + Common.makeBoundary(3) + "@" + as2Info.getProperty("as2-to", "") + "_" + as2Info.getProperty("as2-from", "") + ">\r\n");
            Thread.sleep(1L);
            sb.append("AS2-To: " + as2Info.getProperty("as2-from", "").trim() + "\r\n");
            if (as2Info.getProperty("as2-to", "").trim().indexOf(" ") >= 0) {
                sb.append("AS2-From: \"" + as2Info.getProperty("as2-to", "").trim() + "\"\r\n");
            } else {
                sb.append("AS2-From: " + as2Info.getProperty("as2-to", "").trim() + "\r\n");
            }
            sb.append("Subject: Message Delivery Notification\r\n");
            sb.append("Connection: close\r\n");
            sb.append("Date: " + sdf_rfc1123.format(new Date()) + "\r\n");
            if (expect100) {
                sb.append("Expect: 100-continue\r\n");
            }
            sb.append("Host: " + new VRL(destUrl).getHost() + ":" + new VRL(destUrl).getPort() + "\r\n");
            if (as2Info.getProperty("signMdn", "false").equals("true")) {
                sb.append("Content-Type: multipart/signed; boundary=\"" + boundary.substring(2) + "\"; protocol=\"application/pkcs7-signature\"; micalg=SHA1; charset=utf-8\r\n");
            } else {
                sb.append("Content-Type: multipart/report; boundary=\"" + boundary.substring(2) + "\"; report-type=disposition-notification; micalg=SHA1; charset=utf-8\r\n");
            }
            sb.append("Content-Length: " + mdn.length() + "\r\n");
            sb.append("\r\n");
            if (sock == null) {
                sock = Common.getSocket("HTTP", new VRL(destUrl), use_dmz, "", 30000);
            }
            if (new VRL(destUrl).getProtocol().equalsIgnoreCase("HTTPS")) {
                SSLSocketFactory factory = null;
                try {
                    new Common();
                    factory = Common.getSSLContext(keystore_path, null, keystore_pass, cert_pass, "TLS", false, acceptAnyCert).getSocketFactory();
                }
                catch (Exception e) {
                    keystore_pass = Common.encryptDecrypt(keystore_pass, false);
                    cert_pass = Common.encryptDecrypt(cert_pass, false);
                    new Common();
                    factory = Common.getSSLContext(keystore_path, null, keystore_pass, cert_pass, "TLS", false, acceptAnyCert).getSocketFactory();
                }
                SSLSocket ss = (SSLSocket)factory.createSocket(sock, new VRL(destUrl).getHost(), new VRL(destUrl).getPort(), true);
                Common.configureSSLTLSSocket(ss, System.getProperty("crushftp.tls_version_client", "TLSv1.2,TLSv1.3"));
                ss.setUseClientMode(true);
                ss.startHandshake();
                sock = ss;
            }
            OutputStream os = sock.getOutputStream();
            BufferedInputStream bis = new BufferedInputStream(sock.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(bis));
            os.write(sb.toString().getBytes("UTF-8"));
            Common.log("AS2_SERVER", 2, sb.toString());
            data_log.append("WROTE:" + sb.toString().trim() + "\r\n");
            os.flush();
            String data = "";
            if (expect100) {
                while ((data = br.readLine()) != null) {
                    Common.log("AS2_SERVER", 2, data);
                    data_log.append("READ:" + data + "\r\n");
                    if (data.equals("")) break;
                }
            }
            data = "";
            data_log.append("WROTE:" + mdn.trim() + "\r\n");
            os.write(mdn.getBytes());
            Common.log("AS2_SERVER", 2, mdn);
            os.flush();
            while ((data = br.readLine()) != null) {
                Common.log("AS2_SERVER", 2, data);
                data_log.append("READ:" + data + "\r\n");
            }
            sock.close();
        }
        catch (Exception e) {
            Common.log("AS2_SERVER", 1, e);
            Common.log("AS2_SERVER", 1, sb.toString());
            Common.log("AS2_SERVER", 1, "" + sock);
        }
        return data_log.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties doPost(Socket sock, String username, String password, boolean expect100, Object inData, String fromPartner, String toPartner, String subject, String from, final String recipientUrl, String responseUrl, boolean asyncMDN, String keystore_path, final String keystore_pass, String cert_pass, boolean acceptAnyCert, final String truststore_path, final String truststore_pass, String trust_pass, String keystoreType, String keystorePath, String keystorePassword, String keyPassword, String alias, Properties otherParams, String use_dmz, String as2_mic_alg) throws Exception {
        SimpleDateFormat sdf_rfc1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        try {
            String ASX = "AS2";
            if (!recipientUrl.toUpperCase().startsWith("HTTP")) {
                ASX = "AS3";
            }
            StringBuffer sb = new StringBuffer();
            if (ASX.equals("AS2")) {
                sb.append("POST " + new VRL(recipientUrl).getPath() + " HTTP/1.1\r\n");
            }
            if (ASX.equals("AS2") && !new VRL(recipientUrl).getUsername().equals("")) {
                sb.append("Authorization: Basic " + Common.encode64(String.valueOf(new VRL(recipientUrl).getUsername()) + ":" + new VRL(recipientUrl).getPassword()).trim() + "\r\n");
            } else if (!(!ASX.equals("AS2") || username.equals("") || password.equals("") || username.equalsIgnoreCase("anonymous") || username.equalsIgnoreCase("template"))) {
                sb.append("Authorization: Basic " + Common.encode64(String.valueOf(username) + ":" + password).trim() + "\r\n");
            }
            sb.append(String.valueOf(ASX) + "-Version: 1.1\r\n");
            sb.append("MIME-Version: 1.0\r\n");
            sb.append("Accept: image/gif, */*\r\n");
            sb.append("User-Agent: CrushClient/6.0 (Generic OS 6.0) Java\r\n");
            sb.append("EDIINT-Features: multiple-attachments\r\n");
            if (!recipientUrl.toUpperCase().startsWith("HTTP")) {
                sb.append("Recipient-Address: " + recipientUrl + "\r\n");
            }
            String oid = "<" + ASX + "-" + new Date().getTime() + "-" + Common.makeBoundary(3) + "@" + fromPartner + "_" + toPartner + ">";
            sb.append("Message-ID: " + oid + "\r\n");
            Thread.sleep(1L);
            if (toPartner.trim().indexOf(" ") >= 0) {
                sb.append(String.valueOf(ASX) + "-To: \"" + toPartner.trim() + "\"\r\n");
            } else {
                sb.append(String.valueOf(ASX) + "-To: " + toPartner.trim() + "\r\n");
            }
            if (fromPartner.trim().indexOf(" ") >= 0) {
                sb.append(String.valueOf(ASX) + "-From: \"" + fromPartner.trim() + "\"\r\n");
            } else {
                sb.append(String.valueOf(ASX) + "-From: " + fromPartner.trim() + "\r\n");
            }
            if (!subject.trim().equals("")) {
                sb.append("Subject: " + subject + "\r\n");
            }
            if (!from.trim().equals("")) {
                sb.append("From: " + from + "\r\n");
            }
            sb.append("Connection: close\r\n");
            sb.append("Date: " + sdf_rfc1123.format(new Date()) + "\r\n");
            sb.append("Content-Type: application/pkcs7-mime; smime-type=enveloped-data; name=smime.p7m\r\n");
            if (asyncMDN || responseUrl != null && responseUrl.trim().length() > 0 && responseUrl.toUpperCase().startsWith("HTTP")) {
                sb.append("receipt-delivery-option: " + responseUrl + "\r\n");
            }
            sb.append("Disposition-notification-to: " + responseUrl + "\r\n");
            sb.append("Disposition-Notification-Options: signed-receipt-protocol=optional, pkcs7-signature; signed-receipt-micalg=" + as2_mic_alg + "\r\n");
            if (otherParams.containsKey("Content-Disposition")) {
                sb.append("Content-Disposition: " + otherParams.getProperty("Content-Disposition", "") + "\r\n");
            } else {
                sb.append("Content-Disposition: attachment; filename=smime.p7m\r\n");
            }
            if (expect100) {
                sb.append("Expect: 100-continue\r\n");
            }
            sb.append("Host: " + new VRL(recipientUrl).getHost() + ":" + new VRL(recipientUrl).getPort() + "\r\n");
            if (inData instanceof File_U) {
                sb.append("Content-Length: " + ((File_U)inData).length() + "\r\n");
            } else {
                sb.append("Content-Length: " + ((byte[])inData).length + "\r\n");
            }
            Enumeration<Object> keys = otherParams.keys();
            while (keys.hasMoreElements()) {
                String key = "" + keys.nextElement();
                if (!key.toUpperCase().startsWith("X-")) continue;
                sb.append(key).append(": ").append(otherParams.getProperty(key)).append("\r\n");
            }
            sb.append("\r\n");
            if (!ASX.equals("AS2")) return null;
            if (sock == null) {
                sock = Common.getSocket("HTTP", new VRL(recipientUrl), use_dmz, "", 30000);
            }
            if (new VRL(recipientUrl).getProtocol().equalsIgnoreCase("HTTPS")) {
                final Properties shared_sock = new Properties();
                shared_sock.put("sock1", sock);
                Worker.startWorker(new Runnable(){

                    @Override
                    public void run() {
                        Socket sock = (Socket)shared_sock.remove("sock1");
                        if (new VRL(recipientUrl).getProtocol().equalsIgnoreCase("HTTPS")) {
                            try {
                                SSLSocket ss = Common.getSSLSocket(truststore_path, keystore_pass, truststore_pass, true, sock, new VRL(recipientUrl).getHost(), new VRL(recipientUrl).getPort());
                                ss.setUseClientMode(true);
                                ss.startHandshake();
                                shared_sock.put("sock2", ss);
                            }
                            catch (Exception e) {
                                shared_sock.put("error", e);
                            }
                        }
                    }
                }, "AS2 multithreaded https conenctor for " + recipientUrl);
                while (shared_sock.containsKey("sock1")) {
                    Thread.sleep(100L);
                }
                int loops = 0;
                while (loops++ < 300) {
                    if (shared_sock.containsKey("sock2")) break;
                    if (shared_sock.containsKey("error")) {
                        throw (Exception)shared_sock.remove("error");
                    }
                    Thread.sleep(100L);
                }
                if (loops >= 300) {
                    throw new Exception("AS2 timeout while attempting HTTPS connection to URL:" + recipientUrl);
                }
                sock = (Socket)shared_sock.remove("sock2");
            }
            OutputStream os = sock.getOutputStream();
            BufferedInputStream bis = new BufferedInputStream(sock.getInputStream());
            bis.mark(65536);
            int skipBytes = 0;
            BufferedReader br = new BufferedReader(new InputStreamReader(bis));
            os.write(sb.toString().getBytes("UTF-8"));
            Common.log("AS2_SERVER", 2, sb.toString());
            os.flush();
            String data = "";
            if (expect100) {
                while ((data = br.readLine()) != null) {
                    skipBytes += data.length() + 2;
                    Common.log("AS2_SERVER", 2, data);
                    if (data.equals("")) break;
                }
            }
            if (inData instanceof File_U) {
                Common.copyStreams(new FileInputStream((File_U)inData), os, true, false);
            } else {
                Common.copyStreams(new ByteArrayInputStream((byte[])inData), os, true, false);
            }
            os.flush();
            data = "";
            int contentLength = 0;
            String contentType = "";
            boolean chunked = false;
            while ((data = br.readLine()) != null) {
                skipBytes += data.length() + 2;
                if (data.toUpperCase().startsWith("CONTENT-LENGTH:")) {
                    contentLength = Integer.parseInt(data.substring(data.indexOf(":") + 1).trim());
                } else if (data.toUpperCase().startsWith("CONTENT-TYPE:")) {
                    contentType = data.substring(data.indexOf(":") + 1).trim();
                }
                if (data.toUpperCase().startsWith("Transfer-Encoding:".toUpperCase()) && data.toUpperCase().indexOf("CHUNKED") > 0 || data.toUpperCase().startsWith("TE:") && data.toUpperCase().indexOf("CHUNKED") > 0) {
                    chunked = true;
                }
                Common.log("AS2_SERVER", 2, data);
                if (data.equals("")) break;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (chunked) {
                try {
                    byte[] b = new byte[32768];
                    int bytes_read = 0;
                    long content_length = Common.getChunkSize(bis);
                    block9: while (true) {
                        if (content_length <= 0L) {
                            baos.flush();
                        }
                        while (true) {
                            if (content_length <= 0L || bytes_read < 0) {
                                Common.getChunkSize(bis);
                                content_length = Common.getChunkSize(bis);
                                continue block9;
                            }
                            if (content_length < (long)b.length) {
                                b = new byte[(int)content_length];
                            }
                            if ((bytes_read = bis.read(b)) <= 0) continue;
                            content_length -= (long)bytes_read;
                            baos.write(b, 0, bytes_read);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    Common.log("AS2_SERVER", 1, e);
                }
            } else {
                int bytesRead = 0;
                BufferedInputStream in = bis;
                bis.reset();
                bis.skip(skipBytes);
                byte[] b = new byte[32768];
                while (contentLength > 0 && bytesRead >= 0) {
                    bytesRead = ((InputStream)in).read(b);
                    if (bytesRead < 0) continue;
                    contentLength -= bytesRead;
                    baos.write(b, 0, bytesRead);
                }
                ((InputStream)in).close();
            }
            sock.close();
            Common.log("AS2_SERVER", 2, "MDNBytes:" + baos.size());
            Common.log("AS2_SERVER", 2, "oid:" + oid);
            Common.log("AS2_SERVER", 2, "contentType:" + contentType);
            if (baos.toByteArray().length == 0 || asyncMDN || responseUrl != null && responseUrl.trim().length() > 0 && responseUrl.toUpperCase().startsWith("HTTP")) {
                Properties mdnInfo = new Properties();
                mdnInfo.put("oid", oid);
                mdnInfo.put("async", "true");
                return mdnInfo;
            }
            Common.log("AS2_SERVER", 2, new String(baos.toByteArray()));
            if (keystorePath.toUpperCase().endsWith(".PFX")) {
                keystoreType = "pkcs12";
            }
            if (!keystorePath.equals("")) {
                this.getPayloadsAndMic(new Properties(), baos.toByteArray(), keystoreType, keystorePath, keystorePassword, alias, A_SHA1);
            }
            Properties mdnInfo = this.parseMDN(baos.toByteArray(), contentType);
            mdnInfo.put("oid", oid);
            mdnInfo.put("async", "false");
            return mdnInfo;
        }
        catch (Exception e) {
            Common.log("AS2_SERVER", 0, e);
            throw e;
        }
    }

    public Properties parseMDN(byte[] data, String contentType) throws Exception {
        MimeMultipart multipart = new MimeMultipart((DataSource)new ByteArrayDataSource(data, contentType));
        MimeMessage message = new MimeMessage(Session.getInstance((Properties)System.getProperties(), null));
        message.setContent((Object)multipart, MimeUtility.unfold((String)multipart.getContentType()));
        message.saveChanges();
        return this.getMDNInfo(this.parseReports((Part)message));
    }

    public Part parseReports(Part part) throws Exception {
        if (part.getContentType().toLowerCase().startsWith("multipart/report")) {
            return part;
        }
        if (part.isMimeType("multipart/*")) {
            Multipart multiPart = (Multipart)part.getContent();
            int x = 0;
            while (x < multiPart.getCount()) {
                Part foundPart = this.parseReports((Part)multiPart.getBodyPart(x));
                if (foundPart != null) {
                    return foundPart;
                }
                ++x;
            }
        }
        Common.log("AS2_SERVER", 2, "Multipart report now found.");
        return null;
    }

    public Properties getMDNInfo(Part report) throws Exception {
        if (report == null) {
            Common.log("AS2_SERVER", 2, "Report was null, returning null.");
            return null;
        }
        Properties mdnInfo = new Properties();
        if (report.isMimeType("multipart/*")) {
            Multipart multiPart = (Multipart)report.getContent();
            int x = 0;
            while (x < multiPart.getCount()) {
                BodyPart body = multiPart.getBodyPart(x);
                if (body.getContentType().toLowerCase().startsWith("text/plain")) {
                    mdnInfo.put("text", body.getContent().toString().trim());
                } else if (body.getContentType().toLowerCase().startsWith("message/disposition-notification")) {
                    if (body.getContent() instanceof InputStream) {
                        InputStream inStream = (InputStream)body.getContent();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
                        String line = "";
                        while ((line = reader.readLine()) != null) {
                            if (line.indexOf(58) < 0) continue;
                            String key = line.substring(0, line.indexOf(58)).toLowerCase();
                            String value = line.substring(line.indexOf(58) + 1).trim();
                            mdnInfo.put(key, value);
                        }
                        inStream.close();
                    } else if (body.getContent() instanceof DispositionNotification) {
                        try {
                            DispositionNotification dn = (DispositionNotification)body.getContent();
                            InternetHeaders ih = dn.getNotifications();
                            Enumeration heads = ih.getAllHeaders();
                            while (heads.hasMoreElements()) {
                                Header h = (Header)heads.nextElement();
                                mdnInfo.put(h.getName().toLowerCase(), h.getValue());
                            }
                        }
                        catch (Exception e) {
                            Common.log("AS2_SERVER", 1, e);
                        }
                    }
                }
                ++x;
            }
        }
        return mdnInfo;
    }

    public byte[] decompressData(byte[] data, String contentType) throws Exception {
        MimeBodyPart compressedPart = new MimeBodyPart();
        compressedPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, contentType)));
        compressedPart.setHeader("content-type", contentType);
        SMIMECompressed compressed = new SMIMECompressed(compressedPart);
        return compressed.getContent((InputExpanderProvider)new ZlibExpanderProvider());
    }

    public MimeBodyPart compressData(byte[] data, String contentType) throws Exception {
        MimeBodyPart body = new MimeBodyPart();
        body.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, contentType)));
        body.addHeader("Content-Type", contentType);
        body.addHeader("Content-Transfer-Encoding", "binary");
        return this.compressData(body);
    }

    public MimeBodyPart compressData(MimeBodyPart body) throws Exception {
        SMIMECompressedGenerator gen = new SMIMECompressedGenerator();
        gen.setContentTransferEncoding("binary");
        return gen.generate(body, (OutputCompressor)new ZlibCompressor());
    }
}

